/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.monitors;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.opends.server.api.MonitorProvider;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.InitializationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemInfoMonitorProvider
extends MonitorProvider {
    private static final String CLASS_NAME = "org.opends.server.monitors.SystemInfoMonitorProvider";

    public SystemInfoMonitorProvider() {
        super("System Info Monitor Provider");
    }

    @Override
    public void initializeMonitorProvider(ConfigEntry configEntry) throws ConfigException, InitializationException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeMonitorProvider", String.valueOf(configEntry)));
    }

    @Override
    public String getMonitorInstanceName() {
        assert (Debug.debugEnter(CLASS_NAME, "getMonitorInstanceName", new String[0]));
        return "System Information";
    }

    @Override
    public long getUpdateInterval() {
        assert (Debug.debugEnter(CLASS_NAME, "getUpdateInterval", new String[0]));
        return 0L;
    }

    @Override
    public void updateMonitorData() {
        assert (Debug.debugEnter(CLASS_NAME, "updateMonitorData", new String[0]));
    }

    public ArrayList<Attribute> getMonitorData() {
        ArrayList<Attribute> arrayList;
        block3: {
            assert (Debug.debugEnter(CLASS_NAME, "getMonitorData", new String[0]));
            arrayList = new ArrayList<Attribute>(12);
            arrayList.add(this.createAttribute("javaVersion", System.getProperty("java.version")));
            arrayList.add(this.createAttribute("javaVendor", System.getProperty("java.vendor")));
            arrayList.add(this.createAttribute("jvmVersion", System.getProperty("java.vm.version")));
            arrayList.add(this.createAttribute("jvmVendor", System.getProperty("java.vm.vendor")));
            arrayList.add(this.createAttribute("javaHome", System.getProperty("java.home")));
            arrayList.add(this.createAttribute("classPath", System.getProperty("java.class.path")));
            arrayList.add(this.createAttribute("workingDirectory", System.getProperty("user.dir")));
            String string = System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch");
            arrayList.add(this.createAttribute("operatingSystem", string));
            try {
                arrayList.add(this.createAttribute("systemName", InetAddress.getLocalHost().getCanonicalHostName()));
            }
            catch (Exception exception) {
                if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "getMonitorData", exception)) break block3;
                throw new AssertionError();
            }
        }
        Runtime runtime = Runtime.getRuntime();
        arrayList.add(this.createAttribute("availableCPUs", String.valueOf(runtime.availableProcessors())));
        arrayList.add(this.createAttribute("maxMemory", String.valueOf(runtime.maxMemory())));
        arrayList.add(this.createAttribute("usedMemory", String.valueOf(runtime.totalMemory())));
        arrayList.add(this.createAttribute("freeUsedMemory", String.valueOf(runtime.freeMemory())));
        return arrayList;
    }

    private Attribute createAttribute(String string, String string2) {
        assert (Debug.debugEnter(CLASS_NAME, "createAttribute", String.valueOf(string), String.valueOf(string2)));
        AttributeType attributeType = DirectoryServer.getDefaultAttributeType(string);
        ASN1OctetString aSN1OctetString = new ASN1OctetString(string2);
        LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>(1);
        try {
            linkedHashSet.add(new AttributeValue(aSN1OctetString, attributeType.normalize(aSN1OctetString)));
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "createAttribute", exception));
            linkedHashSet.add(new AttributeValue(aSN1OctetString, (ByteString)aSN1OctetString));
        }
        return new Attribute(attributeType, string, linkedHashSet);
    }
}

