/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.monitors;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.LockStats;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.TransactionStats;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.MonitorProvider;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.InitializationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseEnvironmentMonitor
extends MonitorProvider {
    private static final String CLASS_NAME = "org.opends.server.monitors.DatabaseEnvironmentMonitor";
    private String name;
    private Environment environment;

    public DatabaseEnvironmentMonitor(String string, Environment environment) {
        super(string + " Monitor Provider");
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
        this.name = string;
        this.environment = environment;
    }

    @Override
    public void initializeMonitorProvider(ConfigEntry configEntry) throws ConfigException, InitializationException {
    }

    @Override
    public String getMonitorInstanceName() {
        return this.name;
    }

    @Override
    public long getUpdateInterval() {
        return 0L;
    }

    @Override
    public void updateMonitorData() {
    }

    private void addAttributesForStatsObject(ArrayList<Attribute> arrayList, Object object, String string) {
        Method[] methodArray;
        Class<?> clazz = object.getClass();
        for (Method method : methodArray = clazz.getMethods()) {
            Class<?> clazz2;
            if (!method.getName().startsWith("get") || !(clazz2 = method.getReturnType()).equals(Integer.TYPE) && !clazz2.equals(Long.TYPE)) continue;
            AttributeSyntax attributeSyntax = DirectoryServer.getDefaultIntegerSyntax();
            String string2 = string + method.getName().substring(3);
            try {
                Object object2 = method.invoke(object, new Object[0]);
                AttributeType attributeType = DirectoryServer.getDefaultAttributeType(string2, attributeSyntax);
                ASN1OctetString aSN1OctetString = new ASN1OctetString(String.valueOf(object2));
                LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>();
                linkedHashSet.add(new AttributeValue(aSN1OctetString, (ByteString)aSN1OctetString));
                arrayList.add(new Attribute(attributeType, string2, linkedHashSet));
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "addAttributesForStatsObject", exception));
            }
        }
    }

    public ArrayList<Attribute> getMonitorData() {
        EnvironmentStats environmentStats = null;
        LockStats lockStats = null;
        TransactionStats transactionStats = null;
        StatsConfig statsConfig = new StatsConfig();
        try {
            environmentStats = this.environment.getStats(statsConfig);
            lockStats = this.environment.getLockStats(statsConfig);
            transactionStats = this.environment.getTransactionStats(statsConfig);
        }
        catch (DatabaseException databaseException) {
            assert (Debug.debugException(CLASS_NAME, "getMonitorData", databaseException));
            return null;
        }
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        this.addAttributesForStatsObject(arrayList, environmentStats, "Environment");
        this.addAttributesForStatsObject(arrayList, lockStats, "Lock");
        this.addAttributesForStatsObject(arrayList, transactionStats, "Transaction");
        return arrayList;
    }
}

