/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import org.opends.server.loggers.Debug;
import org.opends.server.loggers.RotationPolicy;
import org.opends.server.util.TimeThread;

public class TimeLimitRotationPolicy
implements RotationPolicy {
    private static final String CLASS_NAME = "org.opends.server.loggers.TimeLimitRotationPolicy";
    private long timeInterval = 0L;
    private long lastModifiedTime = 0L;

    public TimeLimitRotationPolicy(long l) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(l)));
        this.timeInterval = l;
        this.lastModifiedTime = TimeThread.getTime();
    }

    public boolean rotateFile() {
        assert (Debug.debugEnter(CLASS_NAME, "rotateFile", new String[0]));
        long l = TimeThread.getTime();
        if (l - this.lastModifiedTime > this.timeInterval) {
            do {
                this.lastModifiedTime += this.timeInterval;
            } while (this.lastModifiedTime < l);
            return true;
        }
        return false;
    }
}

