/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import org.opends.server.loggers.Debug;
import org.opends.server.loggers.DirectoryFileHandler;
import org.opends.server.loggers.RotationPolicy;
import org.opends.server.types.DebugLogCategory;
import org.opends.server.types.DebugLogSeverity;

public class SizeBasedRotationPolicy
implements RotationPolicy {
    private static final String CLASS_NAME = "org.opends.server.loggers.SizeBasedRotationPolicy";
    private long sizeLimit;
    private DirectoryFileHandler fileHandler;

    public SizeBasedRotationPolicy(long l) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(l)));
        this.sizeLimit = l;
    }

    public void setFileHandler(DirectoryFileHandler directoryFileHandler) {
        this.fileHandler = directoryFileHandler;
    }

    public long getMaxFileSize() {
        return this.sizeLimit;
    }

    public boolean rotateFile() {
        assert (Debug.debugEnter(CLASS_NAME, "rotateFile", new String[0]));
        if (this.fileHandler.getFileSize() >= this.sizeLimit) {
            assert (Debug.debugMessage(DebugLogCategory.CORE_SERVER, DebugLogSeverity.INFO, CLASS_NAME, "rotateFile", "File Length:" + this.fileHandler.getFileSize()));
            return true;
        }
        return false;
    }
}

