/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import java.util.concurrent.CopyOnWriteArrayList;
import org.opends.server.api.DirectoryThread;
import org.opends.server.api.ServerShutdownListener;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.LoggerAlarmHandler;
import org.opends.server.loggers.RetentionPolicy;
import org.opends.server.loggers.RotationPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggerThread
extends DirectoryThread
implements ServerShutdownListener {
    private static final String CLASS_NAME = "org.opends.server.loggers.LoggerThread";
    private CopyOnWriteArrayList<RotationPolicy> rotationPolicies;
    private CopyOnWriteArrayList<RetentionPolicy> retentionPolicies;
    private LoggerAlarmHandler handler;
    private int time;
    private boolean stopRequested;
    private Thread loggerThread;

    public LoggerThread(String string, int n, LoggerAlarmHandler loggerAlarmHandler, CopyOnWriteArrayList<RotationPolicy> copyOnWriteArrayList, CopyOnWriteArrayList<RetentionPolicy> copyOnWriteArrayList2) {
        super(string);
        this.time = n;
        this.handler = loggerAlarmHandler;
        this.rotationPolicies = copyOnWriteArrayList;
        this.retentionPolicies = copyOnWriteArrayList2;
        this.loggerThread = null;
        this.stopRequested = false;
        DirectoryServer.registerShutdownListener(this);
    }

    @Override
    public void run() {
        assert (Debug.debugEnter(CLASS_NAME, "run", new String[0]));
        this.loggerThread = Thread.currentThread();
        while (!this.stopRequested) {
            block7: {
                try {
                    LoggerThread.sleep(this.time);
                }
                catch (Exception exception) {
                    if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "run", exception)) break block7;
                    throw new AssertionError();
                }
            }
            this.handler.flush();
            if (this.rotationPolicies != null) {
                for (RotationPolicy rotationPolicy : this.rotationPolicies) {
                    if (!rotationPolicy.rotateFile()) continue;
                    this.handler.rollover();
                }
            }
            if (this.retentionPolicies == null) continue;
            for (RetentionPolicy retentionPolicy : this.retentionPolicies) {
                int n = retentionPolicy.deleteFiles();
                System.out.println(n + " files deleted");
            }
        }
    }

    @Override
    public String getShutdownListenerName() {
        assert (Debug.debugEnter(CLASS_NAME, "getShutdownListenerName", new String[0]));
        return "Logger Thread " + this.getName();
    }

    @Override
    public void processServerShutdown(String string) {
        block4: {
            assert (Debug.debugEnter(CLASS_NAME, "processServerShutdown", String.valueOf(string)));
            this.stopRequested = true;
            try {
                if (this.loggerThread != null) {
                    this.loggerThread.interrupt();
                }
            }
            catch (Exception exception) {
                if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "processServerShutdown", exception)) break block4;
                throw new AssertionError();
            }
        }
    }
}

