/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opends.server.api.ConfigurableComponent;
import org.opends.server.api.DebugLogger;
import org.opends.server.api.ProtocolElement;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.config.MultiChoiceConfigAttribute;
import org.opends.server.config.StringConfigAttribute;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.DirectoryFileFormatter;
import org.opends.server.loggers.DirectoryFileHandler;
import org.opends.server.loggers.DirectoryLogLevel;
import org.opends.server.loggers.LoggerThread;
import org.opends.server.loggers.RotationConfigUtil;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogCategory;
import org.opends.server.types.DebugLogSeverity;
import org.opends.server.types.ResultCode;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryDebugLogger
extends DebugLogger
implements ConfigurableComponent {
    private static final int DEFAULT_TIME_INTERVAL = 30000;
    private static final int DEFAULT_BUFFER_SIZE = 0;
    private Logger debugLogger = null;
    private DirectoryFileHandler fileHandler = null;
    private HashMap<DebugLogCategory, HashSet<DebugLogSeverity>> definedSeverities;
    private HashSet<DebugLogSeverity> defaultSeverities;
    private DN configDN;

    @Override
    public void initializeDebugLogger(ConfigEntry configEntry) throws ConfigException {
        String string;
        this.configDN = configEntry.getDN();
        this.defaultSeverities = new HashSet();
        HashSet<String> hashSet = new HashSet<String>();
        for (DebugLogSeverity debugLogSeverity : DebugLogSeverity.values()) {
            hashSet.add(debugLogSeverity.toString().toLowerCase());
        }
        List<String> list = this.getSeverities(configEntry, "ds-cfg-default-severity", hashSet);
        if (list.isEmpty()) {
            this.defaultSeverities.add(DebugLogSeverity.ERROR);
            this.defaultSeverities.add(DebugLogSeverity.WARNING);
        } else {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                DebugLogSeverity debugLogSeverity;
                String string2 = (String)iterator.next();
                debugLogSeverity = DebugLogSeverity.getByName(string2);
                if (debugLogSeverity != null) {
                    this.defaultSeverities.add(debugLogSeverity);
                    continue;
                }
                System.err.println("Ignoring invalid severity name:" + string2);
            }
        }
        this.definedSeverities = new HashMap();
        HashSet<String> hashSet2 = new HashSet<String>();
        for (DebugLogCategory debugLogCategory : DebugLogCategory.values()) {
            for (DebugLogSeverity debugLogSeverity : DebugLogSeverity.values()) {
                string = debugLogCategory.toString().toLowerCase() + "=" + debugLogSeverity.toString().toLowerCase();
                hashSet2.add(string);
            }
        }
        List<String> list2 = this.getSeverities(configEntry, "ds-cfg-override-severity", hashSet2);
        Object object3 = list2.iterator();
        while (object3.hasNext()) {
            String string3 = (String)object3.next();
            if (string3 == null) continue;
            int n = string3.indexOf(61);
            if (n < 0) {
                System.err.println("Invalid override of severity level. Ignoring...");
                continue;
            }
            String iOException = string3.substring(0, n);
            DebugLogCategory debugLogCategory = DebugLogCategory.getByName(iOException);
            if (debugLogCategory == null) {
                System.err.println("Invalid debug log category. Ignoring ...");
                continue;
            }
            HashSet<DebugLogSeverity> hashSet3 = new HashSet<DebugLogSeverity>();
            StringTokenizer stringTokenizer = new StringTokenizer(string3.substring(n + 1), ",");
            while (stringTokenizer.hasMoreElements()) {
                string = stringTokenizer.nextToken();
                DebugLogSeverity debugLogSeverity = DebugLogSeverity.getByName(string);
                if (debugLogSeverity == null) {
                    System.err.println("Invalid debug log severity. Ignoring ...");
                    continue;
                }
                hashSet3.add(debugLogSeverity);
            }
            this.definedSeverities.put(debugLogCategory, hashSet3);
        }
        object3 = new StringConfigAttribute("ds-cfg-log-file", MessageHandler.getMessage(0x300033), true, false, true);
        StringConfigAttribute stringConfigAttribute = (StringConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object3);
        if (stringConfigAttribute == null) {
            int n = 3407954;
            String string2 = MessageHandler.getMessage(n, configEntry.getDN().toString());
            throw new ConfigException(n, string2);
        }
        this.debugLogger = Logger.getLogger("org.opends.server.loggers.DirectoryDebugLogger");
        this.debugLogger.setLevel(Level.ALL);
        File file = new File(stringConfigAttribute.activeValue());
        if (!file.isAbsolute()) {
            file = new File(DirectoryServer.getServerRoot() + File.separator + stringConfigAttribute.activeValue());
        }
        try {
            int n;
            int n2 = RotationConfigUtil.getIntegerAttribute(configEntry, "ds-cfg-buffer-size", 0x40000A);
            if (n2 == -1) {
                n = 0;
            }
            this.fileHandler = new DirectoryFileHandler(configEntry, file.getAbsolutePath(), n);
            this.fileHandler.setFormatter(new DirectoryFileFormatter(false));
            this.debugLogger.addHandler(this.fileHandler);
            int n3 = RotationConfigUtil.getIntegerAttribute(configEntry, "ds-cfg-thread-time-interval", 0x400009);
            if (n3 == -1) {
                n3 = 30000;
            }
            LoggerThread loggerThread = new LoggerThread("DebugLogger Thread", n3, this.fileHandler, null, null);
            loggerThread.start();
        }
        catch (IOException iOException) {
            int n = 0x440003;
            String string3 = MessageHandler.getMessage(n, String.valueOf(iOException));
            throw new ConfigException(n, string3, iOException);
        }
    }

    @Override
    public void closeDebugLogger() {
        this.fileHandler.close();
    }

    @Override
    public void debugBytesRead(String string, String string2, ByteBuffer byteBuffer) {
        HashSet<DebugLogSeverity> hashSet = this.definedSeverities.get((Object)DebugLogCategory.DATA_READ);
        if (hashSet == null) {
            hashSet = this.defaultSeverities;
        }
        if (hashSet.contains((Object)DebugLogSeverity.COMMUNICATION)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Bytes Read:").append("classname=").append(string).append(" methodname=").append(string2).append(" bytebuffer=").append(ServerConstants.EOL);
            StaticUtils.byteArrayToHexPlusAscii(stringBuilder, byteBuffer, 4);
            this.debugLogger.log(DirectoryLogLevel.COMMUNICATION, stringBuilder.toString());
        }
    }

    @Override
    public void debugBytesWritten(String string, String string2, ByteBuffer byteBuffer) {
        HashSet<DebugLogSeverity> hashSet = this.definedSeverities.get((Object)DebugLogCategory.DATA_WRITE);
        if (hashSet == null) {
            hashSet = this.defaultSeverities;
        }
        if (hashSet.contains((Object)DebugLogSeverity.COMMUNICATION)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Bytes Written:").append("classname=").append(string).append(" methodname=").append(string2).append(" bytebuffer=").append(ServerConstants.EOL);
            StaticUtils.byteArrayToHexPlusAscii(stringBuilder, byteBuffer, 4);
            this.debugLogger.log(DirectoryLogLevel.COMMUNICATION, stringBuilder.toString());
        }
    }

    @Override
    public void debugConstructor(String string, String ... stringArray) {
        HashSet<DebugLogSeverity> hashSet = this.definedSeverities.get((Object)DebugLogCategory.CONSTRUCTOR);
        if (hashSet == null) {
            hashSet = this.defaultSeverities;
        }
        if (hashSet.contains((Object)DebugLogSeverity.INFO)) {
            if (stringArray.length == 0) {
                this.debugLogger.log(DirectoryLogLevel.INFO, "CONSTRUCTOR " + string);
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(stringArray[0]);
                for (int i = 1; i < stringArray.length; ++i) {
                    stringBuilder.append(",").append(stringArray[i]);
                }
                this.debugLogger.log(DirectoryLogLevel.INFO, "CONSTRUCTOR " + string + " (" + stringBuilder.toString() + ")");
            }
        }
    }

    @Override
    public void debugEnter(String string, String string2, String ... stringArray) {
        HashSet<DebugLogSeverity> hashSet = this.definedSeverities.get((Object)DebugLogCategory.METHOD_ENTER);
        if (hashSet == null) {
            hashSet = this.defaultSeverities;
        }
        if (hashSet.contains((Object)DebugLogSeverity.INFO)) {
            if (stringArray.length == 0) {
                this.debugLogger.log(DirectoryLogLevel.INFO, "Entered method:" + string + ":" + string2);
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(stringArray[0]);
                for (int i = 1; i < stringArray.length; ++i) {
                    stringBuilder.append(",").append(stringArray[i]);
                }
                this.debugLogger.log(DirectoryLogLevel.INFO, "Entered method:" + string + ":" + string2 + ":" + stringBuilder.toString());
            }
        }
    }

    @Override
    public void debugMessage(DebugLogCategory debugLogCategory, DebugLogSeverity debugLogSeverity, String string, String string2, String string3) {
        HashSet<DebugLogSeverity> hashSet = this.definedSeverities.get((Object)debugLogCategory);
        if (hashSet == null) {
            hashSet = this.defaultSeverities;
        }
        if (hashSet.contains((Object)debugLogSeverity)) {
            this.debugLogger.log(DirectoryLogLevel.INFO, "classname:" + string + " methodname:" + string2 + ":" + string3);
        }
    }

    @Override
    public void debugException(String string, String string2, Throwable throwable) {
        HashSet<DebugLogSeverity> hashSet = this.definedSeverities.get((Object)DebugLogCategory.EXCEPTION);
        if (hashSet == null) {
            hashSet = this.defaultSeverities;
        }
        if (hashSet.contains((Object)DebugLogSeverity.ERROR)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("classname=").append(string).append(" methodname=").append(string2).append(' ').append(StaticUtils.stackTraceToString(throwable));
            this.debugLogger.log(DirectoryLogLevel.ERROR, stringBuilder.toString());
        }
    }

    @Override
    public void debugProtocolElementRead(String string, String string2, ProtocolElement protocolElement) {
        HashSet<DebugLogSeverity> hashSet = this.definedSeverities.get((Object)DebugLogCategory.PROTOCOL_READ);
        if (hashSet == null) {
            hashSet = this.defaultSeverities;
        }
        if (hashSet.contains((Object)DebugLogSeverity.COMMUNICATION)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("classname=").append(string).append(" methodname=").append(string2);
            protocolElement.toString(stringBuilder, 4);
            this.debugLogger.log(DirectoryLogLevel.COMMUNICATION, stringBuilder.toString());
        }
    }

    @Override
    public void debugProtocolElementWritten(String string, String string2, ProtocolElement protocolElement) {
        HashSet<DebugLogSeverity> hashSet = this.definedSeverities.get((Object)DebugLogCategory.PROTOCOL_WRITE);
        if (hashSet == null) {
            hashSet = this.defaultSeverities;
        }
        if (hashSet.contains((Object)DebugLogSeverity.COMMUNICATION)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("classname=").append(string).append(" methodname=").append(string2);
            protocolElement.toString(stringBuilder, 4);
            this.debugLogger.log(DirectoryLogLevel.COMMUNICATION, stringBuilder.toString());
        }
    }

    @Override
    public int hashCode() {
        return this.debugLogger.hashCode();
    }

    @Override
    public DN getConfigurableComponentEntryDN() {
        return this.configDN;
    }

    @Override
    public List<ConfigAttribute> getConfigurationAttributes() {
        return null;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        return this.debugLogger.equals(object);
    }

    @Override
    public boolean hasAcceptableConfiguration(ConfigEntry configEntry, List<String> list) {
        try {
            StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-log-file", MessageHandler.getMessage(0x300033), true, false, true);
            StringConfigAttribute stringConfigAttribute2 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
            if (stringConfigAttribute2 == null) {
                int n = 3407954;
                String string = MessageHandler.getMessage(n, configEntry.getDN().toString());
                list.add(string);
                return false;
            }
        }
        catch (ConfigException configException) {
            int n = 3407928;
            String string = MessageHandler.getMessage(n, this.getClass().getName(), configEntry.getDN().toString(), String.valueOf(configException));
            list.add(string);
            return false;
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyNewConfiguration(ConfigEntry configEntry, boolean bl) {
        this.fileHandler.close();
        try {
            this.initializeDebugLogger(configEntry);
        }
        catch (ConfigException configException) {
            return new ConfigChangeResult(DirectoryServer.getServerErrorResultCode(), false);
        }
        return new ConfigChangeResult(ResultCode.SUCCESS, false);
    }

    private List<String> getSeverities(ConfigEntry configEntry, String string, Set<String> set) {
        ArrayList<String> arrayList = new ArrayList<String>();
        MultiChoiceConfigAttribute multiChoiceConfigAttribute = new MultiChoiceConfigAttribute(string, MessageHandler.getMessage(0x300033), false, true, true, set);
        MultiChoiceConfigAttribute multiChoiceConfigAttribute2 = null;
        try {
            multiChoiceConfigAttribute2 = (MultiChoiceConfigAttribute)configEntry.getConfigAttribute(multiChoiceConfigAttribute);
        }
        catch (ConfigException configException) {
            configException.printStackTrace();
            System.err.println("Cannot retrieve the config value for:" + string);
            return arrayList;
        }
        if (multiChoiceConfigAttribute2 == null) {
            return arrayList;
        }
        return multiChoiceConfigAttribute2.activeValues();
    }
}

