/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.AbstractCollection;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.opends.server.api.ConfigurableComponent;
import org.opends.server.api.MonitorProvider;
import org.opends.server.api.WorkQueue;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.config.IntegerConfigAttribute;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.Operation;
import org.opends.server.extensions.TraditionalWorkerThread;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.monitors.TraditionalWorkQueueMonitor;
import org.opends.server.types.CancelRequest;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraditionalWorkQueue
extends WorkQueue
implements ConfigurableComponent {
    private static final String CLASS_NAME = "org.opends.server.core.WorkQueue";
    private static final int MAX_RETRY_COUNT = 5;
    private ArrayList<TraditionalWorkerThread> workerThreads;
    private AtomicLong opsSubmitted;
    private AtomicLong queueFullRejects;
    private boolean killThreads;
    private boolean shutdownRequested;
    private DN configEntryDN;
    private int lastThreadNumber;
    private int maxCapacity;
    private int numWorkerThreads;
    private LinkedBlockingQueue<Operation> opQueue;
    private ReentrantLock queueLock;

    public TraditionalWorkQueue() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    @Override
    public void initializeWorkQueue(ConfigEntry configEntry) throws ConfigException, InitializationException {
        String string;
        Object object;
        IntegerConfigAttribute integerConfigAttribute;
        assert (Debug.debugEnter(CLASS_NAME, "initializeWorkQueue", String.valueOf(configEntry)));
        this.shutdownRequested = false;
        this.killThreads = false;
        this.opsSubmitted = new AtomicLong(0L);
        this.queueFullRejects = new AtomicLong(0L);
        this.queueLock = new ReentrantLock();
        this.configEntryDN = configEntry.getDN();
        int n = 0x300055;
        IntegerConfigAttribute integerConfigAttribute2 = new IntegerConfigAttribute("ds-cfg-num-worker-threads", MessageHandler.getMessage(n), true, false, false, true, 1L, false, 0L, 24L);
        try {
            integerConfigAttribute = (IntegerConfigAttribute)configEntry.getConfigAttribute(integerConfigAttribute2);
            if (integerConfigAttribute == null) {
                this.numWorkerThreads = 24;
            } else {
                this.numWorkerThreads = integerConfigAttribute.activeIntValue();
                if (this.numWorkerThreads <= 0) {
                    n = 3276889;
                    object = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), this.numWorkerThreads);
                    Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, (String)object, n);
                    this.numWorkerThreads = 24;
                }
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "<init>", exception));
            n = 3407959;
            object = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), String.valueOf(exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, (String)object, n);
            this.numWorkerThreads = 24;
        }
        n = 3145814;
        integerConfigAttribute = new IntegerConfigAttribute("ds-cfg-max-work-queue-capacity", MessageHandler.getMessage(n), true, false, false, true, 0L, false, 0L, 0L);
        try {
            object = (IntegerConfigAttribute)configEntry.getConfigAttribute(integerConfigAttribute);
            if (object == null) {
                this.maxCapacity = 0;
            } else {
                this.maxCapacity = ((IntegerConfigAttribute)object).activeIntValue();
                if (this.maxCapacity < 0) {
                    n = 3276890;
                    string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), this.maxCapacity);
                    Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, string, n);
                    this.maxCapacity = 0;
                }
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "<init>", exception));
            n = 3407960;
            string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), String.valueOf(exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, string, n);
            this.maxCapacity = 0;
        }
        this.opQueue = this.maxCapacity > 0 ? new LinkedBlockingQueue(this.maxCapacity) : new LinkedBlockingQueue();
        this.workerThreads = new ArrayList(this.numWorkerThreads);
        this.lastThreadNumber = 0;
        while (this.lastThreadNumber < this.numWorkerThreads) {
            object = new TraditionalWorkerThread(this, this.lastThreadNumber);
            ((Thread)object).start();
            this.workerThreads.add((TraditionalWorkerThread)object);
            ++this.lastThreadNumber;
        }
        DirectoryServer.registerConfigurableComponent(this);
        try {
            object = new TraditionalWorkQueueMonitor(this);
            ((TraditionalWorkQueueMonitor)object).initializeMonitorProvider(configEntry);
            ((Thread)object).start();
            DirectoryServer.registerMonitorProvider((MonitorProvider)object);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "<init>", exception));
            n = 3407967;
            string = MessageHandler.getMessage(n, TraditionalWorkQueueMonitor.class, String.valueOf(exception));
            Error.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.SEVERE_ERROR, string, n);
        }
    }

    @Override
    public void finalizeWorkQueue(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "finalizeWorkQueue", new String[0]));
        this.shutdownRequested = true;
        CancelRequest cancelRequest = new CancelRequest(true, string);
        ArrayList arrayList = new ArrayList();
        this.opQueue.removeAll(arrayList);
        for (Operation runnable : arrayList) {
            try {
                runnable.cancel(cancelRequest);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "processServerShutdown", exception));
                Error.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.SEVERE_WARNING, 65651, String.valueOf(runnable), String.valueOf(exception));
            }
        }
        for (TraditionalWorkerThread traditionalWorkerThread : this.workerThreads) {
            try {
                traditionalWorkerThread.shutDown();
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "processServerShutdown", exception));
                Error.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.SEVERE_WARNING, 65652, traditionalWorkerThread.getName(), String.valueOf(exception));
            }
        }
    }

    public boolean shutdownRequested() {
        assert (Debug.debugEnter(CLASS_NAME, "shutdownRequested", new String[0]));
        return this.shutdownRequested;
    }

    @Override
    public void submitOperation(Operation operation) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "submitOperation", String.valueOf(operation)));
        if (this.shutdownRequested) {
            int n = 65647;
            String string = MessageHandler.getMessage(n);
            throw new DirectoryException(ResultCode.UNAVAILABLE, string, n);
        }
        if (!this.opQueue.offer(operation)) {
            this.queueFullRejects.incrementAndGet();
            int n = 131184;
            String string = MessageHandler.getMessage(n, this.maxCapacity);
            throw new DirectoryException(ResultCode.UNAVAILABLE, string, n);
        }
        this.opsSubmitted.incrementAndGet();
    }

    public Operation nextOperation(TraditionalWorkerThread traditionalWorkerThread) {
        assert (Debug.debugEnter(CLASS_NAME, "nextOperation", new String[0]));
        return this.retryNextOperation(traditionalWorkerThread, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Operation retryNextOperation(TraditionalWorkerThread traditionalWorkerThread, int n) {
        int n2;
        assert (Debug.debugEnter(CLASS_NAME, "retryNextOperation", new String[0]));
        if (this.killThreads) {
            this.queueLock.lock();
            try {
                n2 = this.workerThreads.size();
                if (n2 > this.numWorkerThreads) {
                    if (this.workerThreads.remove(Thread.currentThread())) {
                        --n2;
                    }
                    if (n2 <= this.numWorkerThreads) {
                        this.killThreads = false;
                    }
                    traditionalWorkerThread.setStoppedByReducedThreadNumber();
                    Operation operation = null;
                    return operation;
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "retryNextOperation", exception));
            }
            finally {
                this.queueLock.unlock();
            }
        }
        if (this.shutdownRequested || n > 5) {
            if (n <= 5) return null;
            n2 = 3407966;
            String string = MessageHandler.getMessage(n2, Thread.currentThread().getName(), n, 5);
            Error.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.SEVERE_ERROR, string, n2);
            return null;
        }
        try {
            Operation operation;
            while ((operation = this.opQueue.poll(5L, TimeUnit.SECONDS)) == null) {
                if (this.shutdownRequested) {
                    return null;
                }
                if (!this.killThreads) continue;
                this.queueLock.lock();
                try {
                    int n3 = this.workerThreads.size();
                    if (n3 <= this.numWorkerThreads) continue;
                    if (this.workerThreads.remove(Thread.currentThread())) {
                        --n3;
                    }
                    if (n3 <= this.numWorkerThreads) {
                        this.killThreads = false;
                    }
                    traditionalWorkerThread.setStoppedByReducedThreadNumber();
                    Operation operation2 = null;
                    return operation2;
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "retryNextOperation", exception));
                }
                finally {
                    this.queueLock.unlock();
                }
            }
            return operation;
        }
        catch (InterruptedException interruptedException) {
            assert (Debug.debugException(CLASS_NAME, "retryNextOperation", interruptedException));
            if (this.shutdownRequested) {
                return null;
            }
            Error.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.SEVERE_WARNING, 131185, Thread.currentThread().getName(), String.valueOf(interruptedException));
            return this.retryNextOperation(traditionalWorkerThread, n + 1);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "nextOperation", exception));
            Error.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.SEVERE_WARNING, 131186, Thread.currentThread().getName(), String.valueOf(exception));
            return this.retryNextOperation(traditionalWorkerThread, n + 1);
        }
    }

    public boolean removeOperation(Operation operation) {
        assert (Debug.debugEnter(CLASS_NAME, "removeOperation", String.valueOf(operation)));
        return this.opQueue.remove(operation);
    }

    public long getOpsSubmitted() {
        assert (Debug.debugEnter(CLASS_NAME, "getOpsSubmitted", new String[0]));
        return this.opsSubmitted.longValue();
    }

    public long getOpsRejectedDueToQueueFull() {
        assert (Debug.debugEnter(CLASS_NAME, "getOpsRejectedDueToQueueFull", new String[0]));
        return this.queueFullRejects.longValue();
    }

    public int size() {
        assert (Debug.debugEnter(CLASS_NAME, "size", new String[0]));
        return this.opQueue.size();
    }

    @Override
    public DN getConfigurableComponentEntryDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigurableComponentEntryDN", new String[0]));
        return this.configEntryDN;
    }

    @Override
    public List<ConfigAttribute> getConfigurationAttributes() {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigurationAttributes", new String[0]));
        LinkedList<ConfigAttribute> linkedList = new LinkedList<ConfigAttribute>();
        int n = 0x300055;
        IntegerConfigAttribute integerConfigAttribute = new IntegerConfigAttribute("ds-cfg-num-worker-threads", MessageHandler.getMessage(n), true, false, false, true, 1L, false, 0L, this.workerThreads.size());
        linkedList.add(integerConfigAttribute);
        n = 3145814;
        IntegerConfigAttribute integerConfigAttribute2 = new IntegerConfigAttribute("ds-cfg-max-work-queue-capacity", MessageHandler.getMessage(n), true, false, false, true, 0L, false, 0L, this.maxCapacity);
        linkedList.add(integerConfigAttribute2);
        return linkedList;
    }

    @Override
    public boolean hasAcceptableConfiguration(ConfigEntry configEntry, List<String> list) {
        String string;
        IntegerConfigAttribute integerConfigAttribute;
        assert (Debug.debugEnter(CLASS_NAME, "hasAcceptableConfiguration", String.valueOf(configEntry), "java.util.List"));
        boolean bl = true;
        int n = 0x300055;
        IntegerConfigAttribute integerConfigAttribute2 = new IntegerConfigAttribute("ds-cfg-num-worker-threads", MessageHandler.getMessage(n), true, false, false, true, 1L, false, 0L, this.workerThreads.size());
        try {
            int n2;
            integerConfigAttribute = (IntegerConfigAttribute)configEntry.getConfigAttribute(integerConfigAttribute2);
            if (integerConfigAttribute != null && (n2 = integerConfigAttribute.activeIntValue()) <= 0) {
                n = 3276889;
                string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), n2);
                list.add(string);
                bl = false;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "<init>", exception));
            n = 3407959;
            String string2 = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), String.valueOf(exception));
            list.add(string2);
            bl = false;
        }
        n = 3145814;
        integerConfigAttribute = new IntegerConfigAttribute("ds-cfg-max-work-queue-capacity", MessageHandler.getMessage(n), true, false, false, true, 0L, false, 0L, this.maxCapacity);
        try {
            int n3;
            IntegerConfigAttribute integerConfigAttribute3 = (IntegerConfigAttribute)configEntry.getConfigAttribute(integerConfigAttribute);
            if (integerConfigAttribute3 != null && (n3 = integerConfigAttribute3.activeIntValue()) < 0) {
                n = 3276890;
                String string3 = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), n3);
                list.add(string3);
                bl = false;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "<init>", exception));
            n = 3407960;
            string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), String.valueOf(exception));
            list.add(string);
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigChangeResult applyNewConfiguration(ConfigEntry configEntry, boolean bl) {
        Object object;
        String string;
        int n;
        Object object2;
        int n2;
        IntegerConfigAttribute integerConfigAttribute;
        assert (Debug.debugEnter(CLASS_NAME, "applyNewConfiguration", String.valueOf(configEntry), String.valueOf(bl)));
        ArrayList<String> arrayList = new ArrayList<String>();
        int n3 = 0x300055;
        IntegerConfigAttribute integerConfigAttribute2 = new IntegerConfigAttribute("ds-cfg-num-worker-threads", MessageHandler.getMessage(n3), true, false, false, true, 1L, false, 0L, this.workerThreads.size());
        try {
            integerConfigAttribute = (IntegerConfigAttribute)configEntry.getConfigAttribute(integerConfigAttribute2);
            if (integerConfigAttribute == null) {
                n2 = 24;
            } else {
                n2 = integerConfigAttribute.activeIntValue();
                if (n2 <= 0) {
                    n3 = 3276889;
                    object2 = MessageHandler.getMessage(n3, String.valueOf(this.configEntryDN), n2);
                    arrayList.add((String)object2);
                    n2 = 24;
                }
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
            n3 = 3407959;
            object2 = MessageHandler.getMessage(n3, String.valueOf(this.configEntryDN), String.valueOf(exception));
            arrayList.add((String)object2);
            n2 = 24;
        }
        n3 = 3145814;
        integerConfigAttribute = new IntegerConfigAttribute("ds-cfg-max-work-queue-capacity", MessageHandler.getMessage(n3), true, false, false, true, 0L, false, 0L, this.maxCapacity);
        try {
            object2 = (IntegerConfigAttribute)configEntry.getConfigAttribute(integerConfigAttribute);
            if (object2 == null) {
                n = 0;
            } else {
                n = ((IntegerConfigAttribute)object2).activeIntValue();
                if (n < 0) {
                    n3 = 3276890;
                    string = MessageHandler.getMessage(n3, String.valueOf(this.configEntryDN), n);
                    arrayList.add(string);
                    n = 0;
                }
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
            n3 = 3407960;
            string = MessageHandler.getMessage(n3, String.valueOf(this.configEntryDN), String.valueOf(exception));
            arrayList.add(string);
            n = 0;
        }
        int n4 = this.workerThreads.size();
        if (n2 != n4) {
            this.queueLock.lock();
            try {
                int n5 = n2 - n4;
                if (n5 > 0) {
                    for (int i = 0; i < n5; ++i) {
                        object = new TraditionalWorkerThread(this, this.lastThreadNumber++);
                        this.workerThreads.add((TraditionalWorkerThread)object);
                        ((Thread)object).start();
                    }
                    if (bl) {
                        n3 = 3145819;
                        String string2 = MessageHandler.getMessage(n3, n5, n2);
                        arrayList.add(string2);
                    }
                    this.killThreads = false;
                } else {
                    if (bl) {
                        n3 = 3145820;
                        String string3 = MessageHandler.getMessage(n3, Math.abs(n5), n2);
                        arrayList.add(string3);
                    }
                    this.killThreads = true;
                }
                this.numWorkerThreads = n2;
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
            }
            finally {
                this.queueLock.unlock();
            }
        }
        if (n != this.maxCapacity) {
            this.queueLock.lock();
            try {
                Object object3;
                LinkedBlockingQueue<Operation> linkedBlockingQueue = n > 0 ? new LinkedBlockingQueue(n) : new LinkedBlockingQueue<Operation>();
                LinkedBlockingQueue<Operation> linkedBlockingQueue2 = this.opQueue;
                this.opQueue = linkedBlockingQueue;
                object = new LinkedList();
                linkedBlockingQueue2.drainTo((Collection<Operation>)object);
                while (!((AbstractCollection)object).isEmpty()) {
                    object3 = ((AbstractSequentialList)object).iterator();
                    while (object3.hasNext()) {
                        Operation operation = (Operation)object3.next();
                        try {
                            if (!linkedBlockingQueue.offer(operation, 1000L, TimeUnit.MILLISECONDS)) continue;
                            object3.remove();
                        }
                        catch (InterruptedException interruptedException) {
                            assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", interruptedException));
                        }
                    }
                }
                if (bl) {
                    n3 = 3145821;
                    object3 = MessageHandler.getMessage(n3, n);
                    arrayList.add((String)object3);
                }
                this.maxCapacity = n;
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
            }
            finally {
                this.queueLock.unlock();
            }
        }
        return new ConfigChangeResult(ResultCode.SUCCESS, false, arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isIdle() {
        assert (Debug.debugEnter(CLASS_NAME, "isIdle", new String[0]));
        if (this.opQueue.size() > 0) {
            return false;
        }
        this.queueLock.lock();
        try {
            for (TraditionalWorkerThread traditionalWorkerThread : this.workerThreads) {
                if (!traditionalWorkerThread.isActive()) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.queueLock.unlock();
        }
    }
}

