/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.security.cert.Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLSession;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.ConnectionSecurityProvider;
import org.opends.server.api.KeyManagerProvider;
import org.opends.server.api.TrustManagerProvider;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.InitializationException;
import org.opends.server.types.SSLClientAuthPolicy;
import org.opends.server.util.StaticUtils;

public class TLSConnectionSecurityProvider
extends ConnectionSecurityProvider {
    private static final String CLASS_NAME = "org.opends.server.extensions.TLSConnectionSecurityProvider";
    private static final String SSL_CONTEXT_INSTANCE_NAME = "TLS";
    private ByteBuffer clearInBuffer;
    private ByteBuffer clearOutBuffer;
    private ByteBuffer sslInBuffer;
    private ByteBuffer sslOutBuffer;
    private ClientConnection clientConnection;
    private int clearBufferSize;
    private int sslBufferSize;
    private SocketChannel socketChannel;
    private SSLClientAuthPolicy sslClientAuthPolicy;
    private SSLContext sslContext;
    private SSLEngine sslEngine;
    private String[] enabledCipherSuites;
    private String[] enabledProtocols;

    public TLSConnectionSecurityProvider() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    private TLSConnectionSecurityProvider(ClientConnection clientConnection, SocketChannel socketChannel, TLSConnectionSecurityProvider tLSConnectionSecurityProvider) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(clientConnection)));
        this.clientConnection = clientConnection;
        this.socketChannel = socketChannel;
        Socket socket = socketChannel.socket();
        InetAddress inetAddress = socketChannel.socket().getInetAddress();
        this.sslContext = tLSConnectionSecurityProvider.sslContext;
        this.sslEngine = this.sslContext.createSSLEngine(inetAddress.getHostName(), socket.getPort());
        this.sslEngine.setUseClientMode(false);
        this.enabledProtocols = tLSConnectionSecurityProvider.enabledProtocols;
        if (this.enabledProtocols != null) {
            this.sslEngine.setEnabledProtocols(this.enabledProtocols);
        }
        this.enabledCipherSuites = tLSConnectionSecurityProvider.enabledCipherSuites;
        if (this.enabledCipherSuites != null) {
            this.sslEngine.setEnabledCipherSuites(this.enabledCipherSuites);
        }
        this.sslClientAuthPolicy = tLSConnectionSecurityProvider.sslClientAuthPolicy;
        if (this.sslClientAuthPolicy == null) {
            this.sslClientAuthPolicy = SSLClientAuthPolicy.OPTIONAL;
        }
        switch (this.sslClientAuthPolicy) {
            case REQUIRED: {
                this.sslEngine.setWantClientAuth(true);
                this.sslEngine.setNeedClientAuth(true);
                break;
            }
            case DISABLED: {
                this.sslEngine.setNeedClientAuth(false);
                this.sslEngine.setWantClientAuth(false);
                break;
            }
            default: {
                this.sslEngine.setNeedClientAuth(false);
                this.sslEngine.setWantClientAuth(true);
            }
        }
        SSLSession sSLSession = this.sslEngine.getSession();
        this.clearBufferSize = sSLSession.getApplicationBufferSize();
        this.clearInBuffer = ByteBuffer.allocate(this.clearBufferSize);
        this.clearOutBuffer = ByteBuffer.allocate(this.clearBufferSize);
        this.sslBufferSize = sSLSession.getPacketBufferSize();
        this.sslInBuffer = ByteBuffer.allocate(this.sslBufferSize);
        this.sslOutBuffer = ByteBuffer.allocate(this.sslBufferSize);
    }

    public void initializeConnectionSecurityProvider(ConfigEntry configEntry) throws ConfigException, InitializationException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeConnectionSecurityProvider", String.valueOf(configEntry)));
        this.clientConnection = null;
        this.socketChannel = null;
        this.clearInBuffer = null;
        this.clearOutBuffer = null;
        this.sslInBuffer = null;
        this.sslOutBuffer = null;
        this.clearBufferSize = -1;
        this.sslBufferSize = -1;
        this.sslEngine = null;
        KeyManagerProvider keyManagerProvider = DirectoryServer.getKeyManagerProvider();
        TrustManagerProvider trustManagerProvider = DirectoryServer.getTrustManagerProvider();
        try {
            this.sslContext = SSLContext.getInstance(SSL_CONTEXT_INSTANCE_NAME);
            this.sslContext.init(keyManagerProvider.getKeyManagers(), trustManagerProvider.getTrustManagers(), null);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeConnectionSecurityProvider", exception));
            int n = 1310832;
            String string = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n, string, exception);
        }
        this.enabledProtocols = null;
        this.enabledCipherSuites = null;
        this.sslClientAuthPolicy = SSLClientAuthPolicy.OPTIONAL;
    }

    public void finalizeConnectionSecurityProvider() {
        assert (Debug.debugEnter(CLASS_NAME, "finalizeConnectionSecurityProvider", new String[0]));
    }

    public String getSecurityMechanismName() {
        assert (Debug.debugEnter(CLASS_NAME, "getSecurityMechanismName", new String[0]));
        return SSL_CONTEXT_INSTANCE_NAME;
    }

    public boolean isSecure() {
        assert (Debug.debugEnter(CLASS_NAME, "isSecure", new String[0]));
        return true;
    }

    public ConnectionSecurityProvider newInstance(ClientConnection clientConnection, SocketChannel socketChannel) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "newInstance", String.valueOf(clientConnection), String.valueOf(socketChannel)));
        return new TLSConnectionSecurityProvider(clientConnection, socketChannel, this);
    }

    public void disconnect(boolean bl) {
        block14: {
            assert (Debug.debugEnter(CLASS_NAME, "disconnect", new String[0]));
            if (bl) {
                try {
                    this.sslEngine.closeInbound();
                    this.sslEngine.closeOutbound();
                    block8: while (true) {
                        switch (this.sslEngine.getHandshakeStatus()) {
                            case FINISHED: 
                            case NOT_HANDSHAKING: {
                                return;
                            }
                            case NEED_TASK: {
                                Runnable runnable = this.sslEngine.getDelegatedTask();
                                runnable.run();
                                break;
                            }
                            case NEED_WRAP: {
                                this.clearOutBuffer.clear();
                                this.sslOutBuffer.clear();
                                this.sslEngine.wrap(this.clearOutBuffer, this.sslOutBuffer);
                                this.sslOutBuffer.flip();
                                while (this.sslOutBuffer.hasRemaining()) {
                                    this.socketChannel.write(this.sslOutBuffer);
                                }
                                continue block8;
                            }
                            case NEED_UNWRAP: {
                                if (this.sslInBuffer.hasRemaining()) {
                                    this.clearInBuffer.clear();
                                    this.sslEngine.unwrap(this.sslInBuffer, this.clearInBuffer);
                                    this.clearInBuffer.flip();
                                    break;
                                }
                                this.sslInBuffer.clear();
                                this.clearInBuffer.clear();
                                int n = this.socketChannel.read(this.sslInBuffer);
                                if (n <= 0) {
                                    return;
                                }
                                this.sslEngine.unwrap(this.sslInBuffer, this.clearInBuffer);
                                this.clearInBuffer.flip();
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "disconnect", exception)) break block14;
                    throw new AssertionError();
                }
            }
        }
    }

    public int getClearBufferSize() {
        assert (Debug.debugEnter(CLASS_NAME, "getClearBufferSize", new String[0]));
        return this.clearBufferSize;
    }

    public int getEncodedBufferSize() {
        assert (Debug.debugEnter(CLASS_NAME, "getEncodedBufferSize", new String[0]));
        return this.sslBufferSize;
    }

    /*
     * Unable to fully structure code
     */
    public boolean readData() {
        if (!TLSConnectionSecurityProvider.$assertionsDisabled && !Debug.debugEnter("org.opends.server.extensions.TLSConnectionSecurityProvider", "readData", new String[0])) {
            throw new AssertionError();
        }
        try {
            block15: while (true) {
                this.sslInBuffer.clear();
                var1_1 = this.socketChannel.read(this.sslInBuffer);
                this.sslInBuffer.flip();
                if (var1_1 < 0) {
                    this.clientConnection.disconnect(DisconnectReason.CLIENT_DISCONNECT, false, -1, new Object[0]);
                    return false;
                }
                block16: while (true) {
                    switch (1.$SwitchMap$javax$net$ssl$SSLEngineResult$HandshakeStatus[this.sslEngine.getHandshakeStatus().ordinal()]) {
                        case 3: {
                            var2_4 = this.sslEngine.getDelegatedTask();
                            var2_4.run();
                            continue block16;
                        }
                        case 4: {
                            this.clearOutBuffer.clear();
                            this.sslOutBuffer.clear();
                            this.sslEngine.wrap(this.clearOutBuffer, this.sslOutBuffer);
                            this.sslOutBuffer.flip();
                            do {
                                if (this.sslOutBuffer.hasRemaining()) ** break;
                                continue block16;
                            } while ((var3_5 = this.socketChannel.write(this.sslOutBuffer)) >= 0);
                            this.clientConnection.disconnect(DisconnectReason.CLIENT_DISCONNECT, false, -1, new Object[0]);
                            return false;
                        }
                    }
                    break;
                }
                if (var1_1 == 0) {
                    return true;
                }
                do {
                    if (!this.sslInBuffer.hasRemaining()) continue block15;
                    this.clearInBuffer.clear();
                    var2_4 = this.sslEngine.unwrap(this.sslInBuffer, this.clearInBuffer);
                    this.clearInBuffer.flip();
                    switch (1.$SwitchMap$javax$net$ssl$SSLEngineResult$Status[var2_4.getStatus().ordinal()]) {
                        case 1: {
                            break;
                        }
                        case 2: {
                            this.clientConnection.disconnect(DisconnectReason.CLIENT_DISCONNECT, false, -1, new Object[0]);
                            return false;
                        }
                        default: {
                            this.clientConnection.disconnect(DisconnectReason.SECURITY_PROBLEM, false, 1310833, new Object[]{String.valueOf((Object)var2_4.getStatus())});
                            return false;
                        }
                    }
                    switch (1.$SwitchMap$javax$net$ssl$SSLEngineResult$HandshakeStatus[var2_4.getHandshakeStatus().ordinal()]) {
                        case 3: {
                            var3_6 = this.sslEngine.getDelegatedTask();
                            var3_6.run();
                            break;
                        }
                        case 4: {
                            this.clearOutBuffer.clear();
                            this.sslOutBuffer.clear();
                            this.sslEngine.wrap(this.clearOutBuffer, this.sslOutBuffer);
                            this.sslOutBuffer.flip();
                            while (this.sslOutBuffer.hasRemaining()) {
                                var4_7 = this.socketChannel.write(this.sslOutBuffer);
                                if (var4_7 >= 0) continue;
                                this.clientConnection.disconnect(DisconnectReason.CLIENT_DISCONNECT, false, -1, new Object[0]);
                                return false;
                            }
                            break block9;
                        }
                    }
                } while (this.clientConnection.processDataRead(this.clearInBuffer));
                break;
            }
            return false;
        }
        catch (IOException var1_2) {
            if (!TLSConnectionSecurityProvider.$assertionsDisabled && !Debug.debugException("org.opends.server.extensions.TLSConnectionSecurityProvider", "readData", var1_2)) {
                throw new AssertionError();
            }
            this.clientConnection.disconnect(DisconnectReason.IO_ERROR, false, -1, new Object[0]);
            return false;
        }
        catch (Exception var1_3) {
            if (!TLSConnectionSecurityProvider.$assertionsDisabled && !Debug.debugException("org.opends.server.extensions.TLSConnectionSecurityProvider", "readData", var1_3)) {
                throw new AssertionError();
            }
            this.clientConnection.disconnect(DisconnectReason.SERVER_ERROR, true, 1310834, new Object[]{StaticUtils.stackTraceToSingleLineString(var1_3)});
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeData(ByteBuffer byteBuffer) {
        assert (Debug.debugEnter(CLASS_NAME, "writeData", "java.nio.ByteBuffer"));
        int n = byteBuffer.position();
        int n2 = byteBuffer.limit();
        int n3 = n2 - n;
        try {
            if (n3 > this.clearBufferSize) {
                int n4 = n;
                int n5 = n + this.clearBufferSize;
                while (n4 < n2) {
                    byteBuffer.position(n4);
                    byteBuffer.limit(n5);
                    if (!this.writeInternal(byteBuffer)) {
                        boolean bl = false;
                        return bl;
                    }
                    n4 = n5;
                    n5 = Math.min(n2, n4 + this.clearBufferSize);
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = this.writeInternal(byteBuffer);
            return bl;
        }
        finally {
            byteBuffer.position(n);
            byteBuffer.limit(n2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean writeInternal(ByteBuffer byteBuffer) {
        try {
            Object object;
            block17: while (true) {
                switch (this.sslEngine.getHandshakeStatus()) {
                    case NEED_TASK: {
                        object = this.sslEngine.getDelegatedTask();
                        object.run();
                        continue block17;
                    }
                    case NEED_WRAP: {
                        int n;
                        this.clearOutBuffer.clear();
                        this.sslOutBuffer.clear();
                        this.sslEngine.wrap(this.clearOutBuffer, this.sslOutBuffer);
                        this.sslOutBuffer.flip();
                        do {
                            if (!this.sslOutBuffer.hasRemaining()) continue block17;
                        } while ((n = this.socketChannel.write(this.sslOutBuffer)) >= 0);
                        this.clientConnection.disconnect(DisconnectReason.CLIENT_DISCONNECT, false, -1, new Object[0]);
                        return false;
                    }
                    case NEED_UNWRAP: {
                        this.sslInBuffer.clear();
                        this.clearInBuffer.clear();
                        int n = this.socketChannel.read(this.sslInBuffer);
                        if (n < 0) {
                            this.clientConnection.disconnect(DisconnectReason.CLIENT_DISCONNECT, false, -1, new Object[0]);
                            return false;
                        }
                        if (n == 0) {
                            this.clientConnection.disconnect(DisconnectReason.SECURITY_PROBLEM, false, 1310835, new Object[0]);
                            return false;
                        }
                        this.sslEngine.unwrap(this.sslInBuffer, this.clearInBuffer);
                        this.clearInBuffer.flip();
                        continue block17;
                    }
                }
                break;
            }
            block19: while (true) {
                int n;
                if (!byteBuffer.hasRemaining()) {
                    return true;
                }
                this.sslOutBuffer.clear();
                object = this.sslEngine.wrap(byteBuffer, this.sslOutBuffer);
                this.sslOutBuffer.flip();
                switch (((SSLEngineResult)object).getStatus()) {
                    case OK: {
                        break;
                    }
                    case CLOSED: {
                        this.clientConnection.disconnect(DisconnectReason.CLIENT_DISCONNECT, false, -1, new Object[0]);
                        return false;
                    }
                    default: {
                        this.clientConnection.disconnect(DisconnectReason.SECURITY_PROBLEM, false, 1310836, String.valueOf((Object)((SSLEngineResult)object).getStatus()));
                        return false;
                    }
                }
                switch (((SSLEngineResult)object).getHandshakeStatus()) {
                    case NEED_TASK: {
                        Runnable runnable = this.sslEngine.getDelegatedTask();
                        runnable.run();
                        break;
                    }
                    case NEED_WRAP: {
                        int n2;
                        this.clearOutBuffer.clear();
                        this.sslOutBuffer.clear();
                        this.sslEngine.wrap(this.clearOutBuffer, this.sslOutBuffer);
                        this.sslOutBuffer.flip();
                        while (this.sslOutBuffer.hasRemaining()) {
                            n2 = this.socketChannel.write(this.sslOutBuffer);
                            if (n2 >= 0) continue;
                            this.clientConnection.disconnect(DisconnectReason.CLIENT_DISCONNECT, false, -1, new Object[0]);
                            return false;
                        }
                        break;
                    }
                    case NEED_UNWRAP: {
                        this.sslInBuffer.clear();
                        this.clearInBuffer.clear();
                        int n2 = this.socketChannel.read(this.sslInBuffer);
                        if (n2 < 0) {
                            this.clientConnection.disconnect(DisconnectReason.CLIENT_DISCONNECT, false, -1, new Object[0]);
                            return false;
                        }
                        if (n2 == 0) {
                            this.clientConnection.disconnect(DisconnectReason.SECURITY_PROBLEM, false, 1310835, new Object[0]);
                            return false;
                        }
                        this.sslEngine.unwrap(this.sslInBuffer, this.clearInBuffer);
                        this.clearInBuffer.flip();
                        break;
                    }
                }
                do {
                    if (!this.sslOutBuffer.hasRemaining()) continue block19;
                } while ((n = this.socketChannel.write(this.sslOutBuffer)) >= 0);
                break;
            }
            this.clientConnection.disconnect(DisconnectReason.CLIENT_DISCONNECT, false, -1, new Object[0]);
            return false;
        }
        catch (IOException iOException) {
            assert (Debug.debugException(CLASS_NAME, "writeData", iOException));
            this.clientConnection.disconnect(DisconnectReason.IO_ERROR, false, -1, new Object[0]);
            return false;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "writeData", exception));
            this.clientConnection.disconnect(DisconnectReason.SERVER_ERROR, true, 1310837, StaticUtils.stackTraceToSingleLineString(exception));
            return false;
        }
    }

    public String[] getEnabledProtocols() {
        assert (Debug.debugEnter(CLASS_NAME, "getEnabledProtocols", new String[0]));
        return this.enabledProtocols;
    }

    public void setEnabledProtocols(String[] stringArray) {
        assert (Debug.debugEnter(CLASS_NAME, "setEnabledProtocols", String.valueOf(stringArray)));
        this.enabledProtocols = stringArray;
    }

    public String[] getEnabledCipherSuites() {
        assert (Debug.debugEnter(CLASS_NAME, "getEnabledCipherSuites", new String[0]));
        return this.enabledCipherSuites;
    }

    public void setEnabledCipherSuites(String[] stringArray) {
        assert (Debug.debugEnter(CLASS_NAME, "setEnabledCipherSuites", String.valueOf(stringArray)));
        this.enabledCipherSuites = stringArray;
    }

    public SSLClientAuthPolicy getSSLClientAuthPolicy() {
        assert (Debug.debugEnter(CLASS_NAME, "getSSLClientAuthPolicy", new String[0]));
        return this.sslClientAuthPolicy;
    }

    public void setSSLClientAuthPolicy(SSLClientAuthPolicy sSLClientAuthPolicy) {
        assert (Debug.debugEnter(CLASS_NAME, "setSSLClientAuthPolicy", String.valueOf((Object)sSLClientAuthPolicy)));
        this.sslClientAuthPolicy = sSLClientAuthPolicy;
    }

    public SSLSession getSSLSession() {
        assert (Debug.debugEnter(CLASS_NAME, "getSSLSession", new String[0]));
        return this.sslEngine.getSession();
    }

    public Certificate[] getClientCertificateChain() {
        assert (Debug.debugEnter(CLASS_NAME, "getClientCertificateChain", new String[0]));
        try {
            return this.sslEngine.getSession().getPeerCertificates();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "getClientCertificateChain", exception));
            return null;
        }
    }
}

