/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.concurrent.locks.Lock;
import javax.security.auth.x500.X500Principal;
import org.opends.server.api.CertificateMapper;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.LockManager;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public class SubjectEqualsDNCertificateMapper
extends CertificateMapper {
    private static final String CLASS_NAME = "org.opends.server.extensions.SubjectEqualsDNCertificateMapper";

    public SubjectEqualsDNCertificateMapper() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    public void initializeCertificateMapper(ConfigEntry configEntry) throws ConfigException, InitializationException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeCertificateMapper", String.valueOf(configEntry)));
    }

    public Entry mapCertificateToUser(Certificate[] certificateArray) throws DirectoryException {
        Entry entry;
        int n;
        DN dN;
        X509Certificate x509Certificate;
        assert (Debug.debugEnter(CLASS_NAME, "mapCertificateToUser", String.valueOf(certificateArray)));
        if (certificateArray == null || certificateArray.length == 0) {
            int n2 = 1245302;
            String string = MessageHandler.getMessage(n2);
            throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, string, n2);
        }
        try {
            x509Certificate = (X509Certificate)certificateArray[0];
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "mapCertificateToUser", exception));
            int n3 = 1245303;
            String string = MessageHandler.getMessage(n3, String.valueOf(certificateArray[0].getType()));
            throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, string, n3);
        }
        X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
        try {
            dN = DN.decode(x500Principal.getName("RFC2253"));
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "mapCertificateToUser", exception));
            int n4 = 1245304;
            String string = MessageHandler.getMessage(n4, String.valueOf(x500Principal), StaticUtils.stackTraceToSingleLineString(exception));
            throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, string, n4);
        }
        Lock lock = null;
        for (n = 0; n < 3 && (lock = LockManager.lockRead(dN)) == null; ++n) {
        }
        if (lock == null) {
            n = 1245348;
            String string = MessageHandler.getMessage(n, String.valueOf(dN));
            throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, string, n);
        }
        try {
            entry = DirectoryServer.getEntry(dN);
        }
        catch (DirectoryException directoryException) {
            assert (Debug.debugException(CLASS_NAME, "mapCertificateToUser", directoryException));
            int n5 = 1245305;
            String string = MessageHandler.getMessage(n5, String.valueOf(dN), directoryException.getErrorMessage());
            throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, string, n5, directoryException);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "mapCertificateToUser", exception));
            int n6 = 1245305;
            String string = MessageHandler.getMessage(n6, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception));
            throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, string, n6, exception);
        }
        finally {
            LockManager.unlock(dN, lock);
        }
        if (entry == null) {
            int n7 = 1245306;
            String string = MessageHandler.getMessage(n7, String.valueOf(dN));
            throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, string, n7);
        }
        return entry;
    }
}

