/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.opends.server.api.ConfigurableComponent;
import org.opends.server.api.IdentityMapper;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.config.DNConfigAttribute;
import org.opends.server.config.StringConfigAttribute;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.internal.InternalSearchOperation;
import org.opends.server.protocols.ldap.LDAPFilter;
import org.opends.server.types.AttributeType;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DereferencePolicy;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchScope;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExactMatchIdentityMapper
extends IdentityMapper
implements ConfigurableComponent {
    private static final String CLASS_NAME = "org.opends.server.core.ExactMatchIdentityMapper";
    private ASN1OctetString[] rawSearchBases;
    private DN configEntryDN;
    private LinkedHashSet<String> requestedAttributes;
    private String[] rawMatchAttributes;

    @Override
    public void initializeIdentityMapper(ConfigEntry configEntry) throws ConfigException, InitializationException {
        List<String> list;
        ConfigAttribute configAttribute;
        assert (Debug.debugEnter(CLASS_NAME, "initializeIdentityMapper", String.valueOf(configEntry)));
        this.configEntryDN = configEntry.getDN();
        int n = 1048874;
        StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-match-attribute", MessageHandler.getMessage(n), true, true, false);
        try {
            configAttribute = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
            if (configAttribute == null) {
                n = 1245483;
                String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN));
                throw new ConfigException(n, string);
            }
            list = configAttribute.activeValues();
            if (list.size() == 0) {
                n = 1245483;
                String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN));
                throw new ConfigException(n, string);
            }
            this.rawMatchAttributes = new String[list.size()];
            for (int i = 0; i < this.rawMatchAttributes.length; ++i) {
                String string = list.get(i);
                String string2 = StaticUtils.toLowerCase(string);
                AttributeType attributeType = DirectoryServer.getAttributeType(string2);
                if (attributeType == null) {
                    n = 1245484;
                    String string3 = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), string2);
                    throw new ConfigException(n, string3);
                }
                this.rawMatchAttributes[i] = string;
            }
        }
        catch (ConfigException configException) {
            throw configException;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeIdentityMapper", exception));
            n = 1245485;
            String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n, string, exception);
        }
        n = 1048878;
        configAttribute = new DNConfigAttribute("ds-cfg-match-base-dn", MessageHandler.getMessage(n), false, true, false);
        try {
            list = (DNConfigAttribute)configEntry.getConfigAttribute(configAttribute);
            if (list == null) {
                this.rawSearchBases = new ASN1OctetString[]{new ASN1OctetString()};
            } else {
                List<DN> list2 = ((DNConfigAttribute)((Object)list)).activeValues();
                if (list2.size() == 0) {
                    this.rawSearchBases = new ASN1OctetString[]{new ASN1OctetString()};
                } else {
                    this.rawSearchBases = new ASN1OctetString[list2.size()];
                    for (int i = 0; i < this.rawSearchBases.length; ++i) {
                        this.rawSearchBases[i] = new ASN1OctetString(list2.get(i).toString());
                    }
                }
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeIdentityMapper", exception));
            n = 1245487;
            String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n, string, exception);
        }
        DirectoryServer.registerConfigurableComponent(this);
        this.requestedAttributes = new LinkedHashSet(2);
        this.requestedAttributes.add("*");
        this.requestedAttributes.add("+");
    }

    @Override
    public void finalizeIdentityMapper() {
        assert (Debug.debugEnter(CLASS_NAME, "finalizeIdentityMapper", new String[0]));
        DirectoryServer.deregisterConfigurableComponent(this);
    }

    @Override
    public Entry getEntryForID(String string) throws DirectoryException {
        Object object;
        Object object2;
        LDAPFilter lDAPFilter;
        assert (Debug.debugEnter(CLASS_NAME, "getEntryForID", String.valueOf(string)));
        String[] stringArray = this.rawMatchAttributes;
        ASN1OctetString[] aSN1OctetStringArray = this.rawSearchBases;
        if (stringArray.length == 1) {
            lDAPFilter = LDAPFilter.createEqualityFilter(stringArray[0], new ASN1OctetString(string));
        } else {
            object2 = new ArrayList<LDAPFilter>(stringArray.length);
            object = new ASN1OctetString(string);
            for (String object3 : stringArray) {
                ((ArrayList)object2).add((LDAPFilter)LDAPFilter.createEqualityFilter(object3, (ASN1OctetString)object));
            }
            lDAPFilter = LDAPFilter.createORFilter(object2);
        }
        object2 = null;
        object = InternalClientConnection.getRootConnection();
        for (ASN1OctetString aSN1OctetString : aSN1OctetStringArray) {
            Object object3;
            InternalSearchOperation internalSearchOperation = ((InternalClientConnection)object).processSearch(aSN1OctetString, SearchScope.WHOLE_SUBTREE, DereferencePolicy.NEVER_DEREF_ALIASES, 1, 10, false, lDAPFilter, this.requestedAttributes);
            switch (internalSearchOperation.getResultCode()) {
                case SUCCESS: {
                    break;
                }
                case NO_SUCH_OBJECT: {
                    break;
                }
                case SIZE_LIMIT_EXCEEDED: {
                    int n = 1245490;
                    object3 = MessageHandler.getMessage(n, String.valueOf(string));
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, (String)object3, n);
                }
                case TIME_LIMIT_EXCEEDED: 
                case ADMIN_LIMIT_EXCEEDED: {
                    int n = 0x130133;
                    object3 = MessageHandler.getMessage(n, String.valueOf(string), String.valueOf(internalSearchOperation.getErrorMessage()));
                    throw new DirectoryException(internalSearchOperation.getResultCode(), (String)object3, n);
                }
                default: {
                    int n = 1245492;
                    object3 = MessageHandler.getMessage(n, String.valueOf(string), String.valueOf(internalSearchOperation.getErrorMessage()));
                    throw new DirectoryException(internalSearchOperation.getResultCode(), (String)object3, n);
                }
            }
            LinkedList<SearchResultEntry> n = internalSearchOperation.getSearchEntries();
            if (n == null || n.isEmpty()) continue;
            if (object2 == null) {
                object3 = n.iterator();
                object2 = (SearchResultEntry)object3.next();
                if (!object3.hasNext()) continue;
                int n2 = 1245490;
                String string2 = MessageHandler.getMessage(n2, String.valueOf(string));
                throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, string2, n2);
            }
            int n3 = 1245490;
            String string3 = MessageHandler.getMessage(n3, String.valueOf(string));
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, string3, n3);
        }
        if (object2 == null) {
            return null;
        }
        return object2;
    }

    @Override
    public DN getConfigurableComponentEntryDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigurableComponentEntryDN", new String[0]));
        return this.configEntryDN;
    }

    @Override
    public List<ConfigAttribute> getConfigurationAttributes() {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigurationAttributes", new String[0]));
        LinkedList<ConfigAttribute> linkedList = new LinkedList<ConfigAttribute>();
        String[] stringArray = this.rawMatchAttributes;
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (String string : stringArray) {
            arrayList.add(string);
        }
        String string = MessageHandler.getMessage(1048874);
        linkedList.add(new StringConfigAttribute("ds-cfg-match-attribute", string, true, true, false, arrayList));
        ASN1OctetString[] aSN1OctetStringArray = this.rawSearchBases;
        ArrayList<DN> arrayList2 = new ArrayList<DN>(aSN1OctetStringArray.length);
        for (ASN1OctetString aSN1OctetString : aSN1OctetStringArray) {
            try {
                arrayList2.add(DN.decode(aSN1OctetString));
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "getConfigurationAttributes", exception));
            }
        }
        String string2 = MessageHandler.getMessage(1048878);
        linkedList.add(new DNConfigAttribute("ds-cfg-match-base-dn", string2, false, true, false, arrayList2));
        return linkedList;
    }

    @Override
    public boolean hasAcceptableConfiguration(ConfigEntry configEntry, List<String> list) {
        List<String> list2;
        ConfigAttribute configAttribute;
        assert (Debug.debugEnter(CLASS_NAME, "hasAcceptableConfiguration", String.valueOf(configEntry), "java.util.List<String>"));
        boolean bl = true;
        int n = 1048874;
        StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-match-attribute", MessageHandler.getMessage(n), true, true, false);
        try {
            configAttribute = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
            if (configAttribute == null) {
                n = 1245483;
                list.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN)));
                bl = false;
            } else {
                list2 = configAttribute.activeValues();
                if (list2.size() == 0) {
                    n = 1245483;
                    list.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN)));
                    bl = false;
                }
                for (String string : list2) {
                    String string2 = StaticUtils.toLowerCase(string);
                    AttributeType attributeType = DirectoryServer.getAttributeType(string2);
                    if (attributeType != null) continue;
                    n = 1245484;
                    list.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), string));
                    bl = false;
                }
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            n = 1245485;
            list.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            bl = false;
        }
        n = 1048878;
        configAttribute = new DNConfigAttribute("ds-cfg-match-base-dn", MessageHandler.getMessage(n), false, true, false);
        try {
            list2 = (DNConfigAttribute)configEntry.getConfigAttribute(configAttribute);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            n = 1245487;
            list.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            bl = false;
        }
        return bl;
    }

    @Override
    public ConfigChangeResult applyNewConfiguration(ConfigEntry configEntry, boolean bl) {
        Object[] objectArray;
        Object[] objectArray2;
        int n;
        ArrayList<String> arrayList;
        boolean bl2;
        ResultCode resultCode;
        block26: {
            List<DN> list;
            List<String> list2;
            block25: {
                assert (Debug.debugEnter(CLASS_NAME, "applyNewConfiguration", String.valueOf(configEntry), String.valueOf(bl)));
                resultCode = ResultCode.SUCCESS;
                bl2 = false;
                arrayList = new ArrayList<String>();
                n = 1048874;
                objectArray2 = null;
                StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-match-attribute", MessageHandler.getMessage(n), true, true, false);
                try {
                    objectArray = (Object[])configEntry.getConfigAttribute(stringConfigAttribute);
                    if (objectArray == null) {
                        n = 1245483;
                        arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN)));
                        if (resultCode == ResultCode.SUCCESS) {
                            resultCode = ResultCode.CONSTRAINT_VIOLATION;
                        }
                    } else {
                        list2 = objectArray.activeValues();
                        if (list2.size() == 0) {
                            n = 1245483;
                            arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN)));
                            if (resultCode == ResultCode.SUCCESS) {
                                resultCode = ResultCode.CONSTRAINT_VIOLATION;
                            }
                        } else {
                            objectArray2 = new String[list2.size()];
                            for (int i = 0; i < objectArray2.length; ++i) {
                                list = list2.get(i);
                                String string = StaticUtils.toLowerCase((String)((Object)list));
                                AttributeType attributeType = DirectoryServer.getAttributeType(string);
                                if (attributeType == null) {
                                    n = 1245484;
                                    arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), String.valueOf(list2.get(i))));
                                    if (resultCode != ResultCode.SUCCESS) continue;
                                    resultCode = ResultCode.CONSTRAINT_VIOLATION;
                                    continue;
                                }
                                objectArray2[i] = list;
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
                    n = 1245485;
                    arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
                    if (resultCode != ResultCode.SUCCESS) break block25;
                    resultCode = DirectoryServer.getServerErrorResultCode();
                }
            }
            n = 1048878;
            objectArray = null;
            list2 = new DNConfigAttribute("ds-cfg-match-base-dn", MessageHandler.getMessage(n), false, true, false);
            try {
                DNConfigAttribute dNConfigAttribute = (DNConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)((Object)list2));
                if (dNConfigAttribute == null) {
                    objectArray = new ASN1OctetString[]{new ASN1OctetString()};
                } else {
                    list = dNConfigAttribute.pendingValues();
                    if (list == null || list.isEmpty()) {
                        objectArray = new ASN1OctetString[]{new ASN1OctetString()};
                    } else {
                        objectArray = new ASN1OctetString[list.size()];
                        for (int i = 0; i < objectArray.length; ++i) {
                            objectArray[i] = new ASN1OctetString(((DN)list.get(i)).toString());
                        }
                    }
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
                n = 1245487;
                arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
                if (resultCode != ResultCode.SUCCESS) break block26;
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
        }
        if (resultCode == ResultCode.SUCCESS) {
            if (!Arrays.equals(this.rawMatchAttributes, objectArray2)) {
                this.rawMatchAttributes = objectArray2;
                if (bl) {
                    n = 0x100130;
                    arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN)));
                }
            }
            if (!Arrays.equals(this.rawSearchBases, objectArray)) {
                this.rawSearchBases = objectArray;
                if (bl) {
                    n = 0x100131;
                    arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN)));
                }
            }
        }
        return new ConfigChangeResult(resultCode, bl2, arrayList);
    }
}

