/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.opends.server.api.AccountStatusNotificationHandler;
import org.opends.server.api.ConfigurableComponent;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.config.MultiChoiceConfigAttribute;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.AccountStatusNotificationType;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorLogAccountStatusNotificationHandler
extends AccountStatusNotificationHandler
implements ConfigurableComponent {
    private static final String CLASS_NAME = "org.opends.server.extensions.ErrorLogAccountStatusNotificationHandler";
    private static final HashSet<String> NOTIFICATION_TYPE_NAMES = new HashSet();
    private DN configEntryDN;
    private HashSet<AccountStatusNotificationType> notificationTypes;

    @Override
    public void initializeStatusNotificationHandler(ConfigEntry configEntry) throws ConfigException, InitializationException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeStatusNotificationHandler", String.valueOf(configEntry)));
        this.configEntryDN = configEntry.getDN();
        int n = 1048948;
        MultiChoiceConfigAttribute multiChoiceConfigAttribute = new MultiChoiceConfigAttribute("ds-cfg-account-status-notification-type", MessageHandler.getMessage(n), true, true, false, NOTIFICATION_TYPE_NAMES);
        try {
            MultiChoiceConfigAttribute multiChoiceConfigAttribute2 = (MultiChoiceConfigAttribute)configEntry.getConfigAttribute(multiChoiceConfigAttribute);
            this.notificationTypes = new HashSet();
            for (String string : multiChoiceConfigAttribute2.activeValues()) {
                AccountStatusNotificationType accountStatusNotificationType = AccountStatusNotificationType.typeForName(string);
                if (accountStatusNotificationType == null) {
                    n = 1245557;
                    String string2 = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), string);
                    throw new ConfigException(n, string2);
                }
                this.notificationTypes.add(accountStatusNotificationType);
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeStatusNotificationHandler", exception));
            n = 1245558;
            String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n, string, exception);
        }
        DirectoryServer.registerConfigurableComponent(this);
        DirectoryServer.registerAccountStatusNotificationHandler(this.configEntryDN, this);
    }

    @Override
    public void handleStatusNotification(AccountStatusNotificationType accountStatusNotificationType, DN dN, int n, String string) {
        assert (Debug.debugEnter(CLASS_NAME, "handleStatusNotification", String.valueOf((Object)accountStatusNotificationType), String.valueOf(dN), String.valueOf(n), String.valueOf(string)));
        if (this.notificationTypes.contains((Object)accountStatusNotificationType)) {
            int n2 = 0x170177;
            Error.logError(ErrorLogCategory.PASSWORD_POLICY, ErrorLogSeverity.NOTICE, n2, accountStatusNotificationType.getNotificationTypeName(), String.valueOf(dN), n, string);
        }
    }

    @Override
    public DN getConfigurableComponentEntryDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigurableComponentEntryDN", new String[0]));
        return this.configEntryDN;
    }

    @Override
    public List<ConfigAttribute> getConfigurationAttributes() {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigurationAttributes", new String[0]));
        LinkedList<ConfigAttribute> linkedList = new LinkedList<ConfigAttribute>();
        LinkedList<String> linkedList2 = new LinkedList<String>();
        for (AccountStatusNotificationType accountStatusNotificationType : this.notificationTypes) {
            linkedList2.add(accountStatusNotificationType.getNotificationTypeName());
        }
        int n = 1048948;
        linkedList.add(new MultiChoiceConfigAttribute("ds-cfg-account-status-notification-type", MessageHandler.getMessage(n), true, true, false, NOTIFICATION_TYPE_NAMES, linkedList2));
        return linkedList;
    }

    @Override
    public boolean hasAcceptableConfiguration(ConfigEntry configEntry, List<String> list) {
        assert (Debug.debugEnter(CLASS_NAME, "hasAcceptableConfiguration", String.valueOf(configEntry), "List<String>"));
        int n = 1048948;
        MultiChoiceConfigAttribute multiChoiceConfigAttribute = new MultiChoiceConfigAttribute("ds-cfg-account-status-notification-type", MessageHandler.getMessage(n), true, true, false, NOTIFICATION_TYPE_NAMES);
        try {
            MultiChoiceConfigAttribute multiChoiceConfigAttribute2 = (MultiChoiceConfigAttribute)configEntry.getConfigAttribute(multiChoiceConfigAttribute);
            HashSet<AccountStatusNotificationType> hashSet = new HashSet<AccountStatusNotificationType>();
            for (String string : multiChoiceConfigAttribute2.activeValues()) {
                AccountStatusNotificationType accountStatusNotificationType = AccountStatusNotificationType.typeForName(string);
                if (accountStatusNotificationType == null) {
                    n = 1245557;
                    String string2 = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), string);
                    list.add(string2);
                    return false;
                }
                hashSet.add(accountStatusNotificationType);
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            n = 1245558;
            String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
            list.add(string);
            return false;
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyNewConfiguration(ConfigEntry configEntry, boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "applyNewConfiguration", String.valueOf(configEntry), String.valueOf(bl)));
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean bl2 = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        HashSet<AccountStatusNotificationType> hashSet = new HashSet<AccountStatusNotificationType>();
        int n = 1048948;
        MultiChoiceConfigAttribute multiChoiceConfigAttribute = new MultiChoiceConfigAttribute("ds-cfg-account-status-notification-type", MessageHandler.getMessage(n), true, true, false, NOTIFICATION_TYPE_NAMES);
        try {
            MultiChoiceConfigAttribute multiChoiceConfigAttribute2 = (MultiChoiceConfigAttribute)configEntry.getConfigAttribute(multiChoiceConfigAttribute);
            for (String string : multiChoiceConfigAttribute2.activeValues()) {
                AccountStatusNotificationType accountStatusNotificationType = AccountStatusNotificationType.typeForName(string);
                if (accountStatusNotificationType == null) {
                    resultCode = ResultCode.UNWILLING_TO_PERFORM;
                    n = 1245557;
                    arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), string));
                    continue;
                }
                hashSet.add(accountStatusNotificationType);
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            resultCode = DirectoryServer.getServerErrorResultCode();
            n = 1245558;
            arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
        }
        if (resultCode == ResultCode.SUCCESS) {
            this.notificationTypes = hashSet;
        }
        return new ConfigChangeResult(resultCode, bl2, arrayList);
    }

    static {
        for (AccountStatusNotificationType accountStatusNotificationType : AccountStatusNotificationType.values()) {
            NOTIFICATION_TYPE_NAMES.add(accountStatusNotificationType.getNotificationTypeName());
        }
    }
}

