/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.security.MessageDigest;
import java.security.SecureRandom;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.ConfigurableComponent;
import org.opends.server.api.IdentityMapper;
import org.opends.server.api.SASLMechanismHandler;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.config.DNConfigAttribute;
import org.opends.server.core.BindOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.PasswordPolicyState;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.AuthenticationInfo;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.LockManager;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CRAMMD5SASLMechanismHandler
extends SASLMechanismHandler
implements ConfigurableComponent {
    private static final String CLASS_NAME = "org.opends.server.extensions.CRAMMD5SASLMechanismHandler";
    private byte[] iPad;
    private byte[] oPad;
    private DN configEntryDN;
    private DN identityMapperDN;
    private IdentityMapper identityMapper;
    private MessageDigest md5Digest;
    private ReentrantLock digestLock;
    private SecureRandom randomGenerator;

    public CRAMMD5SASLMechanismHandler() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    @Override
    public void initializeSASLMechanismHandler(ConfigEntry configEntry) throws ConfigException, InitializationException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeSASLMechanismHandler", String.valueOf(configEntry)));
        this.configEntryDN = configEntry.getDN();
        this.digestLock = new ReentrantLock();
        this.randomGenerator = new SecureRandom();
        try {
            this.md5Digest = MessageDigest.getInstance("MD5");
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeSASLMechanismHandler", exception));
            int n = 1310886;
            String string = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n, string, exception);
        }
        this.iPad = new byte[64];
        this.oPad = new byte[64];
        Arrays.fill(this.iPad, (byte)54);
        Arrays.fill(this.oPad, (byte)92);
        int n = 1048885;
        DNConfigAttribute dNConfigAttribute = new DNConfigAttribute("ds-cfg-identity-mapper-dn", MessageHandler.getMessage(n), true, false, false);
        try {
            DNConfigAttribute dNConfigAttribute2 = (DNConfigAttribute)configEntry.getConfigAttribute(dNConfigAttribute);
            if (dNConfigAttribute2 == null) {
                n = 1245494;
                String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN));
                throw new ConfigException(n, string);
            }
            this.identityMapperDN = dNConfigAttribute2.activeValue();
            this.identityMapper = DirectoryServer.getIdentityMapper(this.identityMapperDN);
            if (this.identityMapper == null) {
                n = 1245495;
                String string = MessageHandler.getMessage(n, String.valueOf(this.identityMapperDN), String.valueOf(this.configEntryDN));
                throw new ConfigException(n, string);
            }
        }
        catch (ConfigException configException) {
            throw configException;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeSASLMechanismHandler", exception));
            n = 1245496;
            String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n, string, exception);
        }
        DirectoryServer.registerSASLMechanismHandler("CRAM-MD5", this);
        DirectoryServer.registerConfigurableComponent(this);
    }

    @Override
    public void finalizeSASLMechanismHandler() {
        assert (Debug.debugEnter(CLASS_NAME, "finalizeSASLMechanismHandler", new String[0]));
        DirectoryServer.deregisterConfigurableComponent(this);
        DirectoryServer.deregisterSASLMechanismHandler("CRAM-MD5");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processSASLBind(BindOperation bindOperation) {
        Object string12;
        Object n9;
        Object directoryException;
        byte[] byArray;
        assert (Debug.debugEnter(CLASS_NAME, "processSASLBind", String.valueOf(bindOperation)));
        ASN1OctetString aSN1OctetString = bindOperation.getSASLCredentials();
        ClientConnection clientConnection = bindOperation.getClientConnection();
        if (aSN1OctetString == null) {
            byte[] byArray2 = new byte[16];
            this.randomGenerator.nextBytes(byArray2);
            StringBuilder stringBuilder = new StringBuilder(18);
            stringBuilder.append('<');
            for (byte string2 : byArray2) {
                stringBuilder.append(StaticUtils.byteToLowerHex(string2));
            }
            stringBuilder.append('>');
            ASN1OctetString string = new ASN1OctetString(stringBuilder.toString());
            clientConnection.setSASLAuthStateInfo(string);
            bindOperation.setServerSASLCredentials(string);
            bindOperation.setResultCode(ResultCode.SASL_BIND_IN_PROGRESS);
            return;
        }
        Object object5 = clientConnection.getSASLAuthStateInfo();
        if (object5 == null) {
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            int n = 1245356;
            String string = MessageHandler.getMessage(n);
            bindOperation.setAuthFailureReason(n, string);
            return;
        }
        if (!(object5 instanceof ASN1OctetString)) {
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            int n = 1245357;
            String string = MessageHandler.getMessage(n);
            bindOperation.setAuthFailureReason(n, string);
            return;
        }
        ASN1OctetString aSN1OctetString2 = (ASN1OctetString)object5;
        clientConnection.setSASLAuthStateInfo(null);
        String string = aSN1OctetString.stringValue();
        int n = string.lastIndexOf(32);
        if (n < 0) {
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            int string3 = 1245358;
            String string4 = MessageHandler.getMessage(string3);
            bindOperation.setAuthFailureReason(string3, string4);
            return;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        if (string3.length() != 32) {
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            int byArray2 = 1245359;
            String parseException = MessageHandler.getMessage(byArray2, string3.length(), 32);
            bindOperation.setAuthFailureReason(byArray2, parseException);
            return;
        }
        try {
            byArray = StaticUtils.hexStringToByteArray(string3);
        }
        catch (ParseException entry) {
            assert (Debug.debugException(CLASS_NAME, "processSASLBind", entry));
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            int string7 = 1245360;
            String object3 = MessageHandler.getMessage(string7, entry.getMessage());
            bindOperation.setAuthFailureReason(string7, object3);
            return;
        }
        Entry entry = null;
        String string4 = StaticUtils.toLowerCase(string2);
        if (string4.startsWith("dn:")) {
            int directoryException2;
            try {
                directoryException = DN.decode(string2.substring(3));
            }
            catch (DirectoryException n7) {
                assert (Debug.debugException(CLASS_NAME, "processSASLBind", n7));
                bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                int string9 = 1245361;
                String n5 = MessageHandler.getMessage(string9, string2, n7.getErrorMessage());
                bindOperation.setAuthFailureReason(string9, n5);
                return;
            }
            if (((DN)directoryException).isNullDN()) {
                bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                int object2 = 1245362;
                String object = MessageHandler.getMessage(object2);
                bindOperation.setAuthFailureReason(object2, object);
                return;
            }
            n9 = DirectoryServer.getActualRootBindDN((DN)directoryException);
            if (n9 != null) {
                directoryException = n9;
            }
            string12 = null;
            for (directoryException2 = 0; directoryException2 < 3 && (string12 = LockManager.lockRead((DN)directoryException)) == null; ++directoryException2) {
            }
            if (string12 == null) {
                bindOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                directoryException2 = 1048755;
                String n8 = MessageHandler.getMessage(directoryException2, String.valueOf(directoryException));
                bindOperation.setAuthFailureReason(directoryException2, n8);
                return;
            }
            try {
                entry = DirectoryServer.getEntry((DN)directoryException);
            }
            catch (DirectoryException string13) {
                assert (Debug.debugException(CLASS_NAME, "processSASLBind", string13));
                bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                int byArray3 = 1245364;
                String string5 = MessageHandler.getMessage(byArray3, String.valueOf(directoryException), string13.getErrorMessage());
                bindOperation.setAuthFailureReason(byArray3, string5);
                return;
            }
            finally {
                LockManager.unlock((DN)directoryException, (Lock)string12);
            }
        }
        if (string4.startsWith("u:")) {
            string2 = string2.substring(2);
        }
        try {
            entry = this.identityMapper.getEntryForID(string2);
        }
        catch (DirectoryException n10) {
            assert (Debug.debugException(CLASS_NAME, "processSASLBind", n10));
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            int exception = 1245497;
            String n11 = MessageHandler.getMessage(exception, String.valueOf(string2), n10.getErrorMessage());
            bindOperation.setAuthFailureReason(exception, n11);
            return;
        }
        if (entry == null) {
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            int n2 = 1245368;
            n9 = MessageHandler.getMessage(n2, string2);
            bindOperation.setAuthFailureReason(n2, (String)n9);
            return;
        }
        bindOperation.setSASLAuthUserEntry(entry);
        try {
            n9 = new PasswordPolicyState(entry, false, false);
            directoryException = ((PasswordPolicyState)n9).getClearPasswords();
            if (directoryException == null || directoryException.isEmpty()) {
                bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                int n12 = 1245373;
                String string14 = MessageHandler.getMessage(n12, String.valueOf(entry.getDN()));
                bindOperation.setAuthFailureReason(n12, string14);
                return;
            }
        }
        catch (Exception bl) {
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            int n13 = 1245561;
            String byteString = MessageHandler.getMessage(n13, String.valueOf(entry.getDN()), String.valueOf(bl));
            bindOperation.setAuthFailureReason(n13, byteString);
            return;
        }
        boolean bl = false;
        string12 = directoryException.iterator();
        while (string12.hasNext()) {
            ByteString string15 = (ByteString)string12.next();
            byte[] byArray3 = this.generateDigest(string15, aSN1OctetString2);
            if (!Arrays.equals(byArray, byArray3)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            int n3 = 1245372;
            String string6 = MessageHandler.getMessage(n3);
            bindOperation.setAuthFailureReason(n3, string6);
            return;
        }
        bindOperation.setResultCode(ResultCode.SUCCESS);
        string12 = new AuthenticationInfo(entry.getDN(), "CRAM-MD5", DirectoryServer.isRootDN(entry.getDN()));
        bindOperation.getClientConnection().setAuthenticationInfo((AuthenticationInfo)string12);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] generateDigest(ByteString byteString, ByteString byteString2) {
        assert (Debug.debugEnter(CLASS_NAME, "generateDigest", String.valueOf(byteString), String.valueOf(byteString2)));
        byte[] byArray = byteString.value();
        byte[] byArray2 = byteString2.value();
        this.digestLock.lock();
        try {
            if (byArray.length > 64) {
                byArray = this.md5Digest.digest(byArray);
            }
            byte[] byArray3 = new byte[64 + byArray2.length];
            System.arraycopy(this.iPad, 0, byArray3, 0, 64);
            System.arraycopy(byArray2, 0, byArray3, 64, byArray2.length);
            byte[] byArray4 = new byte[80];
            System.arraycopy(this.oPad, 0, byArray4, 0, 64);
            for (int i = 0; i < byArray.length; ++i) {
                int n = i;
                byArray3[n] = (byte)(byArray3[n] ^ byArray[i]);
                int n2 = i;
                byArray4[n2] = (byte)(byArray4[n2] ^ byArray[i]);
            }
            System.arraycopy(this.md5Digest.digest(byArray3), 0, byArray4, 64, 16);
            byte[] byArray5 = this.md5Digest.digest(byArray4);
            return byArray5;
        }
        finally {
            this.digestLock.unlock();
        }
    }

    @Override
    public DN getConfigurableComponentEntryDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigurableComponentEntryDN", new String[0]));
        return this.configEntryDN;
    }

    @Override
    public List<ConfigAttribute> getConfigurationAttributes() {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigurationAttributes", new String[0]));
        LinkedList<ConfigAttribute> linkedList = new LinkedList<ConfigAttribute>();
        int n = 1048885;
        linkedList.add(new DNConfigAttribute("ds-cfg-identity-mapper-dn", MessageHandler.getMessage(n), true, false, false, this.identityMapperDN));
        return linkedList;
    }

    @Override
    public boolean hasAcceptableConfiguration(ConfigEntry configEntry, List<String> list) {
        assert (Debug.debugEnter(CLASS_NAME, "hasAcceptableConfiguration", String.valueOf(configEntry), "java.util.List<String>"));
        int n = 1048885;
        DNConfigAttribute dNConfigAttribute = new DNConfigAttribute("ds-cfg-identity-mapper-dn", MessageHandler.getMessage(n), true, false, false);
        try {
            IdentityMapper identityMapper;
            DNConfigAttribute dNConfigAttribute2 = (DNConfigAttribute)configEntry.getConfigAttribute(dNConfigAttribute);
            if (dNConfigAttribute2 == null) {
                n = 1245494;
                list.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN)));
                return false;
            }
            DN dN = dNConfigAttribute2.pendingValue();
            if (!dN.equals(this.identityMapperDN) && (identityMapper = DirectoryServer.getIdentityMapper(dN)) == null) {
                n = 1245495;
                list.add(MessageHandler.getMessage(n, String.valueOf(dN), String.valueOf(this.configEntryDN)));
                return false;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            n = 1245496;
            list.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            return false;
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyNewConfiguration(ConfigEntry configEntry, boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "applyNewConfiguration", String.valueOf(configEntry), String.valueOf(bl)));
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean bl2 = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        DN dN = null;
        IdentityMapper identityMapper = null;
        int n = 1048885;
        DNConfigAttribute dNConfigAttribute = new DNConfigAttribute("ds-cfg-identity-mapper-dn", MessageHandler.getMessage(n), true, false, false);
        try {
            DNConfigAttribute dNConfigAttribute2 = (DNConfigAttribute)configEntry.getConfigAttribute(dNConfigAttribute);
            if (dNConfigAttribute2 == null) {
                n = 1245494;
                arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN)));
                resultCode = ResultCode.CONSTRAINT_VIOLATION;
            } else {
                dN = dNConfigAttribute2.pendingValue();
                if (!dN.equals(this.identityMapperDN) && (identityMapper = DirectoryServer.getIdentityMapper(dN)) == null) {
                    n = 1245495;
                    arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN), String.valueOf(this.configEntryDN)));
                    resultCode = ResultCode.CONSTRAINT_VIOLATION;
                }
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
            n = 1245496;
            arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            resultCode = DirectoryServer.getServerErrorResultCode();
        }
        if (resultCode == ResultCode.SUCCESS && dN != null && this.identityMapper != null) {
            this.identityMapperDN = dN;
            this.identityMapper = identityMapper;
            if (bl) {
                n = 1048890;
                arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), String.valueOf(this.identityMapperDN)));
            }
        }
        return new ConfigChangeResult(resultCode, bl2, arrayList);
    }

    @Override
    public boolean isPasswordBased(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "isPasswordBased", String.valueOf(string)));
        return true;
    }

    @Override
    public boolean isSecure(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "isSecure", String.valueOf(string)));
        return true;
    }
}

