/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import org.opends.server.api.ConfigAddListener;
import org.opends.server.api.ConfigChangeListener;
import org.opends.server.api.ConfigDeleteListener;
import org.opends.server.api.SynchronizationProvider;
import org.opends.server.config.BooleanConfigAttribute;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.config.StringConfigAttribute;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.util.StaticUtils;

public class SynchronizationProviderConfigManager
implements ConfigChangeListener,
ConfigAddListener,
ConfigDeleteListener {
    private static final String CLASS_NAME = "org.opends.server.core.SynchronizationProviderConfigManager";
    private ConcurrentHashMap<DN, SynchronizationProvider> registeredProviders;
    private DN configEntryDN;

    public SynchronizationProviderConfigManager() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    public void initializeSynchronizationProviders() throws ConfigException, InitializationException {
        ConfigEntry configEntry;
        assert (Debug.debugEnter(CLASS_NAME, "initializeSynchronizationProviders", new String[0]));
        this.registeredProviders = new ConcurrentHashMap();
        try {
            this.configEntryDN = DN.decode("cn=Synchronization Providers,cn=config");
            configEntry = DirectoryServer.getConfigEntry(this.configEntryDN);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeSynchronizationProviders", exception));
            int n = 3473860;
            String string = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
            throw new ConfigException(n, string, exception);
        }
        if (configEntry == null) {
            int n = 3473861;
            String string = MessageHandler.getMessage(n);
            throw new ConfigException(n, string);
        }
        configEntry.registerAddListener(this);
        configEntry.registerDeleteListener(this);
        for (ConfigEntry configEntry2 : configEntry.getChildren().values()) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            DN dN = configEntry2.getDN();
            configEntry2.registerChangeListener(this);
            try {
                SearchFilter searchFilter = SearchFilter.createFilterFromString("(objectClass=ds-cfg-synchronization-provider)");
                if (!searchFilter.matchesEntry(configEntry2.getEntry())) {
                    int n = 3473862;
                    object4 = MessageHandler.getMessage(n, String.valueOf(dN));
                    throw new ConfigException(n, (String)object4);
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializeSynchronizationProviders", exception));
                int n = 3473863;
                object4 = MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception));
                throw new InitializationException(n, (String)object4, exception);
            }
            int n = 3146184;
            BooleanConfigAttribute booleanConfigAttribute = new BooleanConfigAttribute("ds-cfg-synchronization-provider-enabled", MessageHandler.getMessage(n), true);
            try {
                object4 = (BooleanConfigAttribute)configEntry2.getConfigAttribute(booleanConfigAttribute);
                if (object4 == null) {
                    n = 3473865;
                    object3 = MessageHandler.getMessage(n, String.valueOf(dN));
                    throw new ConfigException(n, (String)object3);
                }
                if (!((BooleanConfigAttribute)object4).activeValue()) {
                    n = 3277258;
                    object3 = MessageHandler.getMessage(n, String.valueOf(dN));
                    Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, (String)object3, n);
                    continue;
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializeSynchronizationProviders", exception));
                n = 3473867;
                object3 = MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception));
                throw new InitializationException(n, (String)object3, exception);
            }
            n = 3146188;
            object3 = new StringConfigAttribute("ds-cfg-synchronization-provider-class", MessageHandler.getMessage(n), true, false, true);
            try {
                object2 = (StringConfigAttribute)configEntry2.getConfigAttribute((ConfigAttribute)object3);
                if (object2 == null) {
                    n = 3473869;
                    object = MessageHandler.getMessage(n, String.valueOf(dN));
                    throw new ConfigException(n, (String)object);
                }
                object4 = ((StringConfigAttribute)object2).activeValue();
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializeSynchronizationProviders", exception));
                n = 3473870;
                object = MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception));
                throw new InitializationException(n, (String)object, exception);
            }
            try {
                object2 = Class.forName((String)object4);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializeSynchronizationProviders", exception));
                n = 3473871;
                String string = MessageHandler.getMessage(n, String.valueOf(object4), String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception));
                throw new InitializationException(n, string, exception);
            }
            try {
                object = (SynchronizationProvider)((Class)object2).newInstance();
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializeSynchronizationProviders", exception));
                n = 3473872;
                String string = MessageHandler.getMessage(n, String.valueOf(object4), String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception));
                throw new InitializationException(n, string, exception);
            }
            try {
                ((SynchronizationProvider)object).initializeSynchronizationProvider(configEntry2);
            }
            catch (ConfigException configException) {
                n = 3473873;
                String string = MessageHandler.getMessage(n, String.valueOf(dN), configException.getMessage());
                throw new ConfigException(n, string, configException);
            }
            catch (InitializationException initializationException) {
                n = 3473873;
                String string = MessageHandler.getMessage(n, String.valueOf(dN), initializationException.getMessage());
                throw new InitializationException(n, string, initializationException);
            }
            catch (Exception exception) {
                n = 3473873;
                String string = MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception));
                throw new ConfigException(n, string, exception);
            }
            DirectoryServer.registerSynchronizationProvider((SynchronizationProvider)object);
            this.registeredProviders.put(dN, (SynchronizationProvider)object);
        }
    }

    public boolean configChangeIsAcceptable(ConfigEntry configEntry, StringBuilder stringBuilder) {
        Object object;
        Object object2;
        assert (Debug.debugEnter(CLASS_NAME, "configChangeIsAcceptable", String.valueOf(configEntry), "java.lang.StringBuilder"));
        DN dN = configEntry.getDN();
        SynchronizationProvider synchronizationProvider = this.registeredProviders.get(dN);
        try {
            SearchFilter searchFilter = SearchFilter.createFilterFromString("(objectClass=ds-cfg-synchronization-provider)");
            if (!searchFilter.matchesEntry(configEntry.getEntry())) {
                int n = 3473862;
                stringBuilder.append(MessageHandler.getMessage(n, String.valueOf(dN)));
                return false;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configChangeIsAcceptable", exception));
            int n = 3473863;
            stringBuilder.append(MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception)));
            return false;
        }
        int n = 3146184;
        BooleanConfigAttribute booleanConfigAttribute = new BooleanConfigAttribute("ds-cfg-synchronization-provider-enabled", MessageHandler.getMessage(n), true);
        try {
            object2 = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute);
            if (object2 == null) {
                n = 3473865;
                stringBuilder.append(MessageHandler.getMessage(n, String.valueOf(dN)));
                return false;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configChangeIsAcceptable", exception));
            n = 3473867;
            stringBuilder.append(MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception)));
            return false;
        }
        n = 3146188;
        StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-synchronization-provider-class", MessageHandler.getMessage(n), true, false, true);
        try {
            object = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
            if (object == null) {
                n = 3473869;
                stringBuilder.append(MessageHandler.getMessage(n, String.valueOf(dN)));
                return false;
            }
            object2 = ((StringConfigAttribute)object).pendingValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configChangeIsAcceptable", exception));
            n = 3473870;
            stringBuilder.append(MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception)));
            return false;
        }
        if (synchronizationProvider == null || !((String)object2).equals(synchronizationProvider.getClass().getName())) {
            try {
                object = Class.forName((String)object2);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "configChangeIsAcceptable", exception));
                n = 3473871;
                stringBuilder.append(MessageHandler.getMessage(n, String.valueOf(object2), String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception)));
                return false;
            }
            try {
                SynchronizationProvider synchronizationProvider2 = (SynchronizationProvider)((Class)object).newInstance();
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "configChangeIsAcceptable", exception));
                n = 3473872;
                stringBuilder.append(MessageHandler.getMessage(n, String.valueOf(object2), String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception)));
                return false;
            }
        }
        return true;
    }

    public ConfigChangeResult applyConfigurationChange(ConfigEntry configEntry) {
        Object object;
        Object object2;
        boolean bl;
        int n;
        ArrayList<String> arrayList;
        boolean bl2;
        ResultCode resultCode;
        SynchronizationProvider synchronizationProvider;
        block40: {
            DN dN;
            block38: {
                block37: {
                    block36: {
                        assert (Debug.debugEnter(CLASS_NAME, "applyConfigurationChange", String.valueOf(configEntry)));
                        dN = configEntry.getDN();
                        synchronizationProvider = this.registeredProviders.get(dN);
                        resultCode = ResultCode.SUCCESS;
                        bl2 = false;
                        arrayList = new ArrayList<String>();
                        try {
                            SearchFilter searchFilter = SearchFilter.createFilterFromString("(objectClass=ds-cfg-synchronization-provider)");
                            if (!searchFilter.matchesEntry(configEntry.getEntry())) {
                                n = 3473862;
                                arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN)));
                                if (resultCode == ResultCode.SUCCESS) {
                                    resultCode = ResultCode.CONSTRAINT_VIOLATION;
                                }
                            }
                        }
                        catch (Exception exception) {
                            assert (Debug.debugException(CLASS_NAME, "applyConfigurationChange", exception));
                            n = 3473863;
                            arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception)));
                            if (resultCode != ResultCode.SUCCESS) break block36;
                            resultCode = DirectoryServer.getServerErrorResultCode();
                        }
                    }
                    bl = false;
                    n = 3146184;
                    BooleanConfigAttribute booleanConfigAttribute = new BooleanConfigAttribute("ds-cfg-synchronization-provider-enabled", MessageHandler.getMessage(n), true);
                    try {
                        object2 = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute);
                        if (object2 == null) {
                            n = 3473865;
                            arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN)));
                            if (resultCode == ResultCode.SUCCESS) {
                                resultCode = ResultCode.CONSTRAINT_VIOLATION;
                            }
                        } else {
                            bl = ((BooleanConfigAttribute)object2).pendingValue();
                        }
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "applyConfigurationChange", exception));
                        n = 3473867;
                        arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception)));
                        if (resultCode != ResultCode.SUCCESS) break block37;
                        resultCode = DirectoryServer.getServerErrorResultCode();
                    }
                }
                object2 = null;
                n = 3146188;
                StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-synchronization-provider-class", MessageHandler.getMessage(n), true, false, true);
                try {
                    object = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
                    if (object == null) {
                        n = 3473869;
                        arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN)));
                        if (resultCode == ResultCode.SUCCESS) {
                            resultCode = ResultCode.CONSTRAINT_VIOLATION;
                        }
                    } else {
                        object2 = ((StringConfigAttribute)object).pendingValue();
                    }
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "applyConfigurationChange", exception));
                    n = 3473870;
                    arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception)));
                    if (resultCode != ResultCode.SUCCESS) break block38;
                    resultCode = DirectoryServer.getServerErrorResultCode();
                }
            }
            object = null;
            if (!(resultCode != ResultCode.SUCCESS || synchronizationProvider != null && synchronizationProvider.getClass().getName().equals(object2))) {
                Class<?> clazz;
                block39: {
                    clazz = null;
                    try {
                        clazz = Class.forName((String)object2);
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "applyConfigurationChange", exception));
                        n = 3473871;
                        arrayList.add(MessageHandler.getMessage(n, String.valueOf(object2), String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception)));
                        if (resultCode != ResultCode.SUCCESS) break block39;
                        resultCode = DirectoryServer.getServerErrorResultCode();
                    }
                }
                try {
                    if (clazz != null) {
                        object = (SynchronizationProvider)clazz.newInstance();
                    }
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "applyConfigurationChange", exception));
                    n = 3473872;
                    arrayList.add(MessageHandler.getMessage(n, String.valueOf(object2), String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception)));
                    if (resultCode != ResultCode.SUCCESS) break block40;
                    resultCode = DirectoryServer.getServerErrorResultCode();
                }
            }
        }
        if (resultCode == ResultCode.SUCCESS) {
            if (synchronizationProvider == null) {
                if (bl && object != null) {
                    try {
                        ((SynchronizationProvider)object).initializeSynchronizationProvider(configEntry);
                        this.registeredProviders.put(this.configEntryDN, (SynchronizationProvider)object);
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "applyConfigurationChange", exception));
                        n = 3473873;
                        arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
                        if (resultCode == ResultCode.SUCCESS) {
                            resultCode = DirectoryServer.getServerErrorResultCode();
                        }
                    }
                }
            } else {
                if (!bl) {
                    n = 3146194;
                    arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN)));
                    bl2 = true;
                }
                if (!synchronizationProvider.getClass().getName().equals(object2)) {
                    n = 3473875;
                    arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), String.valueOf(synchronizationProvider.getClass().getName()), String.valueOf(object2)));
                    bl2 = true;
                }
            }
        }
        return new ConfigChangeResult(resultCode, bl2, arrayList);
    }

    public boolean configAddIsAcceptable(ConfigEntry configEntry, StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "configAddIsAcceptable", String.valueOf(configEntry), "java.lang.StringBuilder"));
        return true;
    }

    public ConfigChangeResult applyConfigurationAdd(ConfigEntry configEntry) {
        assert (Debug.debugEnter(CLASS_NAME, "applyConfigurationAdd", String.valueOf(configEntry)));
        return null;
    }

    public boolean configDeleteIsAcceptable(ConfigEntry configEntry, StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "configDeleteIsAcceptable", String.valueOf(configEntry), "java.lang.StringBuilder"));
        return true;
    }

    public ConfigChangeResult applyConfigurationDelete(ConfigEntry configEntry) {
        assert (Debug.debugEnter(CLASS_NAME, "applyConfigurationDelete", String.valueOf(configEntry)));
        return null;
    }
}

