/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.ConfigAddListener;
import org.opends.server.api.ConfigChangeListener;
import org.opends.server.api.ConfigDeleteListener;
import org.opends.server.api.ConfigHandler;
import org.opends.server.api.MatchingRule;
import org.opends.server.config.BooleanConfigAttribute;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigConstants;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.config.StringConfigAttribute;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.schema.AttributeTypeSyntax;
import org.opends.server.schema.DITContentRuleSyntax;
import org.opends.server.schema.DITStructureRuleSyntax;
import org.opends.server.schema.MatchingRuleUseSyntax;
import org.opends.server.schema.NameFormSyntax;
import org.opends.server.schema.ObjectClassSyntax;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DITContentRule;
import org.opends.server.types.DITStructureRule;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.InitializationException;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.MatchingRuleUse;
import org.opends.server.types.NameForm;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.ResultCode;
import org.opends.server.types.Schema;
import org.opends.server.util.LDIFReader;
import org.opends.server.util.StaticUtils;

public class SchemaConfigManager
implements ConfigChangeListener,
ConfigAddListener,
ConfigDeleteListener {
    private static final String CLASS_NAME = "org.opends.server.core.SchemaConfigManager";
    private Schema schema;
    private ConfigHandler configHandler;

    public SchemaConfigManager() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
        this.configHandler = DirectoryServer.getConfigHandler();
        this.schema = new Schema();
    }

    public Schema getSchema() {
        assert (Debug.debugEnter(CLASS_NAME, "getSchema", new String[0]));
        return this.schema;
    }

    public void initializeMatchingRules() throws ConfigException, InitializationException {
        ConfigEntry configEntry;
        assert (Debug.debugEnter(CLASS_NAME, "initializeMatchingRules", new String[0]));
        try {
            DN dN = DN.decode("cn=Matching Rules,cn=config");
            configEntry = this.configHandler.getConfigEntry(dN);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeMatchingRules", exception));
            int n = 3408032;
            String string = MessageHandler.getMessage(n, String.valueOf(exception));
            throw new ConfigException(n, string, exception);
        }
        if (configEntry == null) {
            int n = 3408033;
            String string = MessageHandler.getMessage(n);
            throw new ConfigException(n, string);
        }
        configEntry.registerAddListener(this);
        configEntry.registerDeleteListener(this);
        if (!configEntry.hasChildren()) {
            int n = 3408034;
            String string = MessageHandler.getMessage(n);
            throw new ConfigException(n, string);
        }
        for (ConfigEntry configEntry2 : configEntry.getChildren().values()) {
            String string;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            int n;
            DN dN;
            block26: {
                Object object5;
                dN = configEntry2.getDN();
                configEntry2.registerChangeListener(this);
                if (!configEntry2.hasObjectClass("ds-cfg-matching-rule")) {
                    n = 3276963;
                    object5 = MessageHandler.getMessage(n, String.valueOf(dN));
                    Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, (String)object5, n);
                    continue;
                }
                n = 3145892;
                object5 = new BooleanConfigAttribute("ds-cfg-matching-rule-enabled", MessageHandler.getMessage(n), false);
                try {
                    object4 = (BooleanConfigAttribute)configEntry2.getConfigAttribute((ConfigAttribute)object5);
                    if (object4 == null) {
                        n = 3276966;
                        object3 = MessageHandler.getMessage(n, String.valueOf(dN));
                        Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, (String)object3, n);
                        continue;
                    }
                    if (!((BooleanConfigAttribute)object4).activeValue()) {
                        n = 3145895;
                        object3 = MessageHandler.getMessage(n, String.valueOf(dN));
                        Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.INFORMATIONAL, (String)object3, n);
                    }
                    break block26;
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "initializeMatchingRules", exception));
                    n = 3408040;
                    object3 = MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception));
                    Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, (String)object3, n);
                }
                continue;
            }
            n = 3145893;
            object3 = new StringConfigAttribute("ds-cfg-matching-rule-class", MessageHandler.getMessage(n), true, false, true);
            try {
                object2 = (StringConfigAttribute)configEntry2.getConfigAttribute((ConfigAttribute)object3);
                if (object2 == null) {
                    n = 3408041;
                    object = MessageHandler.getMessage(n, String.valueOf(dN));
                    Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, (String)object, n);
                    continue;
                }
                object4 = ((StringConfigAttribute)object2).activeValue();
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializeMatchingRules", exception));
                n = 3408042;
                object = MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, (String)object, n);
                continue;
            }
            try {
                object = Class.forName((String)object4);
                object2 = (MatchingRule)((Class)object).newInstance();
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializeMatchingRules", exception));
                n = 3408043;
                string = MessageHandler.getMessage(n, String.valueOf(object4), String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, string, n);
                continue;
            }
            try {
                ((MatchingRule)object2).initializeMatchingRule(configEntry2);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializeMatchingRules", exception));
                n = 3408044;
                string = MessageHandler.getMessage(n, String.valueOf(object4), String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, string, n);
                continue;
            }
            try {
                this.schema.registerMatchingRule((MatchingRule)object2, false);
            }
            catch (DirectoryException directoryException) {
                assert (Debug.debugException(CLASS_NAME, "initializeMatchingRules", directoryException));
                n = 3276973;
                string = MessageHandler.getMessage(n, String.valueOf(dN), directoryException.getErrorMessage());
                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, string, n);
            }
        }
    }

    public void initializeAttributeSyntaxes() throws ConfigException, InitializationException {
        ConfigEntry configEntry;
        assert (Debug.debugEnter(CLASS_NAME, "initializeAttributeSyntaxes", new String[0]));
        try {
            DN dN = DN.decode("cn=Syntaxes,cn=config");
            configEntry = this.configHandler.getConfigEntry(dN);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeAttributeSyntaxes", exception));
            int n = 3408046;
            String string = MessageHandler.getMessage(n, String.valueOf(exception));
            throw new ConfigException(n, string, exception);
        }
        if (configEntry == null) {
            int n = 3408047;
            String string = MessageHandler.getMessage(n);
            throw new ConfigException(n, string);
        }
        configEntry.registerAddListener(this);
        configEntry.registerDeleteListener(this);
        if (!configEntry.hasChildren()) {
            int n = 3408048;
            String string = MessageHandler.getMessage(n);
            throw new ConfigException(n, string);
        }
        for (ConfigEntry configEntry2 : configEntry.getChildren().values()) {
            String string;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            int n;
            DN dN;
            block26: {
                Object object5;
                dN = configEntry2.getDN();
                configEntry2.registerChangeListener(this);
                if (!configEntry2.hasObjectClass("ds-cfg-attribute-syntax")) {
                    n = 3276977;
                    object5 = MessageHandler.getMessage(n, String.valueOf(dN));
                    Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, (String)object5, n);
                    continue;
                }
                n = 3145906;
                object5 = new BooleanConfigAttribute("ds-cfg-syntax-enabled", MessageHandler.getMessage(n), false);
                try {
                    object4 = (BooleanConfigAttribute)configEntry2.getConfigAttribute((ConfigAttribute)object5);
                    if (object4 == null) {
                        n = 3276980;
                        object3 = MessageHandler.getMessage(n, String.valueOf(dN));
                        Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, (String)object3, n);
                        continue;
                    }
                    if (!((BooleanConfigAttribute)object4).activeValue()) {
                        n = 3145909;
                        object3 = MessageHandler.getMessage(n, String.valueOf(dN));
                        Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.INFORMATIONAL, (String)object3, n);
                    }
                    break block26;
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "initializeAttributeSyntaxes", exception));
                    n = 3408054;
                    object3 = MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception));
                    Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, (String)object3, n);
                }
                continue;
            }
            n = 0x3000B3;
            object3 = new StringConfigAttribute("ds-cfg-syntax-class", MessageHandler.getMessage(n), true, false, true);
            try {
                object2 = (StringConfigAttribute)configEntry2.getConfigAttribute((ConfigAttribute)object3);
                if (object2 == null) {
                    n = 3408055;
                    object = MessageHandler.getMessage(n, String.valueOf(dN));
                    Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, (String)object, n);
                    continue;
                }
                object4 = ((StringConfigAttribute)object2).activeValue();
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializeAttributeSyntaxes", exception));
                n = 3408056;
                object = MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, (String)object, n);
                continue;
            }
            try {
                object = Class.forName((String)object4);
                object2 = (AttributeSyntax)((Class)object).newInstance();
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializeAttributeSyntaxes", exception));
                n = 3408057;
                string = MessageHandler.getMessage(n, String.valueOf(object4), String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, string, n);
                continue;
            }
            try {
                ((AttributeSyntax)object2).initializeSyntax(configEntry2);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializeAttributeSyntaxes", exception));
                n = 3408058;
                string = MessageHandler.getMessage(n, String.valueOf(object4), String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, string, n);
                continue;
            }
            try {
                this.schema.registerSyntax((AttributeSyntax)object2, false);
            }
            catch (DirectoryException directoryException) {
                assert (Debug.debugException(CLASS_NAME, "initializeAttributeSyntaxes", directoryException));
                n = 3276987;
                string = MessageHandler.getMessage(n, String.valueOf(dN), directoryException.getErrorMessage());
                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, string, n);
            }
        }
    }

    public void initializeSchemaFromFiles() throws ConfigException, InitializationException {
        Object[] objectArray;
        assert (Debug.debugEnter(CLASS_NAME, "initializeSchemaFromFiles", new String[0]));
        String string = DirectoryServer.getServerRoot() + File.separator + ConfigConstants.PATH_SCHEMA_DIR;
        File file = new File(string);
        try {
            if (!file.exists()) {
                int n = 3408060;
                String string2 = MessageHandler.getMessage(n, string);
                throw new InitializationException(n, string2);
            }
            if (!file.isDirectory()) {
                int n = 3408061;
                String string3 = MessageHandler.getMessage(n, string);
                throw new InitializationException(n, string3);
            }
            Object[] objectArray2 = file.listFiles();
            ArrayList<String> arrayList = new ArrayList<String>(objectArray2.length);
            for (Object object5 : objectArray2) {
                if (!((File)object5).isFile()) continue;
                arrayList.add(((File)object5).getAbsolutePath());
            }
            objectArray = new String[arrayList.size()];
            arrayList.toArray(objectArray);
            Arrays.sort(objectArray);
        }
        catch (InitializationException initializationException) {
            assert (Debug.debugException(CLASS_NAME, "initializeSchemaFromFiles", initializationException));
            throw initializationException;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeSchemaFromFiles", exception));
            int n = 3408062;
            String string4 = MessageHandler.getMessage(n, string, StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n, string4, exception);
        }
        for (Object object : objectArray) {
            String string5;
            int n;
            Object object2;
            MatchingRuleUseSyntax matchingRuleUseSyntax;
            DITStructureRuleSyntax dITStructureRuleSyntax;
            DITContentRuleSyntax dITContentRuleSyntax;
            NameFormSyntax nameFormSyntax;
            ObjectClassSyntax objectClassSyntax;
            AttributeTypeSyntax attributeTypeSyntax;
            Object object3;
            Object object4;
            Object object5;
            block133: {
                LDIFReader lDIFReader;
                block132: {
                    try {
                        lDIFReader = new LDIFReader(new LDIFImportConfig((String)object));
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "initializeSchemaFromFiles", exception));
                        int n2 = 3276991;
                        object4 = MessageHandler.getMessage(n2, object, string, StaticUtils.stackTraceToSingleLineString(exception));
                        Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, (String)object4, n2);
                        continue;
                    }
                    try {
                        object5 = lDIFReader.readEntry(false);
                        if (object5 == null) {
                        }
                        break block132;
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "initializeSchemaFromFiles", exception));
                        int n3 = 3276992;
                        object3 = MessageHandler.getMessage(n3, object, string, StaticUtils.stackTraceToSingleLineString(exception));
                        Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, (String)object3, n3);
                    }
                    continue;
                }
                try {
                    lDIFReader.close();
                }
                catch (Exception exception) {
                    if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "initializeSchemaFromFiles", exception)) break block133;
                    throw new AssertionError();
                }
            }
            try {
                attributeTypeSyntax = (AttributeTypeSyntax)this.schema.getSyntax("1.3.6.1.4.1.1466.115.121.1.3");
                if (attributeTypeSyntax == null) {
                    attributeTypeSyntax = new AttributeTypeSyntax();
                    attributeTypeSyntax.initializeSyntax(null);
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializeSchemaFromFiles", exception));
                attributeTypeSyntax = new AttributeTypeSyntax();
                attributeTypeSyntax.initializeSyntax(null);
            }
            object4 = this.schema.getAttributeType("attributetypes");
            if (object4 == null) {
                object4 = DirectoryServer.getDefaultAttributeType("attributeTypes", attributeTypeSyntax);
            }
            object3 = ((Entry)object5).getAttribute((AttributeType)object4);
            try {
                objectClassSyntax = (ObjectClassSyntax)this.schema.getSyntax("1.3.6.1.4.1.1466.115.121.1.37");
                if (objectClassSyntax == null) {
                    objectClassSyntax = new ObjectClassSyntax();
                    objectClassSyntax.initializeSyntax(null);
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializeSchemaFromFiles", exception));
                objectClassSyntax = new ObjectClassSyntax();
                objectClassSyntax.initializeSyntax(null);
            }
            AttributeType attributeType = this.schema.getAttributeType("objectclasses");
            if (attributeType == null) {
                attributeType = DirectoryServer.getDefaultAttributeType("objectClasses", objectClassSyntax);
            }
            List<Attribute> list = ((Entry)object5).getAttribute(attributeType);
            try {
                nameFormSyntax = (NameFormSyntax)this.schema.getSyntax("1.3.6.1.4.1.1466.115.121.1.35");
                if (nameFormSyntax == null) {
                    nameFormSyntax = new NameFormSyntax();
                    nameFormSyntax.initializeSyntax(null);
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializeSchemaFromFiles", exception));
                nameFormSyntax = new NameFormSyntax();
                nameFormSyntax.initializeSyntax(null);
            }
            AttributeType attributeType2 = this.schema.getAttributeType("nameforms");
            if (attributeType2 == null) {
                attributeType2 = DirectoryServer.getDefaultAttributeType("nameForms", nameFormSyntax);
            }
            List<Attribute> list2 = ((Entry)object5).getAttribute(attributeType2);
            try {
                dITContentRuleSyntax = (DITContentRuleSyntax)this.schema.getSyntax("1.3.6.1.4.1.1466.115.121.1.16");
                if (dITContentRuleSyntax == null) {
                    dITContentRuleSyntax = new DITContentRuleSyntax();
                    dITContentRuleSyntax.initializeSyntax(null);
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializeSchemaFromFiles", exception));
                dITContentRuleSyntax = new DITContentRuleSyntax();
                dITContentRuleSyntax.initializeSyntax(null);
            }
            AttributeType attributeType3 = this.schema.getAttributeType("ditcontentrules");
            if (attributeType3 == null) {
                attributeType3 = DirectoryServer.getDefaultAttributeType("dITContentRules", dITContentRuleSyntax);
            }
            List<Attribute> list3 = ((Entry)object5).getAttribute(attributeType3);
            try {
                dITStructureRuleSyntax = (DITStructureRuleSyntax)this.schema.getSyntax("1.3.6.1.4.1.1466.115.121.1.17");
                if (dITStructureRuleSyntax == null) {
                    dITStructureRuleSyntax = new DITStructureRuleSyntax();
                    dITStructureRuleSyntax.initializeSyntax(null);
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializeSchemaFromFiles", exception));
                dITStructureRuleSyntax = new DITStructureRuleSyntax();
                dITStructureRuleSyntax.initializeSyntax(null);
            }
            AttributeType attributeType4 = this.schema.getAttributeType("ditstructurerules");
            if (attributeType4 == null) {
                attributeType4 = DirectoryServer.getDefaultAttributeType("dITStructureRules", dITStructureRuleSyntax);
            }
            List<Attribute> list4 = ((Entry)object5).getAttribute(attributeType4);
            try {
                matchingRuleUseSyntax = (MatchingRuleUseSyntax)this.schema.getSyntax("1.3.6.1.4.1.1466.115.121.1.31");
                if (matchingRuleUseSyntax == null) {
                    matchingRuleUseSyntax = new MatchingRuleUseSyntax();
                    matchingRuleUseSyntax.initializeSyntax(null);
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializeSchemaFromFiles", exception));
                matchingRuleUseSyntax = new MatchingRuleUseSyntax();
                matchingRuleUseSyntax.initializeSyntax(null);
            }
            AttributeType attributeType5 = this.schema.getAttributeType("matchingruleuse");
            if (attributeType5 == null) {
                attributeType5 = DirectoryServer.getDefaultAttributeType("matchingRuleUse", matchingRuleUseSyntax);
            }
            List<Attribute> list5 = ((Entry)object5).getAttribute(attributeType5);
            if (object3 != null) {
                Iterator<Object> iterator = object3.iterator();
                while (iterator.hasNext()) {
                    Attribute attribute = (Attribute)iterator.next();
                    for (AttributeValue attributeValue : attribute.getValues()) {
                        try {
                            object2 = AttributeTypeSyntax.decodeAttributeType(attributeValue.getValue(), this.schema);
                        }
                        catch (DirectoryException directoryException) {
                            assert (Debug.debugException(CLASS_NAME, "initializeSchemaFromFiles", directoryException));
                            n = 3276993;
                            string5 = MessageHandler.getMessage(n, object, directoryException.getErrorMessage());
                            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string5, n);
                            continue;
                        }
                        catch (Exception exception) {
                            assert (Debug.debugException(CLASS_NAME, "initializeSchemaFromFiles", exception));
                            n = 3276993;
                            string5 = MessageHandler.getMessage(n, object, attributeValue.getStringValue() + ":  " + StaticUtils.stackTraceToSingleLineString(exception));
                            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string5, n);
                            continue;
                        }
                        try {
                            this.schema.registerAttributeType((AttributeType)object2, false);
                        }
                        catch (DirectoryException directoryException) {
                            assert (Debug.debugException(CLASS_NAME, "initializeSchemaFromFiles", directoryException));
                            n = 3276994;
                            string5 = MessageHandler.getMessage(n, object, directoryException.getErrorMessage());
                            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string5, n);
                            try {
                                this.schema.registerAttributeType((AttributeType)object2, true);
                            }
                            catch (Exception exception) {
                                assert (Debug.debugException(CLASS_NAME, "initializeSchemaFromFiles", exception));
                            }
                        }
                    }
                }
            }
            if (list != null) {
                for (Attribute attribute : list) {
                    for (AttributeValue attributeValue : attribute.getValues()) {
                        try {
                            object2 = ObjectClassSyntax.decodeObjectClass(attributeValue.getValue(), this.schema);
                        }
                        catch (DirectoryException directoryException) {
                            assert (Debug.debugException(CLASS_NAME, "initializeSchemaFromFiles", directoryException));
                            n = 3276996;
                            string5 = MessageHandler.getMessage(n, object, directoryException.getErrorMessage());
                            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string5, n);
                            continue;
                        }
                        catch (Exception exception) {
                            assert (Debug.debugException(CLASS_NAME, "initializeSchemaFromFiles", exception));
                            n = 3276996;
                            string5 = MessageHandler.getMessage(n, object, attributeValue.getStringValue() + ":  " + StaticUtils.stackTraceToSingleLineString(exception));
                            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string5, n);
                            continue;
                        }
                        try {
                            this.schema.registerObjectClass((ObjectClass)object2, false);
                        }
                        catch (DirectoryException directoryException) {
                            assert (Debug.debugException(CLASS_NAME, "initializeSchemaFromFiles", directoryException));
                            n = 3276995;
                            string5 = MessageHandler.getMessage(n, object, directoryException.getErrorMessage());
                            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string5, n);
                            try {
                                this.schema.registerObjectClass((ObjectClass)object2, true);
                            }
                            catch (Exception exception) {
                                assert (Debug.debugException(CLASS_NAME, "initializeSchemaFromFiles", exception));
                            }
                        }
                    }
                }
            }
            if (list2 != null) {
                for (Attribute attribute : list2) {
                    for (AttributeValue attributeValue : attribute.getValues()) {
                        try {
                            object2 = NameFormSyntax.decodeNameForm(attributeValue.getValue(), this.schema);
                            ((NameForm)object2).getExtraProperties().remove("X-SCHEMA-FILE");
                            ((NameForm)object2).setSchemaFile((String)object);
                        }
                        catch (DirectoryException directoryException) {
                            assert (Debug.debugException(CLASS_NAME, "initializeSchemaFromFiles", directoryException));
                            n = 3277016;
                            string5 = MessageHandler.getMessage(n, object, directoryException.getErrorMessage());
                            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string5, n);
                            continue;
                        }
                        catch (Exception exception) {
                            assert (Debug.debugException(CLASS_NAME, "initializeSchemaFromFiles", exception));
                            n = 3277016;
                            string5 = MessageHandler.getMessage(n, object, attributeValue.getStringValue() + ":  " + StaticUtils.stackTraceToSingleLineString(exception));
                            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string5, n);
                            continue;
                        }
                        try {
                            this.schema.registerNameForm((NameForm)object2, false);
                        }
                        catch (DirectoryException directoryException) {
                            assert (Debug.debugException(CLASS_NAME, "initializeSchemaFromFiles", directoryException));
                            n = 3277017;
                            string5 = MessageHandler.getMessage(n, object, directoryException.getErrorMessage());
                            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string5, n);
                            try {
                                this.schema.registerNameForm((NameForm)object2, true);
                            }
                            catch (Exception exception) {
                                assert (Debug.debugException(CLASS_NAME, "initializeSchemaFromFiles", exception));
                            }
                        }
                    }
                }
            }
            if (list3 != null) {
                for (Attribute attribute : list3) {
                    for (AttributeValue attributeValue : attribute.getValues()) {
                        try {
                            object2 = DITContentRuleSyntax.decodeDITContentRule(attributeValue.getValue(), this.schema);
                            ((DITContentRule)object2).getExtraProperties().remove("X-SCHEMA-FILE");
                            ((DITContentRule)object2).setSchemaFile((String)object);
                        }
                        catch (DirectoryException directoryException) {
                            assert (Debug.debugException(CLASS_NAME, "initializeSchemaFromFiles", directoryException));
                            n = 3277018;
                            string5 = MessageHandler.getMessage(n, object, directoryException.getErrorMessage());
                            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string5, n);
                            continue;
                        }
                        catch (Exception exception) {
                            assert (Debug.debugException(CLASS_NAME, "initializeSchemaFromFiles", exception));
                            n = 3277018;
                            string5 = MessageHandler.getMessage(n, object, attributeValue.getStringValue() + ":  " + StaticUtils.stackTraceToSingleLineString(exception));
                            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string5, n);
                            continue;
                        }
                        try {
                            this.schema.registerDITContentRule((DITContentRule)object2, false);
                        }
                        catch (DirectoryException directoryException) {
                            assert (Debug.debugException(CLASS_NAME, "initializeSchemaFromFiles", directoryException));
                            n = 3277019;
                            string5 = MessageHandler.getMessage(n, object, directoryException.getErrorMessage());
                            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string5, n);
                            try {
                                this.schema.registerDITContentRule((DITContentRule)object2, true);
                            }
                            catch (Exception exception) {
                                assert (Debug.debugException(CLASS_NAME, "initializeSchemaFromFiles", exception));
                            }
                        }
                    }
                }
            }
            if (list4 != null) {
                for (Attribute attribute : list4) {
                    for (AttributeValue attributeValue : attribute.getValues()) {
                        try {
                            object2 = DITStructureRuleSyntax.decodeDITStructureRule(attributeValue.getValue(), this.schema);
                            ((DITStructureRule)object2).getExtraProperties().remove("X-SCHEMA-FILE");
                            ((DITStructureRule)object2).setSchemaFile((String)object);
                        }
                        catch (DirectoryException directoryException) {
                            assert (Debug.debugException(CLASS_NAME, "initializeSchemaFromFiles", directoryException));
                            n = 3277020;
                            string5 = MessageHandler.getMessage(n, object, directoryException.getErrorMessage());
                            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string5, n);
                            continue;
                        }
                        catch (Exception exception) {
                            assert (Debug.debugException(CLASS_NAME, "initializeSchemaFromFiles", exception));
                            n = 3277020;
                            string5 = MessageHandler.getMessage(n, object, attributeValue.getStringValue() + ":  " + StaticUtils.stackTraceToSingleLineString(exception));
                            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string5, n);
                            continue;
                        }
                        try {
                            this.schema.registerDITStructureRule((DITStructureRule)object2, false);
                        }
                        catch (DirectoryException directoryException) {
                            assert (Debug.debugException(CLASS_NAME, "initializeSchemaFromFiles", directoryException));
                            n = 3277021;
                            string5 = MessageHandler.getMessage(n, object, directoryException.getErrorMessage());
                            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string5, n);
                            try {
                                this.schema.registerDITStructureRule((DITStructureRule)object2, true);
                            }
                            catch (Exception exception) {
                                assert (Debug.debugException(CLASS_NAME, "initializeSchemaFromFiles", exception));
                            }
                        }
                    }
                }
            }
            if (list5 == null) continue;
            for (Attribute attribute : list5) {
                for (AttributeValue attributeValue : attribute.getValues()) {
                    try {
                        object2 = MatchingRuleUseSyntax.decodeMatchingRuleUse(attributeValue.getValue(), this.schema);
                        ((MatchingRuleUse)object2).getExtraProperties().remove("X-SCHEMA-FILE");
                        ((MatchingRuleUse)object2).setSchemaFile((String)object);
                    }
                    catch (DirectoryException directoryException) {
                        assert (Debug.debugException(CLASS_NAME, "initializeSchemaFromFiles", directoryException));
                        n = 3277022;
                        string5 = MessageHandler.getMessage(n, object, directoryException.getErrorMessage());
                        Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string5, n);
                        continue;
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "initializeSchemaFromFiles", exception));
                        n = 3277022;
                        string5 = MessageHandler.getMessage(n, object, attributeValue.getStringValue() + ":  " + StaticUtils.stackTraceToSingleLineString(exception));
                        Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string5, n);
                        continue;
                    }
                    try {
                        this.schema.registerMatchingRuleUse((MatchingRuleUse)object2, false);
                    }
                    catch (DirectoryException directoryException) {
                        assert (Debug.debugException(CLASS_NAME, "initializeSchemaFromFiles", directoryException));
                        n = 3277023;
                        string5 = MessageHandler.getMessage(n, object, directoryException.getErrorMessage());
                        Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string5, n);
                        try {
                            this.schema.registerMatchingRuleUse((MatchingRuleUse)object2, true);
                        }
                        catch (Exception exception) {
                            assert (Debug.debugException(CLASS_NAME, "initializeSchemaFromFiles", exception));
                        }
                    }
                }
            }
        }
    }

    public boolean configChangeIsAcceptable(ConfigEntry configEntry, StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "configChangeIsAcceptable", String.valueOf(configEntry), "java.lang.StringBuilder"));
        return true;
    }

    public ConfigChangeResult applyConfigurationChange(ConfigEntry configEntry) {
        assert (Debug.debugEnter(CLASS_NAME, "applyConfigurationChange", String.valueOf(configEntry)));
        DN dN = configEntry.getDN();
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        return new ConfigChangeResult(resultCode, bl, arrayList);
    }

    public boolean configAddIsAcceptable(ConfigEntry configEntry, StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "configAddIsAcceptable", String.valueOf(configEntry), "java.lang.StringBuilder"));
        return true;
    }

    public ConfigChangeResult applyConfigurationAdd(ConfigEntry configEntry) {
        assert (Debug.debugEnter(CLASS_NAME, "applyConfigurationAdd", String.valueOf(configEntry)));
        DN dN = configEntry.getDN();
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        return new ConfigChangeResult(resultCode, bl, arrayList);
    }

    public boolean configDeleteIsAcceptable(ConfigEntry configEntry, StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "configDeleteIsAcceptable", String.valueOf(configEntry), "java.lang.StringBuilder"));
        return true;
    }

    public ConfigChangeResult applyConfigurationDelete(ConfigEntry configEntry) {
        assert (Debug.debugEnter(CLASS_NAME, "applyConfigurationDelete", String.valueOf(configEntry)));
        DN dN = configEntry.getDN();
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean bl = false;
        return new ConfigChangeResult(resultCode, bl);
    }
}

