/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opends.server.api.ClientConnection;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.types.AuthenticationInfo;
import org.opends.server.types.CancelRequest;
import org.opends.server.types.CancelResult;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.OperationType;
import org.opends.server.types.ResultCode;
import org.opends.server.types.operation.PostOperationOperation;
import org.opends.server.types.operation.PostResponseOperation;
import org.opends.server.types.operation.PreOperationOperation;
import org.opends.server.types.operation.PreParseOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Operation
implements PreParseOperation,
PreOperationOperation,
PostOperationOperation,
PostResponseOperation,
Runnable {
    private static final String CLASS_NAME = "org.opends.server.core.Operation";
    protected static final List<Control> NO_RESPONSE_CONTROLS = new ArrayList<Control>(0);
    protected final ClientConnection clientConnection;
    protected final int messageID;
    protected final long operationID;
    private boolean isInternalOperation;
    private boolean isSynchronizationOperation;
    private CancelResult cancelResult;
    private DN authorizationDN;
    private DN matchedDN;
    private Map<String, Object> attachments;
    private List<Control> requestControls;
    private List<String> referralURLs;
    private ResultCode resultCode;
    private StringBuilder additionalLogMessage;
    private StringBuilder errorMessage;

    protected Operation(ClientConnection clientConnection, long l, int n, List<Control> list) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(clientConnection), String.valueOf(n), String.valueOf(list)));
        this.clientConnection = clientConnection;
        this.operationID = l;
        this.messageID = n;
        this.requestControls = list == null ? new ArrayList<Control>(0) : list;
        this.resultCode = ResultCode.UNDEFINED;
        this.additionalLogMessage = new StringBuilder();
        this.errorMessage = new StringBuilder();
        this.attachments = new HashMap<String, Object>();
        this.matchedDN = null;
        this.referralURLs = null;
        this.cancelResult = null;
        this.isInternalOperation = false;
        this.isSynchronizationOperation = false;
        this.authorizationDN = clientConnection.getAuthenticationInfo().getAuthorizationDN();
    }

    @Override
    public abstract OperationType getOperationType();

    @Override
    public abstract void disconnectClient(DisconnectReason var1, boolean var2, String var3, int var4);

    public final String[][] getCommonLogElements() {
        return new String[][]{{"connID", String.valueOf(this.getConnectionID())}, {"opID", String.valueOf(this.operationID)}, {"messageID", String.valueOf(this.messageID)}};
    }

    public abstract String[][] getRequestLogElements();

    public abstract String[][] getResponseLogElements();

    @Override
    public final ClientConnection getClientConnection() {
        assert (Debug.debugEnter(CLASS_NAME, "getClientConnection", new String[0]));
        return this.clientConnection;
    }

    @Override
    public final long getConnectionID() {
        assert (Debug.debugEnter(CLASS_NAME, "getConnectionID", new String[0]));
        return this.clientConnection.getConnectionID();
    }

    @Override
    public final long getOperationID() {
        assert (Debug.debugEnter(CLASS_NAME, "getOperationID", new String[0]));
        return this.operationID;
    }

    @Override
    public final int getMessageID() {
        assert (Debug.debugEnter(CLASS_NAME, "getMessageID", new String[0]));
        return this.messageID;
    }

    @Override
    public final List<Control> getRequestControls() {
        assert (Debug.debugEnter(CLASS_NAME, "getRequestControls", new String[0]));
        return this.requestControls;
    }

    @Override
    public final void addRequestControl(Control control) {
        assert (Debug.debugEnter(CLASS_NAME, "addRequestControl", String.valueOf(control)));
        this.requestControls.add(control);
    }

    @Override
    public final void removeRequestControl(Control control) {
        assert (Debug.debugEnter(CLASS_NAME, "removeRequestControl", String.valueOf(control)));
        this.requestControls.remove(control);
    }

    @Override
    public abstract List<Control> getResponseControls();

    @Override
    public abstract void addResponseControl(Control var1);

    @Override
    public abstract void removeResponseControl(Control var1);

    @Override
    public final ResultCode getResultCode() {
        assert (Debug.debugEnter(CLASS_NAME, "getResultCode", new String[0]));
        return this.resultCode;
    }

    @Override
    public final void setResultCode(ResultCode resultCode) {
        assert (Debug.debugEnter(CLASS_NAME, "setResultCode", String.valueOf((Object)resultCode)));
        this.resultCode = resultCode;
    }

    @Override
    public final StringBuilder getErrorMessage() {
        assert (Debug.debugEnter(CLASS_NAME, "getErrorMessage", new String[0]));
        return this.errorMessage;
    }

    @Override
    public final void setErrorMessage(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "setErrorMessage", String.valueOf(stringBuilder)));
        this.errorMessage = stringBuilder == null ? new StringBuilder() : stringBuilder;
    }

    @Override
    public final void appendErrorMessage(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "appendErrorMessage", String.valueOf(string)));
        if (this.errorMessage == null) {
            this.errorMessage = new StringBuilder(string);
        } else {
            if (this.errorMessage.length() > 0) {
                this.errorMessage.append("  ");
            }
            this.errorMessage.append(string);
        }
    }

    @Override
    public final StringBuilder getAdditionalLogMessage() {
        assert (Debug.debugEnter(CLASS_NAME, "getAdditionalLogMessage", new String[0]));
        return this.additionalLogMessage;
    }

    @Override
    public final void setAdditionalLogMessage(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "setAdditionalLogMessage", String.valueOf(stringBuilder)));
        this.additionalLogMessage = stringBuilder == null ? new StringBuilder() : stringBuilder;
    }

    @Override
    public final void appendAdditionalLogMessage(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "appendAdditionalLogMessage", String.valueOf(string)));
        if (this.additionalLogMessage == null) {
            this.additionalLogMessage = new StringBuilder(string);
        } else {
            this.additionalLogMessage.append(string);
        }
    }

    @Override
    public final DN getMatchedDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getMatchedDN", new String[0]));
        return this.matchedDN;
    }

    @Override
    public final void setMatchedDN(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "setMatchedDN", String.valueOf(dN)));
        this.matchedDN = dN;
    }

    @Override
    public final List<String> getReferralURLs() {
        assert (Debug.debugEnter(CLASS_NAME, "getReferralURLs", new String[0]));
        return this.referralURLs;
    }

    @Override
    public final void setReferralURLs(List<String> list) {
        assert (Debug.debugEnter(CLASS_NAME, "setReferralURLs", String.valueOf(list)));
        this.referralURLs = list;
    }

    @Override
    public final void setResponseData(DirectoryException directoryException) {
        assert (Debug.debugEnter(CLASS_NAME, "setResponseData", new String[0]));
        this.resultCode = directoryException.getResultCode();
        this.matchedDN = directoryException.getMatchedDN();
        this.referralURLs = directoryException.getReferralURLs();
        this.appendErrorMessage(directoryException.getErrorMessage());
    }

    @Override
    public final boolean isInternalOperation() {
        assert (Debug.debugEnter(CLASS_NAME, "isInternalOperation", new String[0]));
        return this.isInternalOperation;
    }

    public final void setInternalOperation(boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "setInternalOperation", String.valueOf(bl)));
        this.isInternalOperation = bl;
    }

    @Override
    public final boolean isSynchronizationOperation() {
        assert (Debug.debugEnter(CLASS_NAME, "isSynchronizationOperation", new String[0]));
        return this.isSynchronizationOperation;
    }

    public final void setSynchronizationOperation(boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "setSynchronizationOperation", String.valueOf(bl)));
        this.isSynchronizationOperation = bl;
    }

    @Override
    public final DN getAuthorizationDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getAuthorizationDN", new String[0]));
        if (this.authorizationDN == null) {
            AuthenticationInfo authenticationInfo = this.clientConnection.getAuthenticationInfo();
            if (authenticationInfo == null) {
                return DN.nullDN();
            }
            return authenticationInfo.getAuthorizationDN();
        }
        return this.authorizationDN;
    }

    public final void setAuthorizationDN(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "setAuthorizationDN", String.valueOf(dN)));
        this.authorizationDN = dN;
    }

    @Override
    public final Map<String, Object> getAttachments() {
        assert (Debug.debugEnter(CLASS_NAME, "getAttachments", new String[0]));
        return this.attachments;
    }

    @Override
    public final Object getAttachment(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "getAttachment", String.valueOf(string)));
        return this.attachments.get(string);
    }

    @Override
    public final Object removeAttachment(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "removeAttachment", String.valueOf(string)));
        return this.attachments.remove(string);
    }

    @Override
    public final Object setAttachment(String string, Object object) {
        assert (Debug.debugEnter(CLASS_NAME, "putAttachment", String.valueOf(string), String.valueOf(object)));
        return this.attachments.put(string, object);
    }

    @Override
    public abstract long getProcessingStartTime();

    @Override
    public abstract long getProcessingStopTime();

    @Override
    public abstract long getProcessingTime();

    @Override
    public abstract void run();

    public final void operationCompleted() {
        assert (Debug.debugEnter(CLASS_NAME, "operationCompleted", new String[0]));
        this.clientConnection.removeOperationInProgress(this.messageID);
    }

    public abstract CancelResult cancel(CancelRequest var1);

    abstract boolean setCancelRequest(CancelRequest var1);

    @Override
    public abstract CancelRequest getCancelRequest();

    public final CancelResult getCancelResult() {
        assert (Debug.debugEnter(CLASS_NAME, "getCancelResult", new String[0]));
        return this.cancelResult;
    }

    public final void setCancelResult(CancelResult cancelResult) {
        assert (Debug.debugEnter(CLASS_NAME, "setCancelResult", String.valueOf((Object)cancelResult)));
        this.cancelResult = cancelResult;
    }

    protected final void indicateCancelled(CancelRequest cancelRequest) {
        assert (Debug.debugEnter(CLASS_NAME, "indicateCancelled", String.valueOf(cancelRequest)));
        this.setCancelResult(CancelResult.CANCELED);
        if (cancelRequest.notifyOriginalRequestor() || DirectoryServer.notifyAbandonedOperations()) {
            this.setResultCode(ResultCode.CANCELED);
            String string = cancelRequest.getCancelReason();
            if (string != null) {
                this.appendErrorMessage(string);
            }
            this.clientConnection.sendResponse(this);
        }
    }

    @Override
    public final String toString() {
        assert (Debug.debugEnter(CLASS_NAME, "toString", new String[0]));
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    public abstract void toString(StringBuilder var1);
}

