/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.ExtendedOperationHandler;
import org.opends.server.api.plugin.PostOperationPluginResult;
import org.opends.server.api.plugin.PreOperationPluginResult;
import org.opends.server.api.plugin.PreParsePluginResult;
import org.opends.server.core.AccessControlConfigManager;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.Operation;
import org.opends.server.core.PluginConfigManager;
import org.opends.server.loggers.Access;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.CancelRequest;
import org.opends.server.types.CancelResult;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.OperationType;
import org.opends.server.types.ResultCode;
import org.opends.server.types.operation.PostOperationExtendedOperation;
import org.opends.server.types.operation.PostResponseExtendedOperation;
import org.opends.server.types.operation.PreOperationExtendedOperation;
import org.opends.server.types.operation.PreParseExtendedOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedOperation
extends Operation
implements PreParseExtendedOperation,
PreOperationExtendedOperation,
PostOperationExtendedOperation,
PostResponseExtendedOperation {
    private static final String CLASS_NAME = "org.opends.server.core.ExtendedOperation";
    private ASN1OctetString requestValue;
    private ASN1OctetString responseValue;
    private boolean responseSent;
    private CancelRequest cancelRequest;
    private List<Control> responseControls;
    private long processingStartTime;
    private long processingStopTime;
    private String requestOID;
    private String responseOID;

    public ExtendedOperation(ClientConnection clientConnection, long l, int n, List<Control> list, String string, ASN1OctetString aSN1OctetString) {
        super(clientConnection, l, n, list);
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(clientConnection), String.valueOf(l), String.valueOf(n), String.valueOf(list), String.valueOf(string), String.valueOf(aSN1OctetString)));
        this.requestOID = string;
        this.requestValue = aSN1OctetString;
        this.responseOID = null;
        this.responseValue = null;
        this.responseControls = new ArrayList<Control>();
        this.cancelRequest = null;
        this.responseSent = false;
    }

    @Override
    public final String getRequestOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getRequestOID", new String[0]));
        return this.requestOID;
    }

    @Override
    public final void setRequestOID(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "setRequestOID", String.valueOf(string)));
        this.requestOID = string;
    }

    @Override
    public final ASN1OctetString getRequestValue() {
        assert (Debug.debugEnter(CLASS_NAME, "getRequestValue", new String[0]));
        return this.requestValue;
    }

    @Override
    public final void setRequestValue(ASN1OctetString aSN1OctetString) {
        assert (Debug.debugEnter(CLASS_NAME, "setRequestValue", String.valueOf(aSN1OctetString)));
        this.requestValue = aSN1OctetString;
    }

    @Override
    public final String getResponseOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getResponseOID", new String[0]));
        return this.responseOID;
    }

    @Override
    public final void setResponseOID(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "setResponseOID", String.valueOf(string)));
        this.responseOID = string;
    }

    @Override
    public final ASN1OctetString getResponseValue() {
        assert (Debug.debugEnter(CLASS_NAME, "getResponseValue", new String[0]));
        return this.responseValue;
    }

    @Override
    public final void setResponseValue(ASN1OctetString aSN1OctetString) {
        assert (Debug.debugEnter(CLASS_NAME, "setResponseValue", String.valueOf(aSN1OctetString)));
        this.responseValue = aSN1OctetString;
    }

    @Override
    public final long getProcessingStartTime() {
        assert (Debug.debugEnter(CLASS_NAME, "getProcessingStartTime", new String[0]));
        return this.processingStartTime;
    }

    @Override
    public final long getProcessingStopTime() {
        assert (Debug.debugEnter(CLASS_NAME, "getProcessingStopTime", new String[0]));
        return this.processingStopTime;
    }

    @Override
    public final long getProcessingTime() {
        assert (Debug.debugEnter(CLASS_NAME, "getProcessingTime", new String[0]));
        return this.processingStopTime - this.processingStartTime;
    }

    @Override
    public final OperationType getOperationType() {
        return OperationType.EXTENDED;
    }

    @Override
    public final void disconnectClient(DisconnectReason disconnectReason, boolean bl, String string, int n) {
        this.setCancelResult(CancelResult.CANCELED);
        this.clientConnection.disconnect(disconnectReason, bl, string, n);
    }

    @Override
    public final String[][] getRequestLogElements() {
        return new String[][]{{"requestOID", this.requestOID}};
    }

    @Override
    public final String[][] getResponseLogElements() {
        CharSequence charSequence;
        String string;
        String string2 = String.valueOf(this.getResultCode().getIntValue());
        StringBuilder stringBuilder = this.getErrorMessage();
        String string3 = stringBuilder == null ? null : stringBuilder.toString();
        DN dN = this.getMatchedDN();
        String string4 = dN == null ? null : dN.toString();
        List<String> list = this.getReferralURLs();
        if (list == null || list.isEmpty()) {
            string = null;
        } else {
            charSequence = new StringBuilder();
            Iterator<String> iterator = list.iterator();
            ((StringBuilder)charSequence).append(iterator.next());
            while (iterator.hasNext()) {
                ((StringBuilder)charSequence).append(", ");
                ((StringBuilder)charSequence).append(iterator.next());
            }
            string = ((StringBuilder)charSequence).toString();
        }
        charSequence = String.valueOf(this.processingStopTime - this.processingStartTime);
        return new String[][]{{"resultCode", string2}, {"errorMessage", string3}, {"matchedDN", string4}, {"referralURLs", string}, {"responseOID", this.responseOID}, {"processingTime", charSequence}};
    }

    @Override
    public final List<Control> getResponseControls() {
        assert (Debug.debugEnter(CLASS_NAME, "getResponseControls", new String[0]));
        return this.responseControls;
    }

    @Override
    public final void addResponseControl(Control control) {
        this.responseControls.add(control);
    }

    @Override
    public final void removeResponseControl(Control control) {
        this.responseControls.remove(control);
    }

    @Override
    public final void run() {
        assert (Debug.debugEnter(CLASS_NAME, "run", new String[0]));
        this.setResultCode(ResultCode.UNDEFINED);
        PluginConfigManager pluginConfigManager = DirectoryServer.getPluginConfigManager();
        boolean bl = false;
        this.processingStartTime = System.currentTimeMillis();
        if (this.cancelRequest != null && !this.requestOID.equals("1.3.6.1.1.8") && !this.requestOID.equals("1.3.6.1.4.1.1466.20037")) {
            this.indicateCancelled(this.cancelRequest);
            this.processingStopTime = System.currentTimeMillis();
            return;
        }
        Object object = pluginConfigManager.invokePreParseExtendedPlugins(this);
        if (((PreParsePluginResult)object).connectionTerminated()) {
            this.setResultCode(ResultCode.CANCELED);
            int n = 262368;
            this.appendErrorMessage(MessageHandler.getMessage(n));
            this.processingStopTime = System.currentTimeMillis();
            Access.logExtendedRequest(this);
            Access.logExtendedResponse(this);
            return;
        }
        if (((PreParsePluginResult)object).sendResponseImmediately()) {
            bl = true;
            Access.logExtendedRequest(this);
        } else {
            Access.logExtendedRequest(this);
            if (this.cancelRequest != null && !this.requestOID.equals("1.3.6.1.1.8") && !this.requestOID.equals("1.3.6.1.4.1.1466.20037")) {
                this.indicateCancelled(this.cancelRequest);
                this.processingStopTime = System.currentTimeMillis();
                return;
            }
            ExtendedOperationHandler extendedOperationHandler = DirectoryServer.getExtendedOperationHandler(this.requestOID);
            if (extendedOperationHandler == null) {
                this.setResultCode(ResultCode.UNAVAILABLE_CRITICAL_EXTENSION);
                this.appendErrorMessage(MessageHandler.getMessage(196876, String.valueOf(this.requestOID)));
            } else if (!AccessControlConfigManager.getInstance().getAccessControlHandler().isAllowed(this)) {
                this.setResultCode(ResultCode.INSUFFICIENT_ACCESS_RIGHTS);
                int n = 262656;
                this.appendErrorMessage(MessageHandler.getMessage(n, String.valueOf(this.requestOID)));
                bl = true;
            } else {
                PreOperationPluginResult preOperationPluginResult = pluginConfigManager.invokePreOperationExtendedPlugins(this);
                if (preOperationPluginResult.connectionTerminated()) {
                    this.setResultCode(ResultCode.CANCELED);
                    int n = 262369;
                    this.appendErrorMessage(MessageHandler.getMessage(n));
                    this.processingStopTime = System.currentTimeMillis();
                    Access.logExtendedResponse(this);
                    return;
                }
                if (preOperationPluginResult.sendResponseImmediately()) {
                    bl = true;
                } else {
                    if (this.cancelRequest != null && !this.requestOID.equals("1.3.6.1.1.8") && !this.requestOID.equals("1.3.6.1.4.1.1466.20037")) {
                        this.indicateCancelled(this.cancelRequest);
                        this.processingStopTime = System.currentTimeMillis();
                        return;
                    }
                    extendedOperationHandler.processExtendedOperation(this);
                }
            }
        }
        this.setCancelResult(CancelResult.TOO_LATE);
        if (!bl && ((PostOperationPluginResult)(object = pluginConfigManager.invokePostOperationExtendedPlugins(this))).connectionTerminated()) {
            this.setResultCode(ResultCode.CANCELED);
            int n = 262369;
            this.appendErrorMessage(MessageHandler.getMessage(n));
            this.processingStopTime = System.currentTimeMillis();
            Access.logExtendedResponse(this);
            return;
        }
        this.processingStopTime = System.currentTimeMillis();
        if (!this.responseSent) {
            this.responseSent = true;
            this.clientConnection.sendResponse(this);
        }
        Access.logExtendedResponse(this);
        pluginConfigManager.invokePostResponseExtendedPlugins(this);
    }

    public final void sendExtendedResponse() {
        assert (Debug.debugEnter(CLASS_NAME, "sendExtendedResponse", new String[0]));
        if (!this.responseSent) {
            this.responseSent = true;
            this.clientConnection.sendResponse(this);
        }
    }

    public final void setResponseSent() {
        assert (Debug.debugEnter(CLASS_NAME, "setResponseSent", String.valueOf(this.responseSent)));
        this.responseSent = true;
    }

    @Override
    public final CancelResult cancel(CancelRequest cancelRequest) {
        assert (Debug.debugEnter(CLASS_NAME, "cancel", String.valueOf(cancelRequest)));
        this.cancelRequest = cancelRequest;
        CancelResult cancelResult = this.getCancelResult();
        long l = System.currentTimeMillis() + 5000L;
        while (cancelResult == null && System.currentTimeMillis() < l) {
            block5: {
                try {
                    Thread.sleep(50L);
                }
                catch (Exception exception) {
                    if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "cancel", exception)) break block5;
                    throw new AssertionError();
                }
            }
            cancelResult = this.getCancelResult();
        }
        if (cancelResult == null) {
            cancelResult = CancelResult.CANNOT_CANCEL;
        }
        return cancelResult;
    }

    @Override
    public final CancelRequest getCancelRequest() {
        assert (Debug.debugEnter(CLASS_NAME, "getCancelRequest", new String[0]));
        return this.cancelRequest;
    }

    @Override
    boolean setCancelRequest(CancelRequest cancelRequest) {
        assert (Debug.debugEnter(CLASS_NAME, "setCancelRequest", String.valueOf(cancelRequest)));
        this.cancelRequest = cancelRequest;
        return true;
    }

    @Override
    public final void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        stringBuilder.append("ExtendedOperation(connID=");
        stringBuilder.append(this.clientConnection.getConnectionID());
        stringBuilder.append(", opID=");
        stringBuilder.append(this.operationID);
        stringBuilder.append(", oid=");
        stringBuilder.append(this.requestOID);
        stringBuilder.append(")");
    }
}

