/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opends.server.api.ClientConnection;
import org.opends.server.core.Operation;
import org.opends.server.loggers.Debug;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.ByteString;
import org.opends.server.types.CancelRequest;
import org.opends.server.types.CancelResult;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.Entry;
import org.opends.server.types.OperationType;
import org.opends.server.types.WritabilityMode;
import org.opends.server.types.operation.PostOperationDeleteOperation;
import org.opends.server.types.operation.PostResponseDeleteOperation;
import org.opends.server.types.operation.PreOperationDeleteOperation;
import org.opends.server.types.operation.PreParseDeleteOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteOperation
extends Operation
implements PreParseDeleteOperation,
PreOperationDeleteOperation,
PostOperationDeleteOperation,
PostResponseDeleteOperation {
    private static final String CLASS_NAME = "org.opends.server.core.DeleteOperation";
    private ByteString rawEntryDN;
    private CancelRequest cancelRequest;
    private DN entryDN;
    private Entry entry;
    private List<Control> responseControls;
    private long changeNumber;
    private long processingStartTime;
    private long processingStopTime;

    public DeleteOperation(ClientConnection clientConnection, long l, int n, List<Control> list, ByteString byteString) {
        super(clientConnection, l, n, list);
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(clientConnection), String.valueOf(l), String.valueOf(n), String.valueOf(list), String.valueOf(byteString)));
        this.rawEntryDN = byteString;
        this.entry = null;
        this.entryDN = null;
        this.responseControls = new ArrayList<Control>();
        this.cancelRequest = null;
        this.changeNumber = -1L;
    }

    public DeleteOperation(ClientConnection clientConnection, long l, int n, List<Control> list, DN dN) {
        super(clientConnection, l, n, list);
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(clientConnection), String.valueOf(l), String.valueOf(n), String.valueOf(list), String.valueOf(dN)));
        this.entryDN = dN;
        this.rawEntryDN = new ASN1OctetString(dN.toString());
        this.responseControls = new ArrayList<Control>();
        this.cancelRequest = null;
        this.changeNumber = -1L;
        this.entry = null;
    }

    @Override
    public final ByteString getRawEntryDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getRawEntryDN", new String[0]));
        return this.rawEntryDN;
    }

    @Override
    public final void setRawEntryDN(ByteString byteString) {
        assert (Debug.debugEnter(CLASS_NAME, "setRawEntryDN", new String[0]));
        this.rawEntryDN = byteString;
        this.entryDN = null;
    }

    @Override
    public final DN getEntryDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getEntryDN", new String[0]));
        return this.entryDN;
    }

    @Override
    public final Entry getEntryToDelete() {
        assert (Debug.debugEnter(CLASS_NAME, "getEntryToDelete", new String[0]));
        return this.entry;
    }

    @Override
    public final long getProcessingStartTime() {
        assert (Debug.debugEnter(CLASS_NAME, "getProcessingStartTime", new String[0]));
        return this.processingStartTime;
    }

    @Override
    public final long getProcessingStopTime() {
        assert (Debug.debugEnter(CLASS_NAME, "getProcessingStopTime", new String[0]));
        return this.processingStopTime;
    }

    @Override
    public final long getProcessingTime() {
        assert (Debug.debugEnter(CLASS_NAME, "getProcessingTime", new String[0]));
        return this.processingStopTime - this.processingStartTime;
    }

    public final long getChangeNumber() {
        assert (Debug.debugEnter(CLASS_NAME, "getChangeNumber", new String[0]));
        return this.changeNumber;
    }

    public final void setChangeNumber(long l) {
        assert (Debug.debugEnter(CLASS_NAME, "setChangeNumber", String.valueOf(l)));
        this.changeNumber = l;
    }

    @Override
    public final OperationType getOperationType() {
        return OperationType.DELETE;
    }

    @Override
    public final void disconnectClient(DisconnectReason disconnectReason, boolean bl, String string, int n) {
        this.setCancelResult(CancelResult.CANCELED);
        this.clientConnection.disconnect(disconnectReason, bl, string, n);
    }

    @Override
    public final String[][] getRequestLogElements() {
        return new String[][]{{"entryDN", String.valueOf(this.rawEntryDN)}};
    }

    @Override
    public final String[][] getResponseLogElements() {
        CharSequence charSequence;
        String string;
        String string2 = String.valueOf(this.getResultCode().getIntValue());
        StringBuilder stringBuilder = this.getErrorMessage();
        String string3 = stringBuilder == null ? null : stringBuilder.toString();
        DN dN = this.getMatchedDN();
        String string4 = dN == null ? null : dN.toString();
        List<String> list = this.getReferralURLs();
        if (list == null || list.isEmpty()) {
            string = null;
        } else {
            charSequence = new StringBuilder();
            Iterator<String> iterator = list.iterator();
            ((StringBuilder)charSequence).append(iterator.next());
            while (iterator.hasNext()) {
                ((StringBuilder)charSequence).append(", ");
                ((StringBuilder)charSequence).append(iterator.next());
            }
            string = ((StringBuilder)charSequence).toString();
        }
        charSequence = String.valueOf(this.processingStopTime - this.processingStartTime);
        return new String[][]{{"resultCode", string2}, {"errorMessage", string3}, {"matchedDN", string4}, {"referralURLs", string}, {"processingTime", charSequence}};
    }

    @Override
    public final List<Control> getResponseControls() {
        assert (Debug.debugEnter(CLASS_NAME, "getResponseControls", new String[0]));
        return this.responseControls;
    }

    @Override
    public final void addResponseControl(Control control) {
        this.responseControls.add(control);
    }

    @Override
    public final void removeResponseControl(Control control) {
        this.responseControls.remove(control);
    }

    /*
     * Exception decompiling
     */
    @Override
    public final void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 78[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public final CancelResult cancel(CancelRequest cancelRequest) {
        assert (Debug.debugEnter(CLASS_NAME, "cancel", String.valueOf(cancelRequest)));
        this.cancelRequest = cancelRequest;
        CancelResult cancelResult = this.getCancelResult();
        long l = System.currentTimeMillis() + 5000L;
        while (cancelResult == null && System.currentTimeMillis() < l) {
            block5: {
                try {
                    Thread.sleep(50L);
                }
                catch (Exception exception) {
                    if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "cancel", exception)) break block5;
                    throw new AssertionError();
                }
            }
            cancelResult = this.getCancelResult();
        }
        if (cancelResult == null) {
            cancelResult = CancelResult.CANNOT_CANCEL;
        }
        return cancelResult;
    }

    @Override
    public final CancelRequest getCancelRequest() {
        assert (Debug.debugEnter(CLASS_NAME, "getCancelRequest", new String[0]));
        return this.cancelRequest;
    }

    @Override
    boolean setCancelRequest(CancelRequest cancelRequest) {
        assert (Debug.debugEnter(CLASS_NAME, "setCancelRequest", String.valueOf(cancelRequest)));
        this.cancelRequest = cancelRequest;
        return true;
    }

    @Override
    public final void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        stringBuilder.append("DeleteOperation(connID=");
        stringBuilder.append(this.clientConnection.getConnectionID());
        stringBuilder.append(", opID=");
        stringBuilder.append(this.operationID);
        stringBuilder.append(", dn=");
        stringBuilder.append(this.rawEntryDN);
        stringBuilder.append(")");
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$org$opends$server$types$WritabilityMode;

        static {
            $SwitchMap$org$opends$server$types$WritabilityMode = new int[WritabilityMode.values().length];
            try {
                1.$SwitchMap$org$opends$server$types$WritabilityMode[WritabilityMode.DISABLED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$opends$server$types$WritabilityMode[WritabilityMode.INTERNAL_ONLY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

