/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.opends.server.api.Backend;
import org.opends.server.api.ConfigAddListener;
import org.opends.server.api.ConfigChangeListener;
import org.opends.server.api.ConfigDeleteListener;
import org.opends.server.api.ConfigHandler;
import org.opends.server.api.ConfigurableComponent;
import org.opends.server.config.BooleanConfigAttribute;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.config.DNConfigAttribute;
import org.opends.server.config.MultiChoiceConfigAttribute;
import org.opends.server.config.StringConfigAttribute;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.LockFileManager;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.WritabilityMode;
import org.opends.server.util.StaticUtils;

public class BackendConfigManager
implements ConfigChangeListener,
ConfigAddListener,
ConfigDeleteListener {
    private static final String CLASS_NAME = "org.opends.server.core.BackendConfigManager";
    private ConcurrentHashMap<DN, Backend> registeredBackends;
    private DN configEntryDN;

    public BackendConfigManager() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    public void initializeBackendConfig() throws ConfigException, InitializationException {
        ConfigEntry configEntry;
        assert (Debug.debugEnter(CLASS_NAME, "initializeBackendConfig", new String[0]));
        this.registeredBackends = new ConcurrentHashMap();
        try {
            this.configEntryDN = DN.decode("cn=Backends,cn=config");
            configEntry = DirectoryServer.getConfigEntry(this.configEntryDN);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeBackendConfig", exception));
            int n = 3407976;
            String string = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
            throw new ConfigException(n, string, exception);
        }
        if (configEntry == null) {
            int n = 3407977;
            String string = MessageHandler.getMessage(n);
            throw new ConfigException(n, string);
        }
        configEntry.registerAddListener(this);
        configEntry.registerDeleteListener(this);
        for (ConfigEntry configEntry2 : configEntry.getChildren().values()) {
            String string;
            CharSequence charSequence;
            Object object;
            Object object2;
            DN[] dNArray;
            int n;
            Object object3;
            DN dN;
            block50: {
                Object object4;
                Object object5;
                Object object6;
                Object object7;
                block49: {
                    Object object8;
                    block48: {
                        Object object9;
                        block47: {
                            block46: {
                                int n2;
                                dN = configEntry2.getDN();
                                configEntry2.registerChangeListener(this);
                                try {
                                    SearchFilter searchFilter = SearchFilter.createFilterFromString("(objectClass=ds-cfg-backend)");
                                    if (!searchFilter.matchesEntry(configEntry2.getEntry())) {
                                        n2 = 3276906;
                                        object3 = MessageHandler.getMessage(n2, String.valueOf(dN));
                                        Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, (String)object3, n2);
                                    }
                                    break block46;
                                }
                                catch (Exception exception) {
                                    assert (Debug.debugException(CLASS_NAME, "initializeBackendConfig", exception));
                                    n2 = 3407979;
                                    object3 = MessageHandler.getMessage(n2, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception));
                                    Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, (String)object3, n2);
                                }
                                continue;
                            }
                            n = 3145836;
                            BooleanConfigAttribute booleanConfigAttribute = new BooleanConfigAttribute("ds-cfg-backend-enabled", MessageHandler.getMessage(n), false);
                            try {
                                object3 = (BooleanConfigAttribute)configEntry2.getConfigAttribute(booleanConfigAttribute);
                                if (object3 == null) {
                                    n = 3276910;
                                    object9 = MessageHandler.getMessage(n, String.valueOf(dN));
                                    Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, (String)object9, n);
                                    continue;
                                }
                                if (!((BooleanConfigAttribute)object3).activeValue()) {
                                    n = 3145839;
                                    object9 = MessageHandler.getMessage(n, String.valueOf(dN));
                                    Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.INFORMATIONAL, (String)object9, n);
                                }
                                break block47;
                            }
                            catch (Exception exception) {
                                assert (Debug.debugException(CLASS_NAME, "initializeBackendConfig", exception));
                                n = 3407984;
                                object9 = MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception));
                                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, (String)object9, n);
                            }
                            continue;
                        }
                        n = 3146110;
                        object3 = null;
                        object9 = new StringConfigAttribute("ds-cfg-backend-id", MessageHandler.getMessage(n), true, false, true);
                        try {
                            object8 = (StringConfigAttribute)configEntry2.getConfigAttribute((ConfigAttribute)object9);
                            if (object8 == null) {
                                n = 3277183;
                                object7 = MessageHandler.getMessage(n, String.valueOf(dN));
                                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, object7, n);
                                continue;
                            }
                            object3 = ((StringConfigAttribute)object8).activeValue();
                            if (DirectoryServer.hasBackend((String)object3)) {
                                n = 3277184;
                                object7 = MessageHandler.getMessage(n, object3, String.valueOf(dN));
                                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, object7, n);
                            }
                            break block48;
                        }
                        catch (Exception exception) {
                            assert (Debug.debugException(CLASS_NAME, "initializeBackendConfig", exception));
                            n = 3408257;
                            object7 = MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception));
                            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, object7, n);
                        }
                        continue;
                    }
                    object8 = new LinkedHashSet(3);
                    ((HashSet)object8).add(WritabilityMode.ENABLED.toString());
                    ((HashSet)object8).add(WritabilityMode.DISABLED.toString());
                    ((HashSet)object8).add(WritabilityMode.INTERNAL_ONLY.toString());
                    n = 3146196;
                    object7 = null;
                    MultiChoiceConfigAttribute multiChoiceConfigAttribute = new MultiChoiceConfigAttribute("ds-cfg-backend-writability-mode", MessageHandler.getMessage(n), true, false, false, (Set<String>)object8);
                    try {
                        dNArray = (DN[])configEntry2.getConfigAttribute(multiChoiceConfigAttribute);
                        if (dNArray == null) {
                            n = 3408341;
                            object6 = MessageHandler.getMessage(n, String.valueOf(dN));
                            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, (String)object6, n);
                            continue;
                        }
                        object7 = WritabilityMode.modeForName(dNArray.activeValue());
                        if (object7 == null) {
                            n = 3408342;
                            object6 = MessageHandler.getMessage(n, String.valueOf(dN), String.valueOf(dNArray.activeValue()));
                            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, (String)object6, n);
                        }
                        break block49;
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "initializeBackendConfig", exception));
                        n = 3408343;
                        object6 = MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception));
                        Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, (String)object6, n);
                    }
                    continue;
                }
                n = 0x300131;
                dNArray = null;
                object6 = new DNConfigAttribute("ds-cfg-backend-base-dn", MessageHandler.getMessage(n), true, true, true);
                try {
                    object2 = (DNConfigAttribute)configEntry2.getConfigAttribute((ConfigAttribute)object6);
                    if (object2 == null) {
                        n = 3408178;
                        object5 = MessageHandler.getMessage(n, String.valueOf(dN));
                        Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, (String)object5, n);
                        continue;
                    }
                    object5 = ((DNConfigAttribute)object2).activeValues();
                    dNArray = new DN[object5.size()];
                    object5.toArray(dNArray);
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "initializeBackendConfig", exception));
                    n = 3408179;
                    object5 = MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception));
                    Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, (String)object5, n);
                    continue;
                }
                n = 3145837;
                object5 = new StringConfigAttribute("ds-cfg-backend-class", MessageHandler.getMessage(n), true, false, true);
                try {
                    object = (StringConfigAttribute)configEntry2.getConfigAttribute((ConfigAttribute)object5);
                    if (object == null) {
                        n = 3407985;
                        object4 = MessageHandler.getMessage(n, String.valueOf(dN));
                        Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, (String)object4, n);
                        continue;
                    }
                    object2 = ((StringConfigAttribute)object).activeValue();
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "initializeBackendConfig", exception));
                    n = 3407986;
                    object4 = MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception));
                    Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, (String)object4, n);
                    continue;
                }
                try {
                    object4 = Class.forName((String)object2);
                    object = (Backend)((Class)object4).newInstance();
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "initializeBackendConfig", exception));
                    n = 3407987;
                    charSequence = MessageHandler.getMessage(n, String.valueOf(object2), String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception));
                    Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, (String)charSequence, n);
                    continue;
                }
                if (object instanceof ConfigHandler) continue;
                ((Backend)object).setBackendID((String)object3);
                ((Backend)object).setWritabilityMode((WritabilityMode)((Object)object7));
                try {
                    object4 = LockFileManager.getBackendLockFileName((Backend)object);
                    charSequence = new StringBuilder();
                    if (!LockFileManager.acquireSharedLock((String)object4, charSequence)) {
                        n = 3408294;
                        string = MessageHandler.getMessage(n, object3, String.valueOf(charSequence));
                        Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, string, n);
                    }
                    break block50;
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "initializeBackendConfig", exception));
                    n = 3408294;
                    charSequence = MessageHandler.getMessage(n, object3, StaticUtils.stackTraceToSingleLineString(exception));
                    Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, (String)charSequence, n);
                }
                continue;
            }
            try {
                ((Backend)object).initializeBackend(configEntry2, dNArray);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializeBackendConfig", exception));
                n = 3407988;
                charSequence = MessageHandler.getMessage(n, String.valueOf(object2), String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, (String)charSequence, n);
                try {
                    StringBuilder stringBuilder;
                    string = LockFileManager.getBackendLockFileName((Backend)object);
                    if (LockFileManager.releaseLock(string, stringBuilder = new StringBuilder())) continue;
                    n = 3277223;
                    charSequence = MessageHandler.getMessage(n, object3, String.valueOf(stringBuilder));
                    Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, (String)charSequence, n);
                }
                catch (Exception exception2) {
                    assert (Debug.debugException(CLASS_NAME, "initializeBackendConfig", exception2));
                    n = 3277223;
                    charSequence = MessageHandler.getMessage(n, object3, StaticUtils.stackTraceToSingleLineString(exception2));
                    Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, (String)charSequence, n);
                }
                continue;
            }
            DirectoryServer.registerBackend((Backend)object);
            this.registeredBackends.put(dN, (Backend)object);
        }
    }

    public boolean configChangeIsAcceptable(ConfigEntry configEntry, StringBuilder stringBuilder) {
        Object object;
        Object object2;
        ConfigAttribute configAttribute;
        Object object3;
        ConfigAttribute configAttribute2;
        assert (Debug.debugEnter(CLASS_NAME, "configChangeIsAcceptable", String.valueOf(configEntry), "java.lang.StringBuilder"));
        DN dN = configEntry.getDN();
        try {
            SearchFilter searchFilter = SearchFilter.createFilterFromString("(objectClass=ds-cfg-backend)");
            if (!searchFilter.matchesEntry(configEntry.getEntry())) {
                int n = 3276906;
                stringBuilder.append(MessageHandler.getMessage(n, String.valueOf(dN)));
                return false;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configChangeIsAcceptable", exception));
            int n = 3407979;
            stringBuilder.append(MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception)));
            return false;
        }
        int n = 3145836;
        BooleanConfigAttribute booleanConfigAttribute = new BooleanConfigAttribute("ds-cfg-backend-enabled", MessageHandler.getMessage(n), false);
        try {
            configAttribute2 = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute);
            if (configAttribute2 == null) {
                n = 3276910;
                stringBuilder.append(MessageHandler.getMessage(n, String.valueOf(dN)));
                return false;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configChangeIsAcceptable", exception));
            n = 3407984;
            stringBuilder.append(MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception)));
            return false;
        }
        n = 3146110;
        configAttribute2 = new StringConfigAttribute("ds-cfg-backend-id", MessageHandler.getMessage(n), true, false, true);
        try {
            object3 = (StringConfigAttribute)configEntry.getConfigAttribute(configAttribute2);
            if (object3 == null) {
                n = 3277183;
                stringBuilder.append(MessageHandler.getMessage(n, String.valueOf(dN)));
                return false;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configChangeIsAcceptable", exception));
            n = 3408257;
            stringBuilder.append(MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception)));
            return false;
        }
        object3 = new LinkedHashSet(3);
        ((HashSet)object3).add(WritabilityMode.ENABLED.toString());
        ((HashSet)object3).add(WritabilityMode.DISABLED.toString());
        ((HashSet)object3).add(WritabilityMode.INTERNAL_ONLY.toString());
        n = 3146196;
        MultiChoiceConfigAttribute multiChoiceConfigAttribute = new MultiChoiceConfigAttribute("ds-cfg-backend-writability-mode", MessageHandler.getMessage(n), true, false, false, (Set<String>)object3);
        try {
            configAttribute = (MultiChoiceConfigAttribute)configEntry.getConfigAttribute(multiChoiceConfigAttribute);
            if (configAttribute == null) {
                n = 3408341;
                stringBuilder.append(MessageHandler.getMessage(n, String.valueOf(dN)));
                return false;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configChangeIsAcceptable", exception));
            n = 3408343;
            stringBuilder.append(MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception)));
            return false;
        }
        n = 0x300131;
        configAttribute = new DNConfigAttribute("ds-cfg-backend-base-dn", MessageHandler.getMessage(n), true, true, true);
        try {
            object2 = (DNConfigAttribute)configEntry.getConfigAttribute(configAttribute);
            if (object2 == null) {
                n = 3408178;
                stringBuilder.append(MessageHandler.getMessage(n, String.valueOf(dN)));
                return false;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configChangeIsAcceptable", exception));
            n = 3408179;
            stringBuilder.append(MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception)));
            return false;
        }
        n = 3145837;
        StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-backend-class", MessageHandler.getMessage(n), true, false, true);
        try {
            object = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
            if (object == null) {
                n = 3407985;
                stringBuilder.append(MessageHandler.getMessage(n, String.valueOf(dN)));
                return false;
            }
            object2 = ((StringConfigAttribute)object).pendingValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configChangeIsAcceptable", exception));
            n = 3407986;
            stringBuilder.append(MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception)));
            return false;
        }
        try {
            object = Class.forName((String)object2);
            if (!Backend.class.isAssignableFrom((Class<?>)object)) {
                n = 3407989;
                stringBuilder.append(MessageHandler.getMessage(n, String.valueOf(object2), String.valueOf(dN)));
                return false;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configChangeIsAcceptable", exception));
            n = 3407987;
            stringBuilder.append(MessageHandler.getMessage(n, String.valueOf(object2), String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception)));
            return false;
        }
        return true;
    }

    public ConfigChangeResult applyConfigurationChange(ConfigEntry configEntry) {
        Object object;
        Object object2;
        Object object3;
        DN[] dNArray;
        Object object4;
        Object object5;
        int n;
        boolean bl;
        ArrayList<String> arrayList;
        boolean bl2;
        ResultCode resultCode;
        Backend backend;
        DN dN;
        block53: {
            assert (Debug.debugEnter(CLASS_NAME, "applyConfigurationChange", String.valueOf(configEntry)));
            dN = configEntry.getDN();
            backend = this.registeredBackends.get(dN);
            resultCode = ResultCode.SUCCESS;
            bl2 = false;
            arrayList = new ArrayList<String>();
            try {
                SearchFilter searchFilter = SearchFilter.createFilterFromString("(objectClass=ds-cfg-backend)");
                if (!searchFilter.matchesEntry(configEntry.getEntry())) {
                    int n2 = 3276906;
                    arrayList.add(MessageHandler.getMessage(n2, String.valueOf(dN)));
                    resultCode = ResultCode.UNWILLING_TO_PERFORM;
                    return new ConfigChangeResult(resultCode, bl2, arrayList);
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "applyConfigurationChange", exception));
                int n3 = 3407979;
                arrayList.add(MessageHandler.getMessage(n3, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception)));
                resultCode = DirectoryServer.getServerErrorResultCode();
                return new ConfigChangeResult(resultCode, bl2, arrayList);
            }
            bl = false;
            n = 3145836;
            BooleanConfigAttribute booleanConfigAttribute = new BooleanConfigAttribute("ds-cfg-backend-enabled", MessageHandler.getMessage(n), false);
            try {
                object5 = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute);
                if (object5 == null) {
                    n = 3276910;
                    arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN)));
                    resultCode = ResultCode.UNWILLING_TO_PERFORM;
                    return new ConfigChangeResult(resultCode, bl2, arrayList);
                }
                if (((BooleanConfigAttribute)object5).pendingValue()) {
                    if (backend == null) {
                        bl = true;
                    }
                    break block53;
                }
                if (backend == null) break block53;
                this.registeredBackends.remove(dN);
                DirectoryServer.deregisterBackend(backend);
                backend.finalizeBackend();
                try {
                    String string = LockFileManager.getBackendLockFileName(backend);
                    StringBuilder stringBuilder = new StringBuilder();
                    if (!LockFileManager.releaseLock(string, stringBuilder)) {
                        n = 3277223;
                        String string2 = MessageHandler.getMessage(n, backend.getBackendID(), String.valueOf(stringBuilder));
                        Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, string2, n);
                    }
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "applyConfigurationChange", exception));
                    n = 3277223;
                    String string = MessageHandler.getMessage(n, backend.getBackendID(), StaticUtils.stackTraceToSingleLineString(exception));
                    Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, string, n);
                }
                return new ConfigChangeResult(resultCode, bl2, arrayList);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "applyConfigurationChange", exception));
                n = 3407984;
                arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception)));
                resultCode = DirectoryServer.getServerErrorResultCode();
                return new ConfigChangeResult(resultCode, bl2, arrayList);
            }
        }
        object5 = null;
        n = 3146110;
        StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-backend-id", MessageHandler.getMessage(n), true, false, true);
        try {
            object4 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
            if (object4 == null) {
                n = 3277183;
                arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN)));
                resultCode = ResultCode.UNWILLING_TO_PERFORM;
                return new ConfigChangeResult(resultCode, bl2, arrayList);
            }
            object5 = ((StringConfigAttribute)object4).pendingValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyConfigurationChange", exception));
            n = 3408257;
            arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception)));
            resultCode = DirectoryServer.getServerErrorResultCode();
            return new ConfigChangeResult(resultCode, bl2, arrayList);
        }
        object4 = new LinkedHashSet(3);
        ((HashSet)object4).add(WritabilityMode.ENABLED.toString());
        ((HashSet)object4).add(WritabilityMode.DISABLED.toString());
        ((HashSet)object4).add(WritabilityMode.INTERNAL_ONLY.toString());
        n = 3146196;
        WritabilityMode writabilityMode = null;
        MultiChoiceConfigAttribute multiChoiceConfigAttribute = new MultiChoiceConfigAttribute("ds-cfg-backend-writability-mode", MessageHandler.getMessage(n), true, false, false, (Set<String>)object4);
        try {
            dNArray = (DN[])configEntry.getConfigAttribute(multiChoiceConfigAttribute);
            if (multiChoiceConfigAttribute == null) {
                n = 3408341;
                arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN)));
                resultCode = ResultCode.UNWILLING_TO_PERFORM;
                return new ConfigChangeResult(resultCode, bl2, arrayList);
            }
            writabilityMode = WritabilityMode.modeForName(dNArray.activeValue());
            if (writabilityMode == null) {
                n = 3408342;
                arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN), String.valueOf(dNArray.activeValue())));
                resultCode = ResultCode.INVALID_ATTRIBUTE_SYNTAX;
                return new ConfigChangeResult(resultCode, bl2, arrayList);
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyConfigurationChange", exception));
            n = 3408343;
            arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception)));
            resultCode = DirectoryServer.getServerErrorResultCode();
            return new ConfigChangeResult(resultCode, bl2, arrayList);
        }
        dNArray = null;
        n = 0x300131;
        DNConfigAttribute dNConfigAttribute = new DNConfigAttribute("ds-cfg-backend-base-dn", MessageHandler.getMessage(n), true, true, true);
        try {
            object3 = (DNConfigAttribute)configEntry.getConfigAttribute(dNConfigAttribute);
            if (object3 == null) {
                n = 3408178;
                arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN)));
                resultCode = ResultCode.UNWILLING_TO_PERFORM;
                return new ConfigChangeResult(resultCode, bl2, arrayList);
            }
            object2 = ((DNConfigAttribute)object3).pendingValues();
            dNArray = new DN[object2.size()];
            object2.toArray(dNArray);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyConfigurationChange", exception));
            n = 3408179;
            arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception)));
            resultCode = DirectoryServer.getServerErrorResultCode();
            return new ConfigChangeResult(resultCode, bl2, arrayList);
        }
        n = 3145837;
        object2 = new StringConfigAttribute("ds-cfg-backend-class", MessageHandler.getMessage(n), true, false, true);
        try {
            object = (StringConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object2);
            if (object == null) {
                n = 3407985;
                arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN)));
                resultCode = ResultCode.UNWILLING_TO_PERFORM;
                return new ConfigChangeResult(resultCode, bl2, arrayList);
            }
            object3 = ((StringConfigAttribute)object).pendingValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyConfigurationChange", exception));
            n = 3407986;
            arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception)));
            resultCode = DirectoryServer.getServerErrorResultCode();
            return new ConfigChangeResult(resultCode, bl2, arrayList);
        }
        if (backend != null && !((String)object3).equals(backend.getClass().getName())) {
            try {
                object = Class.forName((String)object3);
                if (Backend.class.isAssignableFrom((Class<?>)object)) {
                    n = 3604598;
                    arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN), backend.getClass().getName(), object3));
                    bl2 = true;
                    return new ConfigChangeResult(resultCode, bl2, arrayList);
                }
                n = 3407989;
                arrayList.add(MessageHandler.getMessage(n, String.valueOf(object3), String.valueOf(dN)));
                resultCode = ResultCode.CONSTRAINT_VIOLATION;
                return new ConfigChangeResult(resultCode, bl2, arrayList);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "applyConfigurationChange", exception));
                n = 3407987;
                arrayList.add(MessageHandler.getMessage(n, String.valueOf(object3), String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception)));
                resultCode = DirectoryServer.getServerErrorResultCode();
                return new ConfigChangeResult(resultCode, bl2, arrayList);
            }
        }
        if (bl) {
            CharSequence charSequence;
            try {
                object = Class.forName((String)object3);
                backend = (Backend)((Class)object).newInstance();
            }
            catch (Exception exception) {
                n = 3407989;
                arrayList.add(MessageHandler.getMessage(n, String.valueOf(object3), String.valueOf(dN)));
                resultCode = ResultCode.CONSTRAINT_VIOLATION;
                return new ConfigChangeResult(resultCode, bl2, arrayList);
            }
            backend.setBackendID((String)object5);
            backend.setWritabilityMode(writabilityMode);
            try {
                object = LockFileManager.getBackendLockFileName(backend);
                charSequence = new StringBuilder();
                if (!LockFileManager.acquireSharedLock((String)object, charSequence)) {
                    n = 3408294;
                    String string = MessageHandler.getMessage(n, object5, String.valueOf(charSequence));
                    Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, string, n);
                    resultCode = ResultCode.CONSTRAINT_VIOLATION;
                    bl2 = true;
                    arrayList.add(string);
                    return new ConfigChangeResult(resultCode, bl2, arrayList);
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "applyConfigurationChange", exception));
                n = 3408294;
                String string = MessageHandler.getMessage(n, object5, StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, string, n);
                resultCode = ResultCode.CONSTRAINT_VIOLATION;
                bl2 = true;
                arrayList.add(string);
                return new ConfigChangeResult(resultCode, bl2, arrayList);
            }
            try {
                backend.initializeBackend(configEntry, dNArray);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "applyConfigurationChange", exception));
                n = 3407988;
                arrayList.add(MessageHandler.getMessage(n, String.valueOf(object3), String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception)));
                resultCode = DirectoryServer.getServerErrorResultCode();
                try {
                    charSequence = LockFileManager.getBackendLockFileName(backend);
                    StringBuilder stringBuilder = new StringBuilder();
                    if (!LockFileManager.releaseLock((String)charSequence, stringBuilder)) {
                        n = 3277223;
                        String string = MessageHandler.getMessage(n, object5, String.valueOf(stringBuilder));
                        Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, string, n);
                    }
                }
                catch (Exception exception2) {
                    assert (Debug.debugException(CLASS_NAME, "applyConfigurationChange", exception2));
                    n = 3277223;
                    String string = MessageHandler.getMessage(n, object5, StaticUtils.stackTraceToSingleLineString(exception2));
                    Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, string, n);
                }
                return new ConfigChangeResult(resultCode, bl2, arrayList);
            }
            DirectoryServer.registerBackend(backend);
            this.registeredBackends.put(dN, backend);
        } else if (resultCode == ResultCode.SUCCESS && backend != null && writabilityMode != backend.getWritabilityMode()) {
            backend.setWritabilityMode(writabilityMode);
        }
        return new ConfigChangeResult(resultCode, bl2, arrayList);
    }

    public boolean configAddIsAcceptable(ConfigEntry configEntry, StringBuilder stringBuilder) {
        LinkedList<String> linkedList;
        Object object;
        Object object2;
        Object object3;
        ConfigAttribute configAttribute;
        Object object4;
        Object object5;
        ConfigAttribute configAttribute2;
        assert (Debug.debugEnter(CLASS_NAME, "configAddIsAcceptable", String.valueOf(configEntry), "java.lang.StringBuilder"));
        DN dN = configEntry.getDN();
        try {
            SearchFilter searchFilter = SearchFilter.createFilterFromString("(objectClass=ds-cfg-backend)");
            if (!searchFilter.matchesEntry(configEntry.getEntry())) {
                int n = 3276906;
                stringBuilder.append(MessageHandler.getMessage(n, String.valueOf(dN)));
                return false;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configAddIsAcceptable", exception));
            int n = 3407979;
            stringBuilder.append(MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception)));
            return false;
        }
        int n = 3145836;
        BooleanConfigAttribute booleanConfigAttribute = new BooleanConfigAttribute("ds-cfg-backend-enabled", MessageHandler.getMessage(n), false);
        try {
            configAttribute2 = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute);
            if (configAttribute2 == null) {
                n = 3276910;
                stringBuilder.append(MessageHandler.getMessage(n, String.valueOf(dN)));
                return false;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configAddIsAcceptable", exception));
            n = 3407984;
            stringBuilder.append(MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception)));
            return false;
        }
        n = 3146110;
        configAttribute2 = new StringConfigAttribute("ds-cfg-backend-id", MessageHandler.getMessage(n), true, false, true);
        try {
            object5 = (StringConfigAttribute)configEntry.getConfigAttribute(configAttribute2);
            if (object5 == null) {
                n = 3277183;
                stringBuilder.append(MessageHandler.getMessage(n, String.valueOf(dN)));
                return false;
            }
            object4 = ((StringConfigAttribute)object5).activeValue();
            if (DirectoryServer.hasBackend((String)object4)) {
                n = 3277184;
                stringBuilder.append(MessageHandler.getMessage(n, String.valueOf(dN)));
                return false;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configAddIsAcceptable", exception));
            n = 3408257;
            stringBuilder.append(MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception)));
            return false;
        }
        object5 = new LinkedHashSet(3);
        ((HashSet)object5).add(WritabilityMode.ENABLED.toString());
        ((HashSet)object5).add(WritabilityMode.DISABLED.toString());
        ((HashSet)object5).add(WritabilityMode.INTERNAL_ONLY.toString());
        n = 3146196;
        object4 = new MultiChoiceConfigAttribute("ds-cfg-backend-writability-mode", MessageHandler.getMessage(n), true, false, false, (Set<String>)object5);
        try {
            configAttribute = (MultiChoiceConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object4);
            if (configAttribute == null) {
                n = 3408341;
                stringBuilder.append(MessageHandler.getMessage(n, String.valueOf(dN)));
                return false;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configAddIsAcceptable", exception));
            n = 3408343;
            stringBuilder.append(MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception)));
            return false;
        }
        n = 0x300131;
        configAttribute = new DNConfigAttribute("ds-cfg-backend-base-dn", MessageHandler.getMessage(n), true, true, true);
        try {
            object3 = (DNConfigAttribute)configEntry.getConfigAttribute(configAttribute);
            if (object3 == null) {
                n = 3408178;
                stringBuilder.append(MessageHandler.getMessage(n, String.valueOf(dN)));
                return false;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configAddIsAcceptable", exception));
            n = 3408179;
            stringBuilder.append(MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception)));
            return false;
        }
        n = 3145837;
        StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-backend-class", MessageHandler.getMessage(n), true, false, true);
        try {
            object2 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
            if (object2 == null) {
                n = 3407985;
                stringBuilder.append(MessageHandler.getMessage(n, String.valueOf(dN)));
                return false;
            }
            object3 = ((StringConfigAttribute)object2).pendingValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configAddIsAcceptable", exception));
            n = 3407986;
            stringBuilder.append(MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception)));
            return false;
        }
        try {
            object = Class.forName((String)object3);
            object2 = (Backend)((Class)object).newInstance();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configAddIsAcceptable", exception));
            n = 3407987;
            stringBuilder.append(MessageHandler.getMessage(n, String.valueOf(object3), String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception)));
            return false;
        }
        if (object2 instanceof ConfigurableComponent && !(object = (ConfigurableComponent)object2).hasAcceptableConfiguration(configEntry, linkedList = new LinkedList<String>())) {
            if (linkedList.isEmpty()) {
                n = 3408028;
                stringBuilder.append(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN)));
            } else {
                Iterator iterator = linkedList.iterator();
                stringBuilder.append((String)iterator.next());
                while (iterator.hasNext()) {
                    stringBuilder.append("  ");
                    stringBuilder.append((String)iterator.next());
                }
            }
            return false;
        }
        return true;
    }

    public ConfigChangeResult applyConfigurationAdd(ConfigEntry configEntry) {
        CharSequence charSequence;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        DN[] dNArray;
        Object object5;
        Object object6;
        assert (Debug.debugEnter(CLASS_NAME, "applyConfigurationAdd", String.valueOf(configEntry)));
        DN dN = configEntry.getDN();
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        configEntry.registerChangeListener(this);
        try {
            SearchFilter searchFilter = SearchFilter.createFilterFromString("(objectClass=ds-cfg-backend)");
            if (!searchFilter.matchesEntry(configEntry.getEntry())) {
                int n = 3276906;
                arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN)));
                resultCode = ResultCode.UNWILLING_TO_PERFORM;
                return new ConfigChangeResult(resultCode, bl, arrayList);
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyConfigurationAdd", exception));
            int n = 3407979;
            arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception)));
            resultCode = DirectoryServer.getServerErrorResultCode();
            return new ConfigChangeResult(resultCode, bl, arrayList);
        }
        int n = 3145836;
        BooleanConfigAttribute booleanConfigAttribute = new BooleanConfigAttribute("ds-cfg-backend-enabled", MessageHandler.getMessage(n), false);
        try {
            object6 = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute);
            if (object6 == null) {
                n = 3276910;
                String string = MessageHandler.getMessage(n, String.valueOf(dN));
                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, string, n);
                arrayList.add(string);
                return new ConfigChangeResult(resultCode, bl, arrayList);
            }
            if (!((BooleanConfigAttribute)object6).activeValue()) {
                n = 3145839;
                String string = MessageHandler.getMessage(n, String.valueOf(dN));
                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.INFORMATIONAL, string, n);
                arrayList.add(string);
                return new ConfigChangeResult(resultCode, bl, arrayList);
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyConfigurationAdd", exception));
            n = 3407984;
            arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception)));
            resultCode = DirectoryServer.getServerErrorResultCode();
            return new ConfigChangeResult(resultCode, bl, arrayList);
        }
        n = 3146110;
        StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-backend-id", MessageHandler.getMessage(n), true, false, true);
        try {
            object5 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
            if (object5 == null) {
                n = 3277183;
                String string = MessageHandler.getMessage(n, String.valueOf(dN));
                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, string, n);
                arrayList.add(string);
                return new ConfigChangeResult(resultCode, bl, arrayList);
            }
            object6 = ((StringConfigAttribute)object5).pendingValue();
            if (DirectoryServer.hasBackend((String)object6)) {
                n = 3277184;
                String string = MessageHandler.getMessage(n, String.valueOf(dN));
                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, string, n);
                arrayList.add(string);
                return new ConfigChangeResult(resultCode, bl, arrayList);
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyConfigurationAdd", exception));
            n = 3408257;
            arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception)));
            resultCode = DirectoryServer.getServerErrorResultCode();
            return new ConfigChangeResult(resultCode, bl, arrayList);
        }
        object5 = new LinkedHashSet(3);
        ((HashSet)object5).add(WritabilityMode.ENABLED.toString());
        ((HashSet)object5).add(WritabilityMode.DISABLED.toString());
        ((HashSet)object5).add(WritabilityMode.INTERNAL_ONLY.toString());
        n = 3146196;
        WritabilityMode writabilityMode = null;
        MultiChoiceConfigAttribute multiChoiceConfigAttribute = new MultiChoiceConfigAttribute("ds-cfg-backend-writability-mode", MessageHandler.getMessage(n), true, false, false, (Set<String>)object5);
        try {
            dNArray = (DN[])configEntry.getConfigAttribute(multiChoiceConfigAttribute);
            if (dNArray == null) {
                n = 3408341;
                arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN)));
                resultCode = ResultCode.UNWILLING_TO_PERFORM;
                return new ConfigChangeResult(resultCode, bl, arrayList);
            }
            writabilityMode = WritabilityMode.modeForName(dNArray.activeValue());
            if (writabilityMode == null) {
                n = 3408342;
                arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN), String.valueOf(dNArray.activeValue())));
                resultCode = ResultCode.INVALID_ATTRIBUTE_SYNTAX;
                return new ConfigChangeResult(resultCode, bl, arrayList);
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyConfigurationAdd", exception));
            n = 3408343;
            arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception)));
            resultCode = DirectoryServer.getServerErrorResultCode();
            return new ConfigChangeResult(resultCode, bl, arrayList);
        }
        dNArray = null;
        n = 0x300131;
        DNConfigAttribute dNConfigAttribute = new DNConfigAttribute("ds-cfg-backend-base-dn", MessageHandler.getMessage(n), true, true, true);
        try {
            object4 = (DNConfigAttribute)configEntry.getConfigAttribute(dNConfigAttribute);
            if (object4 == null) {
                n = 3408178;
                String string = MessageHandler.getMessage(n, String.valueOf(dN));
                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, string, n);
                arrayList.add(string);
                return new ConfigChangeResult(resultCode, bl, arrayList);
            }
            object3 = ((DNConfigAttribute)object4).pendingValues();
            dNArray = new DN[object3.size()];
            object3.toArray(dNArray);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyConfigurationAdd", exception));
            n = 3408179;
            arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception)));
            resultCode = DirectoryServer.getServerErrorResultCode();
            return new ConfigChangeResult(resultCode, bl, arrayList);
        }
        n = 3145837;
        object3 = new StringConfigAttribute("ds-cfg-backend-class", MessageHandler.getMessage(n), true, false, true);
        try {
            object2 = (StringConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object3);
            if (object2 == null) {
                n = 3407985;
                arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN)));
                resultCode = ResultCode.UNWILLING_TO_PERFORM;
                return new ConfigChangeResult(resultCode, bl, arrayList);
            }
            object4 = ((StringConfigAttribute)object2).activeValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyConfigurationAdd", exception));
            n = 3407986;
            arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception)));
            resultCode = DirectoryServer.getServerErrorResultCode();
            return new ConfigChangeResult(resultCode, bl, arrayList);
        }
        try {
            object = Class.forName((String)object4);
            object2 = (Backend)((Class)object).newInstance();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyConfigurationAdd", exception));
            n = 3407987;
            arrayList.add(MessageHandler.getMessage(n, String.valueOf(object4), String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception)));
            resultCode = DirectoryServer.getServerErrorResultCode();
            return new ConfigChangeResult(resultCode, bl, arrayList);
        }
        ((Backend)object2).setBackendID((String)object6);
        ((Backend)object2).setWritabilityMode(writabilityMode);
        try {
            object = LockFileManager.getBackendLockFileName((Backend)object2);
            charSequence = new StringBuilder();
            if (!LockFileManager.acquireSharedLock((String)object, charSequence)) {
                n = 3408294;
                String string = MessageHandler.getMessage(n, object6, String.valueOf(charSequence));
                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, string, n);
                resultCode = ResultCode.CONSTRAINT_VIOLATION;
                bl = true;
                arrayList.add(string);
                return new ConfigChangeResult(resultCode, bl, arrayList);
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyConfigurationAdd", exception));
            n = 3408294;
            String string = MessageHandler.getMessage(n, object6, StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, string, n);
            resultCode = ResultCode.CONSTRAINT_VIOLATION;
            bl = true;
            arrayList.add(string);
            return new ConfigChangeResult(resultCode, bl, arrayList);
        }
        try {
            ((Backend)object2).initializeBackend(configEntry, dNArray);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyConfigurationAdd", exception));
            n = 3407988;
            arrayList.add(MessageHandler.getMessage(n, String.valueOf(object4), String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception)));
            resultCode = DirectoryServer.getServerErrorResultCode();
            try {
                charSequence = LockFileManager.getBackendLockFileName((Backend)object2);
                StringBuilder stringBuilder = new StringBuilder();
                if (!LockFileManager.releaseLock((String)charSequence, stringBuilder)) {
                    n = 3277223;
                    String string = MessageHandler.getMessage(n, object6, String.valueOf(stringBuilder));
                    Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, string, n);
                }
            }
            catch (Exception exception2) {
                assert (Debug.debugException(CLASS_NAME, "applyConfigurationAdd", exception2));
                n = 3277223;
                String string = MessageHandler.getMessage(n, object6, StaticUtils.stackTraceToSingleLineString(exception2));
                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, string, n);
            }
            return new ConfigChangeResult(resultCode, bl, arrayList);
        }
        DirectoryServer.registerBackend((Backend)object2);
        this.registeredBackends.put(dN, (Backend)object2);
        return new ConfigChangeResult(resultCode, bl, arrayList);
    }

    public boolean configDeleteIsAcceptable(ConfigEntry configEntry, StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "configDeleteIsAcceptable", String.valueOf(configEntry), "java.lang.StringBuilder"));
        DN dN = configEntry.getDN();
        Backend backend = this.registeredBackends.get(dN);
        if (dN == null) {
            return true;
        }
        Backend[] backendArray = backend.getSubordinateBackends();
        if (backendArray == null || backendArray.length == 0) {
            return true;
        }
        int n = 0x370077;
        stringBuilder.append(MessageHandler.getMessage(n, String.valueOf(dN)));
        return false;
    }

    public ConfigChangeResult applyConfigurationDelete(ConfigEntry configEntry) {
        assert (Debug.debugEnter(CLASS_NAME, "applyConfigurationDelete", String.valueOf(configEntry)));
        DN dN = configEntry.getDN();
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        Backend backend = this.registeredBackends.get(dN);
        if (dN == null) {
            return new ConfigChangeResult(resultCode, bl, arrayList);
        }
        Backend[] backendArray = backend.getSubordinateBackends();
        if (backendArray == null || backendArray.length == 0) {
            return new ConfigChangeResult(resultCode, bl, arrayList);
        }
        int n = 0x370077;
        arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN)));
        resultCode = ResultCode.UNWILLING_TO_PERFORM;
        return new ConfigChangeResult(resultCode, bl, arrayList);
    }
}

