/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import java.util.ArrayList;
import java.util.concurrent.locks.Lock;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.PasswordPolicyState;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.ldap.LDAPException;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.LockManager;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public class ProxiedAuthV1Control
extends Control {
    private static final String CLASS_NAME = "org.opends.server.controls.ProxiedAuthV1Control";
    private ASN1OctetString rawAuthorizationDN;
    private DN authorizationDN;

    public ProxiedAuthV1Control(ASN1OctetString aSN1OctetString) {
        super("2.16.840.1.113730.3.4.12", true, ProxiedAuthV1Control.encodeValue(aSN1OctetString));
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(aSN1OctetString)));
        this.rawAuthorizationDN = aSN1OctetString;
        this.authorizationDN = null;
    }

    public ProxiedAuthV1Control(DN dN) {
        super("2.16.840.1.113730.3.4.12", true, ProxiedAuthV1Control.encodeValue(new ASN1OctetString(dN.toString())));
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(dN)));
        this.authorizationDN = dN;
        this.rawAuthorizationDN = new ASN1OctetString(dN.toString());
    }

    private ProxiedAuthV1Control(String string, boolean bl, ASN1OctetString aSN1OctetString, ASN1OctetString aSN1OctetString2) {
        super(string, bl, aSN1OctetString);
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(bl), String.valueOf(aSN1OctetString), String.valueOf(aSN1OctetString2)));
        this.rawAuthorizationDN = aSN1OctetString2;
        this.authorizationDN = null;
    }

    private static ASN1OctetString encodeValue(ASN1OctetString aSN1OctetString) {
        assert (Debug.debugEnter(CLASS_NAME, "encodeValue", String.valueOf(aSN1OctetString)));
        ArrayList<ASN1Element> arrayList = new ArrayList<ASN1Element>(1);
        arrayList.add(aSN1OctetString);
        return new ASN1OctetString(new ASN1Sequence(arrayList).encode());
    }

    public static ProxiedAuthV1Control decodeControl(Control control) throws LDAPException {
        ASN1OctetString aSN1OctetString;
        assert (Debug.debugEnter(CLASS_NAME, "decodeControl", String.valueOf(control)));
        if (!control.hasValue()) {
            int n = 2294053;
            String string = MessageHandler.getMessage(n);
            throw new LDAPException(2, n, string);
        }
        try {
            ArrayList<ASN1Element> arrayList = ASN1Sequence.decodeAsSequence(control.getValue().value()).elements();
            if (arrayList.size() != 1) {
                int n = 2294054;
                String string = MessageHandler.getMessage(n, arrayList.size());
                throw new LDAPException(2, n, string);
            }
            aSN1OctetString = arrayList.get(0).decodeAsOctetString();
        }
        catch (LDAPException lDAPException) {
            throw lDAPException;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeControl", exception));
            int n = 2294055;
            String string = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
            throw new LDAPException(2, n, string, exception);
        }
        return new ProxiedAuthV1Control(control.getOID(), control.isCritical(), control.getValue(), aSN1OctetString);
    }

    public ASN1OctetString getRawAuthorizationDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getRawAuthorizationDN", new String[0]));
        return this.rawAuthorizationDN;
    }

    public void setRawAuthorizationDN(ASN1OctetString aSN1OctetString) {
        assert (Debug.debugEnter(CLASS_NAME, "setRawAuthorizationDN", String.valueOf(aSN1OctetString)));
        this.rawAuthorizationDN = aSN1OctetString;
        this.setValue(ProxiedAuthV1Control.encodeValue(aSN1OctetString));
        this.authorizationDN = null;
    }

    public DN getAuthorizationDN() throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "getAuthorizationDN", new String[0]));
        if (this.authorizationDN == null) {
            this.authorizationDN = DN.decode(this.rawAuthorizationDN);
        }
        return this.authorizationDN;
    }

    public void setAuthorizationDN(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "setAuthorizationDN", String.valueOf(dN)));
        this.authorizationDN = dN;
        this.rawAuthorizationDN = new ASN1OctetString(dN.toString());
        this.setValue(ProxiedAuthV1Control.encodeValue(this.rawAuthorizationDN));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DN getValidatedAuthorizationDN() throws DirectoryException {
        int n;
        assert (Debug.debugEnter(CLASS_NAME, "getValidatedAuthorizationDN", new String[0]));
        DN dN = this.getAuthorizationDN();
        if (dN.isNullDN()) {
            return dN;
        }
        Lock lock = null;
        for (n = 0; n < 3 && (lock = LockManager.lockRead(dN)) == null; ++n) {
        }
        if (lock == null) {
            n = 2294131;
            String string = MessageHandler.getMessage(n, String.valueOf(dN));
            throw new DirectoryException(ResultCode.AUTHORIZATION_DENIED, string, n);
        }
        try {
            Entry entry = DirectoryServer.getEntry(dN);
            if (entry == null) {
                int n2 = 2294056;
                String string = MessageHandler.getMessage(n2, String.valueOf(dN));
                throw new DirectoryException(ResultCode.AUTHORIZATION_DENIED, string, n2);
            }
            PasswordPolicyState passwordPolicyState = new PasswordPolicyState(entry, false, false);
            if (passwordPolicyState.isDisabled() || passwordPolicyState.isAccountExpired() || passwordPolicyState.lockedDueToFailures() || passwordPolicyState.lockedDueToIdleInterval() || passwordPolicyState.lockedDueToMaximumResetAge() || passwordPolicyState.isPasswordExpired()) {
                int n3 = 2294132;
                String string = MessageHandler.getMessage(n3, String.valueOf(dN));
                throw new DirectoryException(ResultCode.AUTHORIZATION_DENIED, string, n3);
            }
            DN dN2 = dN;
            return dN2;
        }
        finally {
            LockManager.unlock(dN, lock);
        }
    }

    public String toString() {
        assert (Debug.debugEnter(CLASS_NAME, "toString", new String[0]));
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        stringBuilder.append("ProxiedAuthorizationV1Control(authorizationDN=\"");
        this.rawAuthorizationDN.toString(stringBuilder);
        stringBuilder.append("\")");
    }
}

