/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.ldap.LDAPException;
import org.opends.server.protocols.ldap.SearchResultEntryProtocolOp;
import org.opends.server.types.Control;
import org.opends.server.types.SearchResultEntry;

public class LDAPPostReadResponseControl
extends Control {
    private static final String CLASS_NAME = "org.opends.server.controls.LDAPPostReadResponseControl";
    private SearchResultEntry searchEntry;

    public LDAPPostReadResponseControl(SearchResultEntry searchResultEntry) {
        super("1.3.6.1.1.13.2", false, LDAPPostReadResponseControl.encodeEntry(searchResultEntry));
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(searchResultEntry)));
        this.searchEntry = searchResultEntry;
    }

    public LDAPPostReadResponseControl(String string, boolean bl, SearchResultEntry searchResultEntry) {
        super(string, bl, LDAPPostReadResponseControl.encodeEntry(searchResultEntry));
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(bl), String.valueOf(searchResultEntry)));
        this.searchEntry = searchResultEntry;
    }

    private LDAPPostReadResponseControl(String string, boolean bl, SearchResultEntry searchResultEntry, ASN1OctetString aSN1OctetString) {
        super(string, bl, aSN1OctetString);
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(bl), String.valueOf(searchResultEntry), String.valueOf(aSN1OctetString)));
        this.searchEntry = searchResultEntry;
    }

    public static LDAPPostReadResponseControl decodeControl(Control control) throws LDAPException {
        SearchResultEntry searchResultEntry;
        assert (Debug.debugEnter(CLASS_NAME, "decodeControl", String.valueOf(control)));
        if (!control.hasValue()) {
            int n = 2294051;
            String string = MessageHandler.getMessage(n);
            throw new LDAPException(2, n, string);
        }
        ASN1OctetString aSN1OctetString = control.getValue();
        try {
            ASN1Element aSN1Element = ASN1Element.decode(aSN1OctetString.value());
            SearchResultEntryProtocolOp searchResultEntryProtocolOp = SearchResultEntryProtocolOp.decodeSearchEntry(aSN1Element);
            searchResultEntry = searchResultEntryProtocolOp.toSearchResultEntry();
        }
        catch (ASN1Exception aSN1Exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeControl", aSN1Exception));
            int n = 2294052;
            String string = MessageHandler.getMessage(n, aSN1Exception.getMessage());
            throw new LDAPException(2, n, string, aSN1Exception);
        }
        catch (LDAPException lDAPException) {
            assert (Debug.debugException(CLASS_NAME, "decodeControl", lDAPException));
            int n = 2294052;
            String string = MessageHandler.getMessage(n, lDAPException.getMessage());
            throw new LDAPException(2, n, string, lDAPException);
        }
        return new LDAPPostReadResponseControl(control.getOID(), control.isCritical(), searchResultEntry, aSN1OctetString);
    }

    private static ASN1OctetString encodeEntry(SearchResultEntry searchResultEntry) {
        assert (Debug.debugEnter(CLASS_NAME, "encodeEntry", String.valueOf(searchResultEntry)));
        SearchResultEntryProtocolOp searchResultEntryProtocolOp = new SearchResultEntryProtocolOp(searchResultEntry);
        return new ASN1OctetString(searchResultEntryProtocolOp.encode().encode());
    }

    public SearchResultEntry getSearchEntry() {
        assert (Debug.debugEnter(CLASS_NAME, "getSearchEntry", new String[0]));
        return this.searchEntry;
    }

    public void setSearchEntry(SearchResultEntry searchResultEntry) {
        assert (Debug.debugEnter(CLASS_NAME, "setSearchEntry", String.valueOf(searchResultEntry)));
        this.searchEntry = searchResultEntry;
        this.setValue(LDAPPostReadResponseControl.encodeEntry(searchResultEntry));
    }

    public String toString() {
        assert (Debug.debugEnter(CLASS_NAME, "toString", new String[0]));
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        stringBuilder.append("LDAPPostReadResponseControl(criticality=");
        stringBuilder.append(this.isCritical());
        stringBuilder.append(",entry=");
        this.searchEntry.toSingleLineString(stringBuilder);
        stringBuilder.append(")");
    }
}

