/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.ldap.LDAPException;
import org.opends.server.protocols.ldap.LDAPFilter;
import org.opends.server.types.Control;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.SearchFilter;

public class LDAPAssertionRequestControl
extends Control {
    private static final String CLASS_NAME = "org.opends.server.controls.LDAPAssertionRequestControl";
    private LDAPFilter rawFilter;
    private SearchFilter filter;

    public LDAPAssertionRequestControl(boolean bl, LDAPFilter lDAPFilter) {
        super("1.3.6.1.1.12", bl, new ASN1OctetString(lDAPFilter.encode().encode()));
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(bl), String.valueOf(lDAPFilter)));
        this.rawFilter = lDAPFilter;
        this.filter = null;
    }

    public LDAPAssertionRequestControl(String string, boolean bl, LDAPFilter lDAPFilter) {
        super(string, bl, new ASN1OctetString(lDAPFilter.encode().encode()));
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(bl), String.valueOf(lDAPFilter)));
        this.rawFilter = lDAPFilter;
        this.filter = null;
    }

    private LDAPAssertionRequestControl(String string, boolean bl, LDAPFilter lDAPFilter, ASN1OctetString aSN1OctetString) {
        super(string, bl, aSN1OctetString);
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(bl), String.valueOf(lDAPFilter), String.valueOf(aSN1OctetString)));
        this.rawFilter = lDAPFilter;
        this.filter = null;
    }

    public static LDAPAssertionRequestControl decodeControl(Control control) throws LDAPException {
        ASN1Element aSN1Element;
        assert (Debug.debugEnter(CLASS_NAME, "decodeControl", String.valueOf(control)));
        if (!control.hasValue()) {
            int n = 2294043;
            String string = MessageHandler.getMessage(n);
            throw new LDAPException(2, n, string);
        }
        try {
            aSN1Element = ASN1Element.decode(control.getValue().value());
        }
        catch (ASN1Exception aSN1Exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeControl", aSN1Exception));
            int n = 2294044;
            String string = MessageHandler.getMessage(n, aSN1Exception.getMessage());
            throw new LDAPException(2, n, string, aSN1Exception);
        }
        return new LDAPAssertionRequestControl(control.getOID(), control.isCritical(), LDAPFilter.decode(aSN1Element), control.getValue());
    }

    public LDAPFilter getRawFilter() {
        assert (Debug.debugEnter(CLASS_NAME, "getRawFilter", new String[0]));
        return this.rawFilter;
    }

    public void setRawFilter(LDAPFilter lDAPFilter) {
        assert (Debug.debugEnter(CLASS_NAME, "setRawFilter", String.valueOf(lDAPFilter)));
        this.rawFilter = lDAPFilter;
        this.filter = null;
        this.setValue(new ASN1OctetString(lDAPFilter.encode().encode()));
    }

    public SearchFilter getSearchFilter() throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "getSearchFilter", new String[0]));
        if (this.filter == null) {
            this.filter = this.rawFilter.toSearchFilter();
        }
        return this.filter;
    }

    public String toString() {
        assert (Debug.debugEnter(CLASS_NAME, "toString", new String[0]));
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        stringBuilder.append("LDAPAssertionRequestControl(criticality=");
        stringBuilder.append(this.isCritical());
        stringBuilder.append(",filter=\"");
        this.rawFilter.toString(stringBuilder);
        stringBuilder.append("\")");
    }
}

