/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import java.util.ArrayList;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Boolean;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1Integer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.ldap.LDAPException;
import org.opends.server.types.Control;
import org.opends.server.util.StaticUtils;

public class AccountUsableResponseControl
extends Control {
    private static final String CLASS_NAME = "org.opends.server.controls.AccountUsableResponseControl";
    public static final byte TYPE_SECONDS_BEFORE_EXPIRATION = -128;
    public static final byte TYPE_MORE_INFO = -95;
    public static final byte TYPE_INACTIVE = -128;
    public static final byte TYPE_RESET = -127;
    public static final byte TYPE_EXPIRED = -126;
    public static final byte TYPE_REMAINING_GRACE_LOGINS = -125;
    public static final byte TYPE_SECONDS_BEFORE_UNLOCK = -124;
    private boolean isUsable;
    private boolean isExpired;
    private boolean isInactive;
    private boolean isLocked;
    private boolean isReset;
    private int remainingGraceLogins;
    private int secondsBeforeExpiration;
    private int secondsBeforeUnlock;

    public AccountUsableResponseControl(int n) {
        super("1.3.6.1.4.1.42.2.27.9.5.8", false, AccountUsableResponseControl.encodeValue(n));
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(n)));
        this.secondsBeforeExpiration = n;
        this.isUsable = true;
        this.isInactive = false;
        this.isReset = false;
        this.isExpired = false;
        this.remainingGraceLogins = -1;
        this.isLocked = false;
        this.secondsBeforeUnlock = 0;
    }

    public AccountUsableResponseControl(String string, boolean bl, int n) {
        super(string, bl, AccountUsableResponseControl.encodeValue(n));
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(bl), String.valueOf(n)));
        this.secondsBeforeExpiration = n;
        this.isUsable = true;
        this.isInactive = false;
        this.isReset = false;
        this.isExpired = false;
        this.remainingGraceLogins = -1;
        this.isLocked = false;
        this.secondsBeforeUnlock = 0;
    }

    public AccountUsableResponseControl(boolean bl, boolean bl2, boolean bl3, int n, boolean bl4, int n2) {
        super("1.3.6.1.4.1.42.2.27.9.5.8", false, AccountUsableResponseControl.encodeValue(bl, bl2, bl3, n, bl4, n2));
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(bl), String.valueOf(bl2), String.valueOf(bl3), String.valueOf(n), String.valueOf(bl4), String.valueOf(n2)));
        this.isInactive = bl;
        this.isReset = bl2;
        this.isExpired = bl3;
        this.remainingGraceLogins = n;
        this.isLocked = bl4;
        this.secondsBeforeUnlock = n2;
        this.isUsable = false;
        this.secondsBeforeExpiration = -1;
    }

    public AccountUsableResponseControl(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, boolean bl5, int n2) {
        super(string, bl, AccountUsableResponseControl.encodeValue(bl2, bl3, bl4, n, bl5, n2));
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(bl), String.valueOf(bl2), String.valueOf(bl3), String.valueOf(bl4), String.valueOf(n), String.valueOf(bl5), String.valueOf(n2)));
        this.isInactive = bl2;
        this.isReset = bl3;
        this.isExpired = bl4;
        this.remainingGraceLogins = n;
        this.isLocked = bl5;
        this.secondsBeforeUnlock = n2;
        this.isUsable = false;
        this.secondsBeforeExpiration = -1;
    }

    private AccountUsableResponseControl(String string, boolean bl, boolean bl2, int n, boolean bl3, boolean bl4, boolean bl5, int n2, boolean bl6, int n3, ASN1OctetString aSN1OctetString) {
        super(string, bl, aSN1OctetString);
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(bl), String.valueOf(bl2), String.valueOf(n), String.valueOf(bl3), String.valueOf(bl4), String.valueOf(bl5), String.valueOf(n2), String.valueOf(bl6), String.valueOf(n3)));
        this.isUsable = bl2;
        this.secondsBeforeExpiration = n;
        this.isInactive = bl3;
        this.isReset = bl4;
        this.isExpired = bl5;
        this.remainingGraceLogins = n2;
        this.isLocked = bl6;
        this.secondsBeforeUnlock = n3;
    }

    private static ASN1OctetString encodeValue(int n) {
        assert (Debug.debugEnter(CLASS_NAME, "encodeValue", String.valueOf(n)));
        ASN1Integer aSN1Integer = new ASN1Integer(-128, n);
        return new ASN1OctetString(aSN1Integer.encode());
    }

    private static ASN1OctetString encodeValue(boolean bl, boolean bl2, boolean bl3, int n, boolean bl4, int n2) {
        assert (Debug.debugEnter(CLASS_NAME, "encodeValue", String.valueOf(bl), String.valueOf(bl2), String.valueOf(bl3), String.valueOf(n), String.valueOf(bl4), String.valueOf(n2)));
        ArrayList<ASN1Element> arrayList = new ArrayList<ASN1Element>(5);
        if (bl) {
            arrayList.add(new ASN1Boolean(-128, true));
        }
        if (bl2) {
            arrayList.add(new ASN1Boolean(-127, true));
        }
        if (bl3) {
            arrayList.add(new ASN1Boolean(-126, true));
            if (n >= 0) {
                arrayList.add(new ASN1Integer(-125, n));
            }
        }
        if (bl4) {
            arrayList.add(new ASN1Integer(-124, n2));
        }
        ASN1Sequence aSN1Sequence = new ASN1Sequence(-95, arrayList);
        return new ASN1OctetString(aSN1Sequence.encode());
    }

    public static AccountUsableResponseControl decodeControl(Control control) throws LDAPException {
        assert (Debug.debugEnter(CLASS_NAME, "decodeControl", String.valueOf(control)));
        ASN1OctetString aSN1OctetString = control.getValue();
        if (aSN1OctetString == null) {
            int n = 2359672;
            String string = MessageHandler.getMessage(n);
            throw new LDAPException(2, n, string);
        }
        try {
            ASN1Element aSN1Element = ASN1Element.decode(aSN1OctetString.value());
            switch (aSN1Element.getType()) {
                case -128: {
                    int n = aSN1Element.decodeAsInteger().intValue();
                    return new AccountUsableResponseControl(control.getOID(), control.isCritical(), true, n, false, false, false, -1, false, 0, aSN1OctetString);
                }
                case -95: {
                    boolean bl = false;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    int n = -1;
                    int n2 = 0;
                    block15: for (ASN1Element aSN1Element2 : aSN1Element.decodeAsSequence().elements()) {
                        switch (aSN1Element2.getType()) {
                            case -128: {
                                bl = aSN1Element2.decodeAsBoolean().booleanValue();
                                continue block15;
                            }
                            case -127: {
                                bl2 = aSN1Element2.decodeAsBoolean().booleanValue();
                                continue block15;
                            }
                            case -126: {
                                bl3 = aSN1Element2.decodeAsBoolean().booleanValue();
                                continue block15;
                            }
                            case -125: {
                                n = aSN1Element2.decodeAsInteger().intValue();
                                continue block15;
                            }
                            case -124: {
                                bl4 = true;
                                n2 = aSN1Element2.decodeAsInteger().intValue();
                                continue block15;
                            }
                        }
                        int n3 = 2359673;
                        String string = MessageHandler.getMessage(n3, StaticUtils.byteToHex(aSN1Element2.getType()));
                        throw new LDAPException(2, n3, string);
                    }
                    return new AccountUsableResponseControl(control.getOID(), control.isCritical(), false, -1, bl, bl2, bl3, n, bl4, n2, aSN1OctetString);
                }
            }
            int n = 2359674;
            String string = MessageHandler.getMessage(n, StaticUtils.byteToHex(aSN1Element.getType()));
            throw new LDAPException(2, n, string);
        }
        catch (LDAPException lDAPException) {
            throw lDAPException;
        }
        catch (ASN1Exception aSN1Exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeControl", aSN1Exception));
            int n = 2359675;
            String string = MessageHandler.getMessage(n, aSN1Exception.getMessage());
            throw new LDAPException(2, n, string);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeControl", exception));
            int n = 2359675;
            String string = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
            throw new LDAPException(2, n, string);
        }
    }

    public boolean isUsable() {
        assert (Debug.debugEnter(CLASS_NAME, "isAvailable", new String[0]));
        return this.isUsable;
    }

    public int getSecondsBeforeExpiration() {
        assert (Debug.debugEnter(CLASS_NAME, "getSecondsBeforeExpiration", new String[0]));
        return this.secondsBeforeExpiration;
    }

    public boolean isInactive() {
        assert (Debug.debugEnter(CLASS_NAME, "isInactive", new String[0]));
        return this.isInactive;
    }

    public boolean isReset() {
        assert (Debug.debugEnter(CLASS_NAME, "isReset", new String[0]));
        return this.isReset;
    }

    public boolean isExpired() {
        assert (Debug.debugEnter(CLASS_NAME, "isExpired", new String[0]));
        return this.isExpired;
    }

    public int getRemainingGraceLogins() {
        assert (Debug.debugEnter(CLASS_NAME, "getRemainingGraceLogins", new String[0]));
        return this.remainingGraceLogins;
    }

    public boolean isLocked() {
        assert (Debug.debugEnter(CLASS_NAME, "isLocked", new String[0]));
        return this.isLocked;
    }

    public int getSecondsBeforeUnlock() {
        assert (Debug.debugEnter(CLASS_NAME, "getSecondsBeforeUnlock", new String[0]));
        return this.secondsBeforeUnlock;
    }

    public String toString() {
        assert (Debug.debugEnter(CLASS_NAME, "toString", new String[0]));
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        stringBuilder.append("AccountUsableResponseControl(isUsable=");
        stringBuilder.append(this.isUsable);
        if (this.isUsable) {
            stringBuilder.append(",secondsBeforeExpiration=");
            stringBuilder.append(this.secondsBeforeExpiration);
        } else {
            stringBuilder.append(",isInactive=");
            stringBuilder.append(this.isInactive);
            stringBuilder.append(",isReset=");
            stringBuilder.append(this.isReset);
            stringBuilder.append(",isExpired=");
            stringBuilder.append(this.isExpired);
            stringBuilder.append(",remainingGraceLogins=");
            stringBuilder.append(this.remainingGraceLogins);
            stringBuilder.append(",isLocked=");
            stringBuilder.append(this.isLocked);
            stringBuilder.append(",secondsBeforeUnlock=");
            stringBuilder.append(this.secondsBeforeUnlock);
        }
        stringBuilder.append(")");
    }
}

