/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.config;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import javax.management.AttributeList;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanParameterInfo;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigConstants;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadOnlyConfigAttribute
extends ConfigAttribute {
    private static final String CLASS_NAME = "org.opends.server.config.ReadOnlyConfigAttribute";
    private List<String> values;

    public ReadOnlyConfigAttribute(String string, String string2, boolean bl) {
        super(string, string2, false, bl, false);
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(string2), String.valueOf(bl)));
        this.values = new ArrayList<String>();
    }

    public ReadOnlyConfigAttribute(String string, String string2, String string3) {
        super(string, string2, false, false, false, ReadOnlyConfigAttribute.getValueSet(string3));
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(string2), String.valueOf(string3)));
        if (string3 == null) {
            this.values = new ArrayList<String>(0);
        } else {
            this.values = new ArrayList<String>(1);
            this.values.add(string3);
        }
    }

    public ReadOnlyConfigAttribute(String string, String string2, List<String> list) {
        super(string, string2, false, true, false, ReadOnlyConfigAttribute.getValueSet(list));
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(string2), String.valueOf(list)));
        this.values = list == null ? new ArrayList<String>() : list;
    }

    @Override
    public String getDataType() {
        assert (Debug.debugEnter(CLASS_NAME, "getDataType", new String[0]));
        return "ReadOnly";
    }

    @Override
    public AttributeSyntax getSyntax() {
        assert (Debug.debugEnter(CLASS_NAME, "getSyntax", new String[0]));
        return DirectoryServer.getDefaultStringSyntax();
    }

    public String activeValue() throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "activeValue", new String[0]));
        if (this.values == null || this.values.isEmpty()) {
            int n = 0x33000F;
            String string = MessageHandler.getMessage(n, this.getName());
            throw new ConfigException(n, string);
        }
        if (this.values.size() > 1) {
            int n = 0x330010;
            String string = MessageHandler.getMessage(n, this.getName());
            throw new ConfigException(n, string);
        }
        return this.values.get(0);
    }

    public List<String> activeValues() {
        assert (Debug.debugEnter(CLASS_NAME, "activeValues", new String[0]));
        return this.values;
    }

    public String pendingValue() throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "pendingValue", new String[0]));
        return this.activeValue();
    }

    public List<String> pendingValues() {
        assert (Debug.debugEnter(CLASS_NAME, "pendingValues", new String[0]));
        return this.activeValues();
    }

    public void setValue(String string) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "setValue", String.valueOf(string)));
        int n = 3342564;
        String string2 = MessageHandler.getMessage(n, this.getName());
        throw new ConfigException(n, string2);
    }

    public void setValues(List<String> list) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "setValues", String.valueOf(list)));
        int n = 3342564;
        String string = MessageHandler.getMessage(n, this.getName());
        throw new ConfigException(n, string);
    }

    private static LinkedHashSet<AttributeValue> getValueSet(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "getValueSet", String.valueOf(string)));
        LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>(1);
        linkedHashSet.add(new AttributeValue(new ASN1OctetString(string), (ByteString)new ASN1OctetString(string)));
        return linkedHashSet;
    }

    private static LinkedHashSet<AttributeValue> getValueSet(List<String> list) {
        assert (Debug.debugEnter(CLASS_NAME, "getValueSet", String.valueOf(list)));
        if (list == null) {
            return null;
        }
        LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>(list.size());
        for (String string : list) {
            linkedHashSet.add(new AttributeValue(new ASN1OctetString(string), (ByteString)new ASN1OctetString(string)));
        }
        return linkedHashSet;
    }

    @Override
    public void applyPendingValues() {
        assert (Debug.debugEnter(CLASS_NAME, "applyPendingValues", new String[0]));
    }

    @Override
    public boolean valueIsAcceptable(AttributeValue attributeValue, StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "valueIsAcceptable", String.valueOf(attributeValue), "java.lang.StringBuilder"));
        stringBuilder.append(MessageHandler.getMessage(3342564, this.getName()));
        return false;
    }

    @Override
    public LinkedHashSet<AttributeValue> stringsToValues(List<String> list, boolean bl) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "stringsToValues", String.valueOf(list), String.valueOf(bl)));
        if (list == null || list.isEmpty()) {
            return new LinkedHashSet<AttributeValue>();
        }
        int n = list.size();
        LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>(n);
        for (String string : list) {
            linkedHashSet.add(new AttributeValue(new ASN1OctetString(string), (ByteString)new ASN1OctetString(string)));
        }
        return linkedHashSet;
    }

    @Override
    public List<String> activeValuesToStrings() {
        assert (Debug.debugEnter(CLASS_NAME, "activeValuesToStrings", new String[0]));
        return this.values;
    }

    @Override
    public List<String> pendingValuesToStrings() {
        assert (Debug.debugEnter(CLASS_NAME, "pendingValuesToStrings", new String[0]));
        return this.activeValuesToStrings();
    }

    @Override
    public ConfigAttribute getConfigAttribute(List<Attribute> list) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigAttribute", String.valueOf(list)));
        return this.duplicate();
    }

    @Override
    public javax.management.Attribute toJMXAttribute() {
        assert (Debug.debugEnter(CLASS_NAME, "toJMXAttribute", new String[0]));
        if (this.isMultiValued()) {
            String[] stringArray = new String[this.values.size()];
            this.values.toArray(stringArray);
            return new javax.management.Attribute(this.getName(), stringArray);
        }
        if (this.values.isEmpty()) {
            return null;
        }
        return new javax.management.Attribute(this.getName(), this.values.get(0));
    }

    @Override
    public javax.management.Attribute toJMXAttributePending() {
        assert (Debug.debugEnter(CLASS_NAME, "toJMXAttributePending", new String[0]));
        return this.toJMXAttribute();
    }

    @Override
    public void toJMXAttribute(AttributeList attributeList) {
        assert (Debug.debugEnter(CLASS_NAME, "toJMXAttribute", String.valueOf(attributeList)));
        javax.management.Attribute attribute = this.toJMXAttribute();
        attributeList.add(attribute);
    }

    @Override
    public void toJMXAttributeInfo(List<MBeanAttributeInfo> list) {
        assert (Debug.debugEnter(CLASS_NAME, "toJMXAttributeInfo", String.valueOf(list)));
        if (this.isMultiValued()) {
            list.add(new MBeanAttributeInfo(this.getName(), ConfigConstants.JMX_TYPE_STRING_ARRAY, this.getDescription(), true, false, false));
        } else {
            list.add(new MBeanAttributeInfo(this.getName(), String.class.getName(), this.getDescription(), true, false, false));
        }
    }

    @Override
    public MBeanParameterInfo toJMXParameterInfo() {
        assert (Debug.debugEnter(CLASS_NAME, "toJMXParameterInfo", new String[0]));
        if (this.isMultiValued()) {
            return new MBeanParameterInfo(this.getName(), ConfigConstants.JMX_TYPE_STRING_ARRAY, this.getDescription());
        }
        return new MBeanParameterInfo(this.getName(), String.class.getName(), this.getDescription());
    }

    @Override
    public void setValue(javax.management.Attribute attribute) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "setValue", String.valueOf(attribute)));
        int n = 3342564;
        String string = MessageHandler.getMessage(n, this.getName());
        throw new ConfigException(n, string);
    }

    @Override
    public ConfigAttribute duplicate() {
        assert (Debug.debugEnter(CLASS_NAME, "duplicate", new String[0]));
        return new ReadOnlyConfigAttribute(this.getName(), this.getDescription(), this.activeValues());
    }
}

