/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.changelog;

import java.io.IOException;
import java.net.SocketException;
import java.util.NoSuchElementException;
import org.opends.server.api.DirectoryThread;
import org.opends.server.changelog.ChangelogCache;
import org.opends.server.changelog.ProtocolSession;
import org.opends.server.changelog.ServerHandler;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.synchronization.UpdateMessage;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;

public class ServerWriter
extends DirectoryThread {
    private ProtocolSession session;
    private ServerHandler handler;
    private ChangelogCache changelogCache;

    public ServerWriter(ProtocolSession protocolSession, short s, ServerHandler serverHandler, ChangelogCache changelogCache) {
        super(serverHandler.toString() + " writer");
        this.session = protocolSession;
        this.handler = serverHandler;
        this.changelogCache = changelogCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            while (true) {
                UpdateMessage updateMessage;
                if ((updateMessage = this.changelogCache.take(this.handler)) == null) {
                    return;
                }
                this.session.publish(updateMessage);
                continue;
                break;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            int n = 0x1070010;
            String string = MessageHandler.getMessage(n, this.handler.toString());
            Error.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.NOTICE, string, n);
            return;
        }
        catch (SocketException socketException) {
            int n = 0x1070010;
            String string = MessageHandler.getMessage(n, this.handler.toString());
            Error.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.NOTICE, string, n);
            return;
        }
        catch (Exception exception) {
            int n = 17039392;
            String string = MessageHandler.getMessage(n, this.handler.toString());
            Error.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.SEVERE_ERROR, string, n);
            return;
        }
        finally {
            try {
                this.session.close();
            }
            catch (IOException iOException) {}
            this.changelogCache.stopServer(this.handler);
        }
    }
}

