/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.changelog;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.opends.server.changelog.Changelog;
import org.opends.server.changelog.ChangelogData;
import org.opends.server.changelog.ChangelogDbEnv;
import org.opends.server.changelog.ChangelogKey;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.synchronization.ChangeNumber;
import org.opends.server.synchronization.UpdateMessage;
import org.opends.server.types.DN;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangelogDB {
    private Database db = null;
    private ChangelogDbEnv dbenv = null;
    private Changelog changelog;
    private Short serverId;
    private DN baseDn;

    public ChangelogDB(Short s, DN dN, Changelog changelog, ChangelogDbEnv changelogDbEnv) throws DatabaseException {
        this.serverId = s;
        this.baseDn = dN;
        this.dbenv = changelogDbEnv;
        this.changelog = changelog;
        this.db = changelogDbEnv.getOrAddDb(s, dN);
    }

    public void addEntries(List<UpdateMessage> list) {
        block7: {
            Transaction transaction = null;
            try {
                transaction = this.dbenv.beginTransaction();
                for (UpdateMessage updateMessage : list) {
                    ChangelogKey changelogKey = new ChangelogKey(updateMessage.getChangeNumber());
                    ChangelogData changelogData = new ChangelogData(updateMessage);
                    try {
                        this.db.put(transaction, (DatabaseEntry)changelogKey, (DatabaseEntry)changelogData);
                    }
                    catch (DatabaseException databaseException) {
                        int n = 17104922;
                        String string = MessageHandler.getMessage(n) + StaticUtils.stackTraceToSingleLineString(databaseException);
                        Error.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.SEVERE_ERROR, string, n);
                        this.changelog.shutdown();
                    }
                }
                transaction.commitWriteNoSync();
                transaction = null;
            }
            catch (DatabaseException databaseException) {
                int n = 17104922;
                String string = MessageHandler.getMessage(n) + StaticUtils.stackTraceToSingleLineString(databaseException);
                Error.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.SEVERE_ERROR, string, n);
                this.changelog.shutdown();
                if (transaction == null) break block7;
                try {
                    transaction.abort();
                }
                catch (DatabaseException databaseException2) {
                    // empty catch block
                }
            }
        }
    }

    public void shutdown() {
        try {
            this.db.close();
        }
        catch (DatabaseException databaseException) {
            int n = 17235992;
            String string = MessageHandler.getMessage(n, this.toString()) + StaticUtils.stackTraceToSingleLineString(databaseException);
            Error.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.NOTICE, string, n);
        }
    }

    public ChangelogCursor openReadCursor(ChangeNumber changeNumber) throws DatabaseException, Exception {
        if (changeNumber == null) {
            changeNumber = this.readFirstChange();
        }
        if (changeNumber == null) {
            return null;
        }
        return new ChangelogCursor(changeNumber);
    }

    public ChangelogCursor openDeleteCursor() throws DatabaseException, Exception {
        return new ChangelogCursor();
    }

    public ChangeNumber readFirstChange() {
        Cursor cursor;
        String string = null;
        try {
            cursor = this.db.openCursor(null, null);
        }
        catch (DatabaseException databaseException) {
            return null;
        }
        try {
            DatabaseEntry databaseEntry = new DatabaseEntry();
            DatabaseEntry databaseEntry2 = new DatabaseEntry();
            OperationStatus operationStatus = cursor.getFirst(databaseEntry, databaseEntry2, LockMode.DEFAULT);
            cursor.close();
            if (operationStatus != OperationStatus.SUCCESS) {
                return null;
            }
            try {
                string = new String(databaseEntry.getData(), "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            return new ChangeNumber(string);
        }
        catch (DatabaseException databaseException) {
            try {
                cursor.close();
            }
            catch (DatabaseException databaseException2) {
                // empty catch block
            }
            int n = 17104922;
            String string2 = MessageHandler.getMessage(n) + StaticUtils.stackTraceToSingleLineString(databaseException);
            Error.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.SEVERE_ERROR, string2, n);
            this.changelog.shutdown();
            return null;
        }
    }

    public ChangeNumber readLastChange() {
        String string = null;
        try {
            Cursor cursor = this.db.openCursor(null, null);
            DatabaseEntry databaseEntry = new DatabaseEntry();
            DatabaseEntry databaseEntry2 = new DatabaseEntry();
            OperationStatus operationStatus = cursor.getLast(databaseEntry, databaseEntry2, LockMode.DEFAULT);
            cursor.close();
            if (operationStatus != OperationStatus.SUCCESS) {
                return null;
            }
            try {
                string = new String(databaseEntry.getData(), "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            return new ChangeNumber(string);
        }
        catch (DatabaseException databaseException) {
            int n = 17104922;
            String string2 = MessageHandler.getMessage(n) + StaticUtils.stackTraceToSingleLineString(databaseException);
            Error.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.SEVERE_ERROR, string2, n);
            this.changelog.shutdown();
            return null;
        }
    }

    public String toString() {
        return this.serverId.toString() + this.baseDn.toString();
    }

    public class ChangelogCursor {
        private Cursor cursor = null;
        private Transaction txn = null;
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry data = new DatabaseEntry();

        private ChangelogCursor(ChangeNumber changeNumber) throws Exception {
            this.cursor = ChangelogDB.this.db.openCursor(this.txn, null);
            ChangelogKey changelogKey = new ChangelogKey(changeNumber);
            DatabaseEntry databaseEntry = new DatabaseEntry();
            if (this.cursor.getSearchKey((DatabaseEntry)changelogKey, databaseEntry, LockMode.DEFAULT) != OperationStatus.SUCCESS) {
                throw new Exception("ChangeNumber not available");
            }
        }

        private ChangelogCursor() throws DatabaseException {
            this.txn = ChangelogDB.this.dbenv.beginTransaction();
            this.cursor = ChangelogDB.this.db.openCursor(this.txn, null);
        }

        public void close() {
            String string;
            int n;
            if (this.cursor == null) {
                return;
            }
            try {
                this.cursor.close();
                this.cursor = null;
            }
            catch (DatabaseException databaseException) {
                n = 17104922;
                string = MessageHandler.getMessage(n) + StaticUtils.stackTraceToSingleLineString(databaseException);
                Error.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.SEVERE_ERROR, string, n);
                ChangelogDB.this.changelog.shutdown();
            }
            if (this.txn != null) {
                try {
                    this.txn.commit();
                }
                catch (DatabaseException databaseException) {
                    n = 17104922;
                    string = MessageHandler.getMessage(n) + StaticUtils.stackTraceToSingleLineString(databaseException);
                    Error.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.SEVERE_ERROR, string, n);
                    ChangelogDB.this.changelog.shutdown();
                }
            }
        }

        public ChangeNumber nextChangeNumber() throws DatabaseException {
            OperationStatus operationStatus = this.cursor.getNext(this.key, this.data, LockMode.DEFAULT);
            if (operationStatus != OperationStatus.SUCCESS) {
                return null;
            }
            try {
                String string = new String(this.key.getData(), "UTF-8");
                return new ChangeNumber(string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return null;
            }
        }

        public UpdateMessage next() {
            UpdateMessage updateMessage = null;
            while (updateMessage == null) {
                try {
                    OperationStatus operationStatus = this.cursor.getNext(this.key, this.data, LockMode.DEFAULT);
                    if (operationStatus != OperationStatus.SUCCESS) {
                        return null;
                    }
                }
                catch (DatabaseException databaseException) {
                    return null;
                }
                try {
                    updateMessage = ChangelogData.generateChange(this.data.getData());
                }
                catch (Exception exception) {}
            }
            return updateMessage;
        }

        public void delete() throws DatabaseException {
            this.cursor.delete();
        }
    }
}

