/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.opends.server.backends.jeb.EntryContainer;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.backends.jeb.EntryIDSet;
import org.opends.server.backends.jeb.Indexer;
import org.opends.server.backends.jeb.JebException;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.ConditionResult;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.Modification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Index {
    private static final String CLASS_NAME = "org.opends.server.backends.jeb.Index";
    private EntryContainer entryContainer;
    private DatabaseConfig dbConfig;
    private String name;
    private ThreadLocal<Database> threadLocalDatabase = new ThreadLocal();
    public Indexer indexer;
    private Comparator<byte[]> comparator;
    private int indexEntryLimit;
    private int cursorEntryLimit;
    private int entryLimitExceededCount;

    public Index(EntryContainer entryContainer, String string, Indexer indexer, int n, int n2) {
        this.entryContainer = entryContainer;
        this.name = string;
        this.indexer = indexer;
        this.comparator = indexer.getComparator();
        this.indexEntryLimit = n;
        this.cursorEntryLimit = n2;
    }

    public void open(DatabaseConfig databaseConfig) throws DatabaseException {
        this.dbConfig = databaseConfig;
        this.dbConfig.setBtreeComparator(this.comparator.getClass());
        this.getDatabase();
    }

    public Database getDatabase() throws DatabaseException {
        Database database = this.threadLocalDatabase.get();
        if (database == null) {
            database = this.entryContainer.openDatabase(this.dbConfig, this.name);
            this.threadLocalDatabase.set(database);
        }
        return database;
    }

    public void insertID(Transaction transaction, DatabaseEntry databaseEntry, EntryID entryID) throws DatabaseException {
        LockMode lockMode = LockMode.RMW;
        DatabaseEntry databaseEntry2 = entryID.getDatabaseEntry();
        DatabaseEntry databaseEntry3 = new DatabaseEntry();
        OperationStatus operationStatus = EntryContainer.read(this.getDatabase(), transaction, databaseEntry, databaseEntry3, lockMode);
        if (operationStatus == OperationStatus.SUCCESS) {
            EntryIDSet entryIDSet = new EntryIDSet(databaseEntry.getData(), databaseEntry3.getData());
            if (entryIDSet.isDefined()) {
                if (this.indexEntryLimit > 0 && entryIDSet.size() >= this.indexEntryLimit) {
                    entryIDSet = new EntryIDSet();
                    ++this.entryLimitExceededCount;
                } else {
                    entryIDSet.add(entryID);
                }
                byte[] byArray = entryIDSet.toDatabase();
                databaseEntry3.setData(byArray);
                EntryContainer.put(this.getDatabase(), transaction, databaseEntry, databaseEntry3);
            }
        } else {
            EntryContainer.put(this.getDatabase(), transaction, databaseEntry, databaseEntry2);
        }
    }

    public void removeID(Transaction transaction, DatabaseEntry databaseEntry, EntryID entryID) throws DatabaseException {
        EntryIDSet entryIDSet;
        LockMode lockMode = LockMode.RMW;
        DatabaseEntry databaseEntry2 = new DatabaseEntry();
        OperationStatus operationStatus = EntryContainer.read(this.getDatabase(), transaction, databaseEntry, databaseEntry2, lockMode);
        if (operationStatus == OperationStatus.SUCCESS && (entryIDSet = new EntryIDSet(databaseEntry.getData(), databaseEntry2.getData())).isDefined() && entryIDSet.remove(entryID)) {
            byte[] byArray = entryIDSet.toDatabase();
            if (byArray == null) {
                EntryContainer.delete(this.getDatabase(), transaction, databaseEntry);
            } else {
                databaseEntry2.setData(byArray);
                EntryContainer.put(this.getDatabase(), transaction, databaseEntry, databaseEntry2);
            }
        }
    }

    public ConditionResult containsID(Transaction transaction, DatabaseEntry databaseEntry, EntryID entryID) throws DatabaseException {
        LockMode lockMode = LockMode.DEFAULT;
        DatabaseEntry databaseEntry2 = new DatabaseEntry();
        OperationStatus operationStatus = EntryContainer.read(this.getDatabase(), transaction, databaseEntry, databaseEntry2, lockMode);
        if (operationStatus == OperationStatus.SUCCESS) {
            EntryIDSet entryIDSet = new EntryIDSet(databaseEntry.getData(), databaseEntry2.getData());
            if (!entryIDSet.isDefined()) {
                return ConditionResult.UNDEFINED;
            }
            if (entryIDSet.contains(entryID)) {
                return ConditionResult.TRUE;
            }
            return ConditionResult.FALSE;
        }
        return ConditionResult.FALSE;
    }

    public EntryIDSet readKey(DatabaseEntry databaseEntry, Transaction transaction, LockMode lockMode) {
        try {
            DatabaseEntry databaseEntry2 = new DatabaseEntry();
            OperationStatus operationStatus = EntryContainer.read(this.getDatabase(), transaction, databaseEntry, databaseEntry2, lockMode);
            if (operationStatus != OperationStatus.SUCCESS) {
                return new EntryIDSet(databaseEntry.getData(), null);
            }
            return new EntryIDSet(databaseEntry.getData(), databaseEntry2.getData());
        }
        catch (DatabaseException databaseException) {
            assert (Debug.debugException(CLASS_NAME, "readKey", databaseException));
            return new EntryIDSet();
        }
    }

    public void writeKey(Transaction transaction, DatabaseEntry databaseEntry, EntryIDSet entryIDSet) throws DatabaseException {
        DatabaseEntry databaseEntry2 = new DatabaseEntry();
        byte[] byArray = entryIDSet.toDatabase();
        if (byArray == null) {
            EntryContainer.delete(this.getDatabase(), transaction, databaseEntry);
        } else {
            if (!entryIDSet.isDefined()) {
                ++this.entryLimitExceededCount;
            }
            databaseEntry2.setData(byArray);
            EntryContainer.put(this.getDatabase(), transaction, databaseEntry, databaseEntry2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EntryIDSet readRange(byte[] byArray, byte[] byArray2, boolean bl, boolean bl2) {
        LockMode lockMode = LockMode.DEFAULT;
        try {
            int n = 0;
            DatabaseEntry databaseEntry = new DatabaseEntry();
            ArrayList<EntryIDSet> arrayList = new ArrayList<EntryIDSet>();
            Cursor cursor = this.getDatabase().openCursor(null, CursorConfig.READ_COMMITTED);
            try {
                int n2;
                OperationStatus operationStatus;
                DatabaseEntry databaseEntry2;
                if (byArray.length > 0) {
                    databaseEntry2 = new DatabaseEntry(byArray);
                    operationStatus = cursor.getSearchKeyRange(databaseEntry2, databaseEntry, lockMode);
                    if (operationStatus == OperationStatus.SUCCESS && !bl && this.comparator.compare(databaseEntry2.getData(), byArray) == 0) {
                        operationStatus = cursor.getNext(databaseEntry2, databaseEntry, lockMode);
                    }
                } else {
                    databaseEntry2 = new DatabaseEntry();
                    operationStatus = cursor.getNext(databaseEntry2, databaseEntry, lockMode);
                }
                if (operationStatus != OperationStatus.SUCCESS) {
                    EntryIDSet entryIDSet = new EntryIDSet(databaseEntry2.getData(), null);
                    return entryIDSet;
                }
                while (operationStatus == OperationStatus.SUCCESS && (byArray2.length <= 0 || (n2 = this.comparator.compare(databaseEntry2.getData(), byArray2)) <= 0 && (n2 != 0 || bl2))) {
                    EntryIDSet entryIDSet = new EntryIDSet(databaseEntry2.getData(), databaseEntry.getData());
                    if (!entryIDSet.isDefined()) {
                        EntryIDSet entryIDSet2 = entryIDSet;
                        return entryIDSet2;
                    }
                    if (this.cursorEntryLimit > 0 && (n += entryIDSet.size()) > this.cursorEntryLimit) {
                        EntryIDSet entryIDSet3 = new EntryIDSet();
                        return entryIDSet3;
                    }
                    arrayList.add(entryIDSet);
                    operationStatus = cursor.getNext(databaseEntry2, databaseEntry, LockMode.DEFAULT);
                }
                EntryIDSet entryIDSet = EntryIDSet.unionOfSets(arrayList, false);
                return entryIDSet;
            }
            finally {
                cursor.close();
            }
        }
        catch (DatabaseException databaseException) {
            if ($assertionsDisabled) return new EntryIDSet();
            if (Debug.debugException(CLASS_NAME, "readRange", databaseException)) return new EntryIDSet();
            throw new AssertionError();
        }
    }

    public int getEntryLimitExceededCount() {
        return this.entryLimitExceededCount;
    }

    public String toString() {
        return this.name;
    }

    public Cursor openCursor(Transaction transaction, CursorConfig cursorConfig) throws JebException {
        try {
            return this.getDatabase().openCursor(transaction, cursorConfig);
        }
        catch (DatabaseException databaseException) {
            assert (Debug.debugException(CLASS_NAME, "openCursor", databaseException));
            int n = 8650766;
            String string = MessageHandler.getMessage(n, databaseException.getMessage());
            throw new JebException(n, string, databaseException);
        }
    }

    public void addEntry(Transaction transaction, EntryID entryID, Entry entry) throws DatabaseException, DirectoryException {
        HashSet<ASN1OctetString> hashSet = new HashSet<ASN1OctetString>();
        this.indexer.indexEntry(transaction, entry, hashSet);
        DatabaseEntry databaseEntry = new DatabaseEntry();
        for (ASN1OctetString aSN1OctetString : hashSet) {
            databaseEntry.setData(aSN1OctetString.value());
            this.insertID(transaction, databaseEntry, entryID);
        }
    }

    public void removeEntry(Transaction transaction, EntryID entryID, Entry entry) throws DatabaseException, DirectoryException {
        HashSet<ASN1OctetString> hashSet = new HashSet<ASN1OctetString>();
        this.indexer.indexEntry(transaction, entry, hashSet);
        DatabaseEntry databaseEntry = new DatabaseEntry();
        for (ASN1OctetString aSN1OctetString : hashSet) {
            databaseEntry.setData(aSN1OctetString.value());
            this.removeID(transaction, databaseEntry, entryID);
        }
    }

    public void modifyEntry(Transaction transaction, EntryID entryID, Entry entry, Entry entry2, List<Modification> list) throws DatabaseException {
        HashSet<ASN1OctetString> hashSet = new HashSet<ASN1OctetString>();
        HashSet<ASN1OctetString> hashSet2 = new HashSet<ASN1OctetString>();
        this.indexer.modifyEntry(transaction, entry, entry2, list, hashSet, hashSet2);
        DatabaseEntry databaseEntry = new DatabaseEntry();
        for (ASN1OctetString aSN1OctetString : hashSet) {
            databaseEntry.setData(aSN1OctetString.value());
            this.insertID(transaction, databaseEntry, entryID);
        }
        for (ASN1OctetString aSN1OctetString : hashSet2) {
            databaseEntry.setData(aSN1OctetString.value());
            this.removeID(transaction, databaseEntry, entryID);
        }
    }
}

