/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.Transaction;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.LinkedBlockingQueue;
import org.opends.server.api.Backend;
import org.opends.server.backends.jeb.AttributeIndex;
import org.opends.server.backends.jeb.Config;
import org.opends.server.backends.jeb.DN2ID;
import org.opends.server.backends.jeb.EntryContainer;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.backends.jeb.EnvManager;
import org.opends.server.backends.jeb.ID2Entry;
import org.opends.server.backends.jeb.ImportContext;
import org.opends.server.backends.jeb.ImportThread;
import org.opends.server.backends.jeb.Index;
import org.opends.server.backends.jeb.IndexConfig;
import org.opends.server.backends.jeb.IndexMergeThread;
import org.opends.server.backends.jeb.JebException;
import org.opends.server.backends.jeb.RootContainer;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.AttributeType;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogCategory;
import org.opends.server.types.DebugLogSeverity;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.ResultCode;
import org.opends.server.util.LDIFException;
import org.opends.server.util.LDIFReader;

public class ImportJob
implements Thread.UncaughtExceptionHandler {
    private static final String CLASS_NAME = "org.opends.server.backends.jeb.ImportJob";
    private Backend backend;
    private Config config;
    private RootContainer rootContainer;
    private LDIFImportConfig ldifImportConfig;
    private LDIFReader reader;
    private HashMap<DN, ImportContext> importMap = new HashMap();
    private ArrayList<ImportThread> threads;
    private int rejectedCount = 0;
    private long progressInterval = 10000L;

    public ImportJob(Backend backend, Config config, LDIFImportConfig lDIFImportConfig) {
        this.backend = backend;
        this.config = config;
        this.ldifImportConfig = lDIFImportConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void importLDIF() throws DatabaseException, IOException, JebException {
        Object object;
        this.rootContainer = new RootContainer(this.config, this.backend);
        if (this.ldifImportConfig.appendToExistingData()) {
            this.rootContainer.open(this.config.getBackendDirectory(), this.config.getBackendPermission(), false, true, true, true, true, false);
        } else {
            this.rootContainer.open(this.config.getBackendDirectory(), this.config.getBackendPermission(), false, true, false, false, false, false);
        }
        if (!this.ldifImportConfig.appendToExistingData()) {
            this.rootContainer.close();
            EnvManager.removeFiles(this.config.getBackendDirectory().getPath());
            this.rootContainer.open(this.config.getBackendDirectory(), this.config.getBackendPermission(), false, true, false, false, false, false);
        }
        int n = this.config.getImportThreadCount();
        long l = this.config.getImportBufferSize() / (long)(n * this.config.getBaseDNs().length);
        int n2 = 8388697;
        String string = MessageHandler.getMessage(n2, n);
        Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, string, n2);
        n2 = 8388698;
        string = MessageHandler.getMessage(n2, l);
        Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, string, n2);
        n2 = 0x800077;
        string = MessageHandler.getMessage(n2, this.rootContainer.getEnvironmentConfig().toString());
        Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, string, n2);
        Debug.debugMessage(DebugLogCategory.BACKEND, DebugLogSeverity.INFO, CLASS_NAME, "importLDIF", this.rootContainer.getEnvironmentConfig().toString());
        this.rootContainer.openEntryContainers(this.config.getBaseDNs());
        for (EntryContainer entryContainer : this.rootContainer.getEntryContainers()) {
            DN dN = entryContainer.getBaseDN();
            object = new ImportContext();
            ((ImportContext)object).setBufferSize(l);
            ((ImportContext)object).setConfig(this.config);
            ((ImportContext)object).setLDIFImportConfig(this.ldifImportConfig);
            ((ImportContext)object).setBaseDN(dN);
            ((ImportContext)object).setContainerName(entryContainer.getContainerName());
            ((ImportContext)object).setEntryContainer(entryContainer);
            ((ImportContext)object).setBufferSize(l);
            LinkedBlockingQueue<Entry> object2 = new LinkedBlockingQueue<Entry>(this.config.getImportQueueSize());
            ((ImportContext)object).setQueue(object2);
            this.importMap.put(dN, (ImportContext)object);
        }
        long l2 = System.currentTimeMillis();
        try {
            object = new File(this.config.getImportTempDirectory());
            ((File)object).mkdir();
            if (((File)object).listFiles() != null) {
                for (File file : ((File)object).listFiles()) {
                    file.delete();
                }
            }
            try {
                boolean bl = true;
                int n3 = 1;
                while (n3 != 0) {
                    n3 = this.processLDIF() ? 1 : 0;
                    if (n3 != 0) {
                        void var10_15;
                        n2 = 8388729;
                        string = MessageHandler.getMessage(n2, (int)(++var10_15));
                        Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, string, n2);
                    } else {
                        n2 = 8388730;
                        string = MessageHandler.getMessage(n2);
                        Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, string, n2);
                    }
                    long l3 = System.currentTimeMillis();
                    this.merge();
                    long l4 = System.currentTimeMillis();
                    if (n3 != 0) {
                        n2 = 8388731;
                        string = MessageHandler.getMessage(n2, (l4 - l3) / 1000L);
                        Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, string, n2);
                        continue;
                    }
                    n2 = 8388732;
                    string = MessageHandler.getMessage(n2, (l4 - l3) / 1000L);
                    Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, string, n2);
                }
            }
            finally {
                ((File)object).delete();
            }
        }
        finally {
            this.rootContainer.close();
            n2 = 8388701;
            string = MessageHandler.getMessage(n2);
            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, string, n2);
        }
        long l5 = System.currentTimeMillis();
        long l6 = l5 - l2;
        float f = 0.0f;
        if (l6 > 0L) {
            f = 1000.0f * (float)this.getImportedCount() / (float)l6;
        }
        n2 = 8388702;
        string = MessageHandler.getMessage(n2, this.reader.getEntriesRead(), this.getImportedCount(), this.reader.getEntriesIgnored(), this.reader.getEntriesRejected(), l6 / 1000L, Float.valueOf(f));
        Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, string, n2);
        n2 = 8388703;
        string = MessageHandler.getMessage(n2, this.getEntryLimitExceededCount());
        Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, string, n2);
    }

    public void merge() {
        Map<AttributeType, IndexConfig> map = this.config.getIndexConfigMap();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (ImportContext object : this.importMap.values()) {
            Index index;
            Object object2;
            String string = object.getContainerName();
            EntryContainer entryContainer = object.getEntryContainer();
            for (IndexConfig indexConfig : map.values()) {
                IndexMergeThread indexMergeThread;
                String string2;
                object2 = entryContainer.getAttributeIndex(indexConfig.getAttributeType());
                if (indexConfig.isEqualityIndex()) {
                    index = ((AttributeIndex)object2).equalityIndex;
                    string2 = string + "_" + index.toString();
                    indexMergeThread = new IndexMergeThread(string2, this.config, this.ldifImportConfig, index, indexConfig.getEqualityEntryLimit());
                    arrayList.add(indexMergeThread);
                }
                if (indexConfig.isPresenceIndex()) {
                    index = ((AttributeIndex)object2).presenceIndex;
                    string2 = string + "_" + index.toString();
                    indexMergeThread = new IndexMergeThread(string2, this.config, this.ldifImportConfig, index, indexConfig.getPresenceEntryLimit());
                    arrayList.add(indexMergeThread);
                }
                if (indexConfig.isSubstringIndex()) {
                    index = ((AttributeIndex)object2).substringIndex;
                    string2 = string + "_" + index.toString();
                    indexMergeThread = new IndexMergeThread(string2, this.config, this.ldifImportConfig, index, indexConfig.getSubstringEntryLimit());
                    arrayList.add(indexMergeThread);
                }
                if (!indexConfig.isOrderingIndex()) continue;
                index = ((AttributeIndex)object2).orderingIndex;
                string2 = string + "_" + index.toString();
                indexMergeThread = new IndexMergeThread(string2, this.config, this.ldifImportConfig, index, indexConfig.getEqualityEntryLimit());
                arrayList.add(indexMergeThread);
            }
            Index index2 = entryContainer.getID2Children();
            String string3 = string + "_" + index2.toString();
            object2 = new IndexMergeThread(string3, this.config, this.ldifImportConfig, index2, this.config.getBackendIndexEntryLimit());
            arrayList.add(object2);
            index = entryContainer.getID2Subtree();
            String string4 = string + "_" + index.toString();
            object2 = new IndexMergeThread(string4, this.config, this.ldifImportConfig, index, this.config.getBackendIndexEntryLimit());
            arrayList.add(object2);
        }
        for (IndexMergeThread indexMergeThread : arrayList) {
            indexMergeThread.start();
        }
        for (IndexMergeThread indexMergeThread : arrayList) {
            try {
                indexMergeThread.join();
            }
            catch (InterruptedException interruptedException) {
                assert (Debug.debugException(CLASS_NAME, "merge", interruptedException));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private boolean processLDIF() throws JebException, DatabaseException, IOException {
        boolean bl = false;
        if (this.reader == null) {
            this.reader = new LDIFReader(this.ldifImportConfig);
            for (ImportContext object : this.importMap.values()) {
                object.setLDIFReader(this.reader);
            }
        }
        try {
            Runnable runnable;
            int n = this.config.getImportThreadCount();
            this.threads = new ArrayList(n * this.importMap.size());
            for (ImportContext importContext : this.importMap.values()) {
                for (int i = 0; i < n; ++i) {
                    runnable = new ImportThread(importContext, i);
                    ((Thread)runnable).setUncaughtExceptionHandler(this);
                    this.threads.add((ImportThread)runnable);
                    ((Thread)runnable).start();
                }
            }
            try {
                boolean object = false;
                int n2 = this.config.getImportPassSize();
                if (n2 <= 0) {
                    n2 = Integer.MAX_VALUE;
                }
                Timer timer = new Timer();
                runnable = new ProgressTask();
                timer.scheduleAtFixedRate((TimerTask)runnable, this.progressInterval, this.progressInterval);
                try {
                    block17: while (true) {
                        try {
                            Object object2;
                            while ((object2 = this.reader.readEntry()) != null) {
                                void var3_8;
                                ImportContext importContext = this.getImportConfig(((Entry)object2).getDN());
                                this.processEntry(importContext, (Entry)object2);
                                if (++var3_8 < n2) continue;
                                bl = true;
                                break block17;
                            }
                        }
                        catch (LDIFException lDIFException) {
                            assert (Debug.debugException(CLASS_NAME, "processLDIF", lDIFException));
                            ++this.rejectedCount;
                            continue;
                        }
                        catch (DirectoryException directoryException) {
                            assert (Debug.debugException(CLASS_NAME, "processLDIF", directoryException));
                            ++this.rejectedCount;
                            continue;
                        }
                        break;
                    }
                    for (ImportContext importContext : this.importMap.values()) {
                        while (importContext.getQueue().size() > 0) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                finally {
                    timer.cancel();
                }
            }
            finally {
                for (ImportThread importThread : this.threads) {
                    importThread.stopProcessing();
                }
                this.joinThreads();
            }
        }
        finally {
            if (!bl) {
                this.reader.close();
            }
        }
        for (ImportContext importContext : this.importMap.values()) {
            ID2Entry iD2Entry = importContext.getEntryContainer().getID2Entry();
            iD2Entry.adjustRecordCount(null, importContext.getEntryInsertCount());
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processEntry(ImportContext importContext, Entry entry) throws JebException, DatabaseException {
        DN dN = entry.getDN();
        LDIFImportConfig lDIFImportConfig = importContext.getLDIFImportConfig();
        Transaction transaction = null;
        if (lDIFImportConfig.appendToExistingData()) {
            transaction = importContext.getEntryContainer().beginTransaction();
        }
        DN2ID dN2ID = importContext.getEntryContainer().getDN2ID();
        ID2Entry iD2Entry = importContext.getEntryContainer().getID2Entry();
        try {
            block20: {
                ArrayList<Object> arrayList;
                EntryID entryID = dN2ID.get(transaction, dN);
                if (entryID != null) {
                    if (lDIFImportConfig.appendToExistingData() && lDIFImportConfig.replaceExistingEntries()) {
                        Entry entry2 = iD2Entry.get(transaction, entryID);
                        entry2.setAttachment(entryID);
                        entry.setAttachment(entry2);
                        try {
                            importContext.getQueue().put(entry);
                        }
                        catch (InterruptedException interruptedException) {
                            assert (Debug.debugException(CLASS_NAME, "processEntry", interruptedException));
                        }
                        break block20;
                    } else {
                        int n = 8519724;
                        String string = MessageHandler.getMessage(n);
                        importContext.getLDIFReader().rejectLastEntry(string);
                        ++this.rejectedCount;
                        return;
                    }
                }
                EntryID entryID2 = null;
                DN dN2 = importContext.getEntryContainer().getParentWithinBase(dN);
                if (dN2 != null && (entryID2 = dN2ID.get(transaction, dN2)) == null) {
                    int n = 8585259;
                    String string = MessageHandler.getMessage(n, dN2.toString());
                    importContext.getLDIFReader().rejectLastEntry(string);
                    ++this.rejectedCount;
                    return;
                }
                entryID = this.rootContainer.getNextEntryID();
                dN2ID.insert(transaction, dN, entryID);
                if (dN2 != null && importContext.getParentDN() != null && dN2.equals(importContext.getParentDN())) {
                    arrayList = new ArrayList<EntryID>(importContext.getIDs());
                    arrayList.set(0, entryID);
                } else {
                    arrayList = new ArrayList<EntryID>(dN.getNumComponents());
                    arrayList.add(entryID);
                    if (entryID2 != null) {
                        arrayList.add(entryID2);
                        EntryContainer entryContainer = importContext.getEntryContainer();
                        DN dN3 = entryContainer.getParentWithinBase(dN2);
                        while (dN3 != null) {
                            EntryID entryID3 = dN2ID.get(transaction, dN3);
                            arrayList.add(entryID3);
                            dN3 = entryContainer.getParentWithinBase(dN3);
                        }
                    }
                }
                importContext.setParentDN(dN2);
                importContext.setIDs(arrayList);
                entry.setAttachment(arrayList);
                try {
                    importContext.getQueue().put(entry);
                }
                catch (InterruptedException interruptedException) {
                    if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "processEntry", interruptedException)) break block20;
                    throw new AssertionError();
                }
            }
            if (transaction == null) return;
            importContext.getEntryContainer();
            EntryContainer.transactionCommit(transaction);
            transaction = null;
            return;
        }
        finally {
            if (transaction != null) {
                importContext.getEntryContainer();
                EntryContainer.transactionAbort(transaction);
            }
        }
    }

    private int getEntryLimitExceededCount() {
        int n = 0;
        for (ImportContext importContext : this.importMap.values()) {
            n += importContext.getEntryContainer().getEntryLimitExceededCount();
        }
        return n;
    }

    private void joinThreads() {
        for (ImportThread importThread : this.threads) {
            try {
                importThread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private int getImportedCount() {
        int n = 0;
        for (ImportThread importThread : this.threads) {
            n += importThread.getImportedCount();
        }
        return n;
    }

    private int getRejectedCount() {
        return this.rejectedCount;
    }

    public void uncaughtException(Thread thread, Throwable throwable) {
        throwable.printStackTrace();
    }

    private ImportContext getImportConfig(DN dN) throws DirectoryException {
        ImportContext importContext = null;
        DN dN2 = dN;
        while (importContext == null && dN2 != null) {
            importContext = this.importMap.get(dN2);
            if (importContext != null) continue;
            dN2 = dN2.getParentDNInSuffix();
        }
        if (dN2 == null) {
            String string = MessageHandler.getMessage(8585217, String.valueOf(dN));
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, string, 8585217);
        }
        return importContext;
    }

    class ProgressTask
    extends TimerTask {
        private int previousCount = 0;
        private long previousTime = System.currentTimeMillis();
        private EnvironmentStats prevEnvStats;
        private static final int bytesPerMegabyte = 0x100000;

        public ProgressTask() throws DatabaseException {
            this.prevEnvStats = ImportJob.this.rootContainer.getEnvironmentStats(new StatsConfig());
        }

        public void run() {
            int n = ImportJob.this.getImportedCount();
            int n2 = n - this.previousCount;
            long l = System.currentTimeMillis();
            long l2 = l - this.previousTime;
            if (l2 == 0L) {
                return;
            }
            long l3 = ImportJob.this.reader.getEntriesRead();
            long l4 = ImportJob.this.reader.getEntriesIgnored();
            long l5 = ImportJob.this.reader.getEntriesRejected();
            float f = 1000.0f * (float)n2 / (float)l2;
            int n3 = 0x800060;
            String string = MessageHandler.getMessage(n3, l3, l4, l5, Float.valueOf(f));
            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, string, n3);
            try {
                Runtime runtime = Runtime.getRuntime();
                long l6 = runtime.freeMemory() / 0x100000L;
                EnvironmentStats environmentStats = ImportJob.this.rootContainer.getEnvironmentStats(new StatsConfig());
                long l7 = environmentStats.getNCacheMiss() - this.prevEnvStats.getNCacheMiss();
                float f2 = 0.0f;
                if (n2 > 0) {
                    f2 = (float)l7 / (float)n2;
                }
                n3 = 8388705;
                string = MessageHandler.getMessage(n3, l6, Float.valueOf(f2));
                Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, string, n3);
                this.prevEnvStats = environmentStats;
            }
            catch (DatabaseException databaseException) {
                // empty catch block
            }
            this.previousCount = n;
            this.previousTime = l;
        }
    }
}

