/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.opends.server.backends.jeb.Config;
import org.opends.server.backends.jeb.EntryContainer;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.util.LDIFReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportContext {
    private String containerName;
    private DN baseDN;
    private Config config;
    private LDIFImportConfig ldifImportConfig;
    private LDIFReader ldifReader;
    private EntryContainer entryContainer;
    private long bufferSize;
    private BlockingQueue<Entry> queue;
    private AtomicLong entryInsertCount = new AtomicLong(0L);
    private DN parentDN;
    private ArrayList<EntryID> IDs;

    public BlockingQueue<Entry> getQueue() {
        return this.queue;
    }

    public void setQueue(BlockingQueue<Entry> blockingQueue) {
        this.queue = blockingQueue;
    }

    public void setContainerName(String string) {
        this.containerName = string;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public void setBaseDN(DN dN) {
        this.baseDN = dN;
    }

    public DN getBaseDN() {
        return this.baseDN;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public Config getConfig() {
        return this.config;
    }

    public void setLDIFImportConfig(LDIFImportConfig lDIFImportConfig) {
        this.ldifImportConfig = lDIFImportConfig;
    }

    public LDIFImportConfig getLDIFImportConfig() {
        return this.ldifImportConfig;
    }

    public void setLDIFReader(LDIFReader lDIFReader) {
        this.ldifReader = lDIFReader;
    }

    public LDIFReader getLDIFReader() {
        return this.ldifReader;
    }

    public void setEntryContainer(EntryContainer entryContainer) {
        this.entryContainer = entryContainer;
    }

    public EntryContainer getEntryContainer() {
        return this.entryContainer;
    }

    public long getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(long l) {
        this.bufferSize = l;
    }

    public long getEntryInsertCount() {
        return this.entryInsertCount.get();
    }

    public void incrEntryInsertCount(long l) {
        this.entryInsertCount.getAndAdd(l);
    }

    public DN getParentDN() {
        return this.parentDN;
    }

    public void setParentDN(DN dN) {
        this.parentDN = dN;
    }

    public ArrayList<EntryID> getIDs() {
        return this.IDs;
    }

    public void setIDs(ArrayList<EntryID> arrayList) {
        this.IDs = arrayList;
    }
}

