/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.DatabaseEntry;
import org.opends.server.backends.jeb.JebFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntryID
implements Comparable<EntryID> {
    private final Long id;
    private DatabaseEntry data = null;

    public EntryID(long l) {
        this.id = l;
    }

    public EntryID(Long l) {
        this.id = l;
    }

    public EntryID(DatabaseEntry databaseEntry) {
        this.data = databaseEntry;
        this.id = JebFormat.entryIDFromDatabase(this.data.getData());
    }

    public long longValue() {
        return this.id;
    }

    public DatabaseEntry getDatabaseEntry() {
        if (this.data == null) {
            this.data = new DatabaseEntry();
            this.data.setData(JebFormat.entryIDToDatabase(this.id));
        }
        return this.data;
    }

    @Override
    public int compareTo(EntryID entryID) throws ClassCastException {
        return this.id.compareTo(entryID.id);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof EntryID)) {
            return false;
        }
        return this.id.equals(((EntryID)object).id);
    }

    public int hashCode() {
        return (int)this.id.longValue();
    }

    public String toString() {
        return this.id.toString();
    }
}

