/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DatabaseNotFoundException;
import com.sleepycat.je.DeadlockException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.locks.Lock;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.Backend;
import org.opends.server.api.EntryCache;
import org.opends.server.backends.jeb.AttributeIndex;
import org.opends.server.backends.jeb.BufferedIndex;
import org.opends.server.backends.jeb.Config;
import org.opends.server.backends.jeb.DN2ID;
import org.opends.server.backends.jeb.DN2URI;
import org.opends.server.backends.jeb.DataConfig;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.backends.jeb.EntryIDSet;
import org.opends.server.backends.jeb.ID2CIndexer;
import org.opends.server.backends.jeb.ID2Entry;
import org.opends.server.backends.jeb.ID2SIndexer;
import org.opends.server.backends.jeb.Index;
import org.opends.server.backends.jeb.IndexConfig;
import org.opends.server.backends.jeb.IndexFilter;
import org.opends.server.backends.jeb.JebException;
import org.opends.server.backends.jeb.RootContainer;
import org.opends.server.controls.PagedResultsControl;
import org.opends.server.core.AddOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.Operation;
import org.opends.server.core.SearchOperation;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.ldap.LDAPException;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.CancelledOperationException;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogCategory;
import org.opends.server.types.DebugLogSeverity;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.LockType;
import org.opends.server.types.Modification;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchScope;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntryContainer {
    private static final String CLASS_NAME = "org.opends.server.backends.jeb.EntryContainer";
    public static final String ID2ENTRY_DATABASE_NAME = "id2entry";
    public static final String DN2ID_DATABASE_NAME = "dn2id";
    public static final String ID2CHILDREN_DATABASE_NAME = "id2children";
    public static final String ID2SUBTREE_DATABASE_NAME = "id2subtree";
    public static final String REFERRAL_DATABASE_NAME = "referral";
    public static final String ATTR_DEBUG_SEARCH_INDEX = "debugsearchindex";
    private Backend backend;
    private RootContainer rootContainer;
    private DN baseDN;
    private Config config;
    private ArrayList<Database> databases;
    private Environment env;
    private DN2ID dn2id;
    private Comparator<byte[]> dn2idComparator;
    private ID2Entry id2entry;
    private DataConfig entryDataConfig;
    private Index id2children;
    private Index id2subtree;
    private DN2URI dn2uri;
    private HashMap<AttributeType, AttributeIndex> attrIndexMap;

    public EntryContainer(DN dN, Backend backend, Config config, Environment environment, RootContainer rootContainer) {
        this.backend = backend;
        this.baseDN = dN;
        this.config = config;
        this.env = environment;
        this.rootContainer = rootContainer;
        this.databases = new ArrayList();
        this.id2children = new Index(this, ID2CHILDREN_DATABASE_NAME, new ID2CIndexer(), config.getBackendIndexEntryLimit(), 0);
        this.id2subtree = new Index(this, ID2SUBTREE_DATABASE_NAME, new ID2SIndexer(), config.getBackendIndexEntryLimit(), 0);
        this.attrIndexMap = new HashMap();
        if (config != null && config.getIndexConfigMap() != null) {
            for (IndexConfig indexConfig : config.getIndexConfigMap().values()) {
                AttributeIndex attributeIndex = new AttributeIndex(this, indexConfig);
                this.attrIndexMap.put(indexConfig.getAttributeType(), attributeIndex);
            }
        }
        this.entryDataConfig = new DataConfig();
        this.entryDataConfig.setCompressed(config.isEntriesCompressed());
    }

    public void open() throws DatabaseException {
        DatabaseConfig databaseConfig = new DatabaseConfig();
        databaseConfig.setAllowCreate(true);
        databaseConfig.setTransactional(true);
        try {
            this.id2entry = new ID2Entry(this, databaseConfig, this.entryDataConfig, ID2ENTRY_DATABASE_NAME);
            this.id2entry.open();
            this.dn2idComparator = new KeyReverseComparator();
            DatabaseConfig databaseConfig2 = new DatabaseConfig();
            databaseConfig2.setAllowCreate(true);
            databaseConfig2.setTransactional(true);
            databaseConfig2.setBtreeComparator(this.dn2idComparator.getClass());
            this.dn2id = new DN2ID(this, databaseConfig2, DN2ID_DATABASE_NAME);
            this.dn2id.open();
            this.id2children.open(databaseConfig);
            this.id2subtree.open(databaseConfig);
            DatabaseConfig databaseConfig3 = new DatabaseConfig();
            databaseConfig3.setSortedDuplicates(true);
            databaseConfig3.setAllowCreate(true);
            databaseConfig3.setTransactional(true);
            databaseConfig3.setBtreeComparator(this.dn2idComparator.getClass());
            this.dn2uri = new DN2URI(this, databaseConfig3, REFERRAL_DATABASE_NAME);
            this.dn2uri.open();
            for (AttributeIndex attributeIndex : this.attrIndexMap.values()) {
                attributeIndex.open(databaseConfig);
            }
        }
        catch (DatabaseException databaseException) {
            assert (Debug.debugException(CLASS_NAME, "open", databaseException));
            this.close();
            throw databaseException;
        }
    }

    public void openNonTransactional(boolean bl) throws DatabaseException {
        DatabaseConfig databaseConfig = new DatabaseConfig();
        databaseConfig.setAllowCreate(true);
        databaseConfig.setTransactional(false);
        databaseConfig.setDeferredWrite(bl);
        try {
            this.id2entry = new ID2Entry(this, databaseConfig, this.entryDataConfig, ID2ENTRY_DATABASE_NAME);
            this.id2entry.open();
            this.dn2idComparator = new KeyReverseComparator();
            DatabaseConfig databaseConfig2 = new DatabaseConfig();
            databaseConfig2.setAllowCreate(true);
            databaseConfig2.setTransactional(false);
            databaseConfig2.setBtreeComparator(this.dn2idComparator.getClass());
            databaseConfig2.setDeferredWrite(bl);
            this.dn2id = new DN2ID(this, databaseConfig2, DN2ID_DATABASE_NAME);
            this.dn2id.open();
            this.id2children.open(databaseConfig);
            this.id2subtree.open(databaseConfig);
            DatabaseConfig databaseConfig3 = new DatabaseConfig();
            databaseConfig3.setSortedDuplicates(true);
            databaseConfig3.setAllowCreate(true);
            databaseConfig3.setTransactional(false);
            databaseConfig3.setBtreeComparator(this.dn2idComparator.getClass());
            databaseConfig3.setDeferredWrite(bl);
            this.dn2uri = new DN2URI(this, databaseConfig3, REFERRAL_DATABASE_NAME);
            this.dn2uri.open();
            for (AttributeIndex attributeIndex : this.attrIndexMap.values()) {
                attributeIndex.open(databaseConfig);
            }
        }
        catch (DatabaseException databaseException) {
            assert (Debug.debugException(CLASS_NAME, "open", databaseException));
            this.close();
            throw databaseException;
        }
    }

    public void openReadOnly() throws DatabaseException {
        DatabaseConfig databaseConfig = new DatabaseConfig();
        databaseConfig.setReadOnly(true);
        databaseConfig.setAllowCreate(false);
        databaseConfig.setTransactional(false);
        try {
            this.id2entry = new ID2Entry(this, databaseConfig, this.entryDataConfig, ID2ENTRY_DATABASE_NAME);
            this.id2entry.open();
            this.dn2idComparator = new KeyReverseComparator();
            DatabaseConfig databaseConfig2 = new DatabaseConfig();
            databaseConfig2.setReadOnly(true);
            databaseConfig2.setAllowCreate(false);
            databaseConfig2.setTransactional(false);
            databaseConfig2.setBtreeComparator(this.dn2idComparator.getClass());
            this.dn2id = new DN2ID(this, databaseConfig2, DN2ID_DATABASE_NAME);
            this.dn2id.open();
            this.id2children.open(databaseConfig);
            this.id2subtree.open(databaseConfig);
            DatabaseConfig databaseConfig3 = new DatabaseConfig();
            databaseConfig3.setReadOnly(true);
            databaseConfig3.setSortedDuplicates(true);
            databaseConfig3.setAllowCreate(false);
            databaseConfig3.setTransactional(false);
            databaseConfig3.setBtreeComparator(this.dn2idComparator.getClass());
            this.dn2uri = new DN2URI(this, databaseConfig3, REFERRAL_DATABASE_NAME);
            this.dn2uri.open();
            for (AttributeIndex attributeIndex : this.attrIndexMap.values()) {
                attributeIndex.open(databaseConfig);
            }
        }
        catch (DatabaseException databaseException) {
            assert (Debug.debugException(CLASS_NAME, "openReadOnly", databaseException));
            this.close();
            throw databaseException;
        }
    }

    public void close() throws DatabaseException {
        for (Database object : this.databases) {
            if (object.getConfig().getDeferredWrite()) {
                object.sync();
            }
            object.close();
        }
        for (AttributeIndex attributeIndex : this.attrIndexMap.values()) {
            attributeIndex.close();
        }
    }

    public DN2ID getDN2ID() {
        return this.dn2id;
    }

    public ID2Entry getID2Entry() {
        return this.id2entry;
    }

    public DN2URI getDN2URI() {
        return this.dn2uri;
    }

    public Index getID2Children() {
        return this.id2children;
    }

    public Index getID2Subtree() {
        return this.id2subtree;
    }

    public AttributeIndex getAttributeIndex(AttributeType attributeType) {
        return this.attrIndexMap.get(attributeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntryID getHighestEntryID() throws DatabaseException {
        EntryID entryID = new EntryID(0L);
        Cursor cursor = this.id2entry.openCursor(null, null);
        DatabaseEntry databaseEntry = new DatabaseEntry();
        DatabaseEntry databaseEntry2 = new DatabaseEntry();
        try {
            OperationStatus operationStatus = cursor.getLast(databaseEntry, databaseEntry2, LockMode.DEFAULT);
            if (operationStatus == OperationStatus.SUCCESS) {
                entryID = new EntryID(databaseEntry);
            }
        }
        finally {
            cursor.close();
        }
        return entryID;
    }

    public void search(SearchOperation searchOperation) throws DirectoryException, DatabaseException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        DN dN = searchOperation.getBaseDN();
        SearchScope searchScope = searchOperation.getScope();
        List<Control> list = searchOperation.getRequestControls();
        PagedResultsControl pagedResultsControl = null;
        if (list != null) {
            for (Control object52 : list) {
                if (!object52.getOID().equals("1.2.840.113556.1.4.319") || pagedResultsControl != null) continue;
                try {
                    pagedResultsControl = new PagedResultsControl(object52.isCritical(), object52.getValue());
                }
                catch (LDAPException lDAPException) {
                    assert (Debug.debugException(CLASS_NAME, "search", lDAPException));
                    throw new DirectoryException(ResultCode.PROTOCOL_ERROR, lDAPException.getMessage(), lDAPException.getMessageID(), lDAPException);
                }
            }
        }
        if (pagedResultsControl != null && pagedResultsControl.getSize() == 0) {
            object4 = new PagedResultsControl(pagedResultsControl.isCritical(), 0, new ASN1OctetString());
            searchOperation.getResponseControls().add((Control)object4);
            return;
        }
        if (searchScope == SearchScope.BASE_OBJECT) {
            block24: {
                object4 = null;
                try {
                    object4 = this.getEntry(dN);
                }
                catch (Exception exception) {
                    if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "search", exception)) break block24;
                    throw new AssertionError();
                }
            }
            if (object4 == null) {
                this.dn2uri.targetEntryReferrals(searchOperation.getBaseDN(), searchOperation.getScope());
                int n = 8585262;
                String string = MessageHandler.getMessage(n, dN.toString());
                throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, string, n);
            }
            if (!EntryContainer.isManageDsaITOperation(searchOperation)) {
                this.dn2uri.checkTargetForReferral((Entry)object4, searchOperation.getScope());
            }
            if (searchOperation.getFilter().matchesEntry((Entry)object4)) {
                searchOperation.returnEntry((Entry)object4, null);
            }
            if (pagedResultsControl != null) {
                PagedResultsControl pagedResultsControl2 = new PagedResultsControl(pagedResultsControl.isCritical(), 0, new ASN1OctetString());
                searchOperation.getResponseControls().add(pagedResultsControl2);
            }
            return;
        }
        object4 = null;
        if (searchOperation.getAttributes().contains(ATTR_DEBUG_SEARCH_INDEX)) {
            object4 = new StringBuilder();
        }
        IndexFilter indexFilter = new IndexFilter(this, searchOperation, (StringBuilder)object4);
        EntryIDSet entryIDSet = indexFilter.evaluate();
        boolean bl = false;
        if (entryIDSet.size() > 10) {
            object3 = this.dn2id.get(null, dN);
            if (object3 == null) {
                int n = 8585262;
                String string = MessageHandler.getMessage(n, dN.toString());
                throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, string, n);
            }
            object2 = ((EntryID)object3).getDatabaseEntry();
            if (searchScope == SearchScope.SINGLE_LEVEL) {
                object = this.id2children.readKey((DatabaseEntry)object2, null, LockMode.DEFAULT);
            } else {
                object = this.id2subtree.readKey((DatabaseEntry)object2, null, LockMode.DEFAULT);
                if (searchScope == SearchScope.WHOLE_SUBTREE) {
                    ((EntryIDSet)object).add((EntryID)object3);
                }
            }
            entryIDSet.retainAll((EntryIDSet)object);
            if (object4 != null) {
                ((StringBuilder)object4).append(" scope=");
                ((StringBuilder)object4).append((Object)searchScope);
                ((EntryIDSet)object).toString((StringBuilder)object4);
            }
            if (((EntryIDSet)object).isDefined()) {
                bl = true;
            }
        }
        if (object4 != null) {
            ((StringBuilder)object4).append(" final=");
            entryIDSet.toString((StringBuilder)object4);
            object3 = DirectoryServer.getDefaultStringSyntax();
            object2 = DirectoryServer.getDefaultAttributeType(ATTR_DEBUG_SEARCH_INDEX, (AttributeSyntax)object3);
            object = new ASN1OctetString(((StringBuilder)object4).toString());
            LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>();
            linkedHashSet.add(new AttributeValue((ByteString)object, (ByteString)object));
            Attribute attribute = new Attribute((AttributeType)object2, ATTR_DEBUG_SEARCH_INDEX, linkedHashSet);
            Entry entry = new Entry(DN.decode("cn=debugsearch"), null, null, null);
            entry.addAttribute(attribute, new ArrayList<AttributeValue>());
            searchOperation.returnEntry(entry, null);
            return;
        }
        if (entryIDSet.isDefined()) {
            this.searchIndexed(entryIDSet, bl, searchOperation, pagedResultsControl);
        } else {
            this.searchNotIndexed(searchOperation, pagedResultsControl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchNotIndexed(SearchOperation searchOperation, PagedResultsControl pagedResultsControl) throws DirectoryException {
        Object object;
        block35: {
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            EntryCache entryCache = DirectoryServer.getEntryCache();
            DN dN = searchOperation.getBaseDN();
            SearchScope searchScope = searchOperation.getScope();
            boolean bl = EntryContainer.isManageDsaITOperation(searchOperation);
            if (pagedResultsControl == null || pagedResultsControl.getCookie().value().length == 0) {
                block34: {
                    object5 = null;
                    try {
                        object5 = this.getEntry(dN);
                    }
                    catch (Exception exception) {
                        if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "search", exception)) break block34;
                        throw new AssertionError();
                    }
                }
                if (object5 == null) {
                    this.dn2uri.targetEntryReferrals(searchOperation.getBaseDN(), searchOperation.getScope());
                    int n = 8585262;
                    String string = MessageHandler.getMessage(n, dN.toString());
                    throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, string, n);
                }
                if (!bl) {
                    this.dn2uri.checkTargetForReferral((Entry)object5, searchOperation.getScope());
                }
                if (searchScope == SearchScope.WHOLE_SUBTREE && searchOperation.getFilter().matchesEntry((Entry)object5)) {
                    searchOperation.returnEntry((Entry)object5, null);
                }
                if (!bl && !this.dn2uri.returnSearchReferences(searchOperation) && pagedResultsControl != null) {
                    object4 = new PagedResultsControl(pagedResultsControl.isCritical(), 0, new ASN1OctetString());
                    searchOperation.getResponseControls().add((Control)object4);
                }
            }
            object5 = StaticUtils.getBytes("," + dN.toNormalizedString());
            object4 = (byte[])object5.clone();
            object4[0] = (byte)(object4[0] + 1);
            if (pagedResultsControl != null && pagedResultsControl.getCookie().value().length != 0) {
                try {
                    object3 = DN.decode(pagedResultsControl.getCookie());
                    object2 = StaticUtils.getBytes(((DN)object3).toNormalizedString());
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "searchNotIndexed", exception));
                    int n = 8585327;
                    String string = StaticUtils.bytesToHex(pagedResultsControl.getCookie().value());
                    String string2 = MessageHandler.getMessage(n, string);
                    throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string2, n, exception);
                }
            } else {
                object2 = object5;
            }
            object3 = new DatabaseEntry();
            DatabaseEntry databaseEntry = new DatabaseEntry((byte[])object2);
            ArrayList<Lock> arrayList = new ArrayList<Lock>(1);
            int n = 0;
            int n2 = searchOperation.getClientConnection().getLookthroughLimit();
            try {
                object = this.dn2id.openCursor(null, null);
                try {
                    OperationStatus operationStatus = object.getSearchKeyRange(databaseEntry, (DatabaseEntry)object3, LockMode.DEFAULT);
                    while (operationStatus == OperationStatus.SUCCESS) {
                        if (n2 > 0 && n > n2) {
                            searchOperation.setResultCode(ResultCode.ADMIN_LIMIT_EXCEEDED);
                            searchOperation.appendErrorMessage(MessageHandler.getMessage(8388735, n2));
                            return;
                        }
                        int n3 = this.dn2idComparator.compare(databaseEntry.getData(), (byte[])object4);
                        if (n3 >= 0) {
                            break;
                        }
                        EntryID entryID = new EntryID((DatabaseEntry)object3);
                        DN dN2 = DN.decode(new ASN1OctetString(databaseEntry.getData()));
                        boolean bl2 = true;
                        if (searchScope == SearchScope.SINGLE_LEVEL && dN2.getNumComponents() != dN.getNumComponents() + 1) {
                            bl2 = false;
                        }
                        if (bl2) {
                            Object object6;
                            Entry entry = null;
                            Entry entry2 = null;
                            arrayList.clear();
                            entry2 = entryCache.getEntry(this.backend, entryID.longValue(), LockType.NONE, arrayList);
                            if (entry2 == null) {
                                object6 = new GetEntryByIDOperation(entryID);
                                this.invokeTransactedOperation((TransactedOperation)object6);
                                entry = ((GetEntryByIDOperation)object6).getEntry();
                            } else {
                                entry = entry2;
                            }
                            if (entry != null) {
                                ++n;
                                if ((bl || entry.getReferralURLs() == null) && searchOperation.getFilter().matchesEntry(entry)) {
                                    if (pagedResultsControl != null && searchOperation.getEntriesSent() == pagedResultsControl.getSize()) {
                                        object6 = new ASN1OctetString(databaseEntry.getData());
                                        PagedResultsControl pagedResultsControl2 = new PagedResultsControl(pagedResultsControl.isCritical(), 0, (ASN1OctetString)object6);
                                        searchOperation.getResponseControls().add(pagedResultsControl2);
                                        return;
                                    }
                                    if (!searchOperation.returnEntry(entry, null)) {
                                        return;
                                    }
                                }
                            }
                        }
                        operationStatus = object.getNext(databaseEntry, (DatabaseEntry)object3, LockMode.DEFAULT);
                    }
                }
                finally {
                    object.close();
                }
            }
            catch (DatabaseException databaseException) {
                assert (Debug.debugException(CLASS_NAME, "searchNotIndexed", databaseException));
            }
            catch (JebException jebException) {
                if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "searchNotIndexed", jebException)) break block35;
                throw new AssertionError();
            }
        }
        if (pagedResultsControl != null) {
            object = new PagedResultsControl(pagedResultsControl.isCritical(), 0, new ASN1OctetString());
            searchOperation.getResponseControls().add((Control)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void searchIndexed(EntryIDSet entryIDSet, boolean bl, SearchOperation searchOperation, PagedResultsControl pagedResultsControl) throws DirectoryException {
        Object object;
        EntryCache entryCache = DirectoryServer.getEntryCache();
        SearchScope searchScope = searchOperation.getScope();
        DN dN = searchOperation.getBaseDN();
        boolean bl2 = EntryContainer.isManageDsaITOperation(searchOperation);
        boolean bl3 = true;
        EntryID entryID = null;
        if (pagedResultsControl != null && pagedResultsControl.getCookie().value().length != 0) {
            try {
                entryID = new EntryID(new DatabaseEntry(pagedResultsControl.getCookie().value()));
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "searchIndexed", exception));
                int n = 8585327;
                String string = StaticUtils.bytesToHex(pagedResultsControl.getCookie().value());
                String string2 = MessageHandler.getMessage(n, string);
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string2, n, exception);
            }
        } else if (!bl2) {
            bl3 = this.dn2uri.returnSearchReferences(searchOperation);
        }
        int n = searchOperation.getClientConnection().getLookthroughLimit();
        if (n > 0 && entryIDSet.size() > n) {
            searchOperation.setResultCode(ResultCode.ADMIN_LIMIT_EXCEEDED);
            searchOperation.appendErrorMessage(MessageHandler.getMessage(8388735, n));
            bl3 = false;
        }
        if (bl3) {
            object = new ArrayList();
            for (EntryID entryID2 : entryIDSet) {
                Object object2;
                Iterator iterator;
                Entry entry;
                Entry entry2;
                block32: {
                    entry2 = null;
                    entry = null;
                    if (entryID != null && entryID2.compareTo(entryID) < 0) continue;
                    object.clear();
                    entry = entryCache.getEntry(this.backend, entryID2.longValue(), LockType.NONE, (List<Lock>)object);
                    if (entry == null) {
                        GetEntryByIDOperation getEntryByIDOperation = new GetEntryByIDOperation(entryID2);
                        try {
                            this.invokeTransactedOperation(getEntryByIDOperation);
                            entry2 = getEntryByIDOperation.getEntry();
                            break block32;
                        }
                        catch (Exception exception) {
                            assert (Debug.debugException(CLASS_NAME, "searchIndexed", exception));
                            iterator = object.iterator();
                            while (iterator.hasNext()) {
                                object2 = (Lock)iterator.next();
                                object2.unlock();
                            }
                            continue;
                        }
                    }
                    entry2 = entry;
                }
                if (entry2 == null) continue;
                boolean bl4 = false;
                DN dN2 = entry2.getDN();
                if (bl) {
                    bl4 = true;
                } else if (searchScope == SearchScope.SINGLE_LEVEL) {
                    if (dN2.getNumComponents() == dN.getNumComponents() + 1 && dN2.isDescendantOf(dN)) {
                        bl4 = true;
                    }
                } else if (searchScope == SearchScope.WHOLE_SUBTREE) {
                    if (dN2.isDescendantOf(dN)) {
                        bl4 = true;
                    }
                } else if (searchScope == SearchScope.SUBORDINATE_SUBTREE && dN2.getNumComponents() > dN.getNumComponents() && dN2.isDescendantOf(dN)) {
                    bl4 = true;
                }
                if (entry == null) {
                    entryCache.putEntryIfAbsent(entry2, this.backend, entryID2.longValue());
                }
                if (!bl4 || !bl2 && entry2.getReferralURLs() != null || !searchOperation.getFilter().matchesEntry(entry2)) continue;
                if (pagedResultsControl != null && searchOperation.getEntriesSent() == pagedResultsControl.getSize()) {
                    iterator = (Iterator)entryID2.getDatabaseEntry().getData();
                    object2 = new ASN1OctetString((byte[])iterator);
                    PagedResultsControl pagedResultsControl2 = new PagedResultsControl(pagedResultsControl.isCritical(), 0, (ASN1OctetString)object2);
                    searchOperation.getResponseControls().add(pagedResultsControl2);
                    return;
                }
                if (searchOperation.returnEntry(entry2, null)) continue;
                break;
            }
        }
        if (searchOperation.getEntriesSent() == 0 && searchOperation.getReferencesSent() == 0) {
            this.dn2uri.targetEntryReferrals(searchOperation.getBaseDN(), searchOperation.getScope());
            if (!this.entryExists(dN)) {
                int n2 = 8585262;
                String string = MessageHandler.getMessage(n2, dN.toString());
                throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, string, n2);
            }
        }
        if (pagedResultsControl == null) return;
        object = new PagedResultsControl(pagedResultsControl.isCritical(), 0, new ASN1OctetString());
        searchOperation.getResponseControls().add((Control)object);
    }

    public void addEntry(Entry entry, AddOperation addOperation) throws DatabaseException, DirectoryException, JebException {
        AddEntryTransaction addEntryTransaction = new AddEntryTransaction(entry);
        this.invokeTransactedOperation(addEntryTransaction);
    }

    private void invokeTransactedOperation(TransactedOperation transactedOperation) throws DatabaseException, DirectoryException, JebException {
        boolean bl = false;
        int n = this.config.getDeadlockRetryLimit();
        while (!bl) {
            Transaction transaction = transactedOperation.beginOperationTransaction();
            try {
                transactedOperation.invokeOperation(transaction);
                EntryContainer.transactionCommit(transaction);
                bl = true;
            }
            catch (DeadlockException deadlockException) {
                EntryContainer.transactionAbort(transaction);
                if (n-- <= 0) {
                    throw deadlockException;
                }
                assert (Debug.debugException(CLASS_NAME, "invokeTransactedOperation", deadlockException));
            }
            catch (DatabaseException databaseException) {
                EntryContainer.transactionAbort(transaction);
                throw databaseException;
            }
            catch (DirectoryException directoryException) {
                EntryContainer.transactionAbort(transaction);
                throw directoryException;
            }
            catch (JebException jebException) {
                EntryContainer.transactionAbort(transaction);
                throw jebException;
            }
            catch (Exception exception) {
                EntryContainer.transactionAbort(transaction);
                int n2 = 8585244;
                String string = MessageHandler.getMessage(n2);
                throw new JebException(n2, string, exception);
            }
        }
        transactedOperation.postCommitAction();
    }

    public void deleteEntry(DN dN, DeleteOperation deleteOperation) throws DirectoryException, DatabaseException, JebException {
        DeleteEntryTransaction deleteEntryTransaction = new DeleteEntryTransaction(dN, deleteOperation);
        this.invokeTransactedOperation(deleteEntryTransaction);
        if (deleteEntryTransaction.adminSizeLimitExceeded()) {
            String string = MessageHandler.getMessage(8847392, deleteEntryTransaction.getDeletedEntryCount());
            throw new DirectoryException(ResultCode.ADMIN_LIMIT_EXCEEDED, string, 8847392);
        }
        String string = MessageHandler.getMessage(8847393, deleteEntryTransaction.getDeletedEntryCount());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        deleteOperation.setErrorMessage(stringBuilder);
    }

    private void deleteLeaf(BufferedIndex bufferedIndex, BufferedIndex bufferedIndex2, Transaction transaction, DN dN, EntryID entryID) throws DatabaseException, DirectoryException, JebException {
        Entry entry = this.id2entry.get(transaction, entryID);
        if (entry == null) {
            int n = 8650763;
            String string = MessageHandler.getMessage(n, entryID.toString());
            throw new JebException(n, string);
        }
        if (!this.dn2id.remove(transaction, dN)) {
            int n = 0x830030;
            String string = MessageHandler.getMessage(n, dN.toString());
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, string, n);
        }
        this.dn2uri.deleteEntry(transaction, entry);
        if (!this.id2entry.remove(transaction, entryID)) {
            int n = 8650763;
            String string = MessageHandler.getMessage(n, entryID.toString());
            throw new JebException(n, string);
        }
        this.indexRemoveEntry(transaction, entry, entryID);
        byte[] byArray = entryID.getDatabaseEntry().getData();
        EntryIDSet entryIDSet = bufferedIndex.get(byArray);
        if (!entryIDSet.isDefined()) {
            bufferedIndex.remove(byArray);
        } else if (entryIDSet.size() != 0) {
            int n = 8585268;
            String string = MessageHandler.getMessage(n, dN.toString());
            throw new DirectoryException(ResultCode.NOT_ALLOWED_ON_NONLEAF, string, n);
        }
        EntryIDSet entryIDSet2 = bufferedIndex2.get(byArray);
        if (!entryIDSet2.isDefined()) {
            bufferedIndex2.remove(byArray);
        } else if (entryIDSet2.size() != 0) {
            int n = 8585268;
            String string = MessageHandler.getMessage(n, dN.toString());
            throw new DirectoryException(ResultCode.NOT_ALLOWED_ON_NONLEAF, string, n);
        }
        boolean bl = true;
        DN dN2 = this.getParentWithinBase(dN);
        while (dN2 != null) {
            EntryID entryID2 = this.dn2id.get(transaction, dN2);
            if (entryID2 == null) {
                int n = 8650762;
                String string = MessageHandler.getMessage(n, dN2.toNormalizedString());
                throw new JebException(n, string);
            }
            DatabaseEntry databaseEntry = entryID2.getDatabaseEntry();
            if (bl) {
                bufferedIndex.removeID(databaseEntry.getData(), entryID);
                bl = false;
            }
            bufferedIndex2.removeID(databaseEntry.getData(), entryID);
            dN2 = this.getParentWithinBase(dN2);
        }
    }

    private void deleteTarget(boolean bl, BufferedIndex bufferedIndex, BufferedIndex bufferedIndex2, Transaction transaction, DN dN) throws DatabaseException, DirectoryException, JebException {
        EntryID entryID = this.dn2id.get(transaction, dN);
        if (entryID == null) {
            int n = 0x830030;
            String string = MessageHandler.getMessage(n, dN.toString());
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, string, n);
        }
        Entry entry = this.id2entry.get(transaction, entryID);
        if (entry == null) {
            int n = 8650763;
            String string = MessageHandler.getMessage(n, entryID.toString());
            throw new JebException(n, string);
        }
        if (!bl) {
            this.dn2uri.checkTargetForReferral(entry, null);
        }
        if (!this.dn2id.remove(transaction, dN)) {
            int n = 0x830030;
            String string = MessageHandler.getMessage(n, dN.toString());
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, string, n);
        }
        this.dn2uri.deleteEntry(transaction, entry);
        if (!this.id2entry.remove(transaction, entryID)) {
            int n = 8650763;
            String string = MessageHandler.getMessage(n, entryID.toString());
            throw new JebException(n, string);
        }
        this.indexRemoveEntry(transaction, entry, entryID);
        boolean bl2 = true;
        DN dN2 = this.getParentWithinBase(dN);
        while (dN2 != null) {
            EntryID entryID2 = this.dn2id.get(transaction, dN2);
            if (entryID2 == null) {
                int n = 8650762;
                String string = MessageHandler.getMessage(n, dN2.toNormalizedString());
                throw new JebException(n, string);
            }
            DatabaseEntry databaseEntry = entryID2.getDatabaseEntry();
            if (bl2) {
                bufferedIndex.removeID(databaseEntry.getData(), entryID);
                bl2 = false;
            }
            bufferedIndex2.removeID(databaseEntry.getData(), entryID);
            dN2 = this.getParentWithinBase(dN2);
        }
    }

    public boolean entryExists(DN dN) throws DirectoryException {
        EntryID entryID;
        block3: {
            EntryCache entryCache = DirectoryServer.getEntryCache();
            if (entryCache != null && entryCache.containsEntry(dN)) {
                return true;
            }
            entryID = null;
            try {
                entryID = this.dn2id.get(null, dN);
            }
            catch (DatabaseException databaseException) {
                if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "entryExists", databaseException)) break block3;
                throw new AssertionError();
            }
        }
        return entryID != null;
    }

    public Entry getEntry(DN dN) throws JebException, DatabaseException, DirectoryException {
        EntryCache entryCache = DirectoryServer.getEntryCache();
        Entry entry = null;
        if (entryCache != null) {
            entry = entryCache.getEntry(dN);
        }
        if (entry == null) {
            GetEntryByDNOperation getEntryByDNOperation = new GetEntryByDNOperation(dN);
            this.invokeTransactedOperation(getEntryByDNOperation);
            entry = getEntryByDNOperation.getEntry();
            if (entry != null && entryCache != null) {
                entryCache.putEntryIfAbsent(entry, this.backend, getEntryByDNOperation.getEntryID().longValue());
            }
        }
        return entry;
    }

    public void replaceEntry(Entry entry, ModifyOperation modifyOperation) throws DatabaseException, DirectoryException, JebException {
        ReplaceEntryTransaction replaceEntryTransaction = new ReplaceEntryTransaction(entry, modifyOperation);
        this.invokeTransactedOperation(replaceEntryTransaction);
    }

    public void renameEntry(DN dN, Entry entry, ModifyDNOperation modifyDNOperation) throws DatabaseException, JebException, DirectoryException, CancelledOperationException {
        RenameEntryTransaction renameEntryTransaction = new RenameEntryTransaction(dN, entry, modifyDNOperation);
        this.invokeTransactedOperation(renameEntryTransaction);
    }

    public static DN modDN(DN dN, int n, DN dN2) {
        DN dN3 = dN.getLocalName(n);
        return dN2.concat(dN3);
    }

    private void indexInsertEntry(Transaction transaction, Entry entry, EntryID entryID) throws DatabaseException, DirectoryException, JebException {
        for (AttributeIndex attributeIndex : this.attrIndexMap.values()) {
            attributeIndex.addEntry(transaction, entryID, entry);
        }
    }

    private void indexRemoveEntry(Transaction transaction, Entry entry, EntryID entryID) throws DatabaseException, DirectoryException, JebException {
        for (AttributeIndex attributeIndex : this.attrIndexMap.values()) {
            attributeIndex.removeEntry(transaction, entryID, entry);
        }
    }

    private void indexModifications(Transaction transaction, Entry entry, Entry entry2, EntryID entryID, List<Modification> list) throws DatabaseException {
        for (AttributeIndex attributeIndex : this.attrIndexMap.values()) {
            boolean bl = false;
            for (Modification modification : list) {
                Attribute attribute = modification.getAttribute();
                AttributeType attributeType = attribute.getAttributeType();
                if (!attributeType.equals(attributeIndex.getAttributeType())) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            attributeIndex.modifyEntry(transaction, entryID, entry, entry2, list);
        }
    }

    public long getEntryCount() throws DatabaseException {
        return this.id2entry.getRecordCount(null);
    }

    public void removeContainer() throws DatabaseException {
        block15: {
            block14: {
                block13: {
                    block12: {
                        try {
                            this.removeDatabase(DN2ID_DATABASE_NAME);
                        }
                        catch (DatabaseNotFoundException databaseNotFoundException) {
                            if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "removeContainer", databaseNotFoundException)) break block12;
                            throw new AssertionError();
                        }
                    }
                    try {
                        this.removeDatabase(ID2ENTRY_DATABASE_NAME);
                    }
                    catch (DatabaseNotFoundException databaseNotFoundException) {
                        if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "removeContainer", databaseNotFoundException)) break block13;
                        throw new AssertionError();
                    }
                }
                try {
                    this.removeDatabase(ID2CHILDREN_DATABASE_NAME);
                }
                catch (DatabaseNotFoundException databaseNotFoundException) {
                    if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "removeContainer", databaseNotFoundException)) break block14;
                    throw new AssertionError();
                }
            }
            try {
                this.removeDatabase(ID2SUBTREE_DATABASE_NAME);
            }
            catch (DatabaseNotFoundException databaseNotFoundException) {
                if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "removeContainer", databaseNotFoundException)) break block15;
                throw new AssertionError();
            }
        }
        for (AttributeIndex attributeIndex : this.attrIndexMap.values()) {
            try {
                attributeIndex.removeIndex();
            }
            catch (DatabaseNotFoundException databaseNotFoundException) {
                assert (Debug.debugException(CLASS_NAME, "removeContainer", databaseNotFoundException));
            }
        }
    }

    public int getEntryLimitExceededCount() {
        int n = 0;
        n += this.id2children.getEntryLimitExceededCount();
        n += this.id2subtree.getEntryLimitExceededCount();
        for (AttributeIndex attributeIndex : this.attrIndexMap.values()) {
            n = (int)((long)n + attributeIndex.getEntryLimitExceededCount());
        }
        return n;
    }

    public void listDatabases(List<Database> list) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Database database : this.databases) {
            try {
                if (hashSet.contains(database.getDatabaseName())) continue;
                hashSet.add(database.getDatabaseName());
                list.add(database);
            }
            catch (DatabaseException databaseException) {
                assert (Debug.debugException(CLASS_NAME, "listDatabases", databaseException));
            }
        }
    }

    public static boolean isManageDsaITOperation(Operation operation) {
        List<Control> list;
        if (operation != null && (list = operation.getRequestControls()) != null) {
            for (Control control : list) {
                if (!control.getOID().equals("2.16.840.1.113730.3.4.2")) continue;
                return true;
            }
        }
        return false;
    }

    private void buildDatabaseName(StringBuilder stringBuilder, String string) {
        stringBuilder.append(this.getContainerName());
        stringBuilder.append('_');
        stringBuilder.append(string);
    }

    public synchronized Database openDatabase(DatabaseConfig databaseConfig, String string) throws DatabaseException {
        Database database;
        StringBuilder stringBuilder = new StringBuilder();
        this.buildDatabaseName(stringBuilder, string);
        String string2 = stringBuilder.toString();
        if (databaseConfig.getTransactional()) {
            Transaction transaction = this.beginTransaction();
            try {
                database = this.env.openDatabase(transaction, string2, databaseConfig);
                assert (Debug.debugMessage(DebugLogCategory.DATABASE_ACCESS, DebugLogSeverity.VERBOSE, CLASS_NAME, "openDatabase", "open db=" + database.getDatabaseName() + " txnid=" + transaction.getId()));
                EntryContainer.transactionCommit(transaction);
            }
            catch (DatabaseException databaseException) {
                EntryContainer.transactionAbort(transaction);
                throw databaseException;
            }
        } else {
            database = this.env.openDatabase(null, string2, databaseConfig);
            assert (Debug.debugMessage(DebugLogCategory.DATABASE_ACCESS, DebugLogSeverity.VERBOSE, CLASS_NAME, "openDatabase", "open db=" + database.getDatabaseName() + " txnid=none"));
        }
        this.databases.add(database);
        return database;
    }

    public Transaction beginTransaction() throws DatabaseException {
        Transaction transaction = null;
        TransactionConfig transactionConfig = null;
        Transaction transaction2 = this.env.beginTransaction(transaction, transactionConfig);
        assert (Debug.debugMessage(DebugLogCategory.DATABASE_ACCESS, DebugLogSeverity.VERBOSE, CLASS_NAME, "beginTransaction", "begin txnid=" + transaction2.getId()));
        return transaction2;
    }

    public static void transactionCommit(Transaction transaction) throws DatabaseException {
        if (transaction != null) {
            transaction.commit();
            assert (Debug.debugMessage(DebugLogCategory.DATABASE_ACCESS, DebugLogSeverity.VERBOSE, CLASS_NAME, "transactionCommit", "commit txnid=" + transaction.getId()));
        }
    }

    public static void transactionAbort(Transaction transaction) throws DatabaseException {
        if (transaction != null) {
            transaction.abort();
            assert (Debug.debugMessage(DebugLogCategory.DATABASE_ACCESS, DebugLogSeverity.VERBOSE, CLASS_NAME, "transactionAbort", "abort txnid=" + transaction.getId()));
        }
    }

    private static boolean debugAccess(String string, DebugLogCategory debugLogCategory, OperationStatus operationStatus, Database database, Transaction transaction, DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2) throws DatabaseException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        if (operationStatus == OperationStatus.SUCCESS) {
            stringBuilder.append(" (ok)");
        } else {
            stringBuilder.append(" (");
            stringBuilder.append(operationStatus.toString());
            stringBuilder.append(")");
        }
        stringBuilder.append(" db=");
        stringBuilder.append(database.getDatabaseName());
        if (transaction != null) {
            stringBuilder.append(" txnid=");
            stringBuilder.append(transaction.getId());
        } else {
            stringBuilder.append(" txnid=none");
        }
        Debug.debugMessage(DebugLogCategory.DATABASE_ACCESS, DebugLogSeverity.VERBOSE, CLASS_NAME, "debugAccess", stringBuilder.toString());
        if (operationStatus == OperationStatus.SUCCESS) {
            stringBuilder.append(" key:");
            stringBuilder.append(ServerConstants.EOL);
            StaticUtils.byteArrayToHexPlusAscii(stringBuilder, databaseEntry.getData(), 0);
            if (databaseEntry2 != null) {
                stringBuilder.append("data(len=");
                stringBuilder.append(databaseEntry2.getSize());
                stringBuilder.append("):");
                stringBuilder.append(ServerConstants.EOL);
                StaticUtils.byteArrayToHexPlusAscii(stringBuilder, databaseEntry2.getData(), 0);
            }
            Debug.debugMessage(debugLogCategory, DebugLogSeverity.VERBOSE, CLASS_NAME, "debugAccess", stringBuilder.toString());
        }
        return true;
    }

    public static OperationStatus insert(Database database, Transaction transaction, DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2) throws DatabaseException {
        OperationStatus operationStatus = database.putNoOverwrite(transaction, databaseEntry, databaseEntry2);
        assert (EntryContainer.debugAccess("insert", DebugLogCategory.DATABASE_WRITE, operationStatus, database, transaction, databaseEntry, databaseEntry2));
        return operationStatus;
    }

    public static OperationStatus cursorInsert(Cursor cursor, DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2) throws DatabaseException {
        OperationStatus operationStatus = cursor.putNoOverwrite(databaseEntry, databaseEntry2);
        assert (EntryContainer.debugAccess("cursorInsert", DebugLogCategory.DATABASE_WRITE, operationStatus, cursor.getDatabase(), null, databaseEntry, databaseEntry2));
        return operationStatus;
    }

    public static OperationStatus put(Database database, Transaction transaction, DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2) throws DatabaseException {
        OperationStatus operationStatus = database.put(transaction, databaseEntry, databaseEntry2);
        assert (EntryContainer.debugAccess("put", DebugLogCategory.DATABASE_WRITE, operationStatus, database, transaction, databaseEntry, databaseEntry2));
        return operationStatus;
    }

    public static OperationStatus cursorPut(Cursor cursor, DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2) throws DatabaseException {
        OperationStatus operationStatus = cursor.put(databaseEntry, databaseEntry2);
        assert (EntryContainer.debugAccess("cursorPut", DebugLogCategory.DATABASE_WRITE, operationStatus, cursor.getDatabase(), null, databaseEntry, databaseEntry2));
        return operationStatus;
    }

    public static OperationStatus read(Database database, Transaction transaction, DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, LockMode lockMode) throws DatabaseException {
        OperationStatus operationStatus = database.get(transaction, databaseEntry, databaseEntry2, lockMode);
        assert (EntryContainer.debugAccess("read", DebugLogCategory.DATABASE_READ, operationStatus, database, transaction, databaseEntry, databaseEntry2));
        return operationStatus;
    }

    public static OperationStatus cursorRead(Cursor cursor, DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, LockMode lockMode) throws DatabaseException {
        OperationStatus operationStatus = cursor.getSearchKey(databaseEntry, databaseEntry2, lockMode);
        assert (EntryContainer.debugAccess("cursorRead", DebugLogCategory.DATABASE_READ, operationStatus, cursor.getDatabase(), null, databaseEntry, databaseEntry2));
        return operationStatus;
    }

    public static OperationStatus delete(Database database, Transaction transaction, DatabaseEntry databaseEntry) throws DatabaseException {
        OperationStatus operationStatus = database.delete(transaction, databaseEntry);
        assert (EntryContainer.debugAccess("delete", DebugLogCategory.DATABASE_WRITE, operationStatus, database, transaction, databaseEntry, null));
        return operationStatus;
    }

    public void removeDatabase(String string) throws DatabaseException {
        StringBuilder stringBuilder = new StringBuilder();
        this.buildDatabaseName(stringBuilder, string);
        String string2 = stringBuilder.toString();
        this.env.removeDatabase(null, string2);
    }

    public String getContainerName() {
        String string = this.baseDN.toNormalizedString();
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append('_');
        }
        return stringBuilder.toString();
    }

    public DN getBaseDN() {
        return this.baseDN;
    }

    public DN getParentWithinBase(DN dN) {
        if (dN.equals(this.baseDN)) {
            return null;
        }
        return dN.getParent();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class KeyReverseComparator
    implements Comparator<byte[]> {
        @Override
        public int compare(byte[] byArray, byte[] byArray2) {
            int n = byArray.length - 1;
            for (int i = byArray2.length - 1; n >= 0 && i >= 0; --n, --i) {
                if (byArray[n] > byArray2[i]) {
                    return 1;
                }
                if (byArray[n] >= byArray2[i]) continue;
                return -1;
            }
            if (byArray.length == byArray2.length) {
                return 0;
            }
            if (byArray.length > byArray2.length) {
                return 1;
            }
            return -1;
        }
    }

    private class RenameEntryTransaction
    implements TransactedOperation {
        private DN oldApexDN;
        private DN oldSuperiorDN;
        private DN newSuperiorDN;
        private Entry newApexEntry;
        private ModifyDNOperation modifyDNOperation;
        private BufferedIndex id2cBuffered;
        private BufferedIndex id2sBuffered;

        public RenameEntryTransaction(DN dN, Entry entry, ModifyDNOperation modifyDNOperation) {
            this.oldApexDN = dN;
            this.oldSuperiorDN = EntryContainer.this.getParentWithinBase(dN);
            this.newSuperiorDN = EntryContainer.this.getParentWithinBase(entry.getDN());
            this.newApexEntry = entry;
            this.modifyDNOperation = modifyDNOperation;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invokeOperation(Transaction transaction) throws DatabaseException, DirectoryException, JebException {
            Object object;
            DN dN = null;
            if (this.modifyDNOperation != null) {
                dN = this.modifyDNOperation.getNewSuperior();
            }
            if (EntryContainer.this.dn2id.get(transaction, this.newApexEntry.getDN()) != null) {
                int n = 8585269;
                String string = MessageHandler.getMessage(n, this.newApexEntry.getDN().toString());
                throw new DirectoryException(ResultCode.ENTRY_ALREADY_EXISTS, string, n);
            }
            EntryID entryID = EntryContainer.this.dn2id.get(transaction, this.oldApexDN);
            if (entryID == null) {
                EntryContainer.this.dn2uri.targetEntryReferrals(this.oldApexDN, null);
                int n = 8585266;
                String string = MessageHandler.getMessage(n, this.oldApexDN.toString());
                throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, string, n);
            }
            Entry entry = EntryContainer.this.id2entry.get(transaction, entryID);
            if (entry == null) {
                int n = 8650763;
                String string = MessageHandler.getMessage(n, entryID.toString());
                throw new JebException(n, string);
            }
            if (!EntryContainer.isManageDsaITOperation(this.modifyDNOperation)) {
                EntryContainer.this.dn2uri.checkTargetForReferral(entry, null);
            }
            this.id2cBuffered = new BufferedIndex(EntryContainer.this.id2children, transaction);
            this.id2sBuffered = new BufferedIndex(EntryContainer.this.id2subtree, transaction);
            EntryID entryID2 = entryID;
            if (this.newSuperiorDN != null) {
                object = EntryContainer.this.dn2id.get(transaction, this.newSuperiorDN);
                if (object == null) {
                    int n = 8585270;
                    String string = MessageHandler.getMessage(n, this.newSuperiorDN.toString());
                    throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, string, n);
                }
                if (((EntryID)object).compareTo(entryID) > 0) {
                    entryID2 = EntryContainer.this.rootContainer.getNextEntryID();
                }
            }
            if (dN != null) {
                this.moveApexEntry(transaction, entryID, entryID2, entry, this.newApexEntry);
            } else {
                this.renameApexEntry(transaction, entryID, entry, this.newApexEntry);
            }
            object = StaticUtils.getBytes("," + this.oldApexDN.toNormalizedString());
            byte[] byArray = (byte[])object.clone();
            byArray[0] = (byte)(byArray[0] + 1);
            Object object2 = object;
            DatabaseEntry databaseEntry = new DatabaseEntry();
            DatabaseEntry databaseEntry2 = new DatabaseEntry((byte[])object2);
            Cursor cursor = EntryContainer.this.dn2id.openCursor(transaction, null);
            try {
                OperationStatus operationStatus = cursor.getSearchKeyRange(databaseEntry2, databaseEntry, LockMode.RMW);
                while (operationStatus == OperationStatus.SUCCESS && EntryContainer.this.dn2idComparator.compare(databaseEntry2.getData(), object2) <= 0) {
                    operationStatus = cursor.getNext(databaseEntry2, databaseEntry, LockMode.RMW);
                }
                while (operationStatus == OperationStatus.SUCCESS) {
                    int n = EntryContainer.this.dn2idComparator.compare(databaseEntry2.getData(), byArray);
                    if (n >= 0) {
                        break;
                    }
                    EntryID entryID3 = new EntryID(databaseEntry);
                    Entry entry2 = EntryContainer.this.id2entry.get(transaction, entryID3);
                    DN dN2 = EntryContainer.modDN(entry2.getDN(), this.oldApexDN.getNumComponents(), this.newApexEntry.getDN());
                    if (dN != null) {
                        EntryID entryID4 = entryID3;
                        if (!entryID2.equals(entryID)) {
                            entryID4 = EntryContainer.this.rootContainer.getNextEntryID();
                        }
                        this.moveSubordinateEntry(transaction, entryID3, entryID4, entry2, dN2);
                    } else {
                        this.renameSubordinateEntry(transaction, entryID3, entry2, dN2);
                    }
                    operationStatus = cursor.getNext(databaseEntry2, databaseEntry, LockMode.RMW);
                }
            }
            finally {
                cursor.close();
            }
            this.id2cBuffered.flush();
            this.id2sBuffered.flush();
        }

        public Transaction beginOperationTransaction() throws DatabaseException {
            return EntryContainer.this.beginTransaction();
        }

        private void moveApexEntry(Transaction transaction, EntryID entryID, EntryID entryID2, Entry entry, Entry entry2) throws JebException, DirectoryException, DatabaseException {
            EntryID entryID3;
            Object object;
            DN dN = entry.getDN();
            DN dN2 = entry2.getDN();
            DN dN3 = EntryContainer.this.getParentWithinBase(dN2);
            EntryContainer.this.dn2id.remove(transaction, dN);
            if (!EntryContainer.this.dn2id.insert(transaction, dN2, entryID2)) {
                int n = 8585269;
                String string = MessageHandler.getMessage(n, dN2.toString());
                throw new DirectoryException(ResultCode.ENTRY_ALREADY_EXISTS, string, n);
            }
            EntryContainer.this.dn2uri.replaceEntry(transaction, entry, entry2);
            if (!entryID2.equals(entryID) || this.modifyDNOperation == null) {
                EntryContainer.this.id2entry.remove(transaction, entryID);
                EntryContainer.this.indexRemoveEntry(transaction, entry, entryID);
                EntryContainer.this.indexInsertEntry(transaction, entry2, entryID2);
            } else {
                EntryContainer.this.indexModifications(transaction, entry, entry2, entryID, this.modifyDNOperation.getModifications());
            }
            EntryContainer.this.id2entry.put(transaction, entryID2, entry2);
            DN dN4 = EntryContainer.this.getParentWithinBase(dN);
            if (dN4 != null) {
                object = EntryContainer.this.dn2id.get(transaction, dN4);
                this.id2cBuffered.removeID(((EntryID)object).getDatabaseEntry().getData(), entryID);
            }
            if (dN3 != null) {
                object = EntryContainer.this.dn2id.get(transaction, dN3);
                this.id2cBuffered.insertID(EntryContainer.this.config.getBackendIndexEntryLimit(), ((EntryID)object).getDatabaseEntry().getData(), entryID2);
            }
            object = EntryContainer.this.getParentWithinBase(dN);
            while (object != null) {
                entryID3 = EntryContainer.this.dn2id.get(transaction, (DN)object);
                this.id2sBuffered.removeID(entryID3.getDatabaseEntry().getData(), entryID);
                object = EntryContainer.this.getParentWithinBase((DN)object);
            }
            object = dN3;
            while (object != null) {
                entryID3 = EntryContainer.this.dn2id.get(transaction, (DN)object);
                this.id2sBuffered.insertID(EntryContainer.this.config.getBackendIndexEntryLimit(), entryID3.getDatabaseEntry().getData(), entryID2);
                object = EntryContainer.this.getParentWithinBase((DN)object);
            }
            if (!entryID2.equals(entryID)) {
                this.id2cBuffered.remove(entryID.getDatabaseEntry().getData());
                this.id2sBuffered.remove(entryID.getDatabaseEntry().getData());
            }
            if ((object = DirectoryServer.getEntryCache()) != null) {
                ((EntryCache)object).removeEntry(dN);
            }
        }

        private void renameApexEntry(Transaction transaction, EntryID entryID, Entry entry, Entry entry2) throws DirectoryException, DatabaseException, JebException {
            DN dN = entry.getDN();
            DN dN2 = entry2.getDN();
            EntryContainer.this.dn2id.remove(transaction, dN);
            if (!EntryContainer.this.dn2id.insert(transaction, dN2, entryID)) {
                int n = 8585269;
                String string = MessageHandler.getMessage(n, dN2.toString());
                throw new DirectoryException(ResultCode.ENTRY_ALREADY_EXISTS, string, n);
            }
            EntryContainer.this.dn2uri.replaceEntry(transaction, entry, entry2);
            EntryContainer.this.id2entry.put(transaction, entryID, entry2);
            if (this.modifyDNOperation == null) {
                EntryContainer.this.indexRemoveEntry(transaction, entry, entryID);
                EntryContainer.this.indexInsertEntry(transaction, entry2, entryID);
            } else {
                EntryContainer.this.indexModifications(transaction, entry, entry2, entryID, this.modifyDNOperation.getModifications());
            }
            EntryCache entryCache = DirectoryServer.getEntryCache();
            if (entryCache != null) {
                entryCache.removeEntry(dN);
            }
        }

        private void moveSubordinateEntry(Transaction transaction, EntryID entryID, EntryID entryID2, Entry entry, DN dN) throws JebException, DirectoryException, DatabaseException {
            Object object;
            Object object22;
            DN dN2 = entry.getDN();
            DN dN3 = EntryContainer.this.getParentWithinBase(dN);
            EntryContainer.this.dn2id.remove(transaction, dN2);
            if (!EntryContainer.this.dn2id.insert(transaction, dN, entryID2)) {
                int n = 8585269;
                String string = MessageHandler.getMessage(n, dN.toString());
                throw new DirectoryException(ResultCode.ENTRY_ALREADY_EXISTS, string, n);
            }
            EntryContainer.this.dn2uri.deleteEntry(transaction, entry);
            if (!entryID2.equals(entryID)) {
                EntryContainer.this.id2entry.remove(transaction, entryID);
                for (Object object22 : EntryContainer.this.attrIndexMap.values()) {
                    ((AttributeIndex)object22).removeEntry(transaction, entryID, entry);
                    ((AttributeIndex)object22).addEntry(transaction, entryID2, entry);
                }
            }
            entry.setDN(dN);
            EntryContainer.this.dn2uri.addEntry(transaction, entry);
            EntryContainer.this.id2entry.put(transaction, entryID2, entry);
            if (!entryID2.equals(entryID)) {
                this.id2cBuffered.remove(entryID.getDatabaseEntry().getData());
                this.id2sBuffered.remove(entryID.getDatabaseEntry().getData());
                if (dN3 != null) {
                    object = EntryContainer.this.dn2id.get(transaction, dN3);
                    this.id2cBuffered.insertID(EntryContainer.this.config.getBackendIndexEntryLimit(), ((EntryID)object).getDatabaseEntry().getData(), entryID2);
                }
            }
            object = this.oldSuperiorDN;
            while (object != null) {
                object22 = EntryContainer.this.dn2id.get(transaction, (DN)object);
                this.id2sBuffered.removeID(((EntryID)object22).getDatabaseEntry().getData(), entryID);
                object = EntryContainer.this.getParentWithinBase((DN)object);
            }
            object = dN3;
            while (object != null) {
                if (!entryID2.equals(entryID) || ((DN)object).isAncestorOf(this.newSuperiorDN)) {
                    object22 = EntryContainer.this.dn2id.get(transaction, (DN)object);
                    this.id2sBuffered.insertID(EntryContainer.this.config.getBackendIndexEntryLimit(), ((EntryID)object22).getDatabaseEntry().getData(), entryID2);
                }
                object = EntryContainer.this.getParentWithinBase((DN)object);
            }
            object = DirectoryServer.getEntryCache();
            if (object != null) {
                ((EntryCache)object).removeEntry(dN2);
            }
        }

        private void renameSubordinateEntry(Transaction transaction, EntryID entryID, Entry entry, DN dN) throws DirectoryException, DatabaseException {
            DN dN2 = entry.getDN();
            EntryContainer.this.dn2id.remove(transaction, dN2);
            if (!EntryContainer.this.dn2id.insert(transaction, dN, entryID)) {
                int n = 8585269;
                String string = MessageHandler.getMessage(n, dN.toString());
                throw new DirectoryException(ResultCode.ENTRY_ALREADY_EXISTS, string, n);
            }
            EntryContainer.this.dn2uri.deleteEntry(transaction, entry);
            entry.setDN(dN);
            EntryContainer.this.dn2uri.addEntry(transaction, entry);
            EntryContainer.this.id2entry.put(transaction, entryID, entry);
            EntryCache entryCache = DirectoryServer.getEntryCache();
            if (entryCache != null) {
                entryCache.removeEntry(dN2);
            }
        }

        public void postCommitAction() {
        }
    }

    private class ReplaceEntryTransaction
    implements TransactedOperation {
        private Entry entry;
        private ModifyOperation modifyOperation;
        private EntryID entryID = null;

        public ReplaceEntryTransaction(Entry entry, ModifyOperation modifyOperation) {
            this.entry = entry;
            this.modifyOperation = modifyOperation;
        }

        public Transaction beginOperationTransaction() throws DatabaseException {
            return EntryContainer.this.beginTransaction();
        }

        public void invokeOperation(Transaction transaction) throws DatabaseException, DirectoryException, JebException {
            List<Modification> list;
            this.entryID = EntryContainer.this.dn2id.get(transaction, this.entry.getDN());
            if (this.entryID == null) {
                int n = 8585265;
                String string = MessageHandler.getMessage(n, this.entry.getDN().toString());
                throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, string, n);
            }
            Entry entry = EntryContainer.this.id2entry.get(transaction, this.entryID);
            if (entry == null) {
                int n = 8650763;
                String string = MessageHandler.getMessage(n, this.entryID.toString());
                throw new JebException(n, string);
            }
            if (!EntryContainer.isManageDsaITOperation(this.modifyOperation)) {
                EntryContainer.this.dn2uri.checkTargetForReferral(entry, null);
            }
            if (this.modifyOperation != null) {
                list = this.modifyOperation.getModifications();
                EntryContainer.this.dn2uri.modifyEntry(transaction, entry, this.entry, list);
            } else {
                EntryContainer.this.dn2uri.replaceEntry(transaction, entry, this.entry);
            }
            EntryContainer.this.id2entry.put(transaction, this.entryID, this.entry);
            if (this.modifyOperation != null) {
                list = this.modifyOperation.getModifications();
                EntryContainer.this.indexModifications(transaction, entry, this.entry, this.entryID, list);
            } else {
                EntryContainer.this.indexRemoveEntry(transaction, entry, this.entryID);
                EntryContainer.this.indexInsertEntry(transaction, this.entry, this.entryID);
            }
        }

        public void postCommitAction() {
            EntryCache entryCache = DirectoryServer.getEntryCache();
            if (entryCache != null) {
                entryCache.putEntry(this.entry, EntryContainer.this.backend, this.entryID.longValue());
            }
        }
    }

    private class GetEntryByIDOperation
    implements TransactedOperation {
        private Entry entry = null;
        private EntryID entryID;

        public GetEntryByIDOperation(EntryID entryID) {
            this.entryID = entryID;
        }

        public Entry getEntry() {
            return this.entry;
        }

        public EntryID getEntryID() {
            return this.entryID;
        }

        public Transaction beginOperationTransaction() throws DatabaseException {
            return null;
        }

        public void invokeOperation(Transaction transaction) throws DatabaseException, DirectoryException, JebException {
            this.entry = EntryContainer.this.id2entry.get(transaction, this.entryID);
        }

        public void postCommitAction() {
        }
    }

    private class GetEntryByDNOperation
    implements TransactedOperation {
        private Entry entry = null;
        private EntryID entryID = null;
        DN entryDN;

        public GetEntryByDNOperation(DN dN) {
            this.entryDN = dN;
        }

        public Entry getEntry() {
            return this.entry;
        }

        public EntryID getEntryID() {
            return this.entryID;
        }

        public Transaction beginOperationTransaction() throws DatabaseException {
            return null;
        }

        public void invokeOperation(Transaction transaction) throws DatabaseException, DirectoryException, JebException {
            this.entryID = EntryContainer.this.dn2id.get(transaction, this.entryDN);
            if (this.entryID == null) {
                EntryContainer.this.dn2uri.targetEntryReferrals(this.entryDN, null);
                return;
            }
            this.entry = EntryContainer.this.id2entry.get(transaction, this.entryID);
            if (this.entry == null) {
                int n = 8650763;
                String string = MessageHandler.getMessage(n, this.entryID.toString());
                throw new JebException(n, string);
            }
        }

        public void postCommitAction() {
        }
    }

    private class DeleteEntryTransaction
    implements TransactedOperation {
        private DN entryDN;
        private DeleteOperation deleteOperation;
        private ArrayList<DN> deletedDNList;
        private boolean adminSizeLimitExceeded = false;

        public DeleteEntryTransaction(DN dN, DeleteOperation deleteOperation) {
            this.entryDN = dN;
            this.deleteOperation = deleteOperation;
            this.deletedDNList = new ArrayList();
        }

        public boolean adminSizeLimitExceeded() {
            return this.adminSizeLimitExceeded;
        }

        public int getDeletedEntryCount() {
            return this.deletedDNList.size();
        }

        public Transaction beginOperationTransaction() throws DatabaseException {
            return EntryContainer.this.beginTransaction();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invokeOperation(Transaction transaction) throws DatabaseException, DirectoryException, JebException {
            EntryContainer.this.dn2uri.targetEntryReferrals(this.entryDN, null);
            int n = EntryContainer.this.config.getSubtreeDeleteSizeLimit();
            boolean bl = false;
            List<Control> list = this.deleteOperation.getRequestControls();
            if (list != null) {
                for (Control object2 : list) {
                    if (!object2.getOID().equals("1.2.840.113556.1.4.805")) continue;
                    bl = true;
                }
            }
            Object object3 = StaticUtils.getBytes("," + this.entryDN.toNormalizedString());
            byte[] byArray = (byte[])object3.clone();
            byArray[0] = (byte)(byArray[0] + 1);
            Object object = object3;
            DatabaseEntry databaseEntry = new DatabaseEntry();
            DatabaseEntry databaseEntry2 = new DatabaseEntry(byArray);
            BufferedIndex bufferedIndex = new BufferedIndex(EntryContainer.this.id2children, transaction);
            BufferedIndex bufferedIndex2 = new BufferedIndex(EntryContainer.this.id2subtree, transaction);
            Cursor cursor = EntryContainer.this.dn2id.openCursor(transaction, null);
            try {
                OperationStatus bl2 = cursor.getSearchKeyRange(databaseEntry2, databaseEntry, LockMode.DEFAULT);
                if (bl2 == OperationStatus.NOTFOUND) {
                    bl2 = cursor.getLast(databaseEntry2, databaseEntry, LockMode.DEFAULT);
                }
                while (bl2 == OperationStatus.SUCCESS && EntryContainer.this.dn2idComparator.compare(databaseEntry2.getData(), byArray) >= 0) {
                    bl2 = cursor.getPrev(databaseEntry2, databaseEntry, LockMode.DEFAULT);
                }
                while (bl2 == OperationStatus.SUCCESS) {
                    Object object2;
                    int n2 = EntryContainer.this.dn2idComparator.compare(databaseEntry2.getData(), object);
                    if (n2 < 0) {
                        break;
                    }
                    if (!bl) {
                        int n3 = 8585268;
                        object2 = MessageHandler.getMessage(n3, this.entryDN.toString());
                        throw new DirectoryException(ResultCode.NOT_ALLOWED_ON_NONLEAF, (String)object2, n3);
                    }
                    if (n > 0 && this.deletedDNList.size() >= n) {
                        this.adminSizeLimitExceeded = true;
                        break;
                    }
                    EntryID n3 = new EntryID(databaseEntry);
                    object2 = DN.decode(new ASN1OctetString(databaseEntry2.getData()));
                    EntryContainer.this.deleteLeaf(bufferedIndex, bufferedIndex2, transaction, (DN)object2, n3);
                    this.deletedDNList.add((DN)object2);
                    bl2 = cursor.getPrev(databaseEntry2, databaseEntry, LockMode.DEFAULT);
                }
            }
            finally {
                cursor.close();
            }
            if (!this.adminSizeLimitExceeded) {
                if (n > 0 && this.deletedDNList.size() >= n) {
                    this.adminSizeLimitExceeded = true;
                } else {
                    boolean bl2 = bl ? true : EntryContainer.isManageDsaITOperation(this.deleteOperation);
                    EntryContainer.this.deleteTarget(bl2, bufferedIndex, bufferedIndex2, transaction, this.entryDN);
                    this.deletedDNList.add(this.entryDN);
                }
            }
            bufferedIndex.flush();
            bufferedIndex2.flush();
            EntryContainer.this.id2entry.adjustRecordCount(transaction, -this.getDeletedEntryCount());
        }

        public void postCommitAction() {
            EntryCache entryCache = DirectoryServer.getEntryCache();
            if (entryCache != null) {
                for (DN dN : this.deletedDNList) {
                    entryCache.removeEntry(dN);
                }
            }
        }
    }

    private class AddEntryTransaction
    implements TransactedOperation {
        private Entry entry;
        DN parentDN;
        EntryID entryID = null;

        public Transaction beginOperationTransaction() throws DatabaseException {
            return EntryContainer.this.beginTransaction();
        }

        public AddEntryTransaction(Entry entry) {
            this.entry = entry;
            this.parentDN = EntryContainer.this.getParentWithinBase(entry.getDN());
        }

        public void invokeOperation(Transaction transaction) throws DatabaseException, DirectoryException, JebException {
            if (EntryContainer.this.dn2id.get(transaction, this.entry.getDN()) != null) {
                int n = 0x830033;
                String string = MessageHandler.getMessage(n, this.entry.getDN().toString());
                throw new DirectoryException(ResultCode.ENTRY_ALREADY_EXISTS, string, n);
            }
            EntryID entryID = null;
            if (this.parentDN != null) {
                EntryContainer.this.dn2uri.targetEntryReferrals(this.entry.getDN(), null);
                entryID = EntryContainer.this.dn2id.get(transaction, this.parentDN);
                if (entryID == null) {
                    int n = 8585263;
                    String string = MessageHandler.getMessage(n, this.entry.getDN().toString());
                    throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, string, n);
                }
            }
            if (this.entryID == null) {
                this.entryID = EntryContainer.this.rootContainer.getNextEntryID();
            }
            if (!EntryContainer.this.dn2id.insert(transaction, this.entry.getDN(), this.entryID)) {
                int n = 0x830033;
                String string = MessageHandler.getMessage(n, this.entry.getDN().toString());
                throw new DirectoryException(ResultCode.ENTRY_ALREADY_EXISTS, string, n);
            }
            EntryContainer.this.dn2uri.addEntry(transaction, this.entry);
            if (!EntryContainer.this.id2entry.insert(transaction, this.entryID, this.entry)) {
                int n = 0x830033;
                String string = MessageHandler.getMessage(n, this.entry.getDN().toString());
                throw new DirectoryException(ResultCode.ENTRY_ALREADY_EXISTS, string, n);
            }
            EntryContainer.this.indexInsertEntry(transaction, this.entry, this.entryID);
            if (this.parentDN != null) {
                EntryContainer.this.id2children.insertID(transaction, entryID.getDatabaseEntry(), this.entryID);
                EntryContainer.this.id2subtree.insertID(transaction, entryID.getDatabaseEntry(), this.entryID);
                DN dN = EntryContainer.this.getParentWithinBase(this.parentDN);
                while (dN != null) {
                    EntryID entryID2 = EntryContainer.this.dn2id.get(transaction, dN);
                    if (entryID2 == null) {
                        int n = 8650762;
                        String string = MessageHandler.getMessage(n, dN.toNormalizedString());
                        throw new JebException(n, string);
                    }
                    EntryContainer.this.id2subtree.insertID(transaction, entryID2.getDatabaseEntry(), this.entryID);
                    dN = EntryContainer.this.getParentWithinBase(dN);
                }
            }
            EntryContainer.this.id2entry.adjustRecordCount(transaction, 1L);
        }

        public void postCommitAction() {
            EntryCache entryCache = DirectoryServer.getEntryCache();
            if (entryCache != null) {
                entryCache.putEntry(this.entry, EntryContainer.this.backend, this.entryID.longValue());
            }
        }
    }

    private static interface TransactedOperation {
        public Transaction beginOperationTransaction() throws DatabaseException;

        public void invokeOperation(Transaction var1) throws DatabaseException, DirectoryException, JebException;

        public void postCommitAction();
    }
}

