/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.opends.server.backends.jeb.EntryContainer;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.SearchOperation;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.LDAPURL;
import org.opends.server.types.Modification;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchResultReference;
import org.opends.server.types.SearchScope;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DN2URI {
    private static final String CLASS_NAME = "org.opends.server.backends.jeb.EntryContainer";
    public AttributeType referralType = DirectoryServer.getAttributeType("ref");
    private EntryContainer entryContainer;
    private DatabaseConfig dbConfig;
    private String name;
    Comparator<byte[]> comparator = new EntryContainer.KeyReverseComparator();
    private ThreadLocal<Database> threadLocalDatabase = new ThreadLocal();

    public DN2URI(EntryContainer entryContainer, DatabaseConfig databaseConfig, String string) {
        this.entryContainer = entryContainer;
        this.dbConfig = databaseConfig;
        this.name = string;
    }

    public void open() throws DatabaseException {
        this.getDatabase();
    }

    private Database getDatabase() throws DatabaseException {
        Database database = this.threadLocalDatabase.get();
        if (database == null) {
            database = this.entryContainer.openDatabase(this.dbConfig, this.name);
            this.threadLocalDatabase.set(database);
        }
        return database;
    }

    public boolean insert(Transaction transaction, DN dN, String string) throws DatabaseException {
        byte[] byArray = StaticUtils.getBytes(dN.toNormalizedString());
        byte[] byArray2 = StaticUtils.getBytes(string);
        DatabaseEntry databaseEntry = new DatabaseEntry(byArray);
        DatabaseEntry databaseEntry2 = new DatabaseEntry(byArray2);
        OperationStatus operationStatus = EntryContainer.put(this.getDatabase(), transaction, databaseEntry, databaseEntry2);
        return operationStatus == OperationStatus.SUCCESS;
    }

    public boolean delete(Transaction transaction, DN dN) throws DatabaseException {
        byte[] byArray = StaticUtils.getBytes(dN.toNormalizedString());
        DatabaseEntry databaseEntry = new DatabaseEntry(byArray);
        OperationStatus operationStatus = EntryContainer.delete(this.getDatabase(), transaction, databaseEntry);
        return operationStatus == OperationStatus.SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(Transaction transaction, DN dN, String string) throws DatabaseException {
        OperationStatus operationStatus;
        CursorConfig cursorConfig = null;
        byte[] byArray = StaticUtils.getBytes(dN.toNormalizedString());
        byte[] byArray2 = StaticUtils.getBytes(string);
        DatabaseEntry databaseEntry = new DatabaseEntry(byArray);
        DatabaseEntry databaseEntry2 = new DatabaseEntry(byArray2);
        Cursor cursor = this.getDatabase().openCursor(transaction, cursorConfig);
        try {
            operationStatus = cursor.getSearchBoth(databaseEntry, databaseEntry2, null);
            if (operationStatus == OperationStatus.SUCCESS) {
                operationStatus = cursor.delete();
            }
        }
        finally {
            cursor.close();
        }
        return operationStatus == OperationStatus.SUCCESS;
    }

    public void modifyEntry(Transaction transaction, Entry entry, Entry entry2, List<Modification> list) throws DatabaseException {
        DN dN = entry.getDN();
        block6: for (Modification modification : list) {
            Attribute attribute = modification.getAttribute();
            AttributeType attributeType = attribute.getAttributeType();
            if (!attributeType.equals(this.referralType)) continue;
            Attribute attribute2 = modification.getAttribute();
            switch (modification.getModificationType()) {
                case ADD: {
                    if (attribute2 == null) break;
                    for (AttributeValue attributeValue : attribute2.getValues()) {
                        this.insert(transaction, dN, attributeValue.getStringValue());
                    }
                    continue block6;
                }
                case DELETE: {
                    if (attribute2 == null || !attribute2.hasValue()) {
                        this.delete(transaction, dN);
                        break;
                    }
                    for (AttributeValue attributeValue : attribute2.getValues()) {
                        this.delete(transaction, dN, attributeValue.getStringValue());
                    }
                    continue block6;
                }
                case INCREMENT: {
                    break;
                }
                case REPLACE: {
                    this.delete(transaction, dN);
                    if (attribute2 == null) break;
                    for (AttributeValue attributeValue : attribute2.getValues()) {
                        this.insert(transaction, dN, attributeValue.getStringValue());
                    }
                    break;
                }
            }
        }
    }

    public void replaceEntry(Transaction transaction, Entry entry, Entry entry2) throws DatabaseException {
        this.deleteEntry(transaction, entry);
        this.addEntry(transaction, entry2);
    }

    public void addEntry(Transaction transaction, Entry entry) throws DatabaseException {
        LinkedHashSet<String> linkedHashSet = entry.getReferralURLs();
        if (linkedHashSet != null) {
            DN dN = entry.getDN();
            for (String string : linkedHashSet) {
                this.insert(transaction, dN, string);
            }
        }
    }

    public void deleteEntry(Transaction transaction, Entry entry) throws DatabaseException {
        LinkedHashSet<String> linkedHashSet = entry.getReferralURLs();
        if (linkedHashSet != null) {
            this.delete(transaction, entry.getDN());
        }
    }

    public void checkTargetForReferral(Entry entry, SearchScope searchScope) throws DirectoryException {
        LinkedHashSet<String> linkedHashSet = entry.getReferralURLs();
        if (linkedHashSet != null) {
            this.throwReferralException(entry.getDN(), entry.getDN(), linkedHashSet, searchScope);
        }
    }

    public void throwReferralException(DN dN, DN dN2, Set<String> set, SearchScope searchScope) throws DirectoryException {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>(set.size());
        Iterator<String> iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2;
            block8: {
                string2 = string = iterator.next();
                int n = string.indexOf(32);
                if (n != -1) {
                    string2 = string.substring(0, n);
                }
                try {
                    LDAPURL lDAPURL = LDAPURL.decode(string2, false);
                    if (lDAPURL.getScheme().equalsIgnoreCase("ldap")) {
                        DN dN3 = dN;
                        if (!dN2.equals(lDAPURL.getBaseDN())) {
                            dN3 = EntryContainer.modDN(dN, dN2.getNumComponents(), lDAPURL.getBaseDN());
                        }
                        lDAPURL.setBaseDN(dN3);
                        if (searchScope == null) {
                            StringBuilder stringBuilder = new StringBuilder(string2.length());
                            lDAPURL.toString(stringBuilder, true);
                            string2 = stringBuilder.toString();
                        } else {
                            lDAPURL.getAttributes().clear();
                            lDAPURL.setScope(searchScope);
                            lDAPURL.setFilter(null);
                            string2 = lDAPURL.toString();
                        }
                    }
                }
                catch (DirectoryException directoryException) {
                    if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "throwReferralException", directoryException)) break block8;
                    throw new AssertionError();
                }
            }
            arrayList.add(string2);
        }
        int n = 0x800070;
        string = MessageHandler.getMessage(n, dN2);
        throw new DirectoryException(ResultCode.REFERRAL, string, n, dN2, arrayList, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void targetEntryReferrals(DN dN, SearchScope searchScope) throws DirectoryException {
        block10: {
            Transaction transaction = null;
            CursorConfig cursorConfig = null;
            try {
                Cursor cursor = this.getDatabase().openCursor(transaction, cursorConfig);
                try {
                    DatabaseEntry databaseEntry = new DatabaseEntry();
                    DatabaseEntry databaseEntry2 = new DatabaseEntry();
                    DN dN2 = this.entryContainer.getParentWithinBase(dN);
                    while (dN2 != null) {
                        String string = dN2.toNormalizedString();
                        databaseEntry.setData(StaticUtils.getBytes(string));
                        OperationStatus operationStatus = cursor.getSearchKey(databaseEntry, databaseEntry2, LockMode.DEFAULT);
                        if (operationStatus == OperationStatus.SUCCESS) {
                            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(cursor.count());
                            do {
                                String string2 = new String(databaseEntry2.getData(), "UTF-8");
                                linkedHashSet.add(string2);
                            } while ((operationStatus = cursor.getNextDup(databaseEntry, databaseEntry2, LockMode.DEFAULT)) == OperationStatus.SUCCESS);
                            this.throwReferralException(dN, dN2, linkedHashSet, searchScope);
                        }
                        dN2 = this.entryContainer.getParentWithinBase(dN2);
                    }
                }
                finally {
                    cursor.close();
                }
            }
            catch (DatabaseException databaseException) {
                assert (Debug.debugException(CLASS_NAME, "targetEntryReferrals", databaseException));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "targetEntryReferrals", unsupportedEncodingException)) break block10;
                throw new AssertionError();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean returnSearchReferences(SearchOperation searchOperation) throws DirectoryException {
        Transaction transaction = null;
        CursorConfig cursorConfig = null;
        DN dN = searchOperation.getBaseDN();
        String string = dN.toNormalizedString();
        byte[] byArray = StaticUtils.getBytes("," + string);
        byte[] byArray2 = (byte[])byArray.clone();
        byArray2[0] = (byte)(byArray2[0] + 1);
        DatabaseEntry databaseEntry = new DatabaseEntry();
        DatabaseEntry databaseEntry2 = new DatabaseEntry(byArray);
        try {
            Cursor cursor = this.getDatabase().openCursor(transaction, cursorConfig);
            try {
                OperationStatus operationStatus = cursor.getSearchKeyRange(databaseEntry2, databaseEntry, LockMode.DEFAULT);
                while (operationStatus == OperationStatus.SUCCESS) {
                    int n = this.comparator.compare(databaseEntry2.getData(), byArray2);
                    if (n >= 0) {
                        return true;
                    }
                    DN dN2 = DN.decode(new ASN1OctetString(databaseEntry2.getData()));
                    if (searchOperation.getScope() != SearchScope.SINGLE_LEVEL || dN2.getNumComponents() == dN.getNumComponents() + 1) {
                        Object object;
                        ArrayList<String> arrayList = new ArrayList<String>(cursor.count());
                        do {
                            String string2;
                            block19: {
                                object = new String(databaseEntry.getData(), "UTF-8");
                                string2 = object;
                                int n2 = ((String)object).indexOf(32);
                                if (n2 != -1) {
                                    string2 = ((String)object).substring(0, n2);
                                }
                                try {
                                    LDAPURL lDAPURL = LDAPURL.decode(string2, false);
                                    if (lDAPURL.getScheme().equalsIgnoreCase("ldap")) {
                                        if (lDAPURL.getBaseDN().isNullDN()) {
                                            lDAPURL.setBaseDN(dN2);
                                        }
                                        lDAPURL.getAttributes().clear();
                                        if (searchOperation.getScope() == SearchScope.SINGLE_LEVEL) {
                                            lDAPURL.setScope(SearchScope.BASE_OBJECT);
                                        } else {
                                            lDAPURL.setScope(SearchScope.WHOLE_SUBTREE);
                                        }
                                        lDAPURL.setFilter(null);
                                        string2 = lDAPURL.toString();
                                    }
                                }
                                catch (DirectoryException directoryException) {
                                    if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "returnSearchReferences", directoryException)) break block19;
                                    throw new AssertionError();
                                }
                            }
                            arrayList.add(string2);
                        } while ((operationStatus = cursor.getNextDup(databaseEntry2, databaseEntry, LockMode.DEFAULT)) == OperationStatus.SUCCESS);
                        object = new SearchResultReference(arrayList);
                        if (!searchOperation.returnReference((SearchResultReference)object)) {
                            boolean bl = false;
                            return bl;
                        }
                    }
                    operationStatus = cursor.getNextNoDup(databaseEntry2, databaseEntry, LockMode.DEFAULT);
                }
                return true;
            }
            finally {
                cursor.close();
            }
        }
        catch (DatabaseException databaseException) {
            if ($assertionsDisabled) return true;
            if (Debug.debugException(CLASS_NAME, "returnSearchReferences", databaseException)) return true;
            throw new AssertionError();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if ($assertionsDisabled) return true;
            if (Debug.debugException(CLASS_NAME, "returnSearchReferences", unsupportedEncodingException)) return true;
            throw new AssertionError();
        }
    }
}

