/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.config.ConfigParam;
import com.sleepycat.je.config.EnvironmentParams;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opends.server.api.ConfigurableComponent;
import org.opends.server.config.BooleanConfigAttribute;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.config.IntegerConfigAttribute;
import org.opends.server.config.IntegerWithUnitConfigAttribute;
import org.opends.server.config.StringConfigAttribute;
import org.opends.server.core.DirectoryServer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.ResultCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurableEnvironment
implements ConfigurableComponent {
    private DN configDN;
    private Environment environment;
    public static final String ATTR_DATABASE_CACHE_PERCENT = "ds-cfg-database-cache-percent";
    public static final String ATTR_DATABASE_CACHE_SIZE = "ds-cfg-database-cache-size";
    public static final String ATTR_DATABASE_TXN_NO_SYNC = "ds-cfg-database-txn-no-sync";
    public static final String ATTR_DATABASE_TXN_WRITE_NO_SYNC = "ds-cfg-database-txn-write-no-sync";
    public static final String ATTR_DATABASE_RUN_CLEANER = "ds-cfg-database-run-cleaner";
    public static final String ATTR_CLEANER_MIN_UTILIZATION = "ds-cfg-database-cleaner-min-utilization";
    public static final String ATTR_DATABASE_LOG_FILE_MAX = "ds-cfg-database-log-file-max";
    public static final String ATTR_EVICTOR_LRU_ONLY = "ds-cfg-database-evictor-lru-only";
    public static final String ATTR_EVICTOR_NODES_PER_SCAN = "ds-cfg-database-evictor-nodes-per-scan";
    public static final String ATTR_LOGGING_FILE_HANDLER_ON = "ds-cfg-database-logging-file-handler-on";
    public static final String ATTR_LOGGING_LEVEL = "ds-cfg-database-logging-level";
    public static final String ATTR_CHECKPOINTER_BYTES_INTERVAL = "ds-cfg-database-checkpointer-bytes-interval";
    public static final String ATTR_CHECKPOINTER_WAKEUP_INTERVAL = "ds-cfg-database-checkpointer-wakeup-interval";
    public static final String ATTR_NUM_LOCK_TABLES = "ds-cfg-database-lock-num-lock-tables";
    public static final String ATTR_NUM_CLEANER_THREADS = "ds-cfg-database-cleaner-num-threads";
    private static HashMap<String, ConfigAttribute> configAttrMap = new HashMap();
    private static ArrayList<ConfigAttribute> configAttrList = new ArrayList();
    private static final ConfigAttribute CONFIG_ATTR_CACHE_PERCENT;
    private static final ConfigAttribute CONFIG_ATTR_CACHE_SIZE;
    private static final ConfigAttribute CONFIG_ATTR_TXN_NO_SYNC;
    private static final ConfigAttribute CONFIG_ATTR_TXN_WRITE_NO_SYNC;
    private static final ConfigAttribute CONFIG_ATTR_RUN_CLEANER;
    private static final ConfigAttribute CONFIG_ATTR_CLEANER_MIN_UTILIZATION;
    private static final ConfigAttribute CONFIG_ATTR_EVICTOR_LRU_ONLY;
    private static final ConfigAttribute CONFIG_ATTR_EVICTOR_NODES_PER_SCAN;
    private static final ConfigAttribute CONFIG_ATTR_LOG_FILE_MAX;
    private static final ConfigAttribute CONFIG_ATTR_LOGGING_FILE_HANDLER_ON;
    private static final ConfigAttribute CONFIG_ATTR_LOGGING_LEVEL;
    private static final ConfigAttribute CONFIG_ATTR_CHECKPOINTER_BYTES_INTERVAL;
    private static final ConfigAttribute CONFIG_ATTR_CHECKPOINTER_WAKEUP_INTERVAL;
    private static final ConfigAttribute CONFIG_ATTR_NUM_LOCK_TABLES;
    private static final ConfigAttribute CONFIG_ATTR_NUM_CLEANER_THREADS;

    private static void registerPropertyAttribute(String string, ConfigAttribute configAttribute) {
        configAttrMap.put(string, configAttribute);
        configAttrList.add(configAttribute);
    }

    public ConfigurableEnvironment(DN dN, Environment environment) {
        this.configDN = dN;
        this.environment = environment;
    }

    public static EnvironmentConfig defaultConfig() {
        EnvironmentConfig environmentConfig = new EnvironmentConfig();
        environmentConfig.setTransactional(true);
        environmentConfig.setAllowCreate(true);
        environmentConfig.setConfigParam("je.env.sharedLatches", "true");
        environmentConfig.setConfigParam("je.cleaner.expunge", "true");
        return environmentConfig;
    }

    public static EnvironmentConfig parseConfigEntry(ConfigEntry configEntry) throws ConfigException {
        EnvironmentConfig environmentConfig = ConfigurableEnvironment.defaultConfig();
        BooleanConfigAttribute booleanConfigAttribute = (BooleanConfigAttribute)configEntry.getConfigAttribute(CONFIG_ATTR_TXN_NO_SYNC);
        if (booleanConfigAttribute != null) {
            environmentConfig.setTxnNoSync(booleanConfigAttribute.activeValue());
        }
        if ((booleanConfigAttribute = (BooleanConfigAttribute)configEntry.getConfigAttribute(CONFIG_ATTR_TXN_WRITE_NO_SYNC)) != null) {
            environmentConfig.setTxnWriteNoSync(booleanConfigAttribute.activeValue());
        }
        for (Map.Entry<String, ConfigAttribute> entry : configAttrMap.entrySet()) {
            ConfigAttribute configAttribute;
            String string = entry.getKey();
            ConfigAttribute configAttribute2 = entry.getValue();
            ConfigAttribute configAttribute3 = configEntry.getConfigAttribute(configAttribute2);
            if (configAttribute2 == null) continue;
            if (configAttribute3 instanceof BooleanConfigAttribute) {
                configAttribute = (BooleanConfigAttribute)configAttribute3;
                boolean bl = ((BooleanConfigAttribute)configAttribute).activeValue();
                environmentConfig.setConfigParam(string, String.valueOf(bl));
                continue;
            }
            if (configAttribute3 instanceof IntegerConfigAttribute) {
                configAttribute = (IntegerConfigAttribute)configAttribute3;
                long l = ((IntegerConfigAttribute)configAttribute).activeValue();
                environmentConfig.setConfigParam(string, String.valueOf(l));
                continue;
            }
            if (configAttribute3 instanceof IntegerWithUnitConfigAttribute) {
                configAttribute = (IntegerWithUnitConfigAttribute)configAttribute3;
                long l = ((IntegerWithUnitConfigAttribute)configAttribute).activeCalculatedValue();
                environmentConfig.setConfigParam(string, String.valueOf(l));
                continue;
            }
            if (!(configAttribute3 instanceof StringConfigAttribute)) continue;
            configAttribute = (StringConfigAttribute)configAttribute3;
            String string2 = ((StringConfigAttribute)configAttribute).activeValue();
            environmentConfig.setConfigParam(string, string2);
        }
        return environmentConfig;
    }

    @Override
    public DN getConfigurableComponentEntryDN() {
        return this.configDN;
    }

    @Override
    public List<ConfigAttribute> getConfigurationAttributes() {
        return configAttrList;
    }

    @Override
    public boolean hasAcceptableConfiguration(ConfigEntry configEntry, List<String> list) {
        return true;
    }

    @Override
    public ConfigChangeResult applyNewConfiguration(ConfigEntry configEntry, boolean bl) {
        boolean bl2 = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            EnvironmentConfig environmentConfig = this.environment.getConfig();
            EnvironmentConfig environmentConfig2 = ConfigurableEnvironment.parseConfigEntry(configEntry);
            Map map = EnvironmentParams.SUPPORTED_PARAMS;
            for (Object v : map.values()) {
                ConfigAttribute configAttribute;
                String string;
                String string2;
                ConfigParam configParam = (ConfigParam)v;
                if (configParam.isMutable() || (string2 = environmentConfig.getConfigParam(configParam.getName())).equalsIgnoreCase(string = environmentConfig2.getConfigParam(configParam.getName()))) continue;
                bl2 = true;
                if (!bl || (configAttribute = configAttrMap.get(configParam.getName())) == null) continue;
                int n = 0x800082;
                arrayList.add(MessageHandler.getMessage(n, configAttribute.getName()));
            }
            this.environment.setMutableConfig((EnvironmentMutableConfig)environmentConfig2);
        }
        catch (Exception exception) {
            arrayList.add(exception.getMessage());
            ConfigChangeResult configChangeResult = new ConfigChangeResult(DirectoryServer.getServerErrorResultCode(), bl2, arrayList);
            return configChangeResult;
        }
        ConfigChangeResult configChangeResult = new ConfigChangeResult(ResultCode.SUCCESS, bl2, arrayList);
        return configChangeResult;
    }

    static {
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        hashMap.put("b", 1.0);
        hashMap.put("bytes", 1.0);
        hashMap.put("kb", 1000.0);
        hashMap.put("kilobytes", 1000.0);
        hashMap.put("mb", 1000000.0);
        hashMap.put("megabytes", 1000000.0);
        hashMap.put("gb", 1.0E9);
        hashMap.put("gigabytes", 1.0E9);
        hashMap.put("kib", 1024.0);
        hashMap.put("kibibytes", 1024.0);
        hashMap.put("mib", 1048576.0);
        hashMap.put("mebibytes", 1048576.0);
        hashMap.put("gib", 1.073741824E9);
        hashMap.put("gibibytes", 1.073741824E9);
        HashMap<String, Double> hashMap2 = new HashMap<String, Double>();
        hashMap2.put("us", 1.0);
        hashMap2.put("microseconds", 1.0);
        hashMap2.put("ms", 1000.0);
        hashMap2.put("milliseconds", 1000.0);
        hashMap2.put("s", 1000000.0);
        hashMap2.put("seconds", 1000000.0);
        hashMap2.put("m", 6.0E7);
        hashMap2.put("minutes", 6.0E7);
        String string = MessageHandler.getMessage(8388629);
        CONFIG_ATTR_TXN_NO_SYNC = new BooleanConfigAttribute(ATTR_DATABASE_TXN_NO_SYNC, string, false);
        string = MessageHandler.getMessage(8388630);
        CONFIG_ATTR_TXN_WRITE_NO_SYNC = new BooleanConfigAttribute(ATTR_DATABASE_TXN_WRITE_NO_SYNC, string, false);
        string = MessageHandler.getMessage(8388627);
        CONFIG_ATTR_CACHE_PERCENT = new IntegerConfigAttribute(ATTR_DATABASE_CACHE_PERCENT, string, true, false, false, true, 1L, true, 90L);
        string = MessageHandler.getMessage(8388628);
        CONFIG_ATTR_CACHE_SIZE = new IntegerWithUnitConfigAttribute(ATTR_DATABASE_CACHE_SIZE, string, false, hashMap, true, 0L, false, 0L);
        string = MessageHandler.getMessage(8388631);
        CONFIG_ATTR_RUN_CLEANER = new BooleanConfigAttribute(ATTR_DATABASE_RUN_CLEANER, string, false);
        string = MessageHandler.getMessage(0x800022);
        CONFIG_ATTR_CLEANER_MIN_UTILIZATION = new IntegerConfigAttribute(ATTR_CLEANER_MIN_UTILIZATION, string, true, false, true, true, 0L, true, 100L);
        string = MessageHandler.getMessage(8388667);
        CONFIG_ATTR_EVICTOR_LRU_ONLY = new BooleanConfigAttribute(ATTR_EVICTOR_LRU_ONLY, string, true);
        string = MessageHandler.getMessage(8388668);
        CONFIG_ATTR_EVICTOR_NODES_PER_SCAN = new IntegerConfigAttribute(ATTR_EVICTOR_NODES_PER_SCAN, string, false, false, true, true, 1L, true, 1000L);
        string = MessageHandler.getMessage(8388689);
        CONFIG_ATTR_LOG_FILE_MAX = new IntegerWithUnitConfigAttribute(ATTR_DATABASE_LOG_FILE_MAX, string, false, hashMap, true, 1000000L, true, 0x100000000L);
        string = MessageHandler.getMessage(8388721);
        CONFIG_ATTR_LOGGING_FILE_HANDLER_ON = new BooleanConfigAttribute(ATTR_LOGGING_FILE_HANDLER_ON, string, true);
        string = MessageHandler.getMessage(8388722);
        CONFIG_ATTR_LOGGING_LEVEL = new StringConfigAttribute(ATTR_LOGGING_LEVEL, string, false, false, true);
        string = MessageHandler.getMessage(8388723);
        CONFIG_ATTR_CHECKPOINTER_BYTES_INTERVAL = new IntegerWithUnitConfigAttribute(ATTR_CHECKPOINTER_BYTES_INTERVAL, string, true, hashMap, true, 0L, false, 0L);
        string = MessageHandler.getMessage(8388724);
        CONFIG_ATTR_CHECKPOINTER_WAKEUP_INTERVAL = new IntegerWithUnitConfigAttribute(ATTR_CHECKPOINTER_WAKEUP_INTERVAL, string, true, hashMap2, true, 1000000L, false, 0L);
        string = MessageHandler.getMessage(8388726);
        CONFIG_ATTR_NUM_LOCK_TABLES = new IntegerConfigAttribute(ATTR_NUM_LOCK_TABLES, string, false, false, true, true, 1L, true, 32767L);
        string = MessageHandler.getMessage(8388733);
        CONFIG_ATTR_NUM_CLEANER_THREADS = new IntegerConfigAttribute(ATTR_NUM_CLEANER_THREADS, string, false, false, false, true, 1L, false, 0L);
        ConfigurableEnvironment.registerPropertyAttribute("je.maxMemoryPercent", CONFIG_ATTR_CACHE_PERCENT);
        ConfigurableEnvironment.registerPropertyAttribute("je.maxMemory", CONFIG_ATTR_CACHE_SIZE);
        ConfigurableEnvironment.registerPropertyAttribute("je.cleaner.minUtilization", CONFIG_ATTR_CLEANER_MIN_UTILIZATION);
        ConfigurableEnvironment.registerPropertyAttribute("je.env.runCleaner", CONFIG_ATTR_RUN_CLEANER);
        ConfigurableEnvironment.registerPropertyAttribute("je.evictor.lruOnly", CONFIG_ATTR_EVICTOR_LRU_ONLY);
        ConfigurableEnvironment.registerPropertyAttribute("je.evictor.nodesPerScan", CONFIG_ATTR_EVICTOR_NODES_PER_SCAN);
        ConfigurableEnvironment.registerPropertyAttribute("je.log.fileMax", CONFIG_ATTR_LOG_FILE_MAX);
        ConfigurableEnvironment.registerPropertyAttribute("java.util.logging.FileHandler.on", CONFIG_ATTR_LOGGING_FILE_HANDLER_ON);
        ConfigurableEnvironment.registerPropertyAttribute("java.util.logging.level", CONFIG_ATTR_LOGGING_LEVEL);
        ConfigurableEnvironment.registerPropertyAttribute("je.checkpointer.bytesInterval", CONFIG_ATTR_CHECKPOINTER_BYTES_INTERVAL);
        ConfigurableEnvironment.registerPropertyAttribute("je.checkpointer.wakeupInterval", CONFIG_ATTR_CHECKPOINTER_WAKEUP_INTERVAL);
        ConfigurableEnvironment.registerPropertyAttribute("je.lock.nLockTables", CONFIG_ATTR_NUM_LOCK_TABLES);
        ConfigurableEnvironment.registerPropertyAttribute("je.cleaner.threads", CONFIG_ATTR_NUM_CLEANER_THREADS);
        configAttrList.add(CONFIG_ATTR_TXN_NO_SYNC);
        configAttrList.add(CONFIG_ATTR_TXN_WRITE_NO_SYNC);
    }
}

