/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.Mac;
import org.opends.server.backends.jeb.Config;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.BackupConfig;
import org.opends.server.types.BackupDirectory;
import org.opends.server.types.BackupInfo;
import org.opends.server.types.CryptoManager;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.RestoreConfig;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackupManager {
    public static final String BACKUP_BASE_FILENAME = "backup-";
    public static final String PROPERTY_LAST_LOGFILE_NAME = "last_logfile_name";
    public static final String PROPERTY_LAST_LOGFILE_SIZE = "last_logfile_size";
    public static final String ZIPENTRY_UNCHANGED_LOGFILES = "unchanged.txt";
    private static final String CLASS_NAME = "org.opends.server.backends.jeb.BackupManager";
    private String backendID;

    public BackupManager(String string) {
        this.backendID = string;
    }

    public void createBackup(ConfigEntry configEntry, BackupConfig backupConfig) throws DirectoryException {
        Object object;
        Object[] objectArray;
        OutputStream outputStream;
        Object object2;
        assert (Debug.debugEnter(CLASS_NAME, "createBackup", String.valueOf(backupConfig)));
        Config config = new Config();
        try {
            config.initializeConfig(configEntry, null);
        }
        catch (ConfigException configException) {
            assert (Debug.debugException(CLASS_NAME, "createBackup", configException));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), configException.getMessage(), configException.getMessageID());
        }
        String string = backupConfig.getBackupID();
        BackupDirectory backupDirectory = backupConfig.getBackupDirectory();
        boolean bl = backupConfig.isIncremental();
        String string2 = backupConfig.getIncrementalBaseID();
        boolean bl2 = backupConfig.compressData();
        boolean bl3 = backupConfig.encryptData();
        boolean bl4 = backupConfig.hashData();
        boolean bl5 = backupConfig.signHash();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        CryptoManager cryptoManager = DirectoryServer.getCryptoManager();
        Mac mac = null;
        MessageDigest messageDigest = null;
        String string3 = null;
        String string4 = null;
        if (bl4) {
            if (bl5) {
                string4 = cryptoManager.getPreferredMACAlgorithm();
                hashMap.put("mac_algorithm", string4);
                try {
                    mac = cryptoManager.getPreferredMACProvider();
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "createBackup", exception));
                    int n = 8650815;
                    String string5 = MessageHandler.getMessage(n, string4, StaticUtils.stackTraceToSingleLineString(exception));
                    throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string5, n, exception);
                }
            }
            string3 = cryptoManager.getPreferredMessageDigestAlgorithm();
            hashMap.put("digest_algorithm", string3);
            try {
                messageDigest = cryptoManager.getPreferredMessageDigest();
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "createBackup", exception));
                int n = 0x840040;
                String string6 = MessageHandler.getMessage(n, string3, StaticUtils.stackTraceToSingleLineString(exception));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string6, n, exception);
            }
        }
        Date date = new Date();
        HashSet<String> hashSet = new HashSet<String>();
        BackupInfo backupInfo = null;
        File file = config.getBackendDirectory();
        if (bl) {
            if (string2 == null && backupDirectory.getLatestBackup() != null) {
                string2 = backupDirectory.getLatestBackup().getBackupID();
            }
            backupInfo = this.getBackupInfo(backupDirectory, string2);
        }
        String string7 = null;
        long l = 0L;
        if (backupInfo != null) {
            object2 = backupInfo.getBackupProperties();
            string7 = ((HashMap)object2).get(PROPERTY_LAST_LOGFILE_NAME);
            l = Long.parseLong(((HashMap)object2).get(PROPERTY_LAST_LOGFILE_SIZE));
        }
        object2 = null;
        try {
            File file2;
            object2 = BACKUP_BASE_FILENAME + this.backendID + "-" + string;
            if (!bl3) {
                object2 = (String)object2 + ".zip";
            }
            if ((file2 = new File(backupDirectory.getPath(), (String)object2)).exists()) {
                int n = 1;
                while ((file2 = new File(backupDirectory.getPath(), (String)object2 + "." + n)).exists()) {
                    ++n;
                }
                object2 = (String)object2 + "." + n;
            }
            outputStream = new FileOutputStream(file2, false);
            hashMap.put("archive_file", (String)object2);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "createBackup", exception));
            int n = 8650817;
            String string8 = MessageHandler.getMessage(n, String.valueOf(object2), backupDirectory.getPath(), StaticUtils.stackTraceToSingleLineString(exception));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string8, n, exception);
        }
        if (bl3) {
            Cipher cipher;
            String string9 = cryptoManager.getPreferredCipherAlgorithm();
            hashMap.put("cipher_algorithm", string9);
            try {
                cipher = cryptoManager.getPreferredCipher(1);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "createBackup", exception));
                int n = 8650818;
                String string10 = MessageHandler.getMessage(n, string9, StaticUtils.stackTraceToSingleLineString(exception));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string10, n, exception);
            }
            outputStream = new CipherOutputStream(outputStream, cipher);
        }
        ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
        int n = 8650819;
        String string11 = MessageHandler.getMessage(n, "OpenDS Directory Server", string, this.backendID);
        zipOutputStream.setComment(string11);
        if (bl2) {
            zipOutputStream.setLevel(-1);
        } else {
            zipOutputStream.setLevel(0);
        }
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(".jdb");
            }
        };
        try {
            objectArray = file.listFiles(filenameFilter);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "createBackup", exception));
            n = 0x840044;
            string11 = MessageHandler.getMessage(n, file.getAbsolutePath(), StaticUtils.stackTraceToSingleLineString(exception));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string11, n, exception);
        }
        Arrays.sort(objectArray);
        try {
            int n2;
            if (string7 != null) {
                String string12;
                int n3;
                ArrayList<String> arrayList = new ArrayList<String>();
                for (n2 = 0; n2 < objectArray.length && (n3 = (string12 = ((File)(object = objectArray[n2])).getName()).compareTo(string7)) <= 0 && (n3 != 0 || ((File)object).length() == l); ++n2) {
                    n = 8388690;
                    string11 = MessageHandler.getMessage(n, string12);
                    Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, string11, n);
                    arrayList.add(string12);
                }
                if (!arrayList.isEmpty()) {
                    object = ZIPENTRY_UNCHANGED_LOGFILES;
                    try {
                        this.archiveList(zipOutputStream, mac, messageDigest, (String)object, arrayList);
                    }
                    catch (IOException iOException) {
                        assert (Debug.debugException(CLASS_NAME, "createBackup", iOException));
                        n = 8650821;
                        string11 = MessageHandler.getMessage(n, object, StaticUtils.stackTraceToSingleLineString(iOException));
                        throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string11, n, iOException);
                    }
                    hashSet.add(backupInfo.getBackupID());
                }
            }
            while (true) {
                boolean bl6 = false;
                while (n2 < objectArray.length) {
                    object = objectArray[n2];
                    try {
                        l = this.archiveFile(zipOutputStream, mac, messageDigest, (File)object);
                        string7 = ((File)object).getName();
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        assert (Debug.debugException(CLASS_NAME, "createBackup", fileNotFoundException));
                        bl6 = true;
                    }
                    catch (IOException iOException) {
                        assert (Debug.debugException(CLASS_NAME, "createBackup", iOException));
                        n = 8650821;
                        string11 = MessageHandler.getMessage(n, ((File)object).getName(), StaticUtils.stackTraceToSingleLineString(iOException));
                        throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string11, n, iOException);
                    }
                    ++n2;
                }
                if (!bl6) break;
                object = ((File)objectArray[objectArray.length - 1]).getName();
                long l2 = l;
                FilenameFilter filenameFilter2 = new FilenameFilter((String)object, l2){
                    final /* synthetic */ String val$latest;
                    final /* synthetic */ long val$latestSize;
                    {
                        this.val$latest = string;
                        this.val$latestSize = l;
                    }

                    public boolean accept(File file, String string) {
                        if (!string.endsWith(".jdb")) {
                            return false;
                        }
                        int n = string.compareTo(this.val$latest);
                        if (n > 0) {
                            return true;
                        }
                        return n == 0 && file.length() > this.val$latestSize;
                    }
                };
                try {
                    objectArray = file.listFiles(filenameFilter2);
                    n2 = 0;
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "createBackup", exception));
                    n = 0x840044;
                    string11 = MessageHandler.getMessage(n, file.getAbsolutePath(), StaticUtils.stackTraceToSingleLineString(exception));
                    throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string11, n, exception);
                }
                if (objectArray != null) {
                    Arrays.sort(objectArray);
                    n = 8388691;
                    string11 = MessageHandler.getMessage(n, objectArray.length);
                    Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, string11, n);
                    continue;
                }
                break;
            }
        }
        catch (DirectoryException directoryException) {
            assert (Debug.debugException(CLASS_NAME, "createBackup", directoryException));
            try {
                zipOutputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            zipOutputStream.close();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "createBackup", exception));
            n = 8650822;
            string11 = MessageHandler.getMessage(n, object2, backupDirectory.getPath(), StaticUtils.stackTraceToSingleLineString(exception));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string11, n, exception);
        }
        byte[] byArray = null;
        byte[] byArray2 = null;
        if (bl4) {
            if (bl5) {
                byArray2 = mac.doFinal();
            } else {
                byArray = messageDigest.digest();
            }
        }
        hashMap.put(PROPERTY_LAST_LOGFILE_NAME, string7);
        hashMap.put(PROPERTY_LAST_LOGFILE_SIZE, String.valueOf(l));
        object = new BackupInfo(backupDirectory, string, date, bl, bl2, bl3, byArray, byArray2, hashSet, hashMap);
        try {
            backupDirectory.addBackup((BackupInfo)object);
            backupDirectory.writeBackupDirectoryDescriptor();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "createBackup", exception));
            n = 8650823;
            string11 = MessageHandler.getMessage(n, backupDirectory.getDescriptorPath(), StaticUtils.stackTraceToSingleLineString(exception));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string11, n, exception);
        }
    }

    public void restoreBackup(ConfigEntry configEntry, RestoreConfig restoreConfig) throws DirectoryException {
        Object object;
        String string = restoreConfig.getBackupID();
        BackupDirectory backupDirectory = restoreConfig.getBackupDirectory();
        boolean bl = restoreConfig.verifyOnly();
        BackupInfo backupInfo = this.getBackupInfo(backupDirectory, string);
        Config config = new Config();
        try {
            config.initializeConfig(configEntry, null);
        }
        catch (ConfigException configException) {
            assert (Debug.debugException(CLASS_NAME, "createBackup", configException));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), configException.getMessage(), configException.getMessageID());
        }
        File file = config.getBackendDirectory();
        File file2 = new File(file.getPath() + "-restore-" + string);
        if (!bl) {
            object = file2.listFiles();
            if (object != null) {
                for (File object2 : object) {
                    object2.delete();
                }
            }
            file2.mkdir();
        }
        try {
            object = this.getUnchanged(backupDirectory, backupInfo);
        }
        catch (IOException iOException) {
            assert (Debug.debugException(CLASS_NAME, "restoreBackup", iOException));
            int n = 8650830;
            String string2 = MessageHandler.getMessage(n, backupInfo.getBackupID(), StaticUtils.stackTraceToSingleLineString(iOException));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string2, n, iOException);
        }
        ArrayList<BackupInfo> arrayList = this.getDependents(backupDirectory, backupInfo);
        File[] fileArray = arrayList.iterator();
        while (fileArray.hasNext()) {
            BackupInfo backupInfo2 = (BackupInfo)fileArray.next();
            try {
                this.restoreArchive(file2, restoreConfig, backupInfo2, (Set<String>)object);
            }
            catch (IOException iOException) {
                assert (Debug.debugException(CLASS_NAME, "restoreBackup", iOException));
                int n = 8650830;
                String file3 = MessageHandler.getMessage(n, backupInfo2.getBackupID(), StaticUtils.stackTraceToSingleLineString(iOException));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), file3, n, iOException);
            }
        }
        try {
            this.restoreArchive(file2, restoreConfig, backupInfo, null);
        }
        catch (IOException iOException) {
            assert (Debug.debugException(CLASS_NAME, "restoreBackup", iOException));
            int n = 8650830;
            String string2 = MessageHandler.getMessage(n, backupInfo.getBackupID(), StaticUtils.stackTraceToSingleLineString(iOException));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string2, n, iOException);
        }
        if (!bl) {
            fileArray = file.listFiles();
            if (fileArray != null) {
                for (File file3 : fileArray) {
                    file3.delete();
                }
            }
            file.delete();
            if (!file2.renameTo(file)) {
                int n = 8650827;
                String string3 = MessageHandler.getMessage(n, file2.getPath(), file.getPath());
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string3, n);
            }
        }
    }

    public void removeBackup(BackupDirectory backupDirectory, String string) throws DirectoryException {
        BackupInfo backupInfo = this.getBackupInfo(backupDirectory, string);
        HashMap<String, String> hashMap = backupInfo.getBackupProperties();
        String string2 = hashMap.get("archive_file");
        File file = new File(backupDirectory.getPath(), string2);
        try {
            backupDirectory.removeBackup(string);
        }
        catch (ConfigException configException) {
            assert (Debug.debugException(CLASS_NAME, "removeBackup", configException));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), configException.getMessage(), configException.getMessageID());
        }
        try {
            backupDirectory.writeBackupDirectoryDescriptor();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "createBackup", exception));
            int n = 8650823;
            String string3 = MessageHandler.getMessage(n, backupDirectory.getDescriptorPath(), StaticUtils.stackTraceToSingleLineString(exception));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string3, n, exception);
        }
        file.delete();
    }

    private void restoreArchive(File file, RestoreConfig restoreConfig, BackupInfo backupInfo, Set<String> set) throws DirectoryException, IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        assert (Debug.debugEnter(CLASS_NAME, "restoreArchive", String.valueOf(restoreConfig)));
        BackupDirectory backupDirectory = restoreConfig.getBackupDirectory();
        boolean bl = restoreConfig.verifyOnly();
        String string = backupInfo.getBackupID();
        boolean bl2 = backupInfo.isEncrypted();
        byte[] byArray = backupInfo.getUnsignedHash();
        byte[] byArray2 = backupInfo.getSignedHash();
        HashMap<String, String> hashMap = backupInfo.getBackupProperties();
        String string2 = hashMap.get("archive_file");
        File file2 = new File(backupDirectory.getPath(), string2);
        InputStream inputStream = new FileInputStream(file2);
        CryptoManager cryptoManager = DirectoryServer.getCryptoManager();
        Mac mac = null;
        MessageDigest messageDigest = null;
        String string3 = null;
        String string4 = null;
        if (byArray2 != null) {
            string4 = hashMap.get("mac_algorithm");
            try {
                mac = cryptoManager.getMACProvider(string4);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "restoreArchive", exception));
                int n = 8650815;
                String string5 = MessageHandler.getMessage(n, string4, StaticUtils.stackTraceToSingleLineString(exception));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string5, n, exception);
            }
        }
        if (byArray != null) {
            string3 = hashMap.get("digest_algorithm");
            try {
                messageDigest = cryptoManager.getMessageDigest(string3);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "restoreArchive", exception));
                int n = 0x840040;
                String string6 = MessageHandler.getMessage(n, string3, StaticUtils.stackTraceToSingleLineString(exception));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string6, n, exception);
            }
        }
        if (bl2) {
            object5 = hashMap.get("cipher_algorithm");
            try {
                object4 = cryptoManager.getCipher((String)object5, 2);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "restoreArchive", exception));
                int n = 8650818;
                String string7 = MessageHandler.getMessage(n, object5, StaticUtils.stackTraceToSingleLineString(exception));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string7, n, exception);
            }
            inputStream = new CipherInputStream(inputStream, (Cipher)object4);
        }
        object5 = new ZipInputStream(inputStream);
        object4 = ((ZipInputStream)object5).getNextEntry();
        while (object4 != null) {
            object3 = ((ZipEntry)object4).getName();
            if (((String)object3).equals(ZIPENTRY_UNCHANGED_LOGFILES)) {
                if (mac != null || messageDigest != null) {
                    if (mac != null) {
                        mac.update(StaticUtils.getBytes((String)object3));
                    }
                    if (messageDigest != null) {
                        messageDigest.update(StaticUtils.getBytes((String)object3));
                    }
                    object2 = new InputStreamReader((InputStream)object5);
                    object = new BufferedReader((Reader)object2);
                    String string8 = ((BufferedReader)object).readLine();
                    while (string8 != null) {
                        if (mac != null) {
                            mac.update(StaticUtils.getBytes(string8));
                        }
                        if (messageDigest != null) {
                            messageDigest.update(StaticUtils.getBytes(string8));
                        }
                        string8 = ((BufferedReader)object).readLine();
                    }
                }
                object4 = ((ZipInputStream)object5).getNextEntry();
                continue;
            }
            object2 = new File(file, (String)object3);
            object = null;
            if ((set == null || set.contains(((ZipEntry)object4).getName())) && !bl) {
                object = new FileOutputStream((File)object2);
            }
            if (object != null || mac != null || messageDigest != null) {
                if (bl) {
                    int n = 8388692;
                    String string9 = MessageHandler.getMessage(n, ((ZipEntry)object4).getName());
                    Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, string9, n);
                }
                if (mac != null) {
                    mac.update(StaticUtils.getBytes((String)object3));
                }
                if (messageDigest != null) {
                    messageDigest.update(StaticUtils.getBytes((String)object3));
                }
                long l = 0L;
                byte[] byArray3 = new byte[8192];
                int n = ((FilterInputStream)object5).read(byArray3);
                while (n > 0) {
                    l += (long)n;
                    if (mac != null) {
                        mac.update(byArray3, 0, n);
                    }
                    if (messageDigest != null) {
                        messageDigest.update(byArray3, 0, n);
                    }
                    if (object != null) {
                        ((OutputStream)object).write(byArray3, 0, n);
                    }
                    n = ((FilterInputStream)object5).read(byArray3);
                }
                if (object != null) {
                    ((OutputStream)object).close();
                    int n2 = 0x800055;
                    String string10 = MessageHandler.getMessage(n2, ((ZipEntry)object4).getName(), l);
                    Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, string10, n2);
                }
            }
            object4 = ((ZipInputStream)object5).getNextEntry();
        }
        ((ZipInputStream)object5).close();
        if (messageDigest != null && !Arrays.equals(messageDigest.digest(), byArray)) {
            int n = 0x840048;
            object2 = MessageHandler.getMessage(n, string);
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), (String)object2, n);
        }
        if (mac != null && !Arrays.equals((byte[])(object3 = (Object)mac.doFinal()), byArray2)) {
            int n = 8650825;
            object = MessageHandler.getMessage(n, string);
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), (String)object, n);
        }
    }

    private long archiveFile(ZipOutputStream zipOutputStream, Mac mac, MessageDigest messageDigest, File file) throws IOException, FileNotFoundException {
        ZipEntry zipEntry = new ZipEntry(file.getName());
        FileInputStream fileInputStream = new FileInputStream(file);
        zipOutputStream.putNextEntry(zipEntry);
        if (mac != null) {
            mac.update(StaticUtils.getBytes(file.getName()));
        }
        if (messageDigest != null) {
            messageDigest.update(StaticUtils.getBytes(file.getName()));
        }
        long l = 0L;
        byte[] byArray = new byte[8192];
        int n = ((InputStream)fileInputStream).read(byArray);
        while (n > 0) {
            if (mac != null) {
                mac.update(byArray, 0, n);
            }
            if (messageDigest != null) {
                messageDigest.update(byArray, 0, n);
            }
            zipOutputStream.write(byArray, 0, n);
            l += (long)n;
            n = ((InputStream)fileInputStream).read(byArray);
        }
        ((InputStream)fileInputStream).close();
        zipOutputStream.closeEntry();
        int n2 = 8388694;
        String string = MessageHandler.getMessage(n2, zipEntry.getName());
        Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, string, n2);
        return l;
    }

    private void archiveList(ZipOutputStream zipOutputStream, Mac mac, MessageDigest messageDigest, String string, List<String> list) throws IOException {
        ZipEntry zipEntry = new ZipEntry(string);
        zipOutputStream.putNextEntry(zipEntry);
        if (mac != null) {
            mac.update(StaticUtils.getBytes(string));
        }
        if (messageDigest != null) {
            messageDigest.update(StaticUtils.getBytes(string));
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(zipOutputStream);
        for (String string2 : list) {
            if (mac != null) {
                mac.update(StaticUtils.getBytes(string2));
            }
            if (messageDigest != null) {
                messageDigest.update(StaticUtils.getBytes(string2));
            }
            outputStreamWriter.write(string2);
            outputStreamWriter.write(ServerConstants.EOL);
        }
        ((Writer)outputStreamWriter).flush();
        zipOutputStream.closeEntry();
    }

    private Set<String> getUnchanged(BackupDirectory backupDirectory, BackupInfo backupInfo) throws DirectoryException, IOException {
        Object object;
        Object object2;
        HashSet<String> hashSet = new HashSet<String>();
        boolean bl = backupInfo.isEncrypted();
        HashMap<String, String> hashMap = backupInfo.getBackupProperties();
        String string = hashMap.get("archive_file");
        File file = new File(backupDirectory.getPath(), string);
        InputStream inputStream = new FileInputStream(file);
        CryptoManager cryptoManager = DirectoryServer.getCryptoManager();
        if (bl) {
            object2 = hashMap.get("cipher_algorithm");
            try {
                object = cryptoManager.getCipher((String)object2, 2);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "restoreArchive", exception));
                int n = 8650818;
                String string2 = MessageHandler.getMessage(n, object2, StaticUtils.stackTraceToSingleLineString(exception));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string2, n, exception);
            }
            inputStream = new CipherInputStream(inputStream, (Cipher)object);
        }
        object2 = new ZipInputStream(inputStream);
        object = ((ZipInputStream)object2).getNextEntry();
        while (object != null) {
            if (((ZipEntry)object).getName().equals(ZIPENTRY_UNCHANGED_LOGFILES)) {
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)object2);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String string3 = bufferedReader.readLine();
                while (string3 != null) {
                    hashSet.add(string3);
                    string3 = bufferedReader.readLine();
                }
                break;
            }
            object = ((ZipInputStream)object2).getNextEntry();
        }
        ((ZipInputStream)object2).close();
        return hashSet;
    }

    private ArrayList<BackupInfo> getDependents(BackupDirectory backupDirectory, BackupInfo backupInfo) throws DirectoryException {
        ArrayList<BackupInfo> arrayList = new ArrayList<BackupInfo>();
        while (backupInfo != null && !backupInfo.getDependencies().isEmpty()) {
            String string = backupInfo.getDependencies().iterator().next();
            if ((backupInfo = this.getBackupInfo(backupDirectory, string)) == null) continue;
            arrayList.add(backupInfo);
        }
        Collections.reverse(arrayList);
        return arrayList;
    }

    private BackupInfo getBackupInfo(BackupDirectory backupDirectory, String string) throws DirectoryException {
        BackupInfo backupInfo = backupDirectory.getBackupInfo(string);
        if (backupInfo == null) {
            int n = 8650831;
            String string2 = MessageHandler.getMessage(n, backupDirectory.getPath(), string);
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string2, n);
        }
        return backupInfo;
    }
}

