/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.opends.server.api.Backend;
import org.opends.server.api.ConfigurableComponent;
import org.opends.server.config.BooleanConfigAttribute;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.config.DNConfigAttribute;
import org.opends.server.core.AddOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.SearchOperation;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.BackupConfig;
import org.opends.server.types.BackupDirectory;
import org.opends.server.types.ByteString;
import org.opends.server.types.CancelRequest;
import org.opends.server.types.CancelResult;
import org.opends.server.types.CancelledOperationException;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.InitializationException;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.RestoreConfig;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.util.LDIFWriter;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootDSEBackend
extends Backend
implements ConfigurableComponent {
    private static final String CLASS_NAME = "org.opends.server.backends.RootDSEBackend";
    private ArrayList<Attribute> staticDSEAttributes;
    private ArrayList<Attribute> userDefinedAttributes;
    private boolean showAllAttributes;
    private ConcurrentHashMap<DN, Backend> subordinateBaseDNs;
    private HashMap<ObjectClass, String> dseObjectClasses;
    private DN configEntryDN;
    private DN rootDSEDN;
    private DN[] baseDNs;
    private HashSet<String> supportedControls;
    private HashSet<String> supportedFeatures;

    public RootDSEBackend() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void initializeBackend(ConfigEntry configEntry, DN[] dNArray) throws ConfigException, InitializationException {
        void var7_22;
        Object object;
        Object object22;
        assert (Debug.debugEnter(CLASS_NAME, "initializeBackend", String.valueOf(configEntry)));
        if (configEntry == null) {
            int n = 9764866;
            String string = MessageHandler.getMessage(n);
            throw new ConfigException(n, string);
        }
        this.configEntryDN = configEntry.getDN();
        this.userDefinedAttributes = new ArrayList();
        for (List<Attribute> object52 : configEntry.getEntry().getUserAttributes().values()) {
            for (Object object22 : object52) {
                if (this.isDSEConfigAttribute((Attribute)object22)) continue;
                this.userDefinedAttributes.add((Attribute)object22);
            }
        }
        for (List<Attribute> list : configEntry.getEntry().getOperationalAttributes().values()) {
            for (Object object22 : list) {
                if (this.isDSEConfigAttribute((Attribute)object22)) continue;
                this.userDefinedAttributes.add((Attribute)object22);
            }
        }
        this.rootDSEDN = DN.nullDN();
        this.baseDNs = new DN[]{this.rootDSEDN};
        String string = MessageHandler.getMessage(0x900003);
        DNConfigAttribute dNConfigAttribute = new DNConfigAttribute("ds-cfg-subordinate-base-dn", string, false, true, false);
        try {
            DNConfigAttribute dNConfigAttribute2 = (DNConfigAttribute)configEntry.getConfigAttribute(dNConfigAttribute);
            if (dNConfigAttribute2 == null) {
                this.subordinateBaseDNs = null;
            } else {
                this.subordinateBaseDNs = new ConcurrentHashMap();
                for (DN dN : dNConfigAttribute2.activeValues()) {
                    object = DirectoryServer.getBackend(dN);
                    if (object == null) {
                        int n = 9568260;
                        String string2 = MessageHandler.getMessage(n, String.valueOf(dN));
                        Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, string2, n);
                        continue;
                    }
                    this.subordinateBaseDNs.put(dN, (Backend)object);
                }
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeBackend", exception));
            int n = 9568261;
            String string3 = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n, string3, exception);
        }
        this.showAllAttributes = false;
        int n = 0x90009D;
        object22 = new BooleanConfigAttribute("ds-cfg-show-all-attributes", MessageHandler.getMessage(n), false);
        try {
            BooleanConfigAttribute booleanConfigAttribute = (BooleanConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object22);
            if (booleanConfigAttribute != null) {
                this.showAllAttributes = booleanConfigAttribute.activeValue();
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeBackend", exception));
            n = 9699486;
            object = MessageHandler.getMessage(n, "ds-cfg-show-all-attributes", StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, (String)object, n);
        }
        this.staticDSEAttributes = new ArrayList();
        this.staticDSEAttributes.add(this.createAttribute("vendorName", "vendorname", "Sun Microsystems, Inc."));
        this.staticDSEAttributes.add(this.createAttribute("vendorVersion", "vendorversion", DirectoryServer.getVersionString()));
        this.dseObjectClasses = new HashMap(2);
        ObjectClass objectClass = DirectoryServer.getObjectClass("top");
        if (objectClass == null) {
            ObjectClass objectClass2 = DirectoryServer.getDefaultObjectClass("top");
        }
        this.dseObjectClasses.put((ObjectClass)var7_22, "top");
        object = DirectoryServer.getObjectClass("ds-rootdse");
        if (object == null) {
            object = DirectoryServer.getDefaultObjectClass("ds-rootDSE");
        }
        this.dseObjectClasses.put((ObjectClass)object, "ds-rootDSE");
        this.supportedControls = new HashSet(0);
        this.supportedFeatures = new HashSet(0);
        DirectoryServer.registerConfigurableComponent(this);
    }

    @Override
    public void finalizeBackend() {
        assert (Debug.debugEnter(CLASS_NAME, "finalizeBackend", new String[0]));
        DirectoryServer.deregisterConfigurableComponent(this);
    }

    private boolean isDSEConfigAttribute(Attribute attribute) {
        assert (Debug.debugEnter(CLASS_NAME, "isConfigAttribute", String.valueOf(attribute)));
        AttributeType attributeType = attribute.getAttributeType();
        return attributeType.hasName("ds-cfg-subordinate-base-dn".toLowerCase()) || attributeType.hasName("ds-cfg-show-all-attributes".toLowerCase()) || attributeType.hasName("cn");
    }

    @Override
    public DN[] getBaseDNs() {
        assert (Debug.debugEnter(CLASS_NAME, "getBaseDNs", new String[0]));
        return this.baseDNs;
    }

    @Override
    public boolean isLocal() {
        assert (Debug.debugEnter(CLASS_NAME, "isLocal", new String[0]));
        return true;
    }

    @Override
    public Entry getEntry(DN dN) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "getEntry", String.valueOf(dN)));
        if (dN == null || dN.isNullDN()) {
            return this.getRootDSE();
        }
        int n = 9502726;
        String string = MessageHandler.getMessage(n, String.valueOf(dN));
        Error.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.MILD_WARNING, string, n);
        if (this.subordinateBaseDNs != null) {
            for (Backend backend : this.subordinateBaseDNs.values()) {
                if (!backend.handlesEntry(dN)) continue;
                return backend.getEntry(dN);
            }
        }
        return null;
    }

    public Entry getRootDSE() {
        List<Object> list;
        AttributeType attributeType;
        Iterator<Attribute> iterator;
        Object object;
        assert (Debug.debugEnter(CLASS_NAME, "getRootDSE", new String[0]));
        HashMap<AttributeType, List<Attribute>> hashMap = new HashMap<AttributeType, List<Attribute>>();
        HashMap<AttributeType, List<Attribute>> hashMap2 = new HashMap<AttributeType, List<Attribute>>();
        Attribute attribute = this.createDNAttribute("namingContexts", "namingcontexts", DirectoryServer.getSuffixes().keySet());
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>(1);
        arrayList.add(attribute);
        if (this.showAllAttributes || !attribute.getAttributeType().isOperational()) {
            hashMap.put(attribute.getAttributeType(), arrayList);
        } else {
            hashMap2.put(attribute.getAttributeType(), arrayList);
        }
        Attribute attribute2 = this.createAttribute("supportedControl", "supportedcontrol", DirectoryServer.getSupportedControls());
        ArrayList<Attribute> arrayList2 = new ArrayList<Attribute>(1);
        arrayList2.add(attribute2);
        if (this.showAllAttributes || !attribute2.getAttributeType().isOperational()) {
            hashMap.put(attribute2.getAttributeType(), arrayList2);
        } else {
            hashMap2.put(attribute2.getAttributeType(), arrayList2);
        }
        Attribute attribute3 = this.createAttribute("supportedExtension", "supportedextension", DirectoryServer.getSupportedExtensions().keySet());
        ArrayList<Attribute> arrayList3 = new ArrayList<Attribute>(1);
        arrayList3.add(attribute3);
        if (this.showAllAttributes || !attribute3.getAttributeType().isOperational()) {
            hashMap.put(attribute3.getAttributeType(), arrayList3);
        } else {
            hashMap2.put(attribute3.getAttributeType(), arrayList3);
        }
        Attribute attribute4 = this.createAttribute("supportedFeatures", "supportedfeatures", DirectoryServer.getSupportedFeatures());
        ArrayList<Attribute> arrayList4 = new ArrayList<Attribute>(1);
        arrayList4.add(attribute4);
        if (this.showAllAttributes || !attribute4.getAttributeType().isOperational()) {
            hashMap.put(attribute4.getAttributeType(), arrayList4);
        } else {
            hashMap2.put(attribute4.getAttributeType(), arrayList4);
        }
        Attribute attribute5 = this.createAttribute("supportedSASLMechanisms", "supportedsaslmechanisms", DirectoryServer.getSupportedSASLMechanisms().keySet());
        ArrayList<Attribute> arrayList5 = new ArrayList<Attribute>(1);
        arrayList5.add(attribute5);
        if (this.showAllAttributes || !attribute5.getAttributeType().isOperational()) {
            hashMap.put(attribute5.getAttributeType(), arrayList5);
        } else {
            hashMap2.put(attribute5.getAttributeType(), arrayList5);
        }
        Set set = DirectoryServer.getAuthPasswordStorageSchemes().keySet();
        if (!set.isEmpty()) {
            object = this.createAttribute("supportedAuthPasswordSchemes", "supportedauthpasswordschemes", set);
            iterator = new ArrayList(1);
            ((ArrayList)((Object)iterator)).add((Attribute)object);
            if (this.showAllAttributes || !attribute5.getAttributeType().isOperational()) {
                hashMap.put(((Attribute)object).getAttributeType(), (List<Attribute>)((Object)iterator));
            } else {
                hashMap2.put(((Attribute)object).getAttributeType(), (List<Attribute>)((Object)iterator));
            }
        }
        if ((object = DirectoryServer.getSchemaDN()) != null) {
            iterator = this.createAttribute("subschemaSubentry", "subschemasubentry", String.valueOf(object));
            ArrayList<Iterator<Attribute>> object2 = new ArrayList<Iterator<Attribute>>(1);
            object2.add(iterator);
            if (this.showAllAttributes || !((Attribute)((Object)iterator)).getAttributeType().isOperational()) {
                hashMap.put(((Attribute)((Object)iterator)).getAttributeType(), object2);
            } else {
                hashMap2.put(((Attribute)((Object)iterator)).getAttributeType(), object2);
            }
        }
        for (Attribute attribute6 : this.staticDSEAttributes) {
            attributeType = attribute6.getAttributeType();
            if (attributeType.isOperational() && !this.showAllAttributes) {
                list = (List)hashMap2.get(attributeType);
                if (list == null) {
                    list = new ArrayList();
                    list.add(attribute6);
                    hashMap2.put(attributeType, list);
                    continue;
                }
                list.add(attribute6);
                continue;
            }
            list = (ArrayList<Attribute>)hashMap.get(attributeType);
            if (list == null) {
                list = new ArrayList<Attribute>();
                list.add(attribute6);
                hashMap.put(attributeType, list);
                continue;
            }
            list.add(attribute6);
        }
        for (Attribute attribute7 : this.userDefinedAttributes) {
            attributeType = attribute7.getAttributeType();
            if (attributeType.isOperational() && !this.showAllAttributes) {
                list = hashMap2.get(attributeType);
                if (list == null) {
                    list = new ArrayList();
                    list.add(attribute7);
                    hashMap2.put(attributeType, list);
                    continue;
                }
                list.add(attribute7);
                continue;
            }
            list = hashMap.get(attributeType);
            if (list == null) {
                list = new ArrayList();
                list.add(attribute7);
                hashMap.put(attributeType, list);
                continue;
            }
            list.add(attribute7);
        }
        return new Entry(this.rootDSEDN, this.dseObjectClasses, hashMap, hashMap2);
    }

    private Attribute createAttribute(String string, String string2, String string3) {
        assert (Debug.debugEnter(CLASS_NAME, "createAttribute", String.valueOf(string), String.valueOf(string2), String.valueOf(string3)));
        AttributeType attributeType = DirectoryServer.getAttributeType(string2);
        if (attributeType == null) {
            attributeType = DirectoryServer.getDefaultAttributeType(string);
        }
        LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>(1);
        linkedHashSet.add(new AttributeValue(attributeType, (ByteString)new ASN1OctetString(string3)));
        return new Attribute(attributeType, string, linkedHashSet);
    }

    private Attribute createDNAttribute(String string, String string2, Collection<DN> collection) {
        assert (Debug.debugEnter(CLASS_NAME, "createDNAttribute", String.valueOf(string), String.valueOf(string2), String.valueOf(collection)));
        AttributeType attributeType = DirectoryServer.getAttributeType(string2);
        if (attributeType == null) {
            attributeType = DirectoryServer.getDefaultAttributeType(string);
        }
        LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>();
        for (DN dN : collection) {
            linkedHashSet.add(new AttributeValue(attributeType, (ByteString)new ASN1OctetString(dN.toString())));
        }
        return new Attribute(attributeType, string, linkedHashSet);
    }

    private Attribute createAttribute(String string, String string2, Collection<String> collection) {
        assert (Debug.debugEnter(CLASS_NAME, "createAttribute", String.valueOf(string), String.valueOf(string2), String.valueOf(collection)));
        AttributeType attributeType = DirectoryServer.getAttributeType(string2);
        if (attributeType == null) {
            attributeType = DirectoryServer.getDefaultAttributeType(string);
        }
        LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>();
        for (String string3 : collection) {
            linkedHashSet.add(new AttributeValue(attributeType, (ByteString)new ASN1OctetString(string3)));
        }
        return new Attribute(attributeType, string, linkedHashSet);
    }

    @Override
    public boolean entryExists(DN dN) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "entryExists", String.valueOf(dN)));
        if (dN.isNullDN()) {
            return true;
        }
        AbstractMap abstractMap = this.subordinateBaseDNs == null ? DirectoryServer.getSuffixes() : this.subordinateBaseDNs;
        for (DN dN2 : abstractMap.keySet()) {
            Backend backend;
            if (!dN.isDescendantOf(dN2) || !(backend = (Backend)abstractMap.get(dN2)).entryExists(dN)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addEntry(Entry entry, AddOperation addOperation) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "addEntry", String.valueOf(entry), String.valueOf(addOperation)));
        int n = 9633799;
        String string = MessageHandler.getMessage(n, String.valueOf(entry.getDN()));
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string, n);
    }

    @Override
    public void deleteEntry(DN dN, DeleteOperation deleteOperation) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "deleteEntry", String.valueOf(dN), String.valueOf(deleteOperation)));
        int n = 9633800;
        String string = MessageHandler.getMessage(n, String.valueOf(dN));
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string, n);
    }

    @Override
    public void replaceEntry(Entry entry, ModifyOperation modifyOperation) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "replaceEntry", String.valueOf(entry), String.valueOf(modifyOperation)));
        int n = 0x930009;
        String string = MessageHandler.getMessage(n, String.valueOf(entry.getDN()), String.valueOf(this.configEntryDN));
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string, n);
    }

    @Override
    public void renameEntry(DN dN, Entry entry, ModifyDNOperation modifyDNOperation) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "renameEntry", String.valueOf(dN), String.valueOf(entry), String.valueOf(modifyDNOperation)));
        int n = 9633802;
        String string = MessageHandler.getMessage(n, String.valueOf(dN));
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void search(SearchOperation searchOperation) throws DirectoryException, CancelledOperationException {
        assert (Debug.debugEnter(CLASS_NAME, "search", String.valueOf(searchOperation)));
        DN dN = searchOperation.getBaseDN();
        if (!dN.isNullDN()) {
            int n = 9633803;
            String string = MessageHandler.getMessage(n, searchOperation.getConnectionID(), searchOperation.getOperationID(), String.valueOf(dN));
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string, n);
        }
        SearchFilter searchFilter = searchOperation.getFilter();
        switch (searchOperation.getScope()) {
            case BASE_OBJECT: {
                Entry entry = this.getRootDSE();
                if (!searchFilter.matchesEntry(entry)) return;
                searchOperation.returnEntry(entry, null);
                return;
            }
            case SINGLE_LEVEL: {
                AbstractMap abstractMap = this.subordinateBaseDNs == null ? DirectoryServer.getSuffixes() : this.subordinateBaseDNs;
                for (DN dN2 : abstractMap.keySet()) {
                    CancelRequest cancelRequest = searchOperation.getCancelRequest();
                    if (cancelRequest != null) {
                        throw new CancelledOperationException(CancelResult.CANCELED);
                    }
                    Backend backend = (Backend)abstractMap.get(dN2);
                    Entry entry = backend.getEntry(dN2);
                    if (entry == null || !searchFilter.matchesEntry(entry)) continue;
                    searchOperation.returnEntry(entry, null);
                }
                return;
            }
            case WHOLE_SUBTREE: 
            case SUBORDINATE_SUBTREE: {
                AbstractMap abstractMap = this.subordinateBaseDNs == null ? DirectoryServer.getSuffixes() : this.subordinateBaseDNs;
                try {
                    for (DN dN3 : abstractMap.keySet()) {
                        CancelRequest cancelRequest = searchOperation.getCancelRequest();
                        if (cancelRequest != null) {
                            throw new CancelledOperationException(CancelResult.CANCELED);
                        }
                        Backend backend = (Backend)abstractMap.get(dN3);
                        searchOperation.setBaseDN(dN3);
                        try {
                            backend.search(searchOperation);
                        }
                        catch (DirectoryException directoryException) {
                            if (directoryException.getResultCode() == ResultCode.NO_SUCH_OBJECT) continue;
                            throw directoryException;
                            return;
                        }
                    }
                }
                catch (DirectoryException directoryException) {
                    if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "search", directoryException)) throw directoryException;
                    throw new AssertionError();
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "search", exception));
                    int n = 9699340;
                    String string = MessageHandler.getMessage(n, searchOperation.getConnectionID(), searchOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(exception));
                    throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, n, exception);
                }
                finally {
                    searchOperation.setBaseDN(this.rootDSEDN);
                }
            }
            default: {
                int n = 9699341;
                String string = MessageHandler.getMessage(n, searchOperation.getConnectionID(), searchOperation.getOperationID(), String.valueOf((Object)searchOperation.getScope()));
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, string, n);
            }
        }
    }

    public HashSet<String> getSupportedControls() {
        assert (Debug.debugEnter(CLASS_NAME, "getSupportedControls", new String[0]));
        return this.supportedControls;
    }

    @Override
    public boolean supportsControl(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "supportsControl", String.valueOf(string)));
        return false;
    }

    public HashSet<String> getSupportedFeatures() {
        assert (Debug.debugEnter(CLASS_NAME, "getSupportedFeatures", new String[0]));
        return this.supportedFeatures;
    }

    @Override
    public boolean supportsFeature(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "supportsFeature", String.valueOf(string)));
        return false;
    }

    @Override
    public boolean supportsLDIFExport() {
        assert (Debug.debugEnter(CLASS_NAME, "supportsLDIFExport", new String[0]));
        return true;
    }

    @Override
    public void exportLDIF(ConfigEntry configEntry, DN[] dNArray, LDIFExportConfig lDIFExportConfig) throws DirectoryException {
        LDIFWriter lDIFWriter;
        assert (Debug.debugEnter(CLASS_NAME, "exportLDIF", String.valueOf(lDIFExportConfig)));
        try {
            lDIFWriter = new LDIFWriter(lDIFExportConfig);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "exportLDIF", exception));
            int n = 9699342;
            String string = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, n);
        }
        try {
            lDIFWriter.writeEntry(this.getRootDSE());
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "exportLDIF", exception));
            int n = 9699343;
            String string = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, n);
        }
        finally {
            block15: {
                try {
                    lDIFWriter.close();
                }
                catch (Exception exception) {
                    if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "exportLDIF", exception)) break block15;
                    throw new AssertionError();
                }
            }
        }
    }

    @Override
    public boolean supportsLDIFImport() {
        assert (Debug.debugEnter(CLASS_NAME, "supportsLDIFImport", new String[0]));
        return false;
    }

    @Override
    public void importLDIF(ConfigEntry configEntry, DN[] dNArray, LDIFImportConfig lDIFImportConfig) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "importLDIF", String.valueOf(lDIFImportConfig)));
        int n = 9699344;
        String string = MessageHandler.getMessage(n);
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string, n);
    }

    @Override
    public boolean supportsBackup() {
        assert (Debug.debugEnter(CLASS_NAME, "supportsBackup", new String[0]));
        return false;
    }

    @Override
    public boolean supportsBackup(BackupConfig backupConfig, StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "supportsBackup", new String[0]));
        return false;
    }

    @Override
    public void createBackup(ConfigEntry configEntry, BackupConfig backupConfig) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "createBackup", String.valueOf(backupConfig)));
        int n = 9699345;
        String string = MessageHandler.getMessage(n);
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string, n);
    }

    @Override
    public void removeBackup(BackupDirectory backupDirectory, String string) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "removeBackup", String.valueOf(backupDirectory), String.valueOf(string)));
        int n = 9699345;
        String string2 = MessageHandler.getMessage(n);
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string2, n);
    }

    @Override
    public boolean supportsRestore() {
        assert (Debug.debugEnter(CLASS_NAME, "supportsRestore", new String[0]));
        return false;
    }

    @Override
    public void restoreBackup(ConfigEntry configEntry, RestoreConfig restoreConfig) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "restoreBackup", String.valueOf(restoreConfig)));
        int n = 9699345;
        String string = MessageHandler.getMessage(n);
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string, n);
    }

    @Override
    public DN getConfigurableComponentEntryDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigurableComponentEntryDN", new String[0]));
        return this.configEntryDN;
    }

    @Override
    public List<ConfigAttribute> getConfigurationAttributes() {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigurationAttributes", new String[0]));
        LinkedList<ConfigAttribute> linkedList = new LinkedList<ConfigAttribute>();
        String string = MessageHandler.getMessage(0x900003);
        ArrayList<DN> arrayList = new ArrayList<DN>();
        if (this.subordinateBaseDNs != null) {
            arrayList.addAll(this.subordinateBaseDNs.keySet());
        }
        linkedList.add(new DNConfigAttribute("ds-cfg-subordinate-base-dn", string, false, true, false, arrayList));
        string = MessageHandler.getMessage(0x90009D);
        linkedList.add(new BooleanConfigAttribute("ds-cfg-show-all-attributes", string, this.showAllAttributes));
        return linkedList;
    }

    @Override
    public boolean hasAcceptableConfiguration(ConfigEntry configEntry, List<String> list) {
        Object object;
        ConfigAttribute configAttribute;
        assert (Debug.debugEnter(CLASS_NAME, "hasAcceptableConfiguration", String.valueOf(configEntry), "java.util.List<String>"));
        boolean bl = true;
        String string = MessageHandler.getMessage(0x900003);
        DNConfigAttribute dNConfigAttribute = new DNConfigAttribute("ds-cfg-subordinate-base-dn", string, false, true, false);
        try {
            configAttribute = (DNConfigAttribute)configEntry.getConfigAttribute(dNConfigAttribute);
            if (configAttribute != null) {
                for (DN object2 : configAttribute.activeValues()) {
                    object = DirectoryServer.getBackend(object2);
                    if (object != null) continue;
                    int n = 9568260;
                    String string2 = MessageHandler.getMessage(n, String.valueOf(object2));
                    list.add(string2);
                    bl = false;
                }
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            int n = 9568261;
            String n2 = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
            list.add(n2);
            bl = false;
        }
        string = MessageHandler.getMessage(0x90009D);
        configAttribute = new BooleanConfigAttribute("ds-cfg-show-all-attributes", string, false);
        try {
            BooleanConfigAttribute booleanConfigAttribute = (BooleanConfigAttribute)configEntry.getConfigAttribute(configAttribute);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            int n = 9699486;
            object = MessageHandler.getMessage(n, "ds-cfg-show-all-attributes", StaticUtils.stackTraceToSingleLineString(exception));
            list.add((String)object);
            bl = false;
        }
        return bl;
    }

    @Override
    public ConfigChangeResult applyNewConfiguration(ConfigEntry configEntry, boolean bl) {
        boolean bl2;
        ConcurrentHashMap<DN, Backend> concurrentHashMap;
        ArrayList<String> arrayList;
        boolean bl3;
        ResultCode resultCode;
        block27: {
            assert (Debug.debugEnter(CLASS_NAME, "applyNewConfiguration", String.valueOf(configEntry), String.valueOf(bl)));
            resultCode = ResultCode.SUCCESS;
            bl3 = false;
            arrayList = new ArrayList<String>();
            String string = MessageHandler.getMessage(0x900003);
            DNConfigAttribute dNConfigAttribute = new DNConfigAttribute("ds-cfg-subordinate-base-dn", string, false, true, false);
            try {
                DNConfigAttribute dNConfigAttribute2 = (DNConfigAttribute)configEntry.getConfigAttribute(dNConfigAttribute);
                if (dNConfigAttribute2 == null) {
                    concurrentHashMap = null;
                } else {
                    concurrentHashMap = new ConcurrentHashMap<DN, Backend>();
                    for (DN serializable2 : dNConfigAttribute2.activeValues()) {
                        Backend n = DirectoryServer.getBackend(serializable2);
                        if (n == null) {
                            int iterator = 9568260;
                            Iterator<Attribute> iterator2 = MessageHandler.getMessage(iterator, String.valueOf(serializable2));
                            arrayList.add((String)((Object)iterator2));
                            if (resultCode != ResultCode.SUCCESS) continue;
                            resultCode = DirectoryServer.getServerErrorResultCode();
                            continue;
                        }
                        concurrentHashMap.put(serializable2, n);
                    }
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
                int n = 9568261;
                String exception2 = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
                arrayList.add(exception2);
                if (resultCode == ResultCode.SUCCESS) {
                    resultCode = DirectoryServer.getServerErrorResultCode();
                }
                concurrentHashMap = null;
            }
            bl2 = false;
            string = MessageHandler.getMessage(0x90009D);
            BooleanConfigAttribute booleanConfigAttribute = new BooleanConfigAttribute("ds-cfg-show-all-attributes", string, false);
            try {
                BooleanConfigAttribute booleanConfigAttribute2 = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute);
                if (booleanConfigAttribute2 != null) {
                    bl2 = booleanConfigAttribute2.pendingValue();
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
                int n = 9699486;
                string = MessageHandler.getMessage(n, "ds-cfg-show-all-attributes", StaticUtils.stackTraceToSingleLineString(exception));
                arrayList.add(string);
                if (resultCode != ResultCode.SUCCESS) break block27;
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
        }
        ArrayList<Attribute> arrayList2 = new ArrayList<Attribute>();
        for (List<Attribute> string : configEntry.getEntry().getUserAttributes().values()) {
            for (Attribute attribute : string) {
                if (this.isDSEConfigAttribute(attribute)) continue;
                arrayList2.add(attribute);
            }
        }
        for (List<Attribute> list : configEntry.getEntry().getOperationalAttributes().values()) {
            for (Attribute attribute : list) {
                if (this.isDSEConfigAttribute(attribute)) continue;
                arrayList2.add(attribute);
            }
        }
        if (resultCode == ResultCode.SUCCESS) {
            this.subordinateBaseDNs = concurrentHashMap;
            if (bl) {
                if (this.subordinateBaseDNs == null) {
                    int n = 9437202;
                    String string = MessageHandler.getMessage(n);
                    arrayList.add(string);
                } else {
                    StringBuilder stringBuilder = new StringBuilder();
                    Iterator iterator = this.subordinateBaseDNs.keySet().iterator();
                    while (iterator.hasNext()) {
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append(", ");
                        } else {
                            stringBuilder.append("{ ");
                        }
                        stringBuilder.append(iterator.next());
                    }
                    stringBuilder.append(" }");
                    int n = 9437203;
                    String string = MessageHandler.getMessage(n, stringBuilder.toString());
                    arrayList.add(string);
                }
            }
            if (this.showAllAttributes != bl2) {
                this.showAllAttributes = bl2;
                if (bl) {
                    int n = 0x90009F;
                    String string = MessageHandler.getMessage(n, "ds-cfg-show-all-attributes", this.showAllAttributes);
                    arrayList.add(string);
                }
            }
            this.userDefinedAttributes = arrayList2;
            if (bl) {
                int n = 9437204;
                String string = MessageHandler.getMessage(n);
                arrayList.add(string);
            }
        }
        return new ConfigChangeResult(resultCode, bl3, arrayList);
    }
}

