/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.api;

import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.Operation;
import org.opends.server.loggers.Debug;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;

public abstract class WorkQueue {
    private static final String CLASS_NAME = "org.opends.server.api.WorkQueue";

    public abstract void initializeWorkQueue(ConfigEntry var1) throws ConfigException, InitializationException;

    public abstract void finalizeWorkQueue(String var1);

    public abstract void submitOperation(Operation var1) throws DirectoryException;

    public abstract boolean isIdle();

    public boolean waitUntilIdle(long l) {
        assert (Debug.debugEnter(CLASS_NAME, "waitUntilIdle", String.valueOf(l)));
        long l2 = l <= 0L ? Long.MAX_VALUE : System.currentTimeMillis() + l;
        while (System.currentTimeMillis() < l2) {
            if (this.isIdle()) {
                return true;
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return false;
    }
}

