/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.api;

import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.loggers.Debug;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConditionResult;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;

public abstract class MatchingRule {
    private static final String CLASS_NAME = "org.opends.server.api.MatchingRule";

    public abstract void initializeMatchingRule(ConfigEntry var1) throws ConfigException, InitializationException;

    public abstract String getName();

    public abstract String getOID();

    public String getNameOrOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getNameOrOID", new String[0]));
        String string = this.getName();
        if (string == null || string.length() == 0) {
            return this.getOID();
        }
        return string;
    }

    public abstract String getDescription();

    public abstract String getSyntaxOID();

    public boolean isObsolete() {
        assert (Debug.debugEnter(CLASS_NAME, "isObsolete", new String[0]));
        return false;
    }

    public abstract ByteString normalizeValue(ByteString var1) throws DirectoryException;

    public abstract ConditionResult valuesMatch(ByteString var1, ByteString var2);

    public int hashCode() {
        assert (Debug.debugEnter(CLASS_NAME, "hashCode", new String[0]));
        int n = 0;
        String string = this.getOID();
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            n += string.charAt(i);
        }
        return n;
    }

    public boolean equals(Object object) {
        assert (Debug.debugEnter(CLASS_NAME, "equals", String.valueOf(object)));
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof MatchingRule)) {
            return false;
        }
        return this.getOID().equals(((MatchingRule)object).getOID());
    }

    public String toString() {
        assert (Debug.debugEnter(CLASS_NAME, "toString", new String[0]));
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        stringBuilder.append("( ");
        stringBuilder.append(this.getOID());
        stringBuilder.append(" NAME '");
        stringBuilder.append(this.getName());
        String string = this.getDescription();
        if (string != null && string.length() > 0) {
            stringBuilder.append("' DESC '");
            stringBuilder.append(string);
        }
        if (this.isObsolete()) {
            stringBuilder.append("' OBSOLETE SYNTAX ");
        } else {
            stringBuilder.append("' SYNTAX ");
        }
        stringBuilder.append(this.getSyntaxOID());
        stringBuilder.append(" )");
    }
}

