/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.api;

import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import org.opends.server.api.ConnectionHandler;
import org.opends.server.api.ConnectionSecurityProvider;
import org.opends.server.api.plugin.IntermediateResponsePluginResult;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.Operation;
import org.opends.server.core.PersistentSearch;
import org.opends.server.core.PluginConfigManager;
import org.opends.server.core.SearchOperation;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.AuthenticationInfo;
import org.opends.server.types.CancelRequest;
import org.opends.server.types.CancelResult;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.IntermediateResponse;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchResultReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClientConnection {
    private static final String CLASS_NAME = "org.opends.server.api.ClientConnection";
    private AuthenticationInfo authenticationInfo;
    private boolean bindInProgress;
    private int sizeLimit;
    private int timeLimit;
    private int lookthroughLimit;
    private Object saslAuthState;
    private CopyOnWriteArrayList<PersistentSearch> persistentSearches;

    protected ClientConnection() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
        this.authenticationInfo = new AuthenticationInfo();
        this.saslAuthState = null;
        this.bindInProgress = false;
        this.persistentSearches = new CopyOnWriteArrayList();
        this.sizeLimit = DirectoryServer.getSizeLimit();
        this.timeLimit = DirectoryServer.getTimeLimit();
        this.lookthroughLimit = DirectoryServer.getLookthroughLimit();
    }

    public abstract long getConnectionID();

    public abstract ConnectionHandler getConnectionHandler();

    public abstract String getProtocol();

    public abstract String getClientAddress();

    public abstract String getServerAddress();

    public abstract InetAddress getRemoteAddress();

    public abstract InetAddress getLocalAddress();

    public abstract boolean isSecure();

    public abstract ConnectionSecurityProvider getConnectionSecurityProvider();

    public abstract void setConnectionSecurityProvider(ConnectionSecurityProvider var1);

    public abstract String getSecurityMechanism();

    public abstract boolean processDataRead(ByteBuffer var1);

    public abstract void sendResponse(Operation var1);

    public abstract void sendSearchEntry(SearchOperation var1, SearchResultEntry var2);

    public abstract boolean sendSearchReference(SearchOperation var1, SearchResultReference var2);

    public final boolean sendIntermediateResponse(IntermediateResponse intermediateResponse) {
        assert (Debug.debugEnter(CLASS_NAME, "sendIntermediateResponse", String.valueOf(intermediateResponse)));
        PluginConfigManager pluginConfigManager = DirectoryServer.getPluginConfigManager();
        IntermediateResponsePluginResult intermediateResponsePluginResult = pluginConfigManager.invokeIntermediateResponsePlugins(intermediateResponse);
        boolean bl = true;
        if (intermediateResponsePluginResult.sendIntermediateResponse()) {
            bl = this.sendIntermediateResponseMessage(intermediateResponse);
        }
        return bl && intermediateResponsePluginResult.continueOperation();
    }

    protected abstract boolean sendIntermediateResponseMessage(IntermediateResponse var1);

    public void disconnect(DisconnectReason disconnectReason, boolean bl, int n, Object ... objectArray) {
        assert (Debug.debugEnter(CLASS_NAME, "disconnect", String.valueOf((Object)disconnectReason), String.valueOf(bl), String.valueOf(n), String.valueOf(objectArray)));
        String string = MessageHandler.getMessage(n, objectArray);
        this.disconnect(disconnectReason, bl, string, n);
    }

    public abstract void disconnect(DisconnectReason var1, boolean var2, String var3, int var4);

    public boolean bindInProgress() {
        assert (Debug.debugEnter(CLASS_NAME, "bindInProgress", new String[0]));
        return this.bindInProgress;
    }

    public void setBindInProgress(boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "setBindInProgress", String.valueOf(bl)));
        this.bindInProgress = bl;
    }

    public boolean mustChangePassword() {
        assert (Debug.debugEnter(CLASS_NAME, "mustChangePassword", new String[0]));
        if (this.authenticationInfo == null) {
            return false;
        }
        return this.authenticationInfo.mustChangePassword();
    }

    public void setMustChangePassword(boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "setMustChangePassword", String.valueOf(bl)));
        if (this.authenticationInfo == null) {
            this.authenticationInfo = new AuthenticationInfo();
        }
        this.authenticationInfo.setMustChangePassword(bl);
    }

    public abstract Collection<Operation> getOperationsInProgress();

    public abstract Operation getOperationInProgress(int var1);

    public abstract boolean removeOperationInProgress(int var1);

    public CopyOnWriteArrayList<PersistentSearch> getPersistentSearches() {
        assert (Debug.debugEnter(CLASS_NAME, "getPersistentSearches", new String[0]));
        return this.persistentSearches;
    }

    public void registerPersistentSearch(PersistentSearch persistentSearch) {
        assert (Debug.debugEnter(CLASS_NAME, "registerPersistentSearch", String.valueOf(persistentSearch)));
        this.persistentSearches.add(persistentSearch);
    }

    public void deregisterPersistentSearch(PersistentSearch persistentSearch) {
        assert (Debug.debugEnter(CLASS_NAME, "deregisterPersistentSearch", String.valueOf(persistentSearch)));
        this.persistentSearches.remove(persistentSearch);
    }

    public abstract CancelResult cancelOperation(int var1, CancelRequest var2);

    public abstract void cancelAllOperations(CancelRequest var1);

    public abstract void cancelAllOperationsExcept(CancelRequest var1, int var2);

    public AuthenticationInfo getAuthenticationInfo() {
        assert (Debug.debugEnter(CLASS_NAME, "getAuthenticationInfo", new String[0]));
        return this.authenticationInfo;
    }

    public void setAuthenticationInfo(AuthenticationInfo authenticationInfo) {
        assert (Debug.debugEnter(CLASS_NAME, "setAuthenticationInfo", String.valueOf(authenticationInfo)));
        this.authenticationInfo = authenticationInfo == null ? new AuthenticationInfo() : authenticationInfo;
    }

    public void setUnauthenticated() {
        assert (Debug.debugEnter(CLASS_NAME, "setUnauthenticated", new String[0]));
        this.authenticationInfo = new AuthenticationInfo();
        this.sizeLimit = DirectoryServer.getSizeLimit();
        this.timeLimit = DirectoryServer.getTimeLimit();
    }

    public final Object getSASLAuthStateInfo() {
        assert (Debug.debugEnter(CLASS_NAME, "getSASLAuthStateInfo", new String[0]));
        return this.saslAuthState;
    }

    public final void setSASLAuthStateInfo(Object object) {
        assert (Debug.debugEnter(CLASS_NAME, "setSASLAuthStateInfo", String.valueOf(object)));
        this.saslAuthState = object;
    }

    public final int getSizeLimit() {
        assert (Debug.debugEnter(CLASS_NAME, "getSizeLimit", new String[0]));
        return this.sizeLimit;
    }

    public final void setSizeLimit(int n) {
        assert (Debug.debugEnter(CLASS_NAME, "setSizeLimit", String.valueOf(n)));
        this.sizeLimit = n;
    }

    public final int getLookthroughLimit() {
        assert (Debug.debugEnter(CLASS_NAME, "getLookthroughLimit", new String[0]));
        return this.lookthroughLimit;
    }

    public final void setLookthroughLimit(int n) {
        assert (Debug.debugEnter(CLASS_NAME, "setLookthroughLimit", String.valueOf(n)));
        this.lookthroughLimit = n;
    }

    public final int getTimeLimit() {
        assert (Debug.debugEnter(CLASS_NAME, "getTimeLimit", new String[0]));
        return this.timeLimit;
    }

    public final void setTimeLimit(int n) {
        assert (Debug.debugEnter(CLASS_NAME, "setTimeLimit", String.valueOf(n)));
        this.timeLimit = n;
    }

    public final String toString() {
        assert (Debug.debugEnter(CLASS_NAME, "toString", new String[0]));
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    public abstract void toString(StringBuilder var1);
}

