/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.Properties;
import java.util.zip.CRC32;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import kafka.message.CompressionCodec;
import kafka.message.CompressionCodec$;
import kafka.message.NoCompressionCodec$;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.ScalaObject;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Utils$
implements ScalaObject {
    public static final Utils$ MODULE$;
    private final Logger kafka$utils$Utils$$logger;

    static {
        new Utils$();
    }

    public final Logger kafka$utils$Utils$$logger() {
        return this.kafka$utils$Utils$$logger;
    }

    public Runnable runnable(Function0<Object> fun$2) {
        return new anon.1(fun$2);
    }

    public Runnable loggedRunnable(Function0<Object> fun$1) {
        return new anon.2(fun$1);
    }

    public Thread daemonThread(String name, Runnable runnable) {
        return this.newThread(name, runnable, true);
    }

    public Thread daemonThread(String name, Function0<Object> fun) {
        return this.daemonThread(name, this.runnable(fun));
    }

    public Thread newThread(String name, Runnable runnable, boolean daemon) {
        Thread thread = new Thread(runnable, name);
        thread.setDaemon(daemon);
        return thread;
    }

    public byte[] readBytes(ByteBuffer buffer, int offset, int size2) {
        byte[] bytes = new byte[size2];
        for (int i = 0; i < size2; ++i) {
            bytes[i] = buffer.get(offset + i);
        }
        return bytes;
    }

    public String readShortString(ByteBuffer buffer, String encoding) {
        short size2 = buffer.getShort();
        if (size2 < 0) {
            return null;
        }
        byte[] bytes = new byte[size2];
        buffer.get(bytes);
        return new String(bytes, encoding);
    }

    public void writeShortString(ByteBuffer buffer, String string, String encoding) {
        if (string == null) {
            buffer.putShort((short)-1);
        } else {
            if (string.length() > Short.MAX_VALUE) {
                throw new IllegalArgumentException(new StringBuilder().append((Object)"String exceeds the maximum size of ").append((Object)BoxesRunTime.boxToShort((short)Short.MAX_VALUE)).append((Object)".").toString());
            }
            buffer.putShort((short)string.length());
            buffer.put(string.getBytes(encoding));
        }
    }

    /*
     * WARNING - void declaration
     */
    public Properties loadProps(String filename) {
        void var3_3;
        FileInputStream propStream = new FileInputStream(filename);
        Properties props = new Properties();
        props.load(propStream);
        return var3_3;
    }

    public int getInt(Properties props, String name) {
        if (props.containsKey(name)) {
            return this.getInt(props, name, -1);
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)"Missing required property '").append((Object)name).append((Object)"'").toString());
    }

    public int getInt(Properties props, String name, int n) {
        return this.getIntInRange(props, name, n, (Tuple2<Integer, Integer>)new Tuple2.mcII.sp(Integer.MIN_VALUE, Integer.MAX_VALUE));
    }

    public int getIntInRange(Properties props, String name, int n, Tuple2<Integer, Integer> range) {
        int v;
        int n2 = v = props.containsKey(name) ? Predef$.MODULE$.augmentString(props.getProperty(name)).toInt() : n;
        if (v < range._1$mcI$sp() || v > range._2$mcI$sp()) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)name).append((Object)" has value ").append((Object)BoxesRunTime.boxToInteger((int)v)).append((Object)" which is not in the range ").append(range).append((Object)".").toString());
        }
        return v;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean getBoolean(Properties props, String name, boolean bl) {
        if (props.containsKey(name)) {
            String string = props.getProperty(name);
            if ("true" == null) {
                if (string == null) return true;
            } else if ("true".equals(string)) {
                return true;
            }
            String string2 = props.getProperty(name);
            if ("false" != null) {
                if (!"false".equals(string2)) throw new IllegalArgumentException(new StringBuilder().append((Object)"Unacceptable value for property '").append((Object)name).append((Object)"', boolean values must be either 'true' or 'false").toString());
                return false;
            }
            if (string2 == null) return false;
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Unacceptable value for property '").append((Object)name).append((Object)"', boolean values must be either 'true' or 'false").toString());
        }
        boolean bl2 = bl;
        return bl2;
    }

    public String getString(Properties props, String name, String string) {
        return props.containsKey(name) ? props.getProperty(name) : string;
    }

    public String getString(Properties props, String name) {
        if (props.containsKey(name)) {
            return props.getProperty(name);
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)"Missing required property '").append((Object)name).append((Object)"'").toString());
    }

    public Properties getProps(Properties props, String name) {
        if (props.containsKey(name)) {
            String propString = props.getProperty(name);
            String[] propValues$1 = propString.split(",");
            Properties properties$1 = new Properties();
            Predef$.MODULE$.intWrapper(0).until(propValues$1.length).foreach((Function1)new anonfun.getProps.1(propValues$1, properties$1));
            return properties$1;
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)"Missing required property '").append((Object)name).append((Object)"'").toString());
    }

    public Properties getProps(Properties props, String name, Properties properties) {
        Properties properties2;
        if (props.containsKey(name)) {
            String propString = props.getProperty(name);
            String[] propValues$2 = propString.split(",");
            if (propValues$2.length < 1) {
                throw new IllegalArgumentException(new StringBuilder().append((Object)"Illegal format of specifying properties '").append((Object)propString).append((Object)"'").toString());
            }
            Properties properties$2 = new Properties();
            Predef$.MODULE$.intWrapper(0).until(propValues$2.length).foreach((Function1)new anonfun.getProps.2(propValues$2, properties$2));
            properties2 = properties$2;
        } else {
            properties2 = properties;
        }
        return properties2;
    }

    public FileChannel openChannel(File file, boolean mutable) {
        return mutable ? new RandomAccessFile(file, "rw").getChannel() : new FileInputStream(file).getChannel();
    }

    public void swallow(Function2<Object, Throwable, Object> log, Function0<Object> action) {
        try {
            action.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            log.apply((Object)throwable.getMessage(), (Object)throwable);
        }
    }

    public boolean equal(ByteBuffer b1$1, ByteBuffer b2$1) {
        Object object = new Object();
        boolean exceptionResult1 = false;
        try {
            if (b1$1.position() != b2$1.position()) {
                return false;
            }
            if (b1$1.remaining() != b2$1.remaining()) {
                return false;
            }
            Predef$.MODULE$.intWrapper(0).until(b1$1.remaining()).foreach$mVc$sp((Function1)new anonfun.equal.1(b1$1, b2$1, object));
            return true;
        }
        catch (NonLocalReturnControl nonLocalReturnControl) {
            if (nonLocalReturnControl.key() == object) {
                exceptionResult1 = BoxesRunTime.unboxToBoolean((Object)nonLocalReturnControl.value());
                return exceptionResult1;
            }
            throw nonLocalReturnControl;
        }
    }

    public String toString(ByteBuffer buffer, String encoding) {
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        return new String(bytes, encoding);
    }

    public void croak(String message) {
        System.err.println(message);
        System.exit(1);
    }

    public void rm(String file) {
        this.rm(new File(file));
    }

    public void rm(File file) {
        if (file == null) {
            return;
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files != null) {
                Predef$.MODULE$.refArrayOps((Object[])files).foreach((Function1)new anonfun.rm.1());
            }
            file.delete();
        } else {
            file.delete();
        }
    }

    public void registerMBean(Object mbean, String name) {
        MBeanServer mbs;
        MBeanServer mBeanServer = mbs = ManagementFactory.getPlatformMBeanServer();
        synchronized (mBeanServer) {
            ObjectName objName = new ObjectName(name);
            if (mbs.isRegistered(objName)) {
                mbs.unregisterMBean(objName);
            }
            mbs.registerMBean(mbean, objName);
            return;
        }
    }

    public void unregisterMBean(String name) {
        MBeanServer mbs;
        MBeanServer mBeanServer = mbs = ManagementFactory.getPlatformMBeanServer();
        synchronized (mBeanServer) {
            BoxedUnit boxedUnit;
            ObjectName objName = new ObjectName(name);
            if (mbs.isRegistered(objName)) {
                mbs.unregisterMBean(objName);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public long getUnsignedInt(ByteBuffer buffer) {
        return (long)buffer.getInt() & 0xFFFFFFFFL;
    }

    public long getUnsignedInt(ByteBuffer buffer, int index) {
        return (long)buffer.getInt(index) & 0xFFFFFFFFL;
    }

    public void putUnsignedInt(ByteBuffer buffer, long value) {
        buffer.putInt((int)(value & 0xFFFFFFFFL));
    }

    public void putUnsignedInt(ByteBuffer buffer, int index, long value) {
        buffer.putInt(index, (int)(value & 0xFFFFFFFFL));
    }

    public long crc32(byte[] bytes) {
        return this.crc32(bytes, 0, bytes.length);
    }

    public long crc32(byte[] bytes, int offset, int size2) {
        CRC32 crc = new CRC32();
        crc.update(bytes, offset, size2);
        return crc.getValue();
    }

    public int hashcode(Seq<Object> as) {
        if (as == null) {
            return 0;
        }
        int h = 1;
        int i = 0;
        while (i < as.length()) {
            if (as.apply(i) == null) continue;
            h = 31 * h + as.apply(i).hashCode();
            ++i;
        }
        return h;
    }

    /*
     * WARNING - void declaration
     */
    public <K, V> Map<K, List<V>> groupby(Iterable<V> vals, Function1<V, K> f$1) {
        void var3_3;
        HashMap m$1 = new HashMap();
        vals.foreach((Function1)new anonfun.groupby.1(f$1, m$1));
        return var3_3;
    }

    public int read(ReadableByteChannel channel, ByteBuffer buffer) {
        int n = channel.read(buffer);
        if (n == -1) {
            throw new EOFException("Received -1 when reading from channel, socket has likely been closed.");
        }
        if (BoxesRunTime.boxToInteger((int)n) instanceof Integer) {
            return n;
        }
        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
    }

    public <V> V notNull(V v) {
        if (v == null) {
            throw new IllegalArgumentException("Value cannot be null.");
        }
        return v;
    }

    public Tuple2<String, Integer> getHostPort(String hostport) {
        String[] splits = hostport.split(":");
        return new Tuple2((Object)splits[0], (Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.augmentString(splits[1]).toInt()));
    }

    public Tuple2<String, Integer> getTopicPartition(String topicPartition) {
        int index = topicPartition.lastIndexOf(45);
        return new Tuple2((Object)topicPartition.substring(0, index), (Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.augmentString(topicPartition.substring(index + 1)).toInt()));
    }

    public String stackTrace(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    private <K, V> Map<K, V> getCSVMap(String allCSVals, String exceptionMsg$1, String successMsg$1) {
        HashMap map$1 = new HashMap();
        if ("".equals(allCSVals)) {
            return map$1;
        }
        String[] csVals$1 = allCSVals.split(",");
        Predef$.MODULE$.intWrapper(0).until(csVals$1.length).foreach((Function1)new anonfun.getCSVMap.1(exceptionMsg$1, successMsg$1, map$1, csVals$1));
        return map$1;
    }

    public Seq<String> getCSVList(String csvList) {
        return csvList == null ? (Seq)Seq$.MODULE$.empty() : Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])csvList.split(",")).filter((Function1)new anonfun.getCSVList.1()));
    }

    public Map<String, Integer> getTopicRentionHours(String retentionHours) {
        String exceptionMsg = "Malformed token for topic.log.retention.hours in server.properties: ";
        String successMsg = "The retention hour for ";
        return this.getCSVMap(retentionHours, exceptionMsg, successMsg);
    }

    public Map<String, Integer> getTopicFlushIntervals(String allIntervals) {
        String exceptionMsg = "Malformed token for topic.flush.Intervals.ms in server.properties: ";
        String successMsg = "The flush interval for ";
        return this.getCSVMap(allIntervals, exceptionMsg, successMsg);
    }

    public Map<String, Integer> getTopicPartitions(String allPartitions) {
        String exceptionMsg = "Malformed token for topic.partition.counts in server.properties: ";
        String successMsg = "The number of partitions for topic  ";
        return this.getCSVMap(allPartitions, exceptionMsg, successMsg);
    }

    public Map<String, Integer> getConsumerTopicMap(String consumerTopicString) {
        String exceptionMsg = "Malformed token for embeddedconsumer.topics in consumer.properties: ";
        String successMsg = "The number of consumer thread for topic  ";
        return this.getCSVMap(consumerTopicString, exceptionMsg, successMsg);
    }

    public <T> T getObject(String className) {
        T t;
        String string = className;
        if (string == null) {
            t = null;
        } else {
            Class<?> clazz = Class.forName(className);
            Class<?> clazzT = clazz;
            Constructor<?>[] constructors = clazzT.getConstructors();
            Predef$.MODULE$.require(constructors.length == 1);
            t = ((Constructor)Predef$.MODULE$.refArrayOps((Object[])constructors).head()).newInstance(new Object[0]);
        }
        return t;
    }

    public boolean propertyExists(String prop) {
        return prop == null ? false : prop.compareTo("") != 0;
    }

    public CompressionCodec getCompressionCodec(Properties props, String codec) {
        String codecValueString = props.getProperty(codec);
        return codecValueString == null ? NoCompressionCodec$.MODULE$ : CompressionCodec$.MODULE$.getCompressionCodec(Predef$.MODULE$.augmentString(codecValueString).toInt());
    }

    private Utils$() {
        MODULE$ = this;
        this.kafka$utils$Utils$$logger = Logger.getLogger(this.getClass());
    }
}

