/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kafka.api.OffsetRequest$;
import kafka.consumer.Consumer$;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.ConsumerConnector;
import kafka.consumer.KafkaMessageStream;
import kafka.message.Message;
import kafka.tools.ReplayLogProducer;
import kafka.tools.ReplayLogProducer$;
import kafka.utils.ZKStringSerializer$;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.log4j.Logger;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class ReplayLogProducer$
implements ScalaObject {
    public static final ReplayLogProducer$ MODULE$;
    private final String GROUPID;
    private final Logger logger;

    static {
        new ReplayLogProducer$();
    }

    private String GROUPID() {
        return this.GROUPID;
    }

    private Logger logger() {
        return this.logger;
    }

    public void main(String[] args) {
        boolean isNoPrint = false;
        ReplayLogProducer.Config config$1 = new ReplayLogProducer.Config(args);
        ExecutorService executor = Executors.newFixedThreadPool(config$1.numThreads());
        CountDownLatch allDone = new CountDownLatch(config$1.numThreads());
        this.tryCleanupZookeeper(config$1.zkConnect(), this.GROUPID());
        Thread.sleep(500L);
        Properties consumerProps = new Properties();
        consumerProps.put("groupid", this.GROUPID());
        consumerProps.put("zk.connect", config$1.zkConnect());
        consumerProps.put("consumer.timeout.ms", "10000");
        consumerProps.put("autooffset.reset", OffsetRequest$.MODULE$.SmallestTimeString());
        consumerProps.put("fetch.size", ((Object)BoxesRunTime.boxToInteger((int)0x100000)).toString());
        consumerProps.put("socket.buffer.size", ((Object)BoxesRunTime.boxToInteger((int)0x200000)).toString());
        ConsumerConfig consumerConfig = new ConsumerConfig(consumerProps);
        ConsumerConnector consumerConnector = Consumer$.MODULE$.create(consumerConfig);
        Map<String, List<KafkaMessageStream<Message>>> topicMessageStreams = consumerConnector.createMessageStreams((Map<String, Integer>)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc((Object)config$1.inputTopic()).$minus$greater((Object)BoxesRunTime.boxToInteger((int)config$1.numThreads()))})), consumerConnector.createMessageStreams$default$2());
        ObjectRef threadList$1 = new ObjectRef((Object)Nil$.MODULE$);
        topicMessageStreams.foreach((Function1)new anonfun.main.1(config$1, threadList$1));
        ((List)threadList$1.elem).foreach((Function1)new anonfun.main.2());
        ((List)threadList$1.elem).foreach((Function1)new anonfun.main.3());
        consumerConnector.shutdown();
    }

    public void tryCleanupZookeeper(String zkUrl, String groupId) {
        try {
            String dir = new StringBuilder().append((Object)"/consumers/").append((Object)groupId).toString();
            this.logger().info((Object)new StringBuilder().append((Object)"Cleaning up temporary zookeeper data under ").append((Object)dir).append((Object)".").toString());
            ZkClient zk = new ZkClient(zkUrl, 30000, 30000, (ZkSerializer)ZKStringSerializer$.MODULE$);
            zk.deleteRecursive(dir);
            zk.close();
        }
        catch (Throwable throwable) {}
    }

    private ReplayLogProducer$() {
        MODULE$ = this;
        this.GROUPID = "replay-log-producer";
        this.logger = Logger.getLogger(this.getClass());
    }
}

