/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.producer.Producer;
import kafka.producer.ProducerConfig;
import kafka.producer.ProducerData;
import kafka.tools.ProducerShell$;
import kafka.utils.Utils$;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.runtime.BoxesRunTime;

public final class ProducerShell$
implements ScalaObject {
    public static final ProducerShell$ MODULE$;

    static {
        new ProducerShell$();
    }

    public void main(String[] args) {
        OptionParser parser$1 = new OptionParser();
        ArgumentAcceptingOptionSpec producerPropsOpt = parser$1.accepts("props", "REQUIRED: Properties file with the producer properties.").withRequiredArg().describedAs("properties").ofType(String.class);
        ArgumentAcceptingOptionSpec topicOpt = parser$1.accepts("topic", "REQUIRED: The topic to produce to.").withRequiredArg().describedAs("topic").ofType(String.class);
        OptionSet options$1 = parser$1.parse(args);
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArgumentAcceptingOptionSpec[]{producerPropsOpt, topicOpt})).foreach((Function1)new anonfun.main.1(parser$1, options$1));
        String propsFile = (String)options$1.valueOf((OptionSpec)producerPropsOpt);
        ProducerConfig producerConfig = new ProducerConfig(Utils$.MODULE$.loadProps(propsFile));
        String topic = (String)options$1.valueOf((OptionSpec)topicOpt);
        Producer producer = new Producer(producerConfig);
        BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
        boolean done = false;
        while (true) {
            if (done) {
                producer.close();
                return;
            }
            String line = input.readLine();
            if (line == null) {
                done = true;
                continue;
            }
            String message = line.trim();
            producer.send(Predef$.MODULE$.wrapRefArray((Object[])new ProducerData[]{new ProducerData(topic, message)}));
            Predef$.MODULE$.println((Object)Predef$.MODULE$.augmentString("Sent: %s (%d bytes)").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{line, BoxesRunTime.boxToInteger((int)message.getBytes().length)})));
        }
    }

    private ProducerShell$() {
        MODULE$ = this;
    }
}

