/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.util.Properties;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicLong;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.message.CompressionCodec;
import kafka.message.CompressionCodec$;
import kafka.producer.DefaultPartitioner;
import kafka.producer.Producer;
import kafka.producer.ProducerConfig;
import kafka.producer.async.DefaultEventHandler;
import kafka.serializer.StringEncoder;
import kafka.tools.ProducerPerformance$;
import kafka.tools.ProducerPerformance$AsyncProducerThread$;
import kafka.tools.ProducerPerformance$PerfConfig$;
import kafka.tools.ProducerPerformance$SyncProducerThread$;
import org.apache.log4j.Logger;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\t5v!B\u0001\u0003\u0011\u000b9\u0011a\u0005)s_\u0012,8-\u001a:QKJ4wN]7b]\u000e,'BA\u0002\u0005\u0003\u0015!xn\u001c7t\u0015\u0005)\u0011!B6bM.\f7\u0001\u0001\t\u0003\u0011%i\u0011A\u0001\u0004\t\u0015\t!\t\u0011!E\u0003\u0017\t\u0019\u0002K]8ek\u000e,'\u000fU3sM>\u0014X.\u00198dKN\u0019\u0011\u0002\u0004\u000b\u0011\u00055\u0011R\"\u0001\b\u000b\u0005=\u0001\u0012\u0001\u00027b]\u001eT\u0011!E\u0001\u0005U\u00064\u0018-\u0003\u0002\u0014\u001d\t1qJ\u00196fGR\u0004\"!\u0006\r\u000e\u0003YQ\u0011aF\u0001\u0006g\u000e\fG.Y\u0005\u00033Y\u00111bU2bY\u0006|%M[3di\")1$\u0003C\u00019\u00051A(\u001b8jiz\"\u0012a\u0002\u0005\u0006=%!\taH\u0001\u0005[\u0006Lg\u000e\u0006\u0002!GA\u0011Q#I\u0005\u0003EY\u0011A!\u00168ji\")A%\ba\u0001K\u0005!\u0011M]4t!\r)b\u0005K\u0005\u0003OY\u0011Q!\u0011:sCf\u0004\"!\u000b\u0017\u000f\u0005UQ\u0013BA\u0016\u0017\u0003\u0019\u0001&/\u001a3fM&\u0011QF\f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005-2b\u0001\u0003\u0019\n\t\u0003\u0005\t\u0011A\u0019\u0003\u0015A+'OZ\"p]\u001aLwmE\u00020\u0019QA\u0001\u0002J\u0018\u0003\u0002\u0003\u0006I!\n\u0005\u00067=\"\t\u0001\u000e\u000b\u0003k]\u0002\"AN\u0018\u000e\u0003%AQ\u0001J\u001aA\u0002\u0015Bq!O\u0018C\u0002\u0013\u0005!(\u0001\u0004qCJ\u001cXM]\u000b\u0002wA\u0011AhP\u0007\u0002{)\ta(\u0001\u0006k_B$8/[7qY\u0016L!\u0001Q\u001f\u0003\u0019=\u0003H/[8o!\u0006\u00148/\u001a:\t\r\t{\u0003\u0015!\u0003<\u0003\u001d\u0001\u0018M]:fe\u0002Bq\u0001R\u0018C\u0002\u0013\u0005Q)A\u0007ce>\\WM]%oM>|\u0005\u000f^\u000b\u0002\rB\u0019Ah\u0012\u0015\n\u0005!k$aG!sOVlWM\u001c;BG\u000e,\u0007\u000f^5oO>\u0003H/[8o'B,7\r\u0003\u0004K_\u0001\u0006IAR\u0001\u000fEJ|7.\u001a:J]\u001a|w\n\u001d;!\u0011\u001dauF1A\u0005\u0002\u0015\u000b\u0001\u0002^8qS\u000e|\u0005\u000f\u001e\u0005\u0007\u001d>\u0002\u000b\u0011\u0002$\u0002\u0013Q|\u0007/[2PaR\u0004\u0003b\u0002)0\u0005\u0004%\t!U\u0001\u000f]VlW*Z:tC\u001e,7o\u00149u+\u0005\u0011\u0006c\u0001\u001fH'B\u0011Q\u0002V\u0005\u0003+:\u0011q!\u00138uK\u001e,'\u000f\u0003\u0004X_\u0001\u0006IAU\u0001\u0010]VlW*Z:tC\u001e,7o\u00149uA!9\u0011l\fb\u0001\n\u0003\t\u0016AD7fgN\fw-Z*ju\u0016|\u0005\u000f\u001e\u0005\u00077>\u0002\u000b\u0011\u0002*\u0002\u001f5,7o]1hKNK'0Z(qi\u0002Bq!X\u0018C\u0002\u0013\u0005a,\u0001\nwCJLX*Z:tC\u001e,7+\u001b>f\u001fB$X#A0\u0011\u0005q\u0002\u0017BA1>\u0005Ey\u0005\u000f^5p]N\u0003Xm\u0019\"vS2$WM\u001d\u0005\u0007G>\u0002\u000b\u0011B0\u0002'Y\f'/_'fgN\fw-Z*ju\u0016|\u0005\u000f\u001e\u0011\t\u000f\u0015|#\u0019!C\u0001=\u0006A\u0011m]=oG>\u0003H\u000f\u0003\u0004h_\u0001\u0006IaX\u0001\nCNLhnY(qi\u0002Bq![\u0018C\u0002\u0013\u0005\u0011+\u0001\u0007cCR\u001c\u0007nU5{K>\u0003H\u000f\u0003\u0004l_\u0001\u0006IAU\u0001\u000eE\u0006$8\r[*ju\u0016|\u0005\u000f\u001e\u0011\t\u000f5|#\u0019!C\u0001#\u0006ia.^7UQJ,\u0017\rZ:PaRDaa\\\u0018!\u0002\u0013\u0011\u0016A\u00048v[RC'/Z1eg>\u0003H\u000f\t\u0005\bc>\u0012\r\u0011\"\u0001R\u0003Q\u0011X\r]8si&tw-\u00138uKJ4\u0018\r\\(qi\"11o\fQ\u0001\nI\u000bQC]3q_J$\u0018N\\4J]R,'O^1m\u001fB$\b\u0005C\u0004v_\t\u0007I\u0011A)\u0002-\r|W\u000e\u001d:fgNLwN\\\"pI\u0016\u001cw\n\u001d;j_:Daa^\u0018!\u0002\u0013\u0011\u0016aF2p[B\u0014Xm]:j_:\u001cu\u000eZ3d\u001fB$\u0018n\u001c8!\u0011\u001dIxF1A\u0005\u0002i\fqa\u001c9uS>t7/F\u0001|!\taD0\u0003\u0002~{\tIq\n\u001d;j_:\u001cV\r\u001e\u0005\u0007\u007f>\u0002\u000b\u0011B>\u0002\u0011=\u0004H/[8og\u0002B\u0011\"a\u00010\u0005\u0004%\t!!\u0002\u0002\u0015\t\u0014xn[3s\u0013:4w.F\u0001)\u0011\u001d\tIa\fQ\u0001\n!\n1B\u0019:pW\u0016\u0014\u0018J\u001c4pA!I\u0011QB\u0018C\u0002\u0013\u0005\u0011qB\u0001\f]VlW*Z:tC\u001e,7/\u0006\u0002\u0002\u0012A\u0019Q#a\u0005\n\u0007\u0005UaCA\u0002J]RD\u0001\"!\u00070A\u0003%\u0011\u0011C\u0001\r]VlW*Z:tC\u001e,7\u000f\t\u0005\n\u0003;y#\u0019!C\u0001\u0003\u001f\t1\"\\3tg\u0006<WmU5{K\"A\u0011\u0011E\u0018!\u0002\u0013\t\t\"\u0001\u0007nKN\u001c\u0018mZ3TSj,\u0007\u0005C\u0005\u0002&=\u0012\r\u0011\"\u0001\u0002(\u0005I\u0011n\u001d$jqNK'0Z\u000b\u0003\u0003S\u00012!FA\u0016\u0013\r\tiC\u0006\u0002\b\u0005>|G.Z1o\u0011!\t\td\fQ\u0001\n\u0005%\u0012AC5t\r&D8+\u001b>fA!I\u0011QG\u0018C\u0002\u0013\u0005\u0011qE\u0001\bSN\f5/\u001f8d\u0011!\tId\fQ\u0001\n\u0005%\u0012\u0001C5t\u0003NLhn\u0019\u0011\t\u0013\u0005ur\u00061A\u0005\u0002\u0005=\u0011!\u00032bi\u000eD7+\u001b>f\u0011%\t\te\fa\u0001\n\u0003\t\u0019%A\u0007cCR\u001c\u0007nU5{K~#S-\u001d\u000b\u0004A\u0005\u0015\u0003BCA$\u0003\u007f\t\t\u00111\u0001\u0002\u0012\u0005\u0019\u0001\u0010J\u0019\t\u0011\u0005-s\u0006)Q\u0005\u0003#\t!BY1uG\"\u001c\u0016N_3!\u0011%\tye\fb\u0001\n\u0003\ty!\u0001\u0006ok6$\u0006N]3bIND\u0001\"a\u00150A\u0003%\u0011\u0011C\u0001\f]VlG\u000b\u001b:fC\u0012\u001c\b\u0005C\u0005\u0002X=\u0012\r\u0011\"\u0001\u0002\u0006\u0005)Ao\u001c9jG\"9\u00111L\u0018!\u0002\u0013A\u0013A\u0002;pa&\u001c\u0007\u0005C\u0005\u0002`=\u0012\r\u0011\"\u0001\u0002\u0010\u0005\t\"/\u001a9peRLgnZ%oi\u0016\u0014h/\u00197\t\u0011\u0005\rt\u0006)A\u0005\u0003#\t!C]3q_J$\u0018N\\4J]R,'O^1mA!I\u0011qM\u0018C\u0002\u0013\u0005\u0011\u0011N\u0001\u0011G>l\u0007O]3tg&|gnQ8eK\u000e,\"!a\u001b\u0011\t\u00055\u00141O\u0007\u0003\u0003_R1!!\u001d\u0005\u0003\u001diWm]:bO\u0016LA!!\u001e\u0002p\t\u00012i\\7qe\u0016\u001c8/[8o\u0007>$Wm\u0019\u0005\t\u0003sz\u0003\u0015!\u0003\u0002l\u0005\t2m\\7qe\u0016\u001c8/[8o\u0007>$Wm\u0019\u0011\t\u000f\u0005u\u0014\u0002\"\u0003\u0002\u0000\u0005\tr-\u001a;TiJLgnZ(g\u0019\u0016tw\r\u001e5\u0015\u0007!\n\t\t\u0003\u0005\u0002\u0004\u0006m\u0004\u0019AA\t\u0003\raWM\u001c\u0004\u000b\u0003\u000fKA\u0011!A\u0001\u0002\u0005%%aE!ts:\u001c\u0007K]8ek\u000e,'\u000f\u00165sK\u0006$7CBAC\u0019\u0005-E\u0003E\u0002\u000e\u0003\u001bK1!a$\u000f\u0005!\u0011VO\u001c8bE2,\u0007bCAJ\u0003\u000b\u0013)\u0019!C\u0001\u0003\u001f\t\u0001\u0002\u001e5sK\u0006$\u0017\n\u001a\u0005\f\u0003/\u000b)I!A!\u0002\u0013\t\t\"A\u0005uQJ,\u0017\rZ%eA!Y\u00111TAC\u0005\u000b\u0007I\u0011AAO\u0003\u0019\u0019wN\u001c4jOV\tQ\u0007\u0003\u0006\u0002\"\u0006\u0015%\u0011!Q\u0001\nU\nqaY8oM&<\u0007\u0005C\u0006\u0002&\u0006\u0015%Q1A\u0005\u0002\u0005\u001d\u0016A\u0004;pi\u0006d')\u001f;fgN+g\u000e^\u000b\u0003\u0003S\u0003B!a+\u0002:6\u0011\u0011Q\u0016\u0006\u0005\u0003_\u000b\t,\u0001\u0004bi>l\u0017n\u0019\u0006\u0005\u0003g\u000b),\u0001\u0006d_:\u001cWO\u001d:f]RT1!a.\u0011\u0003\u0011)H/\u001b7\n\t\u0005m\u0016Q\u0016\u0002\u000b\u0003R|W.[2M_:<\u0007bCA`\u0003\u000b\u0013\t\u0011)A\u0005\u0003S\u000bq\u0002^8uC2\u0014\u0015\u0010^3t'\u0016tG\u000f\t\u0005\f\u0003\u0007\f)I!b\u0001\n\u0003\t9+A\tu_R\fG.T3tg\u0006<Wm]*f]RD1\"a2\u0002\u0006\n\u0005\t\u0015!\u0003\u0002*\u0006\u0011Bo\u001c;bY6+7o]1hKN\u001cVM\u001c;!\u0011-\tY-!\"\u0003\u0006\u0004%\t!!4\u0002\u000f\u0005dG\u000eR8oKV\u0011\u0011q\u001a\t\u0005\u0003#\f\u0019.\u0004\u0002\u00022&!\u0011Q[AY\u00059\u0019u.\u001e8u\t><h\u000eT1uG\"D1\"!7\u0002\u0006\n\u0005\t\u0015!\u0003\u0002P\u0006A\u0011\r\u001c7E_:,\u0007\u0005C\u0006\u0002^\u0006\u0015%Q1A\u0005\u0002\u0005}\u0017\u0001\u0002:b]\u0012,\"!!9\u0011\t\u0005\r\u0018Q]\u0007\u0003\u0003kKA!a:\u00026\n1!+\u00198e_6D1\"a;\u0002\u0006\n\u0005\t\u0015!\u0003\u0002b\u0006)!/\u00198eA!91$!\"\u0005\u0002\u0005=HCDAy\u0003g\f)0a>\u0002z\u0006m\u0018Q \t\u0004m\u0005\u0015\u0005\u0002CAJ\u0003[\u0004\r!!\u0005\t\u000f\u0005m\u0015Q\u001ea\u0001k!A\u0011QUAw\u0001\u0004\tI\u000b\u0003\u0005\u0002D\u00065\b\u0019AAU\u0011!\tY-!<A\u0002\u0005=\u0007\u0002CAo\u0003[\u0004\r!!9\t\u0015\t\u0005\u0011Q\u0011b\u0001\n\u0003\u0011\u0019!\u0001\u0004m_\u001e<WM]\u000b\u0003\u0005\u000b\u0001BAa\u0002\u0003\u00165\u0011!\u0011\u0002\u0006\u0005\u0005\u0017\u0011i!A\u0003m_\u001e$$N\u0003\u0003\u0003\u0010\tE\u0011AB1qC\u000eDWM\u0003\u0002\u0003\u0014\u0005\u0019qN]4\n\t\t]!\u0011\u0002\u0002\u0007\u0019><w-\u001a:\t\u0013\tm\u0011Q\u0011Q\u0001\n\t\u0015\u0011a\u00027pO\u001e,'\u000f\t\u0005\u000b\u0005?\t)I1A\u0005\u0002\t\u0005\u0012A\u00042s_.,'/\u00138g_2K7\u000f^\u000b\u0003\u0005G\u0001B!\u0006\u0014\u0003&A\u0019QBa\n\n\u00055r\u0001\"\u0003B\u0016\u0003\u000b\u0003\u000b\u0011\u0002B\u0012\u0003=\u0011'o\\6fe&sgm\u001c'jgR\u0004\u0003B\u0003B\u0018\u0003\u000b\u0013\r\u0011\"\u0001\u00032\u0005)\u0001O]8qgV\u0011!1\u0007\t\u0005\u0003G\u0014)$\u0003\u0003\u00038\u0005U&A\u0003)s_B,'\u000f^5fg\"I!1HACA\u0003%!1G\u0001\u0007aJ|\u0007o\u001d\u0011\t\u0015\t}\u0012Q\u0011b\u0001\n\u0003\u0011\t%\u0001\bqe>$WoY3s\u0007>tg-[4\u0016\u0005\t\r\u0003\u0003\u0002B#\u0005\u0017j!Aa\u0012\u000b\u0007\t%C!\u0001\u0005qe>$WoY3s\u0013\u0011\u0011iEa\u0012\u0003\u001dA\u0013x\u000eZ;dKJ\u001cuN\u001c4jO\"I!\u0011KACA\u0003%!1I\u0001\u0010aJ|G-^2fe\u000e{gNZ5hA!Q!\u0011JAC\u0005\u0004%\tA!\u0016\u0016\u0005\t]\u0003C\u0002B#\u00053B\u0003&\u0003\u0003\u0003\\\t\u001d#\u0001\u0003)s_\u0012,8-\u001a:\t\u0013\t}\u0013Q\u0011Q\u0001\n\t]\u0013!\u00039s_\u0012,8-\u001a:!\u0011!\u0011\u0019'!\"\u0005B\t\u0015\u0014a\u0001:v]R\t\u0001E\u0002\u0006\u0003j%!\t\u0011!A\u0001\u0005W\u0012!cU=oGB\u0013x\u000eZ;dKJ$\u0006N]3bIN1!q\r\u0007\u0002\fRA1\"a%\u0003h\t\u0015\r\u0011\"\u0001\u0002\u0010!Y\u0011q\u0013B4\u0005\u0003\u0005\u000b\u0011BA\t\u0011-\tYJa\u001a\u0003\u0006\u0004%\t!!(\t\u0015\u0005\u0005&q\rB\u0001B\u0003%Q\u0007C\u0006\u0002&\n\u001d$Q1A\u0005\u0002\u0005\u001d\u0006bCA`\u0005O\u0012\t\u0011)A\u0005\u0003SC1\"a1\u0003h\t\u0015\r\u0011\"\u0001\u0002(\"Y\u0011q\u0019B4\u0005\u0003\u0005\u000b\u0011BAU\u0011-\tYMa\u001a\u0003\u0006\u0004%\t!!4\t\u0017\u0005e'q\rB\u0001B\u0003%\u0011q\u001a\u0005\f\u0003;\u00149G!b\u0001\n\u0003\ty\u000eC\u0006\u0002l\n\u001d$\u0011!Q\u0001\n\u0005\u0005\bbB\u000e\u0003h\u0011\u0005!q\u0011\u000b\u000f\u0005\u0013\u0013YI!$\u0003\u0010\nE%1\u0013BK!\r1$q\r\u0005\t\u0003'\u0013)\t1\u0001\u0002\u0012!9\u00111\u0014BC\u0001\u0004)\u0004\u0002CAS\u0005\u000b\u0003\r!!+\t\u0011\u0005\r'Q\u0011a\u0001\u0003SC\u0001\"a3\u0003\u0006\u0002\u0007\u0011q\u001a\u0005\t\u0003;\u0014)\t1\u0001\u0002b\"Q!\u0011\u0001B4\u0005\u0004%\tAa\u0001\t\u0013\tm!q\rQ\u0001\n\t\u0015\u0001B\u0003B\u0018\u0005O\u0012\r\u0011\"\u0001\u00032!I!1\bB4A\u0003%!1\u0007\u0005\u000b\u0005?\u00119G1A\u0005\u0002\t\u0005\u0002\"\u0003B\u0016\u0005O\u0002\u000b\u0011\u0002B\u0012\u0011)\u0011yDa\u001aC\u0002\u0013\u0005!\u0011\t\u0005\n\u0005#\u00129\u0007)A\u0005\u0005\u0007B!B!\u0013\u0003h\t\u0007I\u0011\u0001B+\u0011%\u0011yFa\u001a!\u0002\u0013\u00119\u0006\u0003\u0005\u0003d\t\u001dD\u0011\tB3\u0001")
public final class ProducerPerformance {
    public static final void main(String[] stringArray) {
        ProducerPerformance$.MODULE$.main(stringArray);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PerfConfig
    implements ScalaObject {
        private final OptionParser parser = new OptionParser();
        private final ArgumentAcceptingOptionSpec<String> brokerInfoOpt = this.parser().accepts("brokerinfo", "REQUIRED: broker info (either from zookeeper or a list.").withRequiredArg().describedAs("broker.list=brokerid:hostname:port or zk.connect=host:port").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> topicOpt = this.parser().accepts("topic", "REQUIRED: The topic to consume from.").withRequiredArg().describedAs("topic").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<Integer> numMessagesOpt = this.parser().accepts("messages", "REQUIRED: The number of messages to send.").withRequiredArg().describedAs("count").ofType(Integer.class);
        private final ArgumentAcceptingOptionSpec<Integer> messageSizeOpt = this.parser().accepts("message-size", "The size of each message.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(100), (Object[])new Integer[0]);
        private final OptionSpecBuilder varyMessageSizeOpt = this.parser().accepts("vary-message-size", "If set, message size will vary up to the given maximum.");
        private final OptionSpecBuilder asyncOpt = this.parser().accepts("async", "If set, messages are sent asynchronously.");
        private final ArgumentAcceptingOptionSpec<Integer> batchSizeOpt = this.parser().accepts("batch-size", "Number of messages to send in a single batch.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(200), (Object[])new Integer[0]);
        private final ArgumentAcceptingOptionSpec<Integer> numThreadsOpt = this.parser().accepts("threads", "Number of sending threads.").withRequiredArg().describedAs("count").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(10), (Object[])new Integer[0]);
        private final ArgumentAcceptingOptionSpec<Integer> reportingIntervalOpt = this.parser().accepts("reporting-interval", "Interval at which to print progress info.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(5000), (Object[])new Integer[0]);
        private final ArgumentAcceptingOptionSpec<Integer> compressionCodecOption = this.parser().accepts("compression-codec", "If set, messages are sent compressed").withRequiredArg().describedAs("compression codec ").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0), (Object[])new Integer[0]);
        private final OptionSet options;
        private final String brokerInfo;
        private final int numMessages;
        private final int messageSize;
        private final boolean isFixSize;
        private final boolean isAsync;
        private int batchSize;
        private final int numThreads;
        private final String topic;
        private final int reportingInterval;
        private final CompressionCodec compressionCodec;

        public OptionParser parser() {
            return this.parser;
        }

        public ArgumentAcceptingOptionSpec<String> brokerInfoOpt() {
            return this.brokerInfoOpt;
        }

        public ArgumentAcceptingOptionSpec<String> topicOpt() {
            return this.topicOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> numMessagesOpt() {
            return this.numMessagesOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> messageSizeOpt() {
            return this.messageSizeOpt;
        }

        public OptionSpecBuilder varyMessageSizeOpt() {
            return this.varyMessageSizeOpt;
        }

        public OptionSpecBuilder asyncOpt() {
            return this.asyncOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> batchSizeOpt() {
            return this.batchSizeOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> numThreadsOpt() {
            return this.numThreadsOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> reportingIntervalOpt() {
            return this.reportingIntervalOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> compressionCodecOption() {
            return this.compressionCodecOption;
        }

        public OptionSet options() {
            return this.options;
        }

        public String brokerInfo() {
            return this.brokerInfo;
        }

        public int numMessages() {
            return this.numMessages;
        }

        public int messageSize() {
            return this.messageSize;
        }

        public boolean isFixSize() {
            return this.isFixSize;
        }

        public boolean isAsync() {
            return this.isAsync;
        }

        public int batchSize() {
            return this.batchSize;
        }

        public void batchSize_$eq(int n) {
            this.batchSize = n;
        }

        public int numThreads() {
            return this.numThreads;
        }

        public String topic() {
            return this.topic;
        }

        public int reportingInterval() {
            return this.reportingInterval;
        }

        public CompressionCodec compressionCodec() {
            return this.compressionCodec;
        }

        public PerfConfig(String[] args) {
            this.options = this.parser().parse(args);
            List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArgumentAcceptingOptionSpec[]{this.brokerInfoOpt(), this.topicOpt(), this.numMessagesOpt()})).foreach((Function1)new PerfConfig$$anonfun$1(this));
            this.brokerInfo = (String)this.options().valueOf(this.brokerInfoOpt());
            this.numMessages = (Integer)this.options().valueOf(this.numMessagesOpt());
            this.messageSize = (Integer)this.options().valueOf(this.messageSizeOpt());
            this.isFixSize = !this.options().has((OptionSpec)this.varyMessageSizeOpt());
            this.isAsync = this.options().has((OptionSpec)this.asyncOpt());
            this.batchSize = (Integer)this.options().valueOf(this.batchSizeOpt());
            this.numThreads = (Integer)this.options().valueOf(this.numThreadsOpt());
            this.topic = (String)this.options().valueOf(this.topicOpt());
            this.reportingInterval = (Integer)this.options().valueOf(this.reportingIntervalOpt());
            this.compressionCodec = CompressionCodec$.MODULE$.getCompressionCodec((Integer)this.options().valueOf(this.compressionCodecOption()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SyncProducerThread
    implements Runnable,
    ScalaObject {
        private final int threadId;
        private final PerfConfig config;
        private final AtomicLong totalBytesSent;
        private final AtomicLong totalMessagesSent;
        private final CountDownLatch allDone;
        private final Random rand;
        private final Logger logger;
        private final Properties props;
        private final String[] brokerInfoList;
        private final ProducerConfig producerConfig;
        private final Producer<String, String> producer;

        public int threadId() {
            return this.threadId;
        }

        public PerfConfig config() {
            return this.config;
        }

        public AtomicLong totalBytesSent() {
            return this.totalBytesSent;
        }

        public AtomicLong totalMessagesSent() {
            return this.totalMessagesSent;
        }

        public CountDownLatch allDone() {
            return this.allDone;
        }

        public Random rand() {
            return this.rand;
        }

        public Logger logger() {
            return this.logger;
        }

        public Properties props() {
            return this.props;
        }

        public String[] brokerInfoList() {
            return this.brokerInfoList;
        }

        public ProducerConfig producerConfig() {
            return this.producerConfig;
        }

        public Producer<String, String> producer() {
            return this.producer;
        }

        @Override
        public void run() {
            LongRef bytesSent$2 = new LongRef(0L);
            LongRef lastBytesSent$2 = new LongRef(0L);
            IntRef nSends$2 = new IntRef(0);
            IntRef lastNSends$2 = new IntRef(0);
            String message$2 = ProducerPerformance$.MODULE$.kafka$tools$ProducerPerformance$$getStringOfLength(this.config().messageSize());
            LongRef reportTime$2 = new LongRef(System.currentTimeMillis());
            LongRef lastReportTime$2 = new LongRef(reportTime$2.elem);
            int messagesPerThread = this.config().numMessages() / this.config().numThreads() / this.config().batchSize();
            this.logger().info((Object)new StringBuilder().append((Object)"Messages per thread = ").append((Object)BoxesRunTime.boxToInteger((int)messagesPerThread)).toString());
            ObjectRef messageSet$1 = new ObjectRef((Object)Nil$.MODULE$);
            Predef$.MODULE$.intWrapper(0).until(this.config().batchSize()).foreach$mVc$sp((Function1)new SyncProducerThread$$anonfun$run$2(this, message$2, messageSet$1));
            Predef$.MODULE$.intWrapper(0).until(messagesPerThread).foreach$mVc$sp((Function1)new SyncProducerThread$$anonfun$run$3(this, bytesSent$2, lastBytesSent$2, nSends$2, lastNSends$2, reportTime$2, lastReportTime$2, messageSet$1));
            this.producer().close();
            this.totalBytesSent().addAndGet(bytesSent$2.elem);
            this.totalMessagesSent().addAndGet(nSends$2.elem * this.config().batchSize());
            this.allDone().countDown();
        }

        public SyncProducerThread(int threadId, PerfConfig config, AtomicLong totalBytesSent, AtomicLong totalMessagesSent, CountDownLatch allDone, Random rand) {
            this.threadId = threadId;
            this.config = config;
            this.totalBytesSent = totalBytesSent;
            this.totalMessagesSent = totalMessagesSent;
            this.allDone = allDone;
            this.rand = rand;
            this.logger = Logger.getLogger(this.getClass());
            this.props = new Properties();
            this.brokerInfoList = config.brokerInfo().split("=");
            String string = this.brokerInfoList()[0];
            String string2 = "zk.connect";
            Object object = !(string != null ? !string.equals(string2) : string2 != null) ? this.props().put("zk.connect", this.brokerInfoList()[1]) : this.props().put("broker.list", this.brokerInfoList()[1]);
            this.props().put("compression.codec", ((Object)BoxesRunTime.boxToInteger((int)config.compressionCodec().codec())).toString());
            this.props().put("reconnect.interval", ((Object)BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE)).toString());
            this.props().put("buffer.size", ((Object)BoxesRunTime.boxToInteger((int)65536)).toString());
            this.producerConfig = new ProducerConfig(this.props());
            this.producer = new Producer(this.producerConfig(), new StringEncoder(), new DefaultEventHandler(this.producerConfig(), null), null, new DefaultPartitioner());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AsyncProducerThread
    implements Runnable,
    ScalaObject {
        private final int threadId;
        private final PerfConfig config;
        private final AtomicLong totalBytesSent;
        private final AtomicLong totalMessagesSent;
        private final CountDownLatch allDone;
        private final Random rand;
        private final Logger logger;
        private final String[] brokerInfoList;
        private final Properties props;
        private final ProducerConfig producerConfig;
        private final Producer<String, String> producer;

        public int threadId() {
            return this.threadId;
        }

        public PerfConfig config() {
            return this.config;
        }

        public AtomicLong totalBytesSent() {
            return this.totalBytesSent;
        }

        public AtomicLong totalMessagesSent() {
            return this.totalMessagesSent;
        }

        public CountDownLatch allDone() {
            return this.allDone;
        }

        public Random rand() {
            return this.rand;
        }

        public Logger logger() {
            return this.logger;
        }

        public String[] brokerInfoList() {
            return this.brokerInfoList;
        }

        public Properties props() {
            return this.props;
        }

        public ProducerConfig producerConfig() {
            return this.producerConfig;
        }

        public Producer<String, String> producer() {
            return this.producer;
        }

        @Override
        public void run() {
            LongRef bytesSent$1 = new LongRef(0L);
            LongRef lastBytesSent$1 = new LongRef(0L);
            IntRef nSends$1 = new IntRef(0);
            IntRef lastNSends$1 = new IntRef(0);
            ObjectRef message$1 = new ObjectRef((Object)ProducerPerformance$.MODULE$.kafka$tools$ProducerPerformance$$getStringOfLength(this.config().messageSize()));
            LongRef reportTime$1 = new LongRef(System.currentTimeMillis());
            LongRef lastReportTime$1 = new LongRef(reportTime$1.elem);
            int messagesPerThread = this.config().numMessages() / this.config().numThreads();
            this.logger().info((Object)new StringBuilder().append((Object)"Messages per thread = ").append((Object)BoxesRunTime.boxToInteger((int)messagesPerThread)).toString());
            Predef$.MODULE$.intWrapper(0).until(messagesPerThread).foreach$mVc$sp((Function1)new AsyncProducerThread$$anonfun$run$1(this, bytesSent$1, lastBytesSent$1, nSends$1, lastNSends$1, message$1, reportTime$1, lastReportTime$1));
            this.producer().close();
            this.totalBytesSent().addAndGet(bytesSent$1.elem);
            this.totalMessagesSent().addAndGet(nSends$1.elem);
            this.allDone().countDown();
        }

        public AsyncProducerThread(int threadId, PerfConfig config, AtomicLong totalBytesSent, AtomicLong totalMessagesSent, CountDownLatch allDone, Random rand) {
            this.threadId = threadId;
            this.config = config;
            this.totalBytesSent = totalBytesSent;
            this.totalMessagesSent = totalMessagesSent;
            this.allDone = allDone;
            this.rand = rand;
            this.logger = Logger.getLogger(this.getClass());
            this.brokerInfoList = config.brokerInfo().split("=");
            this.props = new Properties();
            String string = this.brokerInfoList()[0];
            String string2 = "zk.connect";
            Object object = !(string != null ? !string.equals(string2) : string2 != null) ? this.props().put("zk.connect", this.brokerInfoList()[1]) : this.props().put("broker.list", this.brokerInfoList()[1]);
            this.props().put("compression.codec", ((Object)BoxesRunTime.boxToInteger((int)config.compressionCodec().codec())).toString());
            this.props().put("producer.type", "async");
            this.props().put("batch.size", ((Object)BoxesRunTime.boxToInteger((int)config.batchSize())).toString());
            this.props().put("reconnect.interval", ((Object)BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE)).toString());
            this.props().put("buffer.size", ((Object)BoxesRunTime.boxToInteger((int)65536)).toString());
            this.props().put("queue.enqueueTimeout.ms", "-1");
            this.logger().info((Object)new StringBuilder().append((Object)"Producer properties = ").append((Object)this.props().toString()).toString());
            this.producerConfig = new ProducerConfig(this.props());
            this.producer = new Producer(this.producerConfig(), new StringEncoder(), new DefaultEventHandler(this.producerConfig(), null), null, new DefaultPartitioner());
        }
    }
}

