/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.log.LogManager;
import kafka.network.Receive;
import kafka.network.Send;
import kafka.network.SocketServer;
import kafka.network.SocketServerStats;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRequestHandlers;
import kafka.server.KafkaServer$;
import kafka.utils.KafkaScheduler;
import kafka.utils.Mx4jLoader$;
import kafka.utils.SystemTime$;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.ScalaObject;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%b\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\u0004\u0003\u0017-\u000bgm[1TKJ4XM\u001d\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u0003\t\u0011\u0005%qQ\"\u0001\u0006\u000b\u0005-a\u0011\u0001\u00027b]\u001eT\u0011!D\u0001\u0005U\u00064\u0018-\u0003\u0002\u0010\u0015\t1qJ\u00196fGR\u0004\"!\u0005\u000b\u000e\u0003IQ\u0011aE\u0001\u0006g\u000e\fG.Y\u0005\u0003+I\u00111bU2bY\u0006|%M[3di\"Aq\u0003\u0001BC\u0002\u0013\u0005\u0001$\u0001\u0004d_:4\u0017nZ\u000b\u00023A\u0011!dG\u0007\u0002\u0005%\u0011AD\u0001\u0002\f\u0017\u000647.Y\"p]\u001aLw\r\u0003\u0005\u001f\u0001\t\u0005\t\u0015!\u0003\u001a\u0003\u001d\u0019wN\u001c4jO\u0002BQ\u0001\t\u0001\u0005\u0002\u0005\na\u0001P5oSRtDC\u0001\u0012$!\tQ\u0002\u0001C\u0003\u0018?\u0001\u0007\u0011\u0004C\u0004&\u0001\t\u0007I\u0011\u0001\u0014\u0002'\rcU)\u0011(`'\"+F\u000bR(X\u001d~3\u0015\nT#\u0016\u0003\u001d\u0002\"!\u0003\u0015\n\u0005%R!AB*ue&tw\r\u0003\u0004,\u0001\u0001\u0006IaJ\u0001\u0015\u00072+\u0015IT0T\u0011V#FiT,O?\u001aKE*\u0012\u0011\t\u000f5\u0002!\u0019!C\u0005]\u0005q\u0011n]*ikR$\u0018N\\4E_^tW#A\u0018\u0011\u0005A:T\"A\u0019\u000b\u0005I\u001a\u0014AB1u_6L7M\u0003\u00025k\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005Yb\u0011\u0001B;uS2L!\u0001O\u0019\u0003\u001b\u0005#x.\\5d\u0005>|G.Z1o\u0011\u0019Q\u0004\u0001)A\u0005_\u0005y\u0011n]*ikR$\u0018N\\4E_^t\u0007\u0005C\u0004=\u0001\t\u0007I\u0011B\u001f\u0002\r1|wmZ3s+\u0005q\u0004CA G\u001b\u0005\u0001%BA!C\u0003\u0015awn\u001a\u001bk\u0015\t\u0019E)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u000b\u0006\u0019qN]4\n\u0005\u001d\u0003%A\u0002'pO\u001e,'\u000f\u0003\u0004J\u0001\u0001\u0006IAP\u0001\bY><w-\u001a:!\u0011\u001dY\u0005A1A\u0005\n1\u000bQb\u001d5vi\u0012|wO\u001c'bi\u000eDW#A'\u0011\u00059{U\"A\u001a\n\u0005A\u001b$AD\"pk:$Hi\\<o\u0019\u0006$8\r\u001b\u0005\u0007%\u0002\u0001\u000b\u0011B'\u0002\u001dMDW\u000f\u001e3po:d\u0015\r^2iA!9A\u000b\u0001b\u0001\n\u00131\u0013AD:uCR\u001cXJQ3b]:\u000bW.\u001a\u0005\u0007-\u0002\u0001\u000b\u0011B\u0014\u0002\u001fM$\u0018\r^:N\u0005\u0016\fgNT1nK\u0002Bq\u0001\u0017\u0001A\u0002\u0013\u0005\u0011,\u0001\u0007t_\u000e\\W\r^*feZ,'/F\u0001[!\tYf,D\u0001]\u0015\tiF!A\u0004oKR<xN]6\n\u0005}c&\u0001D*pG.,GoU3sm\u0016\u0014\bbB1\u0001\u0001\u0004%\tAY\u0001\u0011g>\u001c7.\u001a;TKJ4XM]0%KF$\"a\u00194\u0011\u0005E!\u0017BA3\u0013\u0005\u0011)f.\u001b;\t\u000f\u001d\u0004\u0017\u0011!a\u00015\u0006\u0019\u0001\u0010J\u0019\t\r%\u0004\u0001\u0015)\u0003[\u00035\u0019xnY6fiN+'O^3sA!91\u000e\u0001b\u0001\n\u0003a\u0017!C:dQ\u0016$W\u000f\\3s+\u0005i\u0007C\u00018r\u001b\u0005y'B\u00019\u0005\u0003\u0015)H/\u001b7t\u0013\t\u0011xN\u0001\bLC\u001a\\\u0017mU2iK\u0012,H.\u001a:\t\rQ\u0004\u0001\u0015!\u0003n\u0003)\u00198\r[3ek2,'\u000f\t\u0005\bm\u0002\u0001\r\u0011\"\u0003x\u0003)awnZ'b]\u0006<WM]\u000b\u0002qB\u0011\u0011\u0010`\u0007\u0002u*\u00111\u0010B\u0001\u0004Y><\u0017BA?{\u0005)aunZ'b]\u0006<WM\u001d\u0005\t\u007f\u0002\u0001\r\u0011\"\u0003\u0002\u0002\u0005qAn\\4NC:\fw-\u001a:`I\u0015\fHcA2\u0002\u0004!9qM`A\u0001\u0002\u0004A\bbBA\u0004\u0001\u0001\u0006K\u0001_\u0001\fY><W*\u00198bO\u0016\u0014\b\u0005C\u0004\u0002\f\u0001!\t!!\u0004\u0002\u000fM$\u0018M\u001d;vaR\t1\rC\u0004\u0002\u0012\u0001!\t!!\u0004\u0002\u0011MDW\u000f\u001e3po:Dq!!\u0006\u0001\t\u0003\ti!A\u0007bo\u0006LGo\u00155vi\u0012|wO\u001c\u0005\b\u00033\u0001A\u0011AA\u000e\u000359W\r\u001e'pO6\u000bg.Y4feR\t\u0001\u0010C\u0004\u0002 \u0001!\t!!\t\u0002\u0011\u001d,Go\u0015;biN$\"!a\t\u0011\u0007m\u000b)#C\u0002\u0002(q\u0013\u0011cU8dW\u0016$8+\u001a:wKJ\u001cF/\u0019;t\u0001")
public class KafkaServer
implements ScalaObject {
    private final KafkaConfig config;
    private final String CLEAN_SHUTDOWN_FILE;
    private final AtomicBoolean isShuttingDown;
    private final Logger kafka$server$KafkaServer$$logger;
    private final CountDownLatch shutdownLatch;
    private final String kafka$server$KafkaServer$$statsMBeanName;
    private SocketServer socketServer;
    private final KafkaScheduler scheduler;
    private LogManager logManager;

    public KafkaConfig config() {
        return this.config;
    }

    public String CLEAN_SHUTDOWN_FILE() {
        return this.CLEAN_SHUTDOWN_FILE;
    }

    private AtomicBoolean isShuttingDown() {
        return this.isShuttingDown;
    }

    public final Logger kafka$server$KafkaServer$$logger() {
        return this.kafka$server$KafkaServer$$logger;
    }

    private CountDownLatch shutdownLatch() {
        return this.shutdownLatch;
    }

    public final String kafka$server$KafkaServer$$statsMBeanName() {
        return this.kafka$server$KafkaServer$$statsMBeanName;
    }

    public SocketServer socketServer() {
        return this.socketServer;
    }

    public void socketServer_$eq(SocketServer socketServer) {
        this.socketServer = socketServer;
    }

    public KafkaScheduler scheduler() {
        return this.scheduler;
    }

    private LogManager logManager() {
        return this.logManager;
    }

    private void logManager_$eq(LogManager logManager) {
        this.logManager = logManager;
    }

    public void startup() {
        try {
            Object object;
            this.kafka$server$KafkaServer$$logger().info((Object)"Starting Kafka server...");
            boolean needRecovery = true;
            File cleanShutDownFile = new File(new File(this.config().logDir()), this.CLEAN_SHUTDOWN_FILE());
            if (cleanShutDownFile.exists()) {
                needRecovery = false;
                object = BoxesRunTime.boxToBoolean((boolean)cleanShutDownFile.delete());
            } else {
                object = BoxedUnit.UNIT;
            }
            this.logManager_$eq(new LogManager(this.config(), this.scheduler(), SystemTime$.MODULE$, 60000L * (long)this.config().logCleanupIntervalMinutes(), 3600000L * (long)this.config().logRetentionHours(), needRecovery));
            KafkaRequestHandlers handlers$1 = new KafkaRequestHandlers(this.logManager());
            this.socketServer_$eq(new SocketServer(this.config().port(), this.config().numThreads(), this.config().monitoringPeriodSecs(), (Function2<Short, Receive, Function1<Receive, Option<Send>>>)new $anonfun$startup$2(this, handlers$1), this.config().maxSocketRequestSize()));
            Utils$.MODULE$.swallow((Function2<Object, Throwable, Object>)new $anonfun$startup$3(this), (Function0<Object>)new $anonfun$startup$1(this));
            this.socketServer().startup();
            Mx4jLoader$.MODULE$.maybeLoad();
            this.logManager().startup();
            this.kafka$server$KafkaServer$$logger().info((Object)"Server started.");
        }
        catch (Throwable throwable) {
            this.kafka$server$KafkaServer$$logger().fatal((Object)"Fatal error during startup.", throwable);
            this.shutdown();
        }
    }

    public void shutdown() {
        boolean canShutdown = this.isShuttingDown().compareAndSet(false, true);
        if (canShutdown) {
            this.kafka$server$KafkaServer$$logger().info((Object)"Shutting down...");
            Object exceptionResult1 = null;
            try {
                this.scheduler().shutdown();
                if (this.socketServer() != null) {
                    this.socketServer().shutdown();
                }
                Utils$.MODULE$.swallow((Function2<Object, Throwable, Object>)new $anonfun$shutdown$2(this), (Function0<Object>)new $anonfun$shutdown$1(this));
                if (this.logManager() != null) {
                    this.logManager().close();
                }
                File cleanShutDownFile = new File(new File(this.config().logDir()), this.CLEAN_SHUTDOWN_FILE());
                exceptionResult1 = BoxesRunTime.boxToBoolean((boolean)cleanShutDownFile.createNewFile());
            }
            catch (Throwable throwable) {
                this.kafka$server$KafkaServer$$logger().fatal((Object)throwable);
                this.kafka$server$KafkaServer$$logger().fatal((Object)Utils$.MODULE$.stackTrace(throwable));
                exceptionResult1 = BoxedUnit.UNIT;
            }
            this.shutdownLatch().countDown();
            this.kafka$server$KafkaServer$$logger().info((Object)"shut down completed");
        }
    }

    public void awaitShutdown() {
        this.shutdownLatch().await();
    }

    public LogManager getLogManager() {
        return this.logManager();
    }

    public SocketServerStats getStats() {
        return this.socketServer().stats();
    }

    public KafkaServer(KafkaConfig config) {
        this.config = config;
        this.CLEAN_SHUTDOWN_FILE = ".kafka_cleanshutdown";
        this.isShuttingDown = new AtomicBoolean(false);
        this.kafka$server$KafkaServer$$logger = Logger.getLogger(KafkaServer.class);
        this.shutdownLatch = new CountDownLatch(1);
        this.kafka$server$KafkaServer$$statsMBeanName = "kafka:type=kafka.SocketServerStats";
        this.socketServer = null;
        this.scheduler = new KafkaScheduler(1, "kafka-logcleaner-", false);
        this.logManager = null;
    }
}

