/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.IOException;
import kafka.api.FetchRequest;
import kafka.api.FetchRequest$;
import kafka.api.MultiFetchRequest;
import kafka.api.MultiFetchRequest$;
import kafka.api.MultiProducerRequest;
import kafka.api.MultiProducerRequest$;
import kafka.api.OffsetArraySend;
import kafka.api.OffsetRequest;
import kafka.api.OffsetRequest$;
import kafka.api.ProducerRequest;
import kafka.api.ProducerRequest$;
import kafka.api.RequestKeys$;
import kafka.common.ErrorMapping$;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.message.MessageSet$;
import kafka.network.Receive;
import kafka.network.Send;
import kafka.server.KafkaRequestHandlers$;
import kafka.server.MessageSetSend;
import kafka.server.MultiMessageSetSend;
import kafka.utils.SystemTime$;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassManifest$;
import scala.reflect.ScalaSignature;
import scala.runtime.AbstractFunction1;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005ea!C\u0001\u0003\t\u0003\u0005\t\u0011\u0001\u0003\u0007\u0005QY\u0015MZ6b%\u0016\fX/Z:u\u0011\u0006tG\r\\3sg*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c2\u0001A\u0004\u0010!\tAQ\"D\u0001\n\u0015\tQ1\"\u0001\u0003mC:<'\"\u0001\u0007\u0002\t)\fg/Y\u0005\u0003\u001d%\u0011aa\u00142kK\u000e$\bC\u0001\t\u0014\u001b\u0005\t\"\"\u0001\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\t\"aC*dC2\fwJ\u00196fGRD\u0001B\u0006\u0001\u0003\u0006\u0004%\t\u0001G\u0001\u000bY><W*\u00198bO\u0016\u00148\u0001A\u000b\u00023A\u0011!$H\u0007\u00027)\u0011A\u0004B\u0001\u0004Y><\u0017B\u0001\u0010\u001c\u0005)aunZ'b]\u0006<WM\u001d\u0005\tA\u0001\u0011\t\u0011)A\u00053\u0005YAn\\4NC:\fw-\u001a:!\u0011\u0015\u0011\u0003\u0001\"\u0001$\u0003\u0019a\u0014N\\5u}Q\u0011AE\n\t\u0003K\u0001i\u0011A\u0001\u0005\u0006-\u0005\u0002\r!\u0007\u0005\bQ\u0001\u0011\r\u0011\"\u0003*\u0003\u0019awnZ4feV\t!\u0006\u0005\u0002,e5\tAF\u0003\u0002.]\u0005)An\\45U*\u0011q\u0006M\u0001\u0007CB\f7\r[3\u000b\u0003E\n1a\u001c:h\u0013\t\u0019DF\u0001\u0004M_\u001e<WM\u001d\u0005\u0007k\u0001\u0001\u000b\u0011\u0002\u0016\u0002\u000f1|wmZ3sA!9q\u0007\u0001b\u0001\n\u0013I\u0013!\u0004:fcV,7\u000f\u001e'pO\u001e,'\u000f\u0003\u0004:\u0001\u0001\u0006IAK\u0001\u000fe\u0016\fX/Z:u\u0019><w-\u001a:!\u0011\u0015Y\u0004\u0001\"\u0001=\u0003)A\u0017M\u001c3mKJ4uN\u001d\u000b\u0004{\u001dc\u0005C\u0001 E\u001d\ty$)D\u0001A\u0015\t\tE!A\u0004oKR<xN]6\n\u0005\r\u0003\u0015a\u0002%b]\u0012dWM]\u0005\u0003\u000b\u001a\u0013q\u0001S1oI2,'O\u0003\u0002D\u0001\")\u0001J\u000fa\u0001\u0013\u0006i!/Z9vKN$H+\u001f9f\u0013\u0012\u0004\"\u0001\u0005&\n\u0005-\u000b\"!B*i_J$\b\"B';\u0001\u0004q\u0015a\u0002:fcV,7\u000f\u001e\t\u0003\u007f=K!\u0001\u0015!\u0003\u000fI+7-Z5wK\")!\u000b\u0001C\u0001'\u0006)\u0002.\u00198eY\u0016\u0004&o\u001c3vG\u0016\u0014(+Z9vKN$HC\u0001+[!\r\u0001RkV\u0005\u0003-F\u0011aa\u00149uS>t\u0007CA Y\u0013\tI\u0006I\u0001\u0003TK:$\u0007\"B.R\u0001\u0004q\u0015a\u0002:fG\u0016Lg/\u001a\u0005\u0006;\u0002!\tAX\u0001\u001bQ\u0006tG\r\\3Nk2$\u0018\u000e\u0015:pIV\u001cWM\u001d*fcV,7\u000f\u001e\u000b\u0003)~CQa\u0017/A\u00029CQA\u0015\u0001\u0005\n\u0005$2AY3m!\t\u00012M\u0003\u0002e#\u0005!aj\u001c8f\u0011\u0015i\u0005\r1\u0001g!\t9'.D\u0001i\u0015\tIG!A\u0002ba&L!a\u001b5\u0003\u001fA\u0013x\u000eZ;dKJ\u0014V-];fgRDQ!\u001c1A\u00029\f!C]3rk\u0016\u001cH\u000fS1oI2,'OT1nKB\u0011qN\u001d\b\u0003!AL!!]\t\u0002\rA\u0013X\rZ3g\u0013\t\u0019HO\u0001\u0004TiJLgn\u001a\u0006\u0003cFAQA\u001e\u0001\u0005\u0002]\f!\u0003[1oI2,g)\u001a;dQJ+\u0017/^3tiR\u0011A\u000b\u001f\u0005\u0006\u001bV\u0004\rA\u0014\u0005\u0006u\u0002!\ta_\u0001\u0018Q\u0006tG\r\\3Nk2$\u0018NR3uG\"\u0014V-];fgR$\"\u0001\u0016?\t\u000b5K\b\u0019\u0001(\t\u000by\u0004A\u0011B@\u0002\u001dI,\u0017\rZ'fgN\fw-Z*fiR!\u0011\u0011AA\u0004!\r)\u00131A\u0005\u0004\u0003\u000b\u0011!AD'fgN\fw-Z*fiN+g\u000e\u001a\u0005\b\u0003\u0013i\b\u0019AA\u0006\u000311W\r^2i%\u0016\fX/Z:u!\r9\u0017QB\u0005\u0004\u0003\u001fA'\u0001\u0004$fi\u000eD'+Z9vKN$\bbBA\n\u0001\u0011\u0005\u0011QC\u0001\u0014Q\u0006tG\r\\3PM\u001a\u001cX\r\u001e*fcV,7\u000f\u001e\u000b\u0004)\u0006]\u0001BB'\u0002\u0012\u0001\u0007a\n")
public class KafkaRequestHandlers
implements ScalaObject {
    private final LogManager logManager;
    private final Logger logger;
    private final Logger kafka$server$KafkaRequestHandlers$$requestLogger;

    public LogManager logManager() {
        return this.logManager;
    }

    private Logger logger() {
        return this.logger;
    }

    public final Logger kafka$server$KafkaRequestHandlers$$requestLogger() {
        return this.kafka$server$KafkaRequestHandlers$$requestLogger;
    }

    public Function1<Receive, Option<Send>> handlerFor(short requestTypeId, Receive request) {
        block7: {
            AbstractFunction1 abstractFunction1;
            block3: {
                short s;
                block6: {
                    block5: {
                        block4: {
                            block2: {
                                s = requestTypeId;
                                if (s != RequestKeys$.MODULE$.Produce()) break block2;
                                abstractFunction1 = new $anonfun$handlerFor$1(this);
                                break block3;
                            }
                            if (s != RequestKeys$.MODULE$.Fetch()) break block4;
                            abstractFunction1 = new $anonfun$handlerFor$2(this);
                            break block3;
                        }
                        if (s != RequestKeys$.MODULE$.MultiFetch()) break block5;
                        abstractFunction1 = new $anonfun$handlerFor$3(this);
                        break block3;
                    }
                    if (s != RequestKeys$.MODULE$.MultiProduce()) break block6;
                    abstractFunction1 = new $anonfun$handlerFor$4(this);
                    break block3;
                }
                if (s != RequestKeys$.MODULE$.Offsets()) break block7;
                abstractFunction1 = new $anonfun$handlerFor$5(this);
            }
            return abstractFunction1;
        }
        throw new IllegalStateException(new StringBuilder().append((Object)"No mapping found for handler id ").append((Object)BoxesRunTime.boxToShort((short)requestTypeId)).toString());
    }

    public Option<Send> handleProducerRequest(Receive receive) {
        long sTime = SystemTime$.MODULE$.milliseconds();
        ProducerRequest request = ProducerRequest$.MODULE$.readFrom(receive.buffer());
        if (this.kafka$server$KafkaRequestHandlers$$requestLogger().isTraceEnabled()) {
            this.kafka$server$KafkaRequestHandlers$$requestLogger().trace((Object)new StringBuilder().append((Object)"Producer request ").append((Object)request.toString()).toString());
        }
        this.kafka$server$KafkaRequestHandlers$$handleProducerRequest(request, "ProduceRequest");
        if (this.logger().isDebugEnabled()) {
            this.logger().debug((Object)new StringBuilder().append((Object)"kafka produce time ").append((Object)BoxesRunTime.boxToLong((long)(SystemTime$.MODULE$.milliseconds() - sTime))).append((Object)" ms").toString());
        }
        return None$.MODULE$;
    }

    public Option<Send> handleMultiProducerRequest(Receive receive) {
        MultiProducerRequest request = MultiProducerRequest$.MODULE$.readFrom(receive.buffer());
        if (this.kafka$server$KafkaRequestHandlers$$requestLogger().isTraceEnabled()) {
            this.kafka$server$KafkaRequestHandlers$$requestLogger().trace((Object)new StringBuilder().append((Object)"Multiproducer request ").append((Object)request.toString()).toString());
        }
        Predef$.MODULE$.refArrayOps((Object[])request.produces()).map((Function1)new $anonfun$handleMultiProducerRequest$1(this), Array$.MODULE$.canBuildFrom(ClassManifest$.MODULE$.classType(None$.class)));
        return None$.MODULE$;
    }

    public final None$ kafka$server$KafkaRequestHandlers$$handleProducerRequest(ProducerRequest request, String requestHandlerName) {
        int partition = request.getTranslatedPartition((Function1<String, Integer>)new $anonfun$1(this));
        try {
            this.logManager().getOrCreateLog(request.topic(), partition).append(request.messages());
            if (this.logger().isTraceEnabled()) {
                this.logger().trace((Object)new StringBuilder().append(request.messages().sizeInBytes()).append((Object)" bytes written to logs.").toString());
            }
            return None$.MODULE$;
        }
        catch (Throwable throwable) {
            this.logger().error((Object)new StringBuilder().append((Object)"Error processing ").append((Object)requestHandlerName).append((Object)" on ").append((Object)request.topic()).append((Object)":").append((Object)BoxesRunTime.boxToInteger((int)partition)).toString(), throwable);
            Throwable throwable2 = throwable;
            if (throwable2 instanceof IOException) {
                this.logger().fatal((Object)new StringBuilder().append((Object)"Halting due to unrecoverable I/O error while handling producer request: ").append((Object)throwable.getMessage()).toString(), throwable);
                Runtime.getRuntime().halt(1);
            }
            throw throwable;
        }
    }

    public Option<Send> handleFetchRequest(Receive request) {
        FetchRequest fetchRequest = FetchRequest$.MODULE$.readFrom(request.buffer());
        if (this.kafka$server$KafkaRequestHandlers$$requestLogger().isTraceEnabled()) {
            this.kafka$server$KafkaRequestHandlers$$requestLogger().trace((Object)new StringBuilder().append((Object)"Fetch request ").append((Object)fetchRequest.toString()).toString());
        }
        return new Some((Object)this.kafka$server$KafkaRequestHandlers$$readMessageSet(fetchRequest));
    }

    public Option<Send> handleMultiFetchRequest(Receive request) {
        MultiFetchRequest multiFetchRequest = MultiFetchRequest$.MODULE$.readFrom(request.buffer());
        if (this.kafka$server$KafkaRequestHandlers$$requestLogger().isTraceEnabled()) {
            this.kafka$server$KafkaRequestHandlers$$requestLogger().trace((Object)"Multifetch request");
        }
        Predef$.MODULE$.refArrayOps((Object[])multiFetchRequest.fetches()).foreach((Function1)new $anonfun$handleMultiFetchRequest$1(this));
        List responses = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])multiFetchRequest.fetches()).map((Function1)new $anonfun$2(this), Array$.MODULE$.canBuildFrom(ClassManifest$.MODULE$.classType(MessageSetSend.class)))).toList();
        return new Some((Object)new MultiMessageSetSend((List<MessageSetSend>)responses));
    }

    /*
     * WARNING - void declaration
     */
    public final MessageSetSend kafka$server$KafkaRequestHandlers$$readMessageSet(FetchRequest fetchRequest) {
        void var2_2;
        MessageSetSend response = null;
        try {
            this.logger().trace((Object)new StringBuilder().append((Object)"Fetching log segment for topic = ").append((Object)fetchRequest.topic()).append((Object)" and partition = ").append((Object)BoxesRunTime.boxToInteger((int)fetchRequest.partition())).toString());
            Log log = this.logManager().getOrCreateLog(fetchRequest.topic(), fetchRequest.partition());
            response = new MessageSetSend(log.read(fetchRequest.offset(), fetchRequest.maxSize()));
        }
        catch (Throwable throwable) {
            this.logger().error((Object)new StringBuilder().append((Object)"error when processing request ").append((Object)fetchRequest).toString(), throwable);
            response = new MessageSetSend(MessageSet$.MODULE$.Empty(), ErrorMapping$.MODULE$.codeFor(throwable.getClass()));
        }
        return var2_2;
    }

    public Option<Send> handleOffsetRequest(Receive request) {
        OffsetRequest offsetRequest = OffsetRequest$.MODULE$.readFrom(request.buffer());
        if (this.kafka$server$KafkaRequestHandlers$$requestLogger().isTraceEnabled()) {
            this.kafka$server$KafkaRequestHandlers$$requestLogger().trace((Object)new StringBuilder().append((Object)"Offset request ").append((Object)offsetRequest.toString()).toString());
        }
        Log log = this.logManager().getOrCreateLog(offsetRequest.topic(), offsetRequest.partition());
        long[] offsets = log.getOffsetsBefore(offsetRequest);
        OffsetArraySend response = new OffsetArraySend(offsets);
        return new Some((Object)response);
    }

    public KafkaRequestHandlers(LogManager logManager) {
        this.logManager = logManager;
        this.logger = Logger.getLogger(KafkaRequestHandlers.class);
        this.kafka$server$KafkaRequestHandlers$$requestLogger = Logger.getLogger((String)"kafka.request.logger");
    }
}

