/*
 * Decompiled with CFR 0.152.
 */
package kafka.producer.async;

import java.lang.management.ManagementFactory;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import kafka.api.ProducerRequest$;
import kafka.producer.ProducerConfig;
import kafka.producer.SyncProducer;
import kafka.producer.async.AsyncProducer$;
import kafka.producer.async.AsyncProducerConfig;
import kafka.producer.async.AsyncProducerInterruptedException;
import kafka.producer.async.AsyncProducerStats;
import kafka.producer.async.CallbackHandler;
import kafka.producer.async.DefaultEventHandler;
import kafka.producer.async.EventHandler;
import kafka.producer.async.ProducerSendThread;
import kafka.producer.async.QueueClosedException;
import kafka.producer.async.QueueFullException;
import kafka.producer.async.QueueItem;
import kafka.serializer.Encoder;
import kafka.utils.Utils$;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005mx!B\u0001\u0003\u0011\u000bI\u0011!D!ts:\u001c\u0007K]8ek\u000e,'O\u0003\u0002\u0004\t\u0005)\u0011m]=oG*\u0011QAB\u0001\taJ|G-^2fe*\tq!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005)YQ\"\u0001\u0002\u0007\u00111\u0011A\u0011!A\t\u00065\u0011Q\"Q:z]\u000e\u0004&o\u001c3vG\u0016\u00148cA\u0006\u000f-A\u0011q\u0002F\u0007\u0002!)\u0011\u0011CE\u0001\u0005Y\u0006twMC\u0001\u0014\u0003\u0011Q\u0017M^1\n\u0005U\u0001\"AB(cU\u0016\u001cG\u000f\u0005\u0002\u001855\t\u0001DC\u0001\u001a\u0003\u0015\u00198-\u00197b\u0013\tY\u0002DA\u0006TG\u0006d\u0017m\u00142kK\u000e$\b\"B\u000f\f\t\u0003q\u0012A\u0002\u001fj]&$h\bF\u0001\n\u0011\u001d\u00013B1A\u0005\u0002\u0005\n\u0001b\u00155vi\u0012|wO\\\u000b\u0002\u001d!11e\u0003Q\u0001\n9\t\u0011b\u00155vi\u0012|wO\u001c\u0011\t\u000f\u0015Z!\u0019!C\u0001M\u00051!+\u00198e_6,\u0012a\n\t\u0003Q-j\u0011!\u000b\u0006\u0003UI\tA!\u001e;jY&\u0011A&\u000b\u0002\u0007%\u0006tGm\\7\t\r9Z\u0001\u0015!\u0003(\u0003\u001d\u0011\u0016M\u001c3p[\u0002Bq\u0001M\u0006C\u0002\u0013\u0005\u0011'A\tQe>$WoY3s\u001b\n+\u0017M\u001c(b[\u0016,\u0012A\r\t\u0003\u001fMJ!\u0001\u000e\t\u0003\rM#(/\u001b8h\u0011\u001914\u0002)A\u0005e\u0005\u0011\u0002K]8ek\u000e,'/\u0014\"fC:t\u0015-\\3!\u0011\u001dA4\"%A\u0005\u0002e\na\"\u001b8ji\u0012\"WMZ1vYR$C'\u0006\u0002;\u000f*\u00121H\u0010\t\u0003/qJ!!\u0010\r\u0003\t9+H\u000e\\\u0016\u0002\u007fA\u0011\u0001)R\u0007\u0002\u0003*\u0011!iQ\u0001\nk:\u001c\u0007.Z2lK\u0012T!\u0001\u0012\r\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002G\u0003\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0005\u0011!;D\u0011!AC\u0002%\u0013\u0011\u0001V\t\u0003\u00156\u0003\"aF&\n\u00051C\"a\u0002(pi\"Lgn\u001a\t\u0003/9K!a\u0014\r\u0003\u0007\u0005s\u0017\u0010C\u0004R\u0017E\u0005I\u0011\u0001*\u0002\u001d%t\u0017\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%kU\u00111k\u0016\u0016\u0003)z\u0002\"\u0001K+\n\u0005YK#A\u0003)s_B,'\u000f^5fg\u0012A\u0001\n\u0015C\u0001\u0002\u000b\u0007\u0011\nC\u0004Z\u0017E\u0005I\u0011\u0001.\u0002\u001d%t\u0017\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%mU\u0011!h\u0017\u0003\t\u0011b#\t\u0011!b\u0001\u0013\"9QlCI\u0001\n\u0003q\u0016AD5oSR$C-\u001a4bk2$HeN\u000b\u0003'~#\u0001\u0002\u0013/\u0005\u0002\u0003\u0015\r!\u0013\u0004\u0006\u0019\t\u0001a!Y\u000b\u0003EZ\u001c2\u0001\u0019\b\u0017\u0011!!\u0007M!A!\u0002\u0013)\u0017AB2p]\u001aLw\r\u0005\u0002\u000bM&\u0011qM\u0001\u0002\u0014\u0003NLhn\u0019)s_\u0012,8-\u001a:D_:4\u0017n\u001a\u0005\t\u000b\u0001\u0014\t\u0011)A\u0005SB\u0011!n[\u0007\u0002\t%\u0011A\u000e\u0002\u0002\r'ft7\r\u0015:pIV\u001cWM\u001d\u0005\t]\u0002\u0014\t\u0011)A\u0005_\u0006Q1/\u001a:jC2L'0\u001a:\u0011\u0007A\u0014H/D\u0001r\u0015\tqg!\u0003\u0002tc\n9QI\\2pI\u0016\u0014\bCA;w\u0019\u0001!\u0001\u0002\u00131\u0005\u0002\u0003\u0015\r!\u0013\u0005\tq\u0002\u0014\t\u0011)A\u0005s\u0006aQM^3oi\"\u000bg\u000e\u001a7feB\u0019!B\u001f;\n\u0005m\u0014!\u0001D#wK:$\b*\u00198eY\u0016\u0014\b\u0002C?a\u0005\u0003\u0005\u000b\u0011\u0002+\u0002#\u00154XM\u001c;IC:$G.\u001a:Qe>\u00048\u000fC\u0005\u0000A\n\u0005\t\u0015!\u0003\u0002\u0002\u0005Q1MY6IC:$G.\u001a:\u0011\t)\t\u0019\u0001^\u0005\u0004\u0003\u000b\u0011!aD\"bY2\u0014\u0017mY6IC:$G.\u001a:\t\u0013\u0005%\u0001M!A!\u0002\u0013!\u0016aD2cW\"\u000bg\u000e\u001a7feB\u0013x\u000e]:\t\ru\u0001G\u0011AA\u0007)A\ty!!\u0005\u0002\u0014\u0005U\u0011qCA\r\u00037\ti\u0002E\u0002\u000bARDa\u0001ZA\u0006\u0001\u0004)\u0007BB\u0003\u0002\f\u0001\u0007\u0011\u000e\u0003\u0004o\u0003\u0017\u0001\ra\u001c\u0005\tq\u0006-\u0001\u0013!a\u0001s\"AQ0a\u0003\u0011\u0002\u0003\u0007A\u000bC\u0005\u0000\u0003\u0017\u0001\n\u00111\u0001\u0002\u0002!I\u0011\u0011BA\u0006!\u0003\u0005\r\u0001\u0016\u0005\n\u0003C\u0001'\u0019!C\u0005\u0003G\ta\u0001\\8hO\u0016\u0014XCAA\u0013!\u0011\t9#!\u000e\u000e\u0005\u0005%\"\u0002BA\u0016\u0003[\tQ\u0001\\8hi)TA!a\f\u00022\u00051\u0011\r]1dQ\u0016T!!a\r\u0002\u0007=\u0014x-\u0003\u0003\u00028\u0005%\"A\u0002'pO\u001e,'\u000f\u0003\u0005\u0002<\u0001\u0004\u000b\u0011BA\u0013\u0003\u001dawnZ4fe\u0002B\u0011\"a\u0010a\u0005\u0004%I!!\u0011\u0002\r\rdwn]3e+\t\t\u0019\u0005\u0005\u0003\u0002F\u0005=SBAA$\u0015\u0011\tI%a\u0013\u0002\r\u0005$x.\\5d\u0015\r\ti%K\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002BA)\u0003\u000f\u0012Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0007\u0002CA+A\u0002\u0006I!a\u0011\u0002\u000f\rdwn]3eA!I\u0011\u0011\f1C\u0002\u0013%\u00111L\u0001\u0006cV,W/Z\u000b\u0003\u0003;\u0002b!a\u0018\u0002b\u0005\u0015TBAA&\u0013\u0011\t\u0019'a\u0013\u0003'1Kgn[3e\u00052|7m[5oOF+X-^3\u0011\t)\t9\u0007^\u0005\u0004\u0003S\u0012!!C)vKV,\u0017\n^3n\u0011!\ti\u0007\u0019Q\u0001\n\u0005u\u0013AB9vKV,\u0007\u0005C\u0005\u0002r\u0001\u0014\r\u0011\"\u0003\u0002t\u0005Q1/\u001a8e)\"\u0014X-\u00193\u0016\u0005\u0005U\u0004\u0003\u0002\u0006\u0002xQL1!!\u001f\u0003\u0005I\u0001&o\u001c3vG\u0016\u00148+\u001a8e)\"\u0014X-\u00193\t\u0011\u0005u\u0004\r)A\u0005\u0003k\n1b]3oIRC'/Z1eA!I\u0011\u0011\u00111C\u0002\u0013\u0005\u00111Q\u0001\u0013CNLhn\u0019)s_\u0012,8-\u001a:Ti\u0006$8/\u0006\u0002\u0002\u0006B!!\"a\"u\u0013\r\tII\u0001\u0002\u0013\u0003NLhn\u0019)s_\u0012,8-\u001a:Ti\u0006$8\u000f\u0003\u0005\u0002\u000e\u0002\u0004\u000b\u0011BAC\u0003M\t7/\u001f8d!J|G-^2feN#\u0018\r^:!\u0011%\t\t\n\u0019b\u0001\n\u0003\t\u0019*A\u0002nEN,\"!!&\u0011\t\u0005]\u0015\u0011U\u0007\u0003\u00033SA!a'\u0002\u001e\u0006QQ.\u00198bO\u0016lWM\u001c;\u000b\u0005\u0005}\u0015!\u00026bm\u0006D\u0018\u0002BAR\u00033\u00131\"\u0014\"fC:\u001cVM\u001d<fe\"A\u0011q\u00151!\u0002\u0013\t)*\u0001\u0003nEN\u0004\u0003BB\u000fa\t\u0003\tY\u000b\u0006\u0003\u0002\u0010\u00055\u0006B\u00023\u0002*\u0002\u0007Q\rC\u0004\u00022\u0002$\t!a-\u0002\u000bM$\u0018M\u001d;\u0016\u0005\u0005U\u0006cA\f\u00028&\u0019\u0011\u0011\u0018\r\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003{\u0003G\u0011AA`\u0003\u0011\u0019XM\u001c3\u0015\r\u0005U\u0016\u0011YAi\u0011!\t\u0019-a/A\u0002\u0005\u0015\u0017!\u0002;pa&\u001c\u0007\u0003BAd\u0003\u001bt1aFAe\u0013\r\tY\rG\u0001\u0007!J,G-\u001a4\n\u0007Q\nyMC\u0002\u0002LbAq!a5\u0002<\u0002\u0007A/A\u0003fm\u0016tG\u000fC\u0004\u0002>\u0002$\t!a6\u0015\u0011\u0005U\u0016\u0011\\An\u0003;D\u0001\"a1\u0002V\u0002\u0007\u0011Q\u0019\u0005\b\u0003'\f)\u000e1\u0001u\u0011!\ty.!6A\u0002\u0005\u0005\u0018!\u00039beRLG/[8o!\r9\u00121]\u0005\u0004\u0003KD\"aA%oi\"9\u0011\u0011\u001e1\u0005\u0002\u0005M\u0016!B2m_N,\u0007bBAwA\u0012\u0005\u0011q^\u0001\u000fg\u0016$Hj\\4hKJdUM^3m)\u0011\t),!=\t\u0011\u0005M\u00181\u001ea\u0001\u0003k\fQ\u0001\\3wK2\u0004B!a\n\u0002x&!\u0011\u0011`A\u0015\u0005\u0015aUM^3m\u0001")
public class AsyncProducer<T>
implements ScalaObject {
    private final AsyncProducerConfig config;
    private final SyncProducer producer;
    private final CallbackHandler<T> cbkHandler;
    private final Logger logger;
    private final AtomicBoolean closed;
    private final LinkedBlockingQueue<QueueItem<T>> queue;
    private final ProducerSendThread<T> sendThread;
    private final AsyncProducerStats<T> asyncProducerStats;
    private final MBeanServer mbs;

    public static final Properties init$default$7() {
        return AsyncProducer$.MODULE$.init$default$7();
    }

    public static final Null$ init$default$6() {
        return AsyncProducer$.MODULE$.init$default$6();
    }

    public static final Properties init$default$5() {
        return AsyncProducer$.MODULE$.init$default$5();
    }

    public static final Null$ init$default$4() {
        return AsyncProducer$.MODULE$.init$default$4();
    }

    public static final String ProducerMBeanName() {
        return AsyncProducer$.MODULE$.ProducerMBeanName();
    }

    public static final Random Random() {
        return AsyncProducer$.MODULE$.Random();
    }

    public static final Object Shutdown() {
        return AsyncProducer$.MODULE$.Shutdown();
    }

    private Logger logger() {
        return this.logger;
    }

    private AtomicBoolean closed() {
        return this.closed;
    }

    private LinkedBlockingQueue<QueueItem<T>> queue() {
        return this.queue;
    }

    private ProducerSendThread<T> sendThread() {
        return this.sendThread;
    }

    public AsyncProducerStats<T> asyncProducerStats() {
        return this.asyncProducerStats;
    }

    public MBeanServer mbs() {
        return this.mbs;
    }

    public AsyncProducer(AsyncProducerConfig config) {
        this(config, new SyncProducer(config), (Encoder)Utils$.MODULE$.getObject(config.serializerClass()), (EventHandler)Utils$.MODULE$.getObject(config.eventHandler()), config.eventHandlerProps(), (CallbackHandler)Utils$.MODULE$.getObject(config.cbkHandler()), config.cbkHandlerProps());
    }

    public void start() {
        this.sendThread().start();
    }

    public void send(String topic, T event) {
        this.send(topic, event, ProducerRequest$.MODULE$.RandomPartition());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void send(String topic, T event, int partition) {
        boolean bl;
        int n;
        this.asyncProducerStats().recordEvent();
        if (this.closed().get()) {
            throw new QueueClosedException("Attempt to add event to a closed queue.");
        }
        QueueItem<T> data = new QueueItem<T>(event, topic, partition);
        if (this.cbkHandler != null) {
            data = this.cbkHandler.beforeEnqueue(data);
        }
        if ((n = this.config.enqueueTimeoutMs()) == 0) {
            bl = this.queue().offer(data);
        } else {
            boolean exceptionResult1 = false;
            try {
                boolean bl2;
                boolean bl3;
                boolean bl4 = bl3 = this.config.enqueueTimeoutMs() < 0;
                if (bl3) {
                    this.queue().put(data);
                    bl2 = true;
                } else {
                    bl2 = this.queue().offer(data, this.config.enqueueTimeoutMs(), TimeUnit.MILLISECONDS);
                }
                bl = exceptionResult1 = bl2;
            }
            catch (InterruptedException interruptedException) {
                String msg = Predef$.MODULE$.augmentString("%s interrupted during enqueue of event %s.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getClass().getSimpleName(), event.toString()}));
                this.logger().error((Object)msg);
                throw new AsyncProducerInterruptedException(msg);
            }
        }
        boolean added = bl;
        if (this.cbkHandler != null) {
            this.cbkHandler.afterEnqueue(data, added);
        }
        if (!added) {
            this.asyncProducerStats().recordDroppedEvents();
            this.logger().error((Object)new StringBuilder().append((Object)"Event queue is full of unsent messages, could not send event: ").append((Object)event.toString()).toString());
            throw new QueueFullException(new StringBuilder().append((Object)"Event queue is full of unsent messages, could not send event: ").append((Object)event.toString()).toString());
        }
        if (this.logger().isTraceEnabled()) {
            this.logger().trace((Object)new StringBuilder().append((Object)"Added event to send queue for topic: ").append((Object)topic).append((Object)", partition: ").append((Object)BoxesRunTime.boxToInteger((int)partition)).append((Object)":").append((Object)event.toString()).toString());
            this.logger().trace((Object)new StringBuilder().append((Object)"Remaining queue size: ").append((Object)BoxesRunTime.boxToInteger((int)this.queue().remainingCapacity())).toString());
        }
    }

    public void close() {
        if (this.cbkHandler != null) {
            this.cbkHandler.close();
            this.logger().info((Object)"Closed the callback handler");
        }
        this.closed().set(true);
        this.queue().put(new QueueItem<Object>(AsyncProducer$.MODULE$.Shutdown(), null, -1));
        if (this.logger().isDebugEnabled()) {
            this.logger().debug((Object)"Added shutdown command to the queue");
        }
        this.sendThread().shutdown();
        this.sendThread().awaitShutdown();
        this.producer.close();
        this.logger().info((Object)"Closed AsyncProducer");
    }

    public void setLoggerLevel(Level level) {
        this.logger().setLevel(level);
    }

    public AsyncProducer(AsyncProducerConfig config, SyncProducer producer, Encoder<T> serializer, EventHandler<T> eventHandler, Properties eventHandlerProps, CallbackHandler<T> cbkHandler, Properties cbkHandlerProps) {
        this.config = config;
        this.producer = producer;
        this.cbkHandler = cbkHandler;
        this.logger = Logger.getLogger(AsyncProducer.class);
        this.closed = new AtomicBoolean(false);
        this.queue = new LinkedBlockingQueue(config.queueSize());
        if (eventHandler != null) {
            eventHandler.init(eventHandlerProps);
        }
        if (cbkHandler != null) {
            cbkHandler.init(cbkHandlerProps);
        }
        this.sendThread = new ProducerSendThread<T>(new StringBuilder().append((Object)"ProducerSendThread-").append((Object)BoxesRunTime.boxToInteger((int)AsyncProducer$.MODULE$.Random().nextInt())).toString(), this.queue(), serializer, producer, eventHandler == null ? new DefaultEventHandler<T>(new ProducerConfig(config.props()), cbkHandler) : eventHandler, cbkHandler, config.queueTime(), config.batchSize(), AsyncProducer$.MODULE$.Shutdown());
        this.sendThread().setDaemon(false);
        this.asyncProducerStats = new AsyncProducerStats<T>(this.queue());
        this.mbs = ManagementFactory.getPlatformMBeanServer();
        Object exceptionResult2 = null;
        try {
            ObjectName objName = new ObjectName(AsyncProducer$.MODULE$.ProducerMBeanName());
            if (this.mbs().isRegistered(objName)) {
                this.mbs().unregisterMBean(objName);
            }
            exceptionResult2 = this.mbs().registerMBean(this.asyncProducerStats(), objName);
        }
        catch (Exception exception) {
            this.logger().warn((Object)"can't register AsyncProducerStats");
            exceptionResult2 = BoxedUnit.UNIT;
        }
    }
}

