/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import kafka.common.InvalidPartitionException;
import kafka.common.InvalidTopicException;
import kafka.log.Log;
import kafka.log.LogManager$;
import kafka.log.LogManager$$anonfun$kafka$log$LogManager$;
import kafka.log.LogManager$StopActor$;
import kafka.log.LogSegment;
import kafka.server.KafkaConfig;
import kafka.server.KafkaZooKeeper;
import kafka.utils.KafkaScheduler;
import kafka.utils.Pool;
import kafka.utils.Time;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.actors.Actor;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\tmf!C\u0001\u0003\t\u0003\u0005\t\u0011\u0001\u0003\u0007\u0005)aunZ'b]\u0006<WM\u001d\u0006\u0003\u0007\u0011\t1\u0001\\8h\u0015\u0005)\u0011!B6bM.\f7c\u0001\u0001\b\u001fA\u0011\u0001\"D\u0007\u0002\u0013)\u0011!bC\u0001\u0005Y\u0006twMC\u0001\r\u0003\u0011Q\u0017M^1\n\u00059I!AB(cU\u0016\u001cG\u000f\u0005\u0002\u0011'5\t\u0011CC\u0001\u0013\u0003\u0015\u00198-\u00197b\u0013\t!\u0012CA\u0006TG\u0006d\u0017m\u00142kK\u000e$\b\u0002\u0003\f\u0001\u0005\u000b\u0007I\u0011\u0001\r\u0002\r\r|gNZ5h\u0007\u0001)\u0012!\u0007\t\u00035ui\u0011a\u0007\u0006\u00039\u0011\taa]3sm\u0016\u0014\u0018B\u0001\u0010\u001c\u0005-Y\u0015MZ6b\u0007>tg-[4\t\u0011\u0001\u0002!\u0011!Q\u0001\ne\tqaY8oM&<\u0007\u0005\u0003\u0005#\u0001\t\u0015\r\u0011\"\u0003$\u0003%\u00198\r[3ek2,'/F\u0001%!\t)\u0003&D\u0001'\u0015\t9C!A\u0003vi&d7/\u0003\u0002*M\tq1*\u00194lCN\u001b\u0007.\u001a3vY\u0016\u0014\b\u0002C\u0016\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0013\u0002\u0015M\u001c\u0007.\u001a3vY\u0016\u0014\b\u0005\u0003\u0005.\u0001\t\u0015\r\u0011\"\u0003/\u0003\u0011!\u0018.\\3\u0016\u0003=\u0002\"!\n\u0019\n\u0005E2#\u0001\u0002+j[\u0016D\u0001b\r\u0001\u0003\u0002\u0003\u0006IaL\u0001\u0006i&lW\r\t\u0005\tk\u0001\u0011)\u0019!C\u0001m\u0005!Bn\\4DY\u0016\fg.\u001e9J]R,'O^1m\u001bN,\u0012a\u000e\t\u0003!aJ!!O\t\u0003\t1{gn\u001a\u0005\tw\u0001\u0011\t\u0011)A\u0005o\u0005)Bn\\4DY\u0016\fg.\u001e9J]R,'O^1m\u001bN\u0004\u0003\u0002C\u001f\u0001\u0005\u000b\u0007I\u0011\u0001\u001c\u0002-1|wm\u00117fC:,\b\u000fR3gCVdG/Q4f\u001bND\u0001b\u0010\u0001\u0003\u0002\u0003\u0006IaN\u0001\u0018Y><7\t\\3b]V\u0004H)\u001a4bk2$\u0018iZ3Ng\u0002B\u0001\"\u0011\u0001\u0003\u0002\u0003\u0006IAQ\u0001\r]\u0016,GMU3d_Z,'/\u001f\t\u0003!\rK!\u0001R\t\u0003\u000f\t{w\u000e\\3b]\")a\t\u0001C\u0001\u000f\u00061A(\u001b8jiz\"r\u0001\u0013&L\u00196su\n\u0005\u0002J\u00015\t!\u0001C\u0003\u0017\u000b\u0002\u0007\u0011\u0004C\u0003#\u000b\u0002\u0007A\u0005C\u0003.\u000b\u0002\u0007q\u0006C\u00036\u000b\u0002\u0007q\u0007C\u0003>\u000b\u0002\u0007q\u0007C\u0003B\u000b\u0002\u0007!\tC\u0004R\u0001\t\u0007I\u0011\u0001*\u0002\r1|w\rR5s+\u0005\u0019\u0006C\u0001+X\u001b\u0005)&B\u0001,\f\u0003\tIw.\u0003\u0002Y+\n!a)\u001b7f\u0011\u0019Q\u0006\u0001)A\u0005'\u00069An\\4ESJ\u0004\u0003b\u0002/\u0001\u0005\u0004%I!X\u0001\u000e]Vl\u0007+\u0019:uSRLwN\\:\u0016\u0003y\u0003\"\u0001E0\n\u0005\u0001\f\"aA%oi\"1!\r\u0001Q\u0001\ny\u000baB\\;n!\u0006\u0014H/\u001b;j_:\u001c\b\u0005C\u0004e\u0001\t\u0007I\u0011\u0002\u001c\u0002\u000f5\f\u0007pU5{K\"1a\r\u0001Q\u0001\n]\n\u0001\"\\1y'&TX\r\t\u0005\bQ\u0002\u0011\r\u0011\"\u0003^\u000351G.^:i\u0013:$XM\u001d<bY\"1!\u000e\u0001Q\u0001\ny\u000baB\u001a7vg\"Le\u000e^3sm\u0006d\u0007\u0005C\u0004m\u0001\t\u0007I\u0011B7\u0002%Q|\u0007/[2QCJ$\u0018\u000e^5p]Nl\u0015\r]\u000b\u0002]B!qN\u001d;_\u001b\u0005\u0001(BA9\u0012\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003gB\u00141!T1q!\t)\bP\u0004\u0002\u0011m&\u0011q/E\u0001\u0007!J,G-\u001a4\n\u0005eT(AB*ue&twM\u0003\u0002x#!1A\u0010\u0001Q\u0001\n9\f1\u0003^8qS\u000e\u0004\u0016M\u001d;ji&|gn]'ba\u0002BqA \u0001C\u0002\u0013%q0\u0001\u0004m_\u001e<WM]\u000b\u0003\u0003\u0003\u0001B!a\u0001\u0002\u00125\u0011\u0011Q\u0001\u0006\u0005\u0003\u000f\tI!A\u0003m_\u001e$$N\u0003\u0003\u0002\f\u00055\u0011AB1qC\u000eDWM\u0003\u0002\u0002\u0010\u0005\u0019qN]4\n\t\u0005M\u0011Q\u0001\u0002\u0007\u0019><w-\u001a:\t\u0011\u0005]\u0001\u0001)A\u0005\u0003\u0003\tq\u0001\\8hO\u0016\u0014\b\u0005C\u0005\u0002\u001c\u0001\u0011\r\u0011\"\u0003\u0002\u001e\u0005yAn\\4De\u0016\fG/[8o\u0019>\u001c7.F\u0001\b\u0011\u001d\t\t\u0003\u0001Q\u0001\n\u001d\t\u0001\u0003\\8h\u0007J,\u0017\r^5p]2{7m\u001b\u0011\t\u0013\u0005\u0015\u0002A1A\u0005\n\u0005\u001d\u0012A\u0002:b]\u0012|W.\u0006\u0002\u0002*A!\u00111FA\u0019\u001b\t\tiCC\u0002\u00020-\tA!\u001e;jY&!\u00111GA\u0017\u0005\u0019\u0011\u0016M\u001c3p[\"A\u0011q\u0007\u0001!\u0002\u0013\tI#A\u0004sC:$w.\u001c\u0011\t\u0013\u0005m\u0002\u00011A\u0005\n\u0005u\u0012AD6bM.\f'l\\8lK\u0016\u0004XM]\u000b\u0003\u0003\u007f\u00012AGA!\u0013\r\t\u0019e\u0007\u0002\u000f\u0017\u000647.\u0019.p_.+W\r]3s\u0011%\t9\u0005\u0001a\u0001\n\u0013\tI%\u0001\nlC\u001a\\\u0017MW8pW\u0016,\u0007/\u001a:`I\u0015\fH\u0003BA&\u0003#\u00022\u0001EA'\u0013\r\ty%\u0005\u0002\u0005+:LG\u000f\u0003\u0006\u0002T\u0005\u0015\u0013\u0011!a\u0001\u0003\u007f\t1\u0001\u001f\u00132\u0011!\t9\u0006\u0001Q!\n\u0005}\u0012aD6bM.\f'l\\8lK\u0016\u0004XM\u001d\u0011\t\u0013\u0005m\u0003\u00011A\u0005\n\u0005u\u0013a\u0002>l\u0003\u000e$xN]\u000b\u0003\u0003?\u0002B!!\u0019\u0002h5\u0011\u00111\r\u0006\u0004\u0003K\n\u0012AB1di>\u00148/\u0003\u0003\u0002j\u0005\r$!B!di>\u0014\b\"CA7\u0001\u0001\u0007I\u0011BA8\u0003-Q8.Q2u_J|F%Z9\u0015\t\u0005-\u0013\u0011\u000f\u0005\u000b\u0003'\nY'!AA\u0002\u0005}\u0003\u0002CA;\u0001\u0001\u0006K!a\u0018\u0002\u0011i\\\u0017i\u0019;pe\u0002B\u0011\"!\u001f\u0001\u0005\u0004%I!a\u001f\u0002\u0019M$\u0018M\u001d;va2\u000bGo\u00195\u0016\u0005\u0005u\u0004\u0003BA@\u0003\u000bk!!!!\u000b\t\u0005\r\u0015QF\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002BAD\u0003\u0003\u0013abQ8v]R$un\u001e8MCR\u001c\u0007\u000e\u0003\u0005\u0002\f\u0002\u0001\u000b\u0011BA?\u00035\u0019H/\u0019:ukBd\u0015\r^2iA!A\u0011q\u0012\u0001C\u0002\u0013%1%A\nm_\u001e4E.^:iKJ\u001c6\r[3ek2,'\u000fC\u0004\u0002\u0014\u0002\u0001\u000b\u0011\u0002\u0013\u0002)1|wM\u00127vg\",'oU2iK\u0012,H.\u001a:!\u0011!\t9\n\u0001b\u0001\n\u0013i\u0017a\u00057pO\u001acWo\u001d5J]R,'O^1m\u001b\u0006\u0004\bbBAN\u0001\u0001\u0006IA\\\u0001\u0015Y><g\t\\;tQ&sG/\u001a:wC2l\u0015\r\u001d\u0011\t\u0013\u0005}\u0005A1A\u0005\n\u0005\u0005\u0016!\u00057pOJ+G/\u001a8uS>tWjU'baV\u0011\u00111\u0015\t\u0005_J$x\u0007\u0003\u0005\u0002(\u0002\u0001\u000b\u0011BAR\u0003Iawn\u001a*fi\u0016tG/[8o\u001bNk\u0015\r\u001d\u0011\t\u0011\u0005-\u0006A1A\u0005\nu\u000b\u0001\u0003\\8h%\u0016$XM\u001c;j_:\u001c\u0016N_3\t\u000f\u0005=\u0006\u0001)A\u0005=\u0006\tBn\\4SKR,g\u000e^5p]NK'0\u001a\u0011\t\u0013\u0005M\u0006A1A\u0005\n\u0005U\u0016\u0001\u00027pON,\"!a.\u0011\r\u0015\nI\f^A_\u0013\r\tYL\n\u0002\u0005!>|G\u000e\u0005\u0004&\u0003ss\u0016q\u0018\t\u0004\u0013\u0006\u0005\u0017bAAb\u0005\t\u0019Aj\\4\t\u0011\u0005\u001d\u0007\u0001)A\u0005\u0003o\u000bQ\u0001\\8hg\u0002B\u0011\"a3\u0001\u0005\u0004%\t!!4\u0002\u000fM,(\rR5sgV\u0011\u0011q\u001a\t\u0005!\u0005E7+C\u0002\u0002TF\u0011Q!\u0011:sCfD\u0001\"a6\u0001A\u0003%\u0011qZ\u0001\tgV\u0014G)\u001b:tA\u001d9\u00111\u001c\u0001\t\u0006\u0006u\u0017!C*u_B\f5\r^8s!\u0011\ty.!9\u000e\u0003\u00011!\"a9\u0001\t\u0003\u0005\tRQAs\u0005%\u0019Fo\u001c9BGR|'o\u0005\u0004\u0002b\u001ey\u0011q\u001d\t\u0004!\u0005%\u0018bAAv#\t9\u0001K]8ek\u000e$\bb\u0002$\u0002b\u0012\u0005\u0011q\u001e\u000b\u0003\u0003;D1\"a=\u0002b\u0012\u0005\t\u0011\"\u0012\u0002v\u0006AAo\\*ue&tw\r\u0006\u0002\u0002xB\u0019\u0001\"!?\n\u0005eL\u0001bCA\u007f\u0003C$\t\u0011!C!\u0003\u007f\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA|\u0011)\u0011\u0019!!9\u0005\u0002\u0003%\t%X\u0001\raJ|G-^2u\u0003JLG/\u001f\u0005\f\u0005\u000f\t\t\u000f\"A\u0001\n\u0003\u0012I!\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\t-!\u0011\u0003\t\u0004!\t5\u0011b\u0001B\b#\t\u0019\u0011I\\=\t\u0013\u0005M#QAA\u0001\u0002\u0004q\u0006b\u0003B\u000b\u0003C$\t\u0011!C!\u0005/\t\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004\u0005\ne\u0001BCA*\u0005'\t\t\u00111\u0001\u0003\f!Y!QDAq\t\u0003\u0005I\u0011\u0003B\u0010\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0003\u001dAC!!9\u0003$A\u0019\u0001C!\n\n\u0007\t\u001d\u0012C\u0001\u0007tKJL\u0017\r\\5{C\ndW\rC\u0004\u0003,\u0001!IA!\f\u0002)\u001d,G\u000fT8h%\u0016$XM\u001c;j_:l5+T1q)\u0011\t\u0019Ka\f\t\u000f\tE\"\u0011\u0006a\u0001]\u0006\u0019Bn\\4SKR,g\u000e^5p]\"{WO]'ba\"9!Q\u0007\u0001\u0005\u0002\t]\u0012aB:uCJ$X\u000f\u001d\u000b\u0003\u0003\u0017BqAa\u000f\u0001\t\u0013\u00119$\u0001\u0007bo\u0006LGo\u0015;beR,\b\u000fC\u0004\u0003@\u0001!\tA!\u0011\u0002)I,w-[:uKJtUm\u001e+pa&\u001c\u0017J\u001c.L)\u0011\tYEa\u0011\t\u000f\t\u0015#Q\ba\u0001i\u0006)Ao\u001c9jG\"9!\u0011\n\u0001\u0005\n\t-\u0013!C2sK\u0006$X\rT8h)\u0019\tyL!\u0014\u0003P!9!Q\tB$\u0001\u0004!\bb\u0002B)\u0005\u000f\u0002\rAX\u0001\na\u0006\u0014H/\u001b;j_:DqA!\u0016\u0001\t\u0003\u00119&A\u000bdQ>|7/\u001a*b]\u0012|W\u000eU1si&$\u0018n\u001c8\u0015\u0007y\u0013I\u0006C\u0004\u0003F\tM\u0003\u0019\u0001;\t\u000f\tu\u0003\u0001\"\u0001\u0003`\u0005qq-\u001a;Pe\u000e\u0013X-\u0019;f\u0019><GCBA`\u0005C\u0012\u0019\u0007C\u0004\u0003F\tm\u0003\u0019\u0001;\t\u000f\tE#1\fa\u0001=\"9!q\r\u0001\u0005\n\t%\u0014A\u00043fY\u0016$XmU3h[\u0016tGo\u001d\u000b\u0006=\n-$Q\u000e\u0005\b\u0007\t\u0015\u0004\u0019AA`\u0011!\u0011yG!\u001aA\u0002\tE\u0014\u0001C:fO6,g\u000e^:\u0011\u000b=\u0014\u0019Ha\u001e\n\u0007\tU\u0004OA\u0002TKF\u00042!\u0013B=\u0013\r\u0011YH\u0001\u0002\u000b\u0019><7+Z4nK:$\bb\u0002B@\u0001\u0011%!\u0011Q\u0001\u0017G2,\u0017M\\;q\u000bb\u0004\u0018N]3e'\u0016<W.\u001a8ugR\u0019aLa!\t\u000f\r\u0011i\b1\u0001\u0002@\"9!q\u0011\u0001\u0005\n\t%\u0015!H2mK\u0006tW\u000f]*fO6,g\u000e^:U_6\u000b\u0017N\u001c;bS:\u001c\u0016N_3\u0015\u0007y\u0013Y\tC\u0004\u0004\u0005\u000b\u0003\r!a0\t\u000f\t=\u0005\u0001\"\u0001\u00038\u0005Y1\r\\3b]V\u0004Hj\\4t\u0011\u001d\u0011\u0019\n\u0001C\u0001\u0005o\tQa\u00197pg\u0016DqAa&\u0001\t\u0013\u0011I*\u0001\bhKRdunZ%uKJ\fGo\u001c:\u0015\u0005\tm\u0005#B8\u0003\u001e\u0006}\u0016b\u0001BPa\nA\u0011\n^3sCR|'\u000fC\u0004\u0003$\u0002!IAa\u000e\u0002\u0019\u0019dWo\u001d5BY2dunZ:\t\u000f\t\u001d\u0006\u0001\"\u0001\u0003*\u0006aq-\u001a;BY2$v\u000e]5dgR\u0011!1\u0016\t\u0005_\nuE\u000fC\u0004\u00030\u0002!\tA!-\u0002+\u001d,G\u000fV8qS\u000e\u0004\u0016M\u001d;ji&|gn]'baR\ta\u000eK\u0002\u0001\u0005k\u00032!\nB\\\u0013\r\u0011IL\n\u0002\u000bi\"\u0014X-\u00193tC\u001a,\u0007")
public class LogManager
implements ScalaObject {
    private final KafkaConfig config;
    private final KafkaScheduler scheduler;
    private final Time time;
    private final long logCleanupIntervalMs;
    private final long logCleanupDefaultAgeMs;
    public final boolean kafka$log$LogManager$$needRecovery;
    private final File logDir;
    private final int kafka$log$LogManager$$numPartitions;
    private final long kafka$log$LogManager$$maxSize;
    private final int kafka$log$LogManager$$flushInterval;
    private final Map<String, Integer> topicPartitionsMap;
    private final Logger kafka$log$LogManager$$logger;
    private final Object logCreationLock;
    private final Random random;
    private KafkaZooKeeper kafka$log$LogManager$$kafkaZookeeper;
    private Actor zkActor;
    private final CountDownLatch startupLatch;
    private final KafkaScheduler logFlusherScheduler;
    private final Map kafka$log$LogManager$$logFlushIntervalMap;
    private final Map<String, Long> logRetentionMSMap;
    private final int logRetentionSize;
    private final Pool kafka$log$LogManager$$logs;
    private final File[] subDirs;
    private /* synthetic */ LogManager$StopActor$ StopActor$module;

    public KafkaConfig config() {
        return this.config;
    }

    private KafkaScheduler scheduler() {
        return this.scheduler;
    }

    private Time time() {
        return this.time;
    }

    public long logCleanupIntervalMs() {
        return this.logCleanupIntervalMs;
    }

    public long logCleanupDefaultAgeMs() {
        return this.logCleanupDefaultAgeMs;
    }

    public File logDir() {
        return this.logDir;
    }

    public final int kafka$log$LogManager$$numPartitions() {
        return this.kafka$log$LogManager$$numPartitions;
    }

    public final long kafka$log$LogManager$$maxSize() {
        return this.kafka$log$LogManager$$maxSize;
    }

    public final int kafka$log$LogManager$$flushInterval() {
        return this.kafka$log$LogManager$$flushInterval;
    }

    private Map<String, Integer> topicPartitionsMap() {
        return this.topicPartitionsMap;
    }

    public final Logger kafka$log$LogManager$$logger() {
        return this.kafka$log$LogManager$$logger;
    }

    private Object logCreationLock() {
        return this.logCreationLock;
    }

    private Random random() {
        return this.random;
    }

    public final KafkaZooKeeper kafka$log$LogManager$$kafkaZookeeper() {
        return this.kafka$log$LogManager$$kafkaZookeeper;
    }

    private void kafka$log$LogManager$$kafkaZookeeper_$eq(KafkaZooKeeper kafkaZooKeeper) {
        this.kafka$log$LogManager$$kafkaZookeeper = kafkaZooKeeper;
    }

    private Actor zkActor() {
        return this.zkActor;
    }

    private void zkActor_$eq(Actor actor) {
        this.zkActor = actor;
    }

    private CountDownLatch startupLatch() {
        return this.startupLatch;
    }

    private KafkaScheduler logFlusherScheduler() {
        return this.logFlusherScheduler;
    }

    public final Map kafka$log$LogManager$$logFlushIntervalMap() {
        return this.kafka$log$LogManager$$logFlushIntervalMap;
    }

    private Map<String, Long> logRetentionMSMap() {
        return this.logRetentionMSMap;
    }

    private int logRetentionSize() {
        return this.logRetentionSize;
    }

    public final Pool kafka$log$LogManager$$logs() {
        return this.kafka$log$LogManager$$logs;
    }

    public File[] subDirs() {
        return this.subDirs;
    }

    public final LogManager$StopActor$ StopActor() {
        if (this.StopActor$module == null) {
            this.StopActor$module = new LogManager$StopActor$(this);
        }
        return this.StopActor$module;
    }

    private Map<String, Long> getLogRetentionMSMap(Map<String, Integer> logRetentionHourMap) {
        ObjectRef ret$1 = new ObjectRef((Object)new HashMap());
        logRetentionHourMap.foreach((Function1)new $anonfun$getLogRetentionMSMap$1(this, ret$1));
        return (HashMap)ret$1.elem;
    }

    public void startup() {
        if (this.config().enableZookeeper()) {
            this.kafka$log$LogManager$$kafkaZookeeper().registerBrokerInZk();
            this.getAllTopics().foreach((Function1)new $anonfun$startup$2(this));
            this.startupLatch().countDown();
        }
        this.kafka$log$LogManager$$logger().info((Object)new StringBuilder().append((Object)"Starting log flusher every ").append((Object)BoxesRunTime.boxToInteger((int)this.config().flushSchedulerThreadRate())).append((Object)" ms with the following overrides ").append((Object)this.kafka$log$LogManager$$logFlushIntervalMap()).toString());
        this.logFlusherScheduler().scheduleWithRate((Function0<Object>)new $anonfun$startup$1(this), this.config().flushSchedulerThreadRate(), this.config().flushSchedulerThreadRate());
    }

    private void awaitStartup() {
        if (this.config().enableZookeeper()) {
            this.startupLatch().await();
        }
    }

    public void registerNewTopicInZK(String topic) {
        if (this.config().enableZookeeper()) {
            this.zkActor().$bang((Object)topic);
        }
    }

    private Log createLog(String topic, int partition) {
        Object object = this.logCreationLock();
        synchronized (object) {
            File d = new File(this.logDir(), new StringBuilder().append((Object)topic).append((Object)"-").append((Object)BoxesRunTime.boxToInteger((int)partition)).toString());
            d.mkdirs();
            Log log = new Log(d, this.kafka$log$LogManager$$maxSize(), this.kafka$log$LogManager$$flushInterval(), false);
            return log;
        }
    }

    public int chooseRandomPartition(String topic) {
        return this.random().nextInt(BoxesRunTime.unboxToInt((Object)this.topicPartitionsMap().getOrElse((Object)topic, (Function0)new $anonfun$chooseRandomPartition$1(this))));
    }

    public Log getOrCreateLog(String topic, int partition) {
        Log log;
        this.awaitStartup();
        if (topic.length() <= 0) {
            throw new InvalidTopicException("topic name can't be empty");
        }
        if (partition < 0 || partition >= BoxesRunTime.unboxToInt((Object)this.topicPartitionsMap().getOrElse((Object)topic, (Function0)new $anonfun$getOrCreateLog$1(this)))) {
            this.kafka$log$LogManager$$logger().warn((Object)new StringBuilder().append((Object)"Wrong partition ").append((Object)BoxesRunTime.boxToInteger((int)partition)).append((Object)" valid partitions (0,").append((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.topicPartitionsMap().getOrElse((Object)topic, (Function0)new $anonfun$getOrCreateLog$2(this))) - 1))).append((Object)")").toString());
            throw new InvalidPartitionException(new StringBuilder().append((Object)"wrong partition ").append((Object)BoxesRunTime.boxToInteger((int)partition)).toString());
        }
        boolean hasNewTopic = false;
        Pool parts = (Pool)this.kafka$log$LogManager$$logs().get(topic);
        if (parts == null) {
            Pool found = this.kafka$log$LogManager$$logs().putIfNotExists(topic, new Pool());
            if (found == null) {
                hasNewTopic = true;
            }
            parts = (Pool)this.kafka$log$LogManager$$logs().get(topic);
        }
        if ((log = (Log)parts.get(BoxesRunTime.boxToInteger((int)partition))) == null) {
            log = this.createLog(topic, partition);
            Log found = parts.putIfNotExists(BoxesRunTime.boxToInteger((int)partition), log);
            if (found == null) {
                this.kafka$log$LogManager$$logger().info((Object)new StringBuilder().append((Object)"Created log for '").append((Object)topic).append((Object)"'-").append((Object)BoxesRunTime.boxToInteger((int)partition)).toString());
            } else {
                log.close();
                log = found;
            }
        }
        if (hasNewTopic) {
            this.registerNewTopicInZK(topic);
        }
        return log;
    }

    private int deleteSegments(Log log$1, Seq<LogSegment> segments) {
        IntRef total$1 = new IntRef(0);
        segments.foreach((Function1)new $anonfun$deleteSegments$1(this, log$1, total$1));
        return total$1.elem;
    }

    private int cleanupExpiredSegments(Log log) {
        long startMs$1 = this.time().milliseconds();
        String topic = (String)Utils$.MODULE$.getTopicPartition(log.dir().getName())._1();
        long logCleanupThresholdMS$1 = BoxesRunTime.unboxToLong((Object)this.logRetentionMSMap().get((Object)topic).getOrElse((Function0)new $anonfun$2(this)));
        Seq<LogSegment> toBeDeleted = log.markDeletedWhile((Function1<LogSegment, Boolean>)new $anonfun$4(this, startMs$1, logCleanupThresholdMS$1));
        int total = this.deleteSegments(log, toBeDeleted);
        return total;
    }

    private int cleanupSegmentsToMaintainSize(Log log) {
        if (this.logRetentionSize() < 0 || log.size() < (long)this.logRetentionSize()) {
            return 0;
        }
        LongRef diff$1 = new LongRef(log.size() - (long)this.logRetentionSize());
        Seq<LogSegment> toBeDeleted = log.markDeletedWhile((Function1<LogSegment, Boolean>)new $anonfun$5(this, diff$1));
        int total = this.deleteSegments(log, toBeDeleted);
        return total;
    }

    public void cleanupLogs() {
        this.kafka$log$LogManager$$logger().debug((Object)"Beginning log cleanup...");
        Iterator<Log> iter = this.getLogIterator();
        int total = 0;
        long startMs = this.time().milliseconds();
        while (iter.hasNext()) {
            Log log = (Log)iter.next();
            this.kafka$log$LogManager$$logger().debug((Object)new StringBuilder().append((Object)"Garbage collecting '").append((Object)log.name()).append((Object)"'").toString());
            total += this.cleanupExpiredSegments(log) + this.cleanupSegmentsToMaintainSize(log);
        }
        this.kafka$log$LogManager$$logger().debug((Object)new StringBuilder().append((Object)"Log cleanup completed. ").append((Object)BoxesRunTime.boxToInteger((int)total)).append((Object)" files deleted in ").append((Object)BoxesRunTime.boxToLong((long)((this.time().milliseconds() - startMs) / 1000L))).append((Object)" seconds").toString());
    }

    public void close() {
        this.logFlusherScheduler().shutdown();
        Iterator<Log> iter = this.getLogIterator();
        while (iter.hasNext()) {
            ((Log)iter.next()).close();
        }
        if (this.config().enableZookeeper()) {
            this.zkActor().$bang((Object)this.StopActor());
            this.kafka$log$LogManager$$kafkaZookeeper().close();
        }
    }

    private Iterator<Log> getLogIterator() {
        return new $anon$2(this);
    }

    public final void kafka$log$LogManager$$flushAllLogs() {
        if (this.kafka$log$LogManager$$logger().isDebugEnabled()) {
            this.kafka$log$LogManager$$logger().debug((Object)"flushing the high watermark of all logs");
        }
        this.getLogIterator().foreach((Function1)new $anonfun$kafka$log$LogManager$$flushAllLogs$1(this));
    }

    public Iterator<String> getAllTopics() {
        return this.kafka$log$LogManager$$logs().keys().iterator();
    }

    public Map<String, Integer> getTopicPartitionsMap() {
        return this.topicPartitionsMap();
    }

    public final boolean shouldDelete$1(LogSegment segment, LongRef longRef) {
        boolean bl;
        if (longRef.elem - segment.size() >= 0L) {
            longRef.elem -= segment.size();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public LogManager(KafkaConfig config, KafkaScheduler scheduler, Time time, long logCleanupIntervalMs, long logCleanupDefaultAgeMs, boolean needRecovery) {
        Object object;
        this.config = config;
        this.scheduler = scheduler;
        this.time = time;
        this.logCleanupIntervalMs = logCleanupIntervalMs;
        this.logCleanupDefaultAgeMs = logCleanupDefaultAgeMs;
        this.kafka$log$LogManager$$needRecovery = needRecovery;
        this.logDir = new File(config.logDir());
        this.kafka$log$LogManager$$numPartitions = config.numPartitions();
        this.kafka$log$LogManager$$maxSize = config.logFileSize();
        this.kafka$log$LogManager$$flushInterval = config.flushInterval();
        this.topicPartitionsMap = config.topicPartitionsMap();
        this.kafka$log$LogManager$$logger = Logger.getLogger(LogManager.class);
        this.logCreationLock = new Object();
        this.random = new Random();
        this.kafka$log$LogManager$$kafkaZookeeper = null;
        this.zkActor = null;
        this.startupLatch = config.enableZookeeper() ? new CountDownLatch(1) : null;
        this.logFlusherScheduler = new KafkaScheduler(1, "kafka-logflusher-", false);
        this.kafka$log$LogManager$$logFlushIntervalMap = config.flushIntervalMap();
        this.logRetentionMSMap = this.getLogRetentionMSMap(config.logRetentionHoursMap());
        this.logRetentionSize = config.logRetentionSize();
        this.kafka$log$LogManager$$logs = new Pool();
        if (this.logDir().exists()) {
            object = BoxedUnit.UNIT;
        } else {
            this.kafka$log$LogManager$$logger().info((Object)new StringBuilder().append((Object)"No log directory found, creating '").append((Object)this.logDir().getAbsolutePath()).append((Object)"'").toString());
            object = BoxesRunTime.boxToBoolean((boolean)this.logDir().mkdirs());
        }
        if (this.logDir().isDirectory() && this.logDir().canRead()) {
            BoxedUnit boxedUnit;
            Object object2;
            this.subDirs = this.logDir().listFiles();
            if (this.subDirs() != null) {
                Predef$.MODULE$.refArrayOps((Object[])this.subDirs()).foreach((Function1)new $anonfun$3(this));
            }
            if (scheduler == null) {
                object2 = BoxedUnit.UNIT;
            } else {
                this.kafka$log$LogManager$$logger().info((Object)new StringBuilder().append((Object)"starting log cleaner every ").append((Object)BoxesRunTime.boxToLong((long)logCleanupIntervalMs)).append((Object)" ms").toString());
                object2 = scheduler.scheduleWithRate((Function0<Object>)new $anonfun$1(this), 60000L, logCleanupIntervalMs);
            }
            if (config.enableZookeeper()) {
                this.kafka$log$LogManager$$kafkaZookeeper_$eq(new KafkaZooKeeper(config, this));
                this.kafka$log$LogManager$$kafkaZookeeper().startup();
                this.zkActor_$eq(new $anon$1(this));
                boxedUnit = this.zkActor().start();
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)this.logDir().getAbsolutePath()).append((Object)" is not a readable log directory.").toString());
    }
}

