/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.text.NumberFormat;
import kafka.common.OffsetOutOfRangeException;
import kafka.utils.Range;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Log$
implements ScalaObject {
    public static final Log$ MODULE$;
    private final String FileSuffix;

    static {
        new Log$();
    }

    public String FileSuffix() {
        return this.FileSuffix;
    }

    public <T extends Range> Option<T> findRange(T[] ranges, long value, int arraySize) {
        if (Predef$.MODULE$.refArrayOps((Object[])ranges).size() < 1) {
            return None$.MODULE$;
        }
        if (value < ranges[0].start() || value > ranges[arraySize - 1].start() + ranges[arraySize - 1].size()) {
            throw new OffsetOutOfRangeException(new StringBuilder().append((Object)"offset ").append((Object)BoxesRunTime.boxToLong((long)value)).append((Object)" is out of range").toString());
        }
        if (value == ranges[arraySize - 1].start() + ranges[arraySize - 1].size()) {
            return None$.MODULE$;
        }
        int low = 0;
        int high = arraySize - 1;
        while (low <= high) {
            int mid = (high + low) / 2;
            T found = ranges[mid];
            if (found.contains(value)) {
                return new Some(found);
            }
            if (value < found.start()) {
                high = mid - 1;
                continue;
            }
            low = mid + 1;
        }
        return None$.MODULE$;
    }

    public <T extends Range> Option<T> findRange(T[] ranges, long value) {
        return this.findRange((Range[])ranges, value, ranges.length);
    }

    public String nameFromOffset(long offset) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMinimumIntegerDigits(20);
        nf.setMaximumFractionDigits(0);
        nf.setGroupingUsed(false);
        return new StringBuilder().append((Object)nf.format(offset)).append((Object)this.FileSuffix()).toString();
    }

    private Log$() {
        MODULE$ = this;
        this.FileSuffix = ".kafka";
    }
}

