/*
 * Decompiled with CFR 0.152.
 */
package kafka.consumer;

import java.net.InetAddress;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kafka.api.OffsetRequest$;
import kafka.cluster.Broker;
import kafka.cluster.Cluster;
import kafka.cluster.Partition;
import kafka.cluster.Partition$;
import kafka.common.InvalidConfigException;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.ConsumerConfig$;
import kafka.consumer.ConsumerConnector;
import kafka.consumer.ConsumerConnector$class;
import kafka.consumer.FetchedDataChunk;
import kafka.consumer.Fetcher;
import kafka.consumer.KafkaMessageStream;
import kafka.consumer.PartitionTopicInfo;
import kafka.consumer.SimpleConsumer;
import kafka.consumer.TopicCount;
import kafka.consumer.TopicCount$;
import kafka.consumer.ZookeeperConsumerConnector$;
import kafka.consumer.ZookeeperConsumerConnector$ZKRebalancerListener$;
import kafka.consumer.ZookeeperConsumerConnector$ZKRebalancerListener$$anonfun$kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$;
import kafka.consumer.ZookeeperConsumerConnectorMBean;
import kafka.serializer.Decoder;
import kafka.serializer.DefaultDecoder;
import kafka.utils.KafkaScheduler;
import kafka.utils.Pool;
import kafka.utils.ZKGroupDirs;
import kafka.utils.ZKGroupTopicDirs;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.IZkChildListener;
import org.I0Itec.zkclient.IZkStateListener;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.log4j.Logger;
import org.apache.zookeeper.Watcher;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\rmxAB\u0001\u0003\u0011\u000b!a!\u0001\u000e[_>\\W-\u001a9fe\u000e{gn];nKJ\u001cuN\u001c8fGR|'O\u0003\u0002\u0004\t\u0005A1m\u001c8tk6,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b!\t9\u0001\"D\u0001\u0003\r%I!\u0001\"A\u0001\u0012\u000b!!B\u0001\u000e[_>\\W-\u001a9fe\u000e{gn];nKJ\u001cuN\u001c8fGR|'oE\u0002\t\u0017M\u0001\"\u0001D\t\u000e\u00035Q!AD\b\u0002\t1\fgn\u001a\u0006\u0002!\u0005!!.\u0019<b\u0013\t\u0011RB\u0001\u0004PE*,7\r\u001e\t\u0003)]i\u0011!\u0006\u0006\u0002-\u0005)1oY1mC&\u0011\u0001$\u0006\u0002\f'\u000e\fG.Y(cU\u0016\u001cG\u000fC\u0003\u001b\u0011\u0011\u0005A$\u0001\u0004=S:LGOP\u0002\u0001)\u00051\u0001b\u0002\u0010\t\u0005\u0004%\taH\u0001\u000e\u001b\u0006CvLT0S\u000bR\u0013\u0016*R*\u0016\u0003\u0001\u0002\"\u0001F\u0011\n\u0005\t*\"aA%oi\"1A\u0005\u0003Q\u0001\n\u0001\na\"T!Y?:{&+\u0012+S\u0013\u0016\u001b\u0006\u0005C\u0004'\u0011\t\u0007I\u0011A\u0014\u0002\u001fMDW\u000f\u001e3po:\u001cu.\\7b]\u0012,\u0012\u0001\u000b\t\u0003\u000f%J!A\u000b\u0002\u0003!\u0019+Go\u00195fI\u0012\u000bG/Y\"ik:\\\u0007B\u0002\u0017\tA\u0003%\u0001&\u0001\ttQV$Hm\\<o\u0007>lW.\u00198eA\u0019I\u0011B\u0001C\u0001\u0002\u0003\u0005AAL\n\u0006[-y#g\u0005\t\u0003\u000fAJ!!\r\u0002\u0003#\r{gn];nKJ\u001cuN\u001c8fGR|'\u000f\u0005\u0002\bg%\u0011AG\u0001\u0002 5>|7.Z3qKJ\u001cuN\\:v[\u0016\u00148i\u001c8oK\u000e$xN]'CK\u0006t\u0007\u0002\u0003\u001c.\u0005\u000b\u0007I\u0011A\u001c\u0002\r\r|gNZ5h+\u0005A\u0004CA\u0004:\u0013\tQ$A\u0001\bD_:\u001cX/\\3s\u0007>tg-[4\t\u0011qj#\u0011!Q\u0001\na\nqaY8oM&<\u0007\u0005\u0003\u0005?[\t\u0015\r\u0011\"\u0001@\u00035)g.\u00192mK\u001a+Go\u00195feV\t\u0001\t\u0005\u0002\u0015\u0003&\u0011!)\u0006\u0002\b\u0005>|G.Z1o\u0011!!UF!A!\u0002\u0013\u0001\u0015AD3oC\ndWMR3uG\",'\u000f\t\u0005\u000655\"\tA\u0012\u000b\u0004\u000f\"K\u0005CA\u0004.\u0011\u00151T\t1\u00019\u0011\u0015qT\t1\u0001A\u0011\u001dYUF1A\u0005\n1\u000ba\u0001\\8hO\u0016\u0014X#A'\u0011\u00059+V\"A(\u000b\u0005A\u000b\u0016!\u00027pORR'B\u0001*T\u0003\u0019\t\u0007/Y2iK*\tA+A\u0002pe\u001eL!AV(\u0003\r1{wmZ3s\u0011\u0019AV\u0006)A\u0005\u001b\u00069An\\4hKJ\u0004\u0003b\u0002..\u0005\u0004%IaW\u0001\u000fSN\u001c\u0006.\u001e;uS:<Gi\\<o+\u0005a\u0006CA/e\u001b\u0005q&BA0a\u0003\u0019\tGo\\7jG*\u0011\u0011MY\u0001\u000bG>t7-\u001e:sK:$(BA2\u0010\u0003\u0011)H/\u001b7\n\u0005\u0015t&!D!u_6L7MQ8pY\u0016\fg\u000e\u0003\u0004h[\u0001\u0006I\u0001X\u0001\u0010SN\u001c\u0006.\u001e;uS:<Gi\\<oA!9\u0011.\fb\u0001\n\u0013Q\u0017!\u0004:fE\u0006d\u0017M\\2f\u0019>\u001c7.F\u0001\f\u0011\u0019aW\u0006)A\u0005\u0017\u0005q!/\u001a2bY\u0006t7-\u001a'pG.\u0004\u0003b\u00028.\u0001\u0004%Ia\\\u0001\bM\u0016$8\r[3s+\u0005\u0001\bc\u0001\u000brg&\u0011!/\u0006\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\u001d!\u0018BA;\u0003\u0005\u001d1U\r^2iKJDqa^\u0017A\u0002\u0013%\u00010A\u0006gKR\u001c\u0007.\u001a:`I\u0015\fHCA=}!\t!\"0\u0003\u0002|+\t!QK\\5u\u0011\u001dih/!AA\u0002A\f1\u0001\u001f\u00132\u0011\u0019yX\u0006)Q\u0005a\u0006Aa-\u001a;dQ\u0016\u0014\b\u0005C\u0005\u0002\u00045\u0002\r\u0011\"\u0003\u0002\u0006\u0005A!p[\"mS\u0016tG/\u0006\u0002\u0002\bA!\u0011\u0011BA\n\u001b\t\tYA\u0003\u0003\u0002\u000e\u0005=\u0011\u0001\u0003>lG2LWM\u001c;\u000b\u0007\u0005E1+\u0001\u0004Ja%#XmY\u0005\u0005\u0003+\tYA\u0001\u0005[W\u000ec\u0017.\u001a8u\u0011%\tI\"\fa\u0001\n\u0013\tY\"\u0001\u0007{W\u000ec\u0017.\u001a8u?\u0012*\u0017\u000fF\u0002z\u0003;A\u0011\"`A\f\u0003\u0003\u0005\r!a\u0002\t\u0011\u0005\u0005R\u0006)Q\u0005\u0003\u000f\t\u0011B_6DY&,g\u000e\u001e\u0011\t\u0013\u0005\u0015RF1A\u0005\n\u0005\u001d\u0012!\u0004;pa&\u001c'+Z4jgR\u0014\u00180\u0006\u0002\u0002*AA\u00111FA\u0019\u0003k\t\u0019%\u0004\u0002\u0002.)\u0019\u0011q\u0006\u0003\u0002\u000bU$\u0018\u000e\\:\n\t\u0005M\u0012Q\u0006\u0002\u0005!>|G\u000e\u0005\u0003\u00028\u0005ubb\u0001\u000b\u0002:%\u0019\u00111H\u000b\u0002\rA\u0013X\rZ3g\u0013\u0011\ty$!\u0011\u0003\rM#(/\u001b8h\u0015\r\tY$\u0006\t\t\u0003W\t\t$!\u0012\u0002RA!\u0011qIA'\u001b\t\tIEC\u0002\u0002L\u0011\tqa\u00197vgR,'/\u0003\u0003\u0002P\u0005%#!\u0003)beRLG/[8o!\r9\u00111K\u0005\u0004\u0003+\u0012!A\u0005)beRLG/[8o)>\u0004\u0018nY%oM>D\u0001\"!\u0017.A\u0003%\u0011\u0011F\u0001\u000fi>\u0004\u0018n\u0019*fO&\u001cHO]=!\u0011%\ti&\fb\u0001\n\u0013\ty&\u0001\u0004rk\u0016,Xm]\u000b\u0003\u0003C\u0002\u0002\"a\u000b\u00022\u0005\r\u0014\u0011\u000e\t\b)\u0005\u0015\u0014QGA\u001b\u0013\r\t9'\u0006\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u000b\u0005-\u0014Q\u000e\u0015\u000e\u0003\u0001L1!a\u001ca\u00055\u0011En\\2lS:<\u0017+^3vK\"A\u00111O\u0017!\u0002\u0013\t\t'A\u0004rk\u0016,Xm\u001d\u0011\t\u0013\u0005]TF1A\u0005\n\u0005e\u0014!C:dQ\u0016$W\u000f\\3s+\t\tY\b\u0005\u0003\u0002,\u0005u\u0014\u0002BA@\u0003[\u0011abS1gW\u0006\u001c6\r[3ek2,'\u000f\u0003\u0005\u0002\u00046\u0002\u000b\u0011BA>\u0003)\u00198\r[3ek2,'\u000f\t\u0005\u000755\"\t!a\"\u0015\u0007\u001d\u000bI\t\u0003\u00047\u0003\u000b\u0003\r\u0001\u000f\u0005\b\u0003\u001bkC\u0011AAH\u0003Q\u0019'/Z1uK6+7o]1hKN#(/Z1ngV!\u0011\u0011SAa)\u0019\t\u0019*a5\u0002ZBA\u0011QSAN\u0003k\ty*\u0004\u0002\u0002\u0018*\u0019\u0011\u0011T\u000b\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u001e\u0006]%aA'baB1\u0011\u0011UAY\u0003osA!a)\u0002.:!\u0011QUAV\u001b\t\t9KC\u0002\u0002*n\ta\u0001\u0010:p_Rt\u0014\"\u0001\f\n\u0007\u0005=V#A\u0004qC\u000e\\\u0017mZ3\n\t\u0005M\u0016Q\u0017\u0002\u0005\u0019&\u001cHOC\u0002\u00020V\u0001RaBA]\u0003{K1!a/\u0003\u0005IY\u0015MZ6b\u001b\u0016\u001c8/Y4f'R\u0014X-Y7\u0011\t\u0005}\u0016\u0011\u0019\u0007\u0001\t-\t\u0019-a#\u0005\u0002\u0003\u0015\r!!2\u0003\u0003Q\u000bB!a2\u0002NB\u0019A#!3\n\u0007\u0005-WCA\u0004O_RD\u0017N\\4\u0011\u0007Q\ty-C\u0002\u0002RV\u00111!\u00118z\u0011!\t).a#A\u0002\u0005]\u0017!\u0004;pa&\u001c7i\\;oi6\u000b\u0007\u000fE\u0004\u0002\u0016\u0006m\u0015Q\u0007\u0011\t\u0015\u0005m\u00171\u0012I\u0001\u0002\u0004\ti.A\u0004eK\u000e|G-\u001a:\u0011\r\u0005}\u0017Q]A_\u001b\t\t\tOC\u0002\u0002d\u0012\t!b]3sS\u0006d\u0017N_3s\u0013\u0011\t9/!9\u0003\u000f\u0011+7m\u001c3fe\"9\u00111^\u0017\u0005\n\u00055\u0018!D2sK\u0006$XMR3uG\",'\u000fF\u0001z\u0011\u001d\t\t0\fC\u0005\u0003[\f\u0011bY8o]\u0016\u001cGOW6\t\u000f\u0005UX\u0006\"\u0001\u0002n\u0006A1\u000f[;uI><h\u000eC\u0004\u0002z6\"\t!a?\u0002\u000f\r|gn];nKV!\u0011Q B\u0004)\u0019\tyP!\u0003\u0003\fAA\u0011QSAN\u0003k\u0011\t\u0001\u0005\u0004\u0002\"\u0006E&1\u0001\t\u0006\u000f\u0005e&Q\u0001\t\u0005\u0003\u007f\u00139\u0001B\u0006\u0002D\u0006]H\u0011!AC\u0002\u0005\u0015\u0007\u0002CAk\u0003o\u0004\r!a6\t\u0011\u0005m\u0017q\u001fa\u0001\u0005\u001b\u0001b!a8\u0002f\n\u0015\u0001b\u0002B\t[\u0011%!1C\u0001\u0015e\u0016<\u0017n\u001d;fe\u000e{gn];nKJLeNW&\u0015\u000fe\u0014)Ba\b\u0003$!A!q\u0003B\b\u0001\u0004\u0011I\"\u0001\u0003eSJ\u001c\b\u0003BA\u0016\u00057IAA!\b\u0002.\tY!lS$s_V\u0004H)\u001b:t\u0011!\u0011\tCa\u0004A\u0002\u0005U\u0012\u0001E2p]N,X.\u001a:JIN#(/\u001b8h\u0011!\u0011)Ca\u0004A\u0002\t\u001d\u0012A\u0003;pa&\u001c7i\\;oiB\u0019qA!\u000b\n\u0007\t-\"A\u0001\u0006U_BL7mQ8v]RDqAa\f.\t\u0013\ti/\u0001\ftK:$7\u000b[;e_^tGk\\!mYF+X-^3t\u0011\u001d\u0011\u0019$\fC\u0001\u0003[\f!\"Y;u_\u000e{W.\\5u\u0011\u001d\u00119$\fC\u0001\u0003[\fQbY8n[&$xJ\u001a4tKR\u001c\bb\u0002B\u001e[\u0011\u0005!QH\u0001\u0012O\u0016$\b+\u0019:u\u001f^tWM]*uCR\u001cHCAA\u001b\u0011\u001d\u0011\t%\fC\u0001\u0005{\t\u0001cZ3u\u0007>t7/^7fe\u001e\u0013x.\u001e9\t\u000f\t\u0015S\u0006\"\u0001\u0003H\u0005aq-\u001a;PM\u001a\u001cX\r\u001e'bORA!\u0011\nB(\u0005'\u00129\u0006E\u0002\u0015\u0005\u0017J1A!\u0014\u0016\u0005\u0011auN\\4\t\u0011\tE#1\ta\u0001\u0003k\tQ\u0001^8qS\u000eDqA!\u0016\u0003D\u0001\u0007\u0001%\u0001\u0005ce>\\WM]%e\u0011\u001d\u0011IFa\u0011A\u0002\u0001\n1\u0002]1si&$\u0018n\u001c8JI\"9!QL\u0017\u0005\u0002\t}\u0013!E4fi\u000e{gn];nK\u0012|eMZ:fiRA!\u0011\nB1\u0005G\u0012)\u0007\u0003\u0005\u0003R\tm\u0003\u0019AA\u001b\u0011\u001d\u0011)Fa\u0017A\u0002\u0001BqA!\u0017\u0003\\\u0001\u0007\u0001\u0005C\u0004\u0003j5\"\tAa\u001b\u0002\u001f\u001d,G\u000fT1uKN$xJ\u001a4tKR$\u0002B!\u0013\u0003n\t=$\u0011\u000f\u0005\t\u0005#\u00129\u00071\u0001\u00026!9!Q\u000bB4\u0001\u0004\u0001\u0003b\u0002B-\u0005O\u0002\r\u0001\t\u0005\b\u0005kjC\u0011\u0002B<\u0003Y)\u0017M\u001d7jKN$xJ\u001d'bi\u0016\u001cHo\u00144gg\u0016$HC\u0003B%\u0005s\u0012YH! \u0003\u0000!A!\u0011\u000bB:\u0001\u0004\t)\u0004C\u0004\u0003V\tM\u0004\u0019\u0001\u0011\t\u000f\te#1\u000fa\u0001A!A!\u0011\u0011B:\u0001\u0004\u0011I%\u0001\tfCJd\u0017.Z:u\u001fJd\u0015\r^3ti\u001aQ!QQ\u0017\u0005\u0002\u0003\u0005\tAa\"\u00031i[5+Z:tS>tW\t\u001f9je\u0016d\u0015n\u001d;f]:,'o\u0005\u0004\u0003\u0004.\u0011Ii\u0005\t\u0005\u0003\u0013\u0011Y)\u0003\u0003\u0003\u000e\u0006-!\u0001E%[WN#\u0018\r^3MSN$XM\\3s\u0011-\u00119Ba!\u0003\u0006\u0004%\tA!%\u0016\u0005\te\u0001b\u0003BK\u0005\u0007\u0013\t\u0011)A\u0005\u00053\tQ\u0001Z5sg\u0002B1B!\t\u0003\u0004\n\u0015\r\u0011\"\u0001\u0003\u001aV\u0011\u0011Q\u0007\u0005\f\u0005;\u0013\u0019I!A!\u0002\u0013\t)$A\td_:\u001cX/\\3s\u0013\u0012\u001cFO]5oO\u0002B1B!\n\u0003\u0004\n\u0015\r\u0011\"\u0001\u0003\"V\u0011!q\u0005\u0005\f\u0005K\u0013\u0019I!A!\u0002\u0013\u00119#A\u0006u_BL7mQ8v]R\u0004\u0003b\u0003BU\u0005\u0007\u0013)\u0019!C\u0001\u0005W\u000bA\u0003\\8bI\n\u000bG.\u00198dKJd\u0015n\u001d;f]\u0016\u0014XC\u0001BW!\u0011\u0011yK!-\u000e\u000352!Ba-.\t\u0003\u0005\t\u0011\u0001B[\u0005QQ6JU3cC2\fgnY3s\u0019&\u001cH/\u001a8feN1!\u0011W\u0006\u00038N\u0001B!!\u0003\u0003:&!!1XA\u0006\u0005AI%l[\"iS2$G*[:uK:,'\u000fC\u0006\u0003@\nE&Q1A\u0005\u0002\te\u0015!B4s_V\u0004\bb\u0003Bb\u0005c\u0013\t\u0011)A\u0005\u0003k\taa\u001a:pkB\u0004\u0003b\u0003B\u0011\u0005c\u0013)\u0019!C\u0001\u00053C1B!(\u00032\n\u0005\t\u0015!\u0003\u00026!9!D!-\u0005\u0002\t-GC\u0002BW\u0005\u001b\u0014y\r\u0003\u0005\u0003@\n%\u0007\u0019AA\u001b\u0011!\u0011\tC!3A\u0002\u0005U\u0002B\u0003B\f\u0005c\u0013\r\u0011\"\u0003\u0003\u0012\"I!Q\u0013BYA\u0003%!\u0011\u0004\u0005\u000b\u0005/\u0014\t\f1A\u0005\n\te\u0017\u0001G8mIB\u000b'\u000f^5uS>t7\u000fU3s)>\u0004\u0018nY'baV\u0011!1\u001c\t\t\u0005;\u0014\u0019/!\u000e\u0003f6\u0011!q\u001c\u0006\u0005\u0005C\f9*A\u0004nkR\f'\r\\3\n\t\u0005u%q\u001c\t\u0007\u0003C\u000b\t,!\u000e\t\u0015\t%(\u0011\u0017a\u0001\n\u0013\u0011Y/\u0001\u000fpY\u0012\u0004\u0016M\u001d;ji&|gn\u001d)feR{\u0007/[2NCB|F%Z9\u0015\u0007e\u0014i\u000fC\u0005~\u0005O\f\t\u00111\u0001\u0003\\\"I!\u0011\u001fBYA\u0003&!1\\\u0001\u001a_2$\u0007+\u0019:uSRLwN\\:QKJ$v\u000e]5d\u001b\u0006\u0004\b\u0005\u0003\u0006\u0003v\nE\u0006\u0019!C\u0005\u00053\fqc\u001c7e\u0007>t7/^7feN\u0004VM\u001d+pa&\u001cW*\u00199\t\u0015\te(\u0011\u0017a\u0001\n\u0013\u0011Y0A\u000epY\u0012\u001cuN\\:v[\u0016\u00148\u000fU3s)>\u0004\u0018nY'ba~#S-\u001d\u000b\u0004s\nu\b\"C?\u0003x\u0006\u0005\t\u0019\u0001Bn\u0011%\u0019\tA!-!B\u0013\u0011Y.\u0001\rpY\u0012\u001cuN\\:v[\u0016\u00148\u000fU3s)>\u0004\u0018nY'ba\u0002B\u0001b!\u0002\u00032\u0012\u00051qA\u0001\u0012Q\u0006tG\r\\3DQ&dGm\u00115b]\u001e,G#B=\u0004\n\r5\u0001\u0002CB\u0006\u0007\u0007\u0001\r!!\u000e\u0002\u0015A\f'/\u001a8u!\u0006$\b\u000e\u0003\u0005\u0004\u0010\r\r\u0001\u0019AB\t\u0003%\u0019WO]\"iS2$7\u000f\u0005\u0004\u0004\u0014\rU\u0011QG\u0007\u0002E&\u0019\u00111\u00172)\r\r\r1\u0011DB\u0010!\r!21D\u0005\u0004\u0007;)\"A\u0002;ie><8o\t\u0002\u0004\"A!\u0011\u0011UB\u0012\u0013\u0011\u0019)#!.\u0003\u0013\u0015C8-\u001a9uS>t\u0007\u0002CB\u0015\u0005c#I!!<\u00023I,G.Z1tKB\u000b'\u000f^5uS>twj\u001e8feND\u0017\u000e\u001d\u0005\t\u0007[\u0011\t\f\"\u0003\u00040\u0005!r-\u001a;D_:\u001cX/\\3sgB+'\u000fV8qS\u000e$BAa7\u00042!A!qXB\u0016\u0001\u0004\t)\u0004\u0003\u0005\u00046\tEF\u0011BB\u001c\u0003M9W\r\u001e*fY\u00164\u0018M\u001c;U_BL7-T1q)1\u0019Id!\u0011\u0004F\r-3qJB*!!\t)*a'\u00026\rm\u0002CBAK\u0007{\t)$\u0003\u0003\u0004@\u0005]%aA*fi\"A11IB\u001a\u0001\u0004\u0019I$A\nnsR{\u0007/[2UQJ,\u0017\rZ%eg6\u000b\u0007\u000f\u0003\u0005\u0004H\rM\u0002\u0019AB%\u0003)qWm\u001e)beRl\u0015\r\u001d\t\t\u0003+\u000bY*!\u000e\u0003f\"A1QJB\u001a\u0001\u0004\u0019I%\u0001\u0006pY\u0012\u0004\u0016M\u001d;NCBD\u0001b!\u0015\u00044\u0001\u00071\u0011J\u0001\u000f]\u0016<8i\u001c8tk6,'/T1q\u0011!\u0019)fa\rA\u0002\r%\u0013AD8mI\u000e{gn];nKJl\u0015\r\u001d\u0005\t\u00073\u0012\t\f\"\u0003\u0004\\\u0005iq-\u001a;U_BL7mQ8v]R$BAa\n\u0004^!A1qLB,\u0001\u0004\t)$\u0001\u0006d_:\u001cX/\\3s\u0013\u0012D\u0001ba\u0019\u00032\u0012\u0005\u0011Q^\u0001\u000be\u0016\u001cX\r^*uCR,\u0007\u0002CB4\u0005c#\t!!<\u0002\u001fMLhnY3e%\u0016\u0014\u0017\r\\1oG\u0016D\u0001ba\u001b\u00032\u0012%1QN\u0001\ne\u0016\u0014\u0017\r\\1oG\u0016$\u0012\u0001\u0011\u0005\t\u0007c\u0012\t\f\"\u0003\u0004t\u0005iQ\u000f\u001d3bi\u00164U\r^2iKJ$R!_B;\u0007{B\u0001\"a\u0013\u0004p\u0001\u00071q\u000f\t\u0005\u0003\u000f\u001aI(\u0003\u0003\u0004|\u0005%#aB\"mkN$XM\u001d\u0005\t\u0007\u007f\u001ay\u00071\u0001\u0004\u0002\u0006\t\u0012/^3vKN$vNY3DY\u0016\f'/\u001a3\u0011\r\u0005U51QA5\u0013\u0011\u0019))a&\u0003\u0011%#XM]1cY\u0016D\u0001b!#\u00032\u0012%11R\u0001\u0011aJ|7-Z:t!\u0006\u0014H/\u001b;j_:$\u0012\u0002QBG\u0007/\u001bYj!(\t\u0011\r=5q\u0011a\u0001\u0007#\u000b\u0011\u0002^8qS\u000e$\u0015N]:\u0011\t\u0005-21S\u0005\u0005\u0007+\u000biC\u0001\t[\u0017\u001e\u0013x.\u001e9U_BL7\rR5sg\"A1\u0011TBD\u0001\u0004\t)$A\u0005qCJ$\u0018\u000e^5p]\"A!\u0011KBD\u0001\u0004\t)\u0004\u0003\u0005\u0004 \u000e\u001d\u0005\u0019AA\u001b\u0003A\u0019wN\\:v[\u0016\u0014H\u000b\u001b:fC\u0012LE\r\u0003\u0005\u0004$\nEF\u0011BBS\u0003U\tG\r\u001a)beRLG/[8o)>\u0004\u0018nY%oM>$\u0012\"_BT\u0007S\u001bika,\t\u0011\r=5\u0011\u0015a\u0001\u0007#C\u0001ba+\u0004\"\u0002\u0007\u0011QG\u0001\u0010a\u0006\u0014H/\u001b;j_:\u001cFO]5oO\"A!\u0011KBQ\u0001\u0004\t)\u0004\u0003\u0005\u0004 \u000e\u0005\u0006\u0019AA\u001b\u0011-\u0019\u0019La!\u0003\u0002\u0003\u0006IA!,\u0002+1|\u0017\r\u001a\"bY\u0006t7-\u001a:MSN$XM\\3sA!9!Da!\u0005\u0002\r]FCCB]\u0007w\u001bila0\u0004BB!!q\u0016BB\u0011!\u00119b!.A\u0002\te\u0001\u0002\u0003B\u0011\u0007k\u0003\r!!\u000e\t\u0011\t\u00152Q\u0017a\u0001\u0005OA\u0001B!+\u00046\u0002\u0007!Q\u0016\u0005\t\u0007\u000b\u0014\u0019\t\"\u0001\u0004H\u0006\u0011\u0002.\u00198eY\u0016\u001cF/\u0019;f\u0007\"\fgnZ3e)\rI8\u0011\u001a\u0005\t\u0007\u0017\u001c\u0019\r1\u0001\u0004N\u0006)1\u000f^1uKB!1qZBw\u001d\u0011\u0019\tna:\u000f\t\rM7\u0011\u001d\b\u0005\u0007+\u001ciN\u0004\u0003\u0004X\u000emg\u0002BAS\u00073L\u0011\u0001V\u0005\u0003%NK1aa8R\u0003%Qxn\\6fKB,'/\u0003\u0003\u0004d\u000e\u0015\u0018aB,bi\u000eDWM\u001d\u0006\u0004\u0007?\f\u0016\u0002BBu\u0007W\fQ!\u0012<f]RTAaa9\u0004f&!1q^By\u0005-YU-\u001a9feN#\u0018\r^3\u000b\t\r%81\u001e\u0015\u0007\u0007\u0007\u001cIba\b\t\u0011\r](1\u0011C\u0001\u0003[\f\u0001\u0003[1oI2,g*Z<TKN\u001c\u0018n\u001c8)\r\rU8\u0011DB\u0010\u0001")
public class ZookeeperConsumerConnector
implements ConsumerConnector,
ZookeeperConsumerConnectorMBean,
ScalaObject {
    private final ConsumerConfig config;
    private final boolean enableFetcher;
    private final Logger kafka$consumer$ZookeeperConsumerConnector$$logger;
    private final AtomicBoolean isShuttingDown;
    private final Object kafka$consumer$ZookeeperConsumerConnector$$rebalanceLock;
    private Option kafka$consumer$ZookeeperConsumerConnector$$fetcher;
    private ZkClient kafka$consumer$ZookeeperConsumerConnector$$zkClient;
    private final Pool kafka$consumer$ZookeeperConsumerConnector$$topicRegistry;
    private final Pool kafka$consumer$ZookeeperConsumerConnector$$queues;
    private final KafkaScheduler scheduler;

    public static final FetchedDataChunk shutdownCommand() {
        return ZookeeperConsumerConnector$.MODULE$.shutdownCommand();
    }

    public static final int MAX_N_RETRIES() {
        return ZookeeperConsumerConnector$.MODULE$.MAX_N_RETRIES();
    }

    @Override
    public /* synthetic */ DefaultDecoder createMessageStreams$default$2() {
        return ConsumerConnector$class.createMessageStreams$default$2(this);
    }

    public ConsumerConfig config() {
        return this.config;
    }

    public boolean enableFetcher() {
        return this.enableFetcher;
    }

    public final Logger kafka$consumer$ZookeeperConsumerConnector$$logger() {
        return this.kafka$consumer$ZookeeperConsumerConnector$$logger;
    }

    private AtomicBoolean isShuttingDown() {
        return this.isShuttingDown;
    }

    public final Object kafka$consumer$ZookeeperConsumerConnector$$rebalanceLock() {
        return this.kafka$consumer$ZookeeperConsumerConnector$$rebalanceLock;
    }

    public final Option kafka$consumer$ZookeeperConsumerConnector$$fetcher() {
        return this.kafka$consumer$ZookeeperConsumerConnector$$fetcher;
    }

    private void kafka$consumer$ZookeeperConsumerConnector$$fetcher_$eq(Option option) {
        this.kafka$consumer$ZookeeperConsumerConnector$$fetcher = option;
    }

    public final ZkClient kafka$consumer$ZookeeperConsumerConnector$$zkClient() {
        return this.kafka$consumer$ZookeeperConsumerConnector$$zkClient;
    }

    private void kafka$consumer$ZookeeperConsumerConnector$$zkClient_$eq(ZkClient zkClient) {
        this.kafka$consumer$ZookeeperConsumerConnector$$zkClient = zkClient;
    }

    public final Pool kafka$consumer$ZookeeperConsumerConnector$$topicRegistry() {
        return this.kafka$consumer$ZookeeperConsumerConnector$$topicRegistry;
    }

    public final Pool kafka$consumer$ZookeeperConsumerConnector$$queues() {
        return this.kafka$consumer$ZookeeperConsumerConnector$$queues;
    }

    private KafkaScheduler scheduler() {
        return this.scheduler;
    }

    public ZookeeperConsumerConnector(ConsumerConfig config) {
        this(config, true);
    }

    @Override
    public <T> Map<String, List<KafkaMessageStream<T>>> createMessageStreams(Map<String, Integer> topicCountMap, Decoder<T> decoder) {
        return this.consume(topicCountMap, decoder);
    }

    private void createFetcher() {
        if (this.enableFetcher()) {
            this.kafka$consumer$ZookeeperConsumerConnector$$fetcher_$eq((Option)new Some((Object)new Fetcher(this.config(), this.kafka$consumer$ZookeeperConsumerConnector$$zkClient())));
        }
    }

    private void connectZk() {
        this.kafka$consumer$ZookeeperConsumerConnector$$logger().info((Object)new StringBuilder().append((Object)"Connecting to zookeeper instance at ").append((Object)this.config().zkConnect()).toString());
        this.kafka$consumer$ZookeeperConsumerConnector$$zkClient_$eq(new ZkClient(this.config().zkConnect(), this.config().zkSessionTimeoutMs(), this.config().zkConnectionTimeoutMs(), (ZkSerializer)ZKStringSerializer$.MODULE$));
    }

    @Override
    public void shutdown() {
        block6: {
            block5: {
                boolean canShutdown = this.isShuttingDown().compareAndSet(false, true);
                if (!canShutdown) break block6;
                this.kafka$consumer$ZookeeperConsumerConnector$$logger().info((Object)"ZKConsumerConnector shutting down");
                try {
                    Option option;
                    block9: {
                        block8: {
                            block7: {
                                this.scheduler().shutdownNow();
                                option = this.kafka$consumer$ZookeeperConsumerConnector$$fetcher();
                                if (!(option instanceof Some)) break block7;
                                ((Fetcher)((Some)option).x()).shutdown();
                                break block8;
                            }
                            None$ none$ = None$.MODULE$;
                            Option option2 = option;
                            if (none$ != null ? !none$.equals(option2) : option2 != null) break block9;
                        }
                        this.sendShudownToAllQueues();
                        if (this.config().autoCommit()) {
                            this.commitOffsets();
                        }
                        if (this.kafka$consumer$ZookeeperConsumerConnector$$zkClient() != null) {
                            this.kafka$consumer$ZookeeperConsumerConnector$$zkClient().close();
                            this.kafka$consumer$ZookeeperConsumerConnector$$zkClient_$eq(null);
                        }
                        break block5;
                    }
                    throw new MatchError((Object)option);
                }
                catch (Throwable throwable) {
                    this.kafka$consumer$ZookeeperConsumerConnector$$logger().fatal((Object)"error during consumer connector shutdown", throwable);
                }
            }
            this.kafka$consumer$ZookeeperConsumerConnector$$logger().info((Object)"ZKConsumerConnector shut down completed");
        }
    }

    public <T> Map<String, List<KafkaMessageStream<T>>> consume(Map<String, Integer> topicCountMap, Decoder<T> decoder$1) {
        Option<String> option;
        block6: {
            String consumerUuid;
            ObjectRef ret$1;
            ZKGroupDirs dirs;
            block5: {
                block4: {
                    this.kafka$consumer$ZookeeperConsumerConnector$$logger().debug((Object)"entering consume ");
                    if (topicCountMap == null) {
                        throw new RuntimeException("topicCountMap is null");
                    }
                    dirs = new ZKGroupDirs(this.config().groupId());
                    ret$1 = new ObjectRef((Object)new HashMap());
                    consumerUuid = null;
                    option = this.config().consumerId();
                    if (!(option instanceof Some)) break block4;
                    consumerUuid = (String)((Some)option).x();
                    break block5;
                }
                None$ none$ = None$.MODULE$;
                Option<String> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block6;
                UUID uuid = UUID.randomUUID();
                consumerUuid = Predef$.MODULE$.augmentString("%s-%d-%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{InetAddress.getLocalHost().getHostName(), BoxesRunTime.boxToLong((long)System.currentTimeMillis()), Predef$.MODULE$.longWrapper(uuid.getMostSignificantBits()).toHexString().substring(0, 8)}));
            }
            String consumerIdString = new StringBuilder().append((Object)this.config().groupId()).append((Object)"_").append((Object)consumerUuid).toString();
            TopicCount topicCount = new TopicCount(consumerIdString, topicCountMap);
            ZKRebalancerListener loadBalancerListener$1 = new ZKRebalancerListener(this, this.config().groupId(), consumerIdString);
            this.kafka$consumer$ZookeeperConsumerConnector$$registerConsumerInZK(dirs, consumerIdString, topicCount);
            this.kafka$consumer$ZookeeperConsumerConnector$$zkClient().subscribeStateChanges((IZkStateListener)new ZKSessionExpireListenner(this, dirs, consumerIdString, topicCount, loadBalancerListener$1));
            this.kafka$consumer$ZookeeperConsumerConnector$$zkClient().subscribeChildChanges(dirs.consumerRegistryDir(), (IZkChildListener)loadBalancerListener$1);
            Map<String, Set<String>> consumerThreadIdsPerTopic = topicCount.getConsumerThreadIdsPerTopic();
            consumerThreadIdsPerTopic.foreach((Function1)new $anonfun$consume$1(this, decoder$1, ret$1, loadBalancerListener$1));
            loadBalancerListener$1.syncedRebalance();
            return (HashMap)ret$1.elem;
        }
        throw new MatchError(option);
    }

    public final void kafka$consumer$ZookeeperConsumerConnector$$registerConsumerInZK(ZKGroupDirs dirs, String consumerIdString, TopicCount topicCount) {
        this.kafka$consumer$ZookeeperConsumerConnector$$logger().info((Object)new StringBuilder().append((Object)"begin registering consumer ").append((Object)consumerIdString).append((Object)" in ZK").toString());
        ZkUtils$.MODULE$.createEphemeralPathExpectConflict(this.kafka$consumer$ZookeeperConsumerConnector$$zkClient(), new StringBuilder().append((Object)dirs.consumerRegistryDir()).append((Object)"/").append((Object)consumerIdString).toString(), topicCount.toJsonString());
        this.kafka$consumer$ZookeeperConsumerConnector$$logger().info((Object)new StringBuilder().append((Object)"end registering consumer ").append((Object)consumerIdString).append((Object)" in ZK").toString());
    }

    private void sendShudownToAllQueues() {
        this.kafka$consumer$ZookeeperConsumerConnector$$queues().values().foreach((Function1)new $anonfun$sendShudownToAllQueues$1(this));
    }

    public void autoCommit() {
        if (this.kafka$consumer$ZookeeperConsumerConnector$$logger().isTraceEnabled()) {
            this.kafka$consumer$ZookeeperConsumerConnector$$logger().trace((Object)"auto committing");
        }
        try {
            this.commitOffsets();
        }
        catch (Throwable throwable) {
            this.kafka$consumer$ZookeeperConsumerConnector$$logger().error((Object)"exception during autoCommit: ", throwable);
        }
    }

    @Override
    public void commitOffsets() {
        if (this.kafka$consumer$ZookeeperConsumerConnector$$zkClient() == null) {
            return;
        }
        this.kafka$consumer$ZookeeperConsumerConnector$$topicRegistry().foreach((Function1)new $anonfun$commitOffsets$1(this));
    }

    @Override
    public String getPartOwnerStats() {
        StringBuilder builder$1 = new StringBuilder();
        this.kafka$consumer$ZookeeperConsumerConnector$$topicRegistry().foreach((Function1)new $anonfun$getPartOwnerStats$1(this, builder$1));
        return builder$1.toString();
    }

    @Override
    public String getConsumerGroup() {
        return this.config().groupId();
    }

    @Override
    public long getOffsetLag(String topic, int brokerId, int partitionId) {
        return this.getLatestOffset(topic, brokerId, partitionId) - this.getConsumedOffset(topic, brokerId, partitionId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long getConsumedOffset(String topic, int brokerId, int partitionId) {
        PartitionTopicInfo partitionInfo;
        Partition partition = new Partition(brokerId, partitionId);
        Pool partitionInfos = (Pool)this.kafka$consumer$ZookeeperConsumerConnector$$topicRegistry().get(topic);
        if (partitionInfos != null && (partitionInfo = (PartitionTopicInfo)partitionInfos.get(partition)) != null) return partitionInfo.getConsumeOffset();
        try {
            ZKGroupTopicDirs topicDirs = new ZKGroupTopicDirs(this.config().groupId(), topic);
            String znode = new StringBuilder().append((Object)topicDirs.consumerOffsetDir()).append((Object)"/").append((Object)partition.name()).toString();
            String offsetString = ZkUtils$.MODULE$.readDataMaybeNull(this.kafka$consumer$ZookeeperConsumerConnector$$zkClient(), znode);
            if (offsetString != null) return Predef$.MODULE$.augmentString(offsetString).toLong();
            return -1L;
        }
        catch (Throwable throwable) {
            this.kafka$consumer$ZookeeperConsumerConnector$$logger().error((Object)"error in getConsumedOffset JMX ", throwable);
            return -2L;
        }
    }

    @Override
    public long getLatestOffset(String topic, int brokerId, int partitionId) {
        return this.kafka$consumer$ZookeeperConsumerConnector$$earliestOrLatestOffset(topic, brokerId, partitionId, OffsetRequest$.MODULE$.LatestTime());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final long kafka$consumer$ZookeeperConsumerConnector$$earliestOrLatestOffset(String topic, int brokerId, int partitionId, long earliestOrLatest) {
        SimpleConsumer simpleConsumer = null;
        long producedOffset = -1L;
        try {
            Cluster cluster = ZkUtils$.MODULE$.getCluster(this.kafka$consumer$ZookeeperConsumerConnector$$zkClient());
            Broker broker = cluster.getBroker(brokerId);
            simpleConsumer = new SimpleConsumer(broker.host(), broker.port(), ConsumerConfig$.MODULE$.SocketTimeout(), ConsumerConfig$.MODULE$.SocketBufferSize());
            long[] offsets = simpleConsumer.getOffsetsBefore(topic, partitionId, earliestOrLatest, 1);
            producedOffset = offsets[0];
            if (simpleConsumer == null) return producedOffset;
            simpleConsumer.close();
            return producedOffset;
        }
        catch (Throwable throwable) {
            try {
                this.kafka$consumer$ZookeeperConsumerConnector$$logger().error((Object)"error in earliestOrLatestOffset() ", throwable);
            }
            finally {
                if (simpleConsumer == null) return producedOffset;
                simpleConsumer.close();
            }
        }
    }

    public ZookeeperConsumerConnector(ConsumerConfig config, boolean enableFetcher) {
        Object object;
        this.config = config;
        this.enableFetcher = enableFetcher;
        ConsumerConnector$class.$init$(this);
        this.kafka$consumer$ZookeeperConsumerConnector$$logger = Logger.getLogger(this.getClass());
        this.isShuttingDown = new AtomicBoolean(false);
        this.kafka$consumer$ZookeeperConsumerConnector$$rebalanceLock = new Object();
        this.kafka$consumer$ZookeeperConsumerConnector$$fetcher = None$.MODULE$;
        this.kafka$consumer$ZookeeperConsumerConnector$$zkClient = null;
        this.kafka$consumer$ZookeeperConsumerConnector$$topicRegistry = new Pool();
        this.kafka$consumer$ZookeeperConsumerConnector$$queues = new Pool();
        this.scheduler = new KafkaScheduler(1, "Kafka-consumer-autocommit-", false);
        this.connectZk();
        this.createFetcher();
        if (config.autoCommit()) {
            this.kafka$consumer$ZookeeperConsumerConnector$$logger().info((Object)new StringBuilder().append((Object)"starting auto committer every ").append((Object)BoxesRunTime.boxToInteger((int)config.autoCommitIntervalMs())).append((Object)" ms").toString());
            object = this.scheduler().scheduleWithRate((Function0<Object>)new $anonfun$1(this), config.autoCommitIntervalMs(), config.autoCommitIntervalMs());
        } else {
            object = BoxedUnit.UNIT;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ZKRebalancerListener
    implements IZkChildListener,
    ScalaObject {
        private final String group;
        private final String consumerIdString;
        private final ZKGroupDirs dirs;
        private scala.collection.mutable.Map<String, List<String>> oldPartitionsPerTopicMap;
        private scala.collection.mutable.Map<String, List<String>> oldConsumersPerTopicMap;
        public final /* synthetic */ ZookeeperConsumerConnector $outer;

        public String group() {
            return this.group;
        }

        public String consumerIdString() {
            return this.consumerIdString;
        }

        private ZKGroupDirs dirs() {
            return this.dirs;
        }

        private scala.collection.mutable.Map<String, List<String>> oldPartitionsPerTopicMap() {
            return this.oldPartitionsPerTopicMap;
        }

        private void oldPartitionsPerTopicMap_$eq(scala.collection.mutable.Map<String, List<String>> map) {
            this.oldPartitionsPerTopicMap = map;
        }

        private scala.collection.mutable.Map<String, List<String>> oldConsumersPerTopicMap() {
            return this.oldConsumersPerTopicMap;
        }

        private void oldConsumersPerTopicMap_$eq(scala.collection.mutable.Map<String, List<String>> map) {
            this.oldConsumersPerTopicMap = map;
        }

        public void handleChildChange(String parentPath, java.util.List<String> curChilds) throws Exception {
            this.syncedRebalance();
        }

        public final void kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$releasePartitionOwnership() {
            this.kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$$outer().kafka$consumer$ZookeeperConsumerConnector$$topicRegistry().foreach((Function1)new ZKRebalancerListener$$anonfun$kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$releasePartitionOwnership$1(this));
        }

        /*
         * WARNING - void declaration
         */
        private scala.collection.mutable.Map<String, List<String>> getConsumersPerTopic(String group) {
            void var3_3;
            Seq<String> consumers = ZkUtils$.MODULE$.getChildrenParentMayNotExist(this.kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$$outer().kafka$consumer$ZookeeperConsumerConnector$$zkClient(), this.dirs().consumerRegistryDir());
            HashMap consumersPerTopicMap$1 = new HashMap();
            consumers.foreach((Function1)new ZKRebalancerListener$$anonfun$getConsumersPerTopic$1(this, consumersPerTopicMap$1));
            consumersPerTopicMap$1.foreach((Function1)new ZKRebalancerListener$$anonfun$getConsumersPerTopic$2(this, consumersPerTopicMap$1));
            return var3_3;
        }

        private Map<String, Set<String>> getRelevantTopicMap(Map<String, Set<String>> myTopicThreadIdsMap, Map<String, List<String>> newPartMap$1, Map<String, List<String>> oldPartMap$1, Map<String, List<String>> newConsumerMap$1, Map<String, List<String>> oldConsumerMap$1) {
            ObjectRef relevantTopicThreadIdsMap$1 = new ObjectRef((Object)new HashMap());
            myTopicThreadIdsMap.foreach((Function1)new ZKRebalancerListener$$anonfun$getRelevantTopicMap$1(this, newPartMap$1, oldPartMap$1, newConsumerMap$1, oldConsumerMap$1, relevantTopicThreadIdsMap$1));
            return (HashMap)relevantTopicThreadIdsMap$1.elem;
        }

        public final TopicCount kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$getTopicCount(String consumerId) {
            String topicCountJson = ZkUtils$.MODULE$.readData(this.kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$$outer().kafka$consumer$ZookeeperConsumerConnector$$zkClient(), new StringBuilder().append((Object)this.dirs().consumerRegistryDir()).append((Object)"/").append((Object)consumerId).toString());
            return TopicCount$.MODULE$.constructTopicCount(consumerId, topicCountJson);
        }

        public void resetState() {
            this.kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$$outer().kafka$consumer$ZookeeperConsumerConnector$$topicRegistry().clear();
            this.oldConsumersPerTopicMap().clear();
            this.oldPartitionsPerTopicMap().clear();
        }

        public void syncedRebalance() {
            Object object = new Object();
            try {
                Object object2 = this.kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$$outer().kafka$consumer$ZookeeperConsumerConnector$$rebalanceLock();
                synchronized (object2) {
                    Predef$.MODULE$.intWrapper(0).until(ZookeeperConsumerConnector$.MODULE$.MAX_N_RETRIES()).foreach$mVc$sp((Function1)new ZKRebalancerListener$$anonfun$syncedRebalance$1(this, object));
                    throw new RuntimeException(new StringBuilder().append((Object)this.consumerIdString()).append((Object)" can't rebalance after ").append((Object)BoxesRunTime.boxToInteger((int)ZookeeperConsumerConnector$.MODULE$.MAX_N_RETRIES())).append((Object)" retires").toString());
                }
            }
            catch (NonLocalReturnControl nonLocalReturnControl) {
                if (nonLocalReturnControl.key() == object) {
                    BoxedUnit cfr_ignored_0 = (BoxedUnit)nonLocalReturnControl.value();
                    return;
                }
                throw nonLocalReturnControl;
            }
        }

        public final boolean kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$rebalance() {
            NonLocalReturnControl nonLocalReturnControl2;
            block3: {
                Object object = new Object();
                boolean exceptionResult1 = false;
                try {
                    Map<String, Set<String>> myTopicThreadIdsMap = this.kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$getTopicCount(this.consumerIdString()).getConsumerThreadIdsPerTopic();
                    Cluster cluster = ZkUtils$.MODULE$.getCluster(this.kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$$outer().kafka$consumer$ZookeeperConsumerConnector$$zkClient());
                    scala.collection.mutable.Map<String, List<String>> consumersPerTopicMap$2 = this.getConsumersPerTopic(this.group());
                    scala.collection.mutable.Map<String, List<String>> partitionsPerTopicMap$1 = ZkUtils$.MODULE$.getPartitionsForTopics(this.kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$$outer().kafka$consumer$ZookeeperConsumerConnector$$zkClient(), (Iterator<String>)myTopicThreadIdsMap.keys().iterator());
                    Map<String, Set<String>> relevantTopicThreadIdsMap = this.getRelevantTopicMap(myTopicThreadIdsMap, (Map<String, List<String>>)partitionsPerTopicMap$1, (Map<String, List<String>>)this.oldPartitionsPerTopicMap(), (Map<String, List<String>>)consumersPerTopicMap$2, (Map<String, List<String>>)this.oldConsumersPerTopicMap());
                    if (relevantTopicThreadIdsMap.size() <= 0) {
                        this.kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$$outer().kafka$consumer$ZookeeperConsumerConnector$$logger().info((Object)new StringBuilder().append((Object)"Consumer ").append((Object)this.consumerIdString()).append((Object)" with ").append(consumersPerTopicMap$2).append((Object)" doesn't need to rebalance.").toString());
                        return true;
                    }
                    this.kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$$outer().kafka$consumer$ZookeeperConsumerConnector$$logger().info((Object)"Committing all offsets");
                    this.kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$$outer().commitOffsets();
                    this.kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$$outer().kafka$consumer$ZookeeperConsumerConnector$$logger().info((Object)"Releasing partition ownership");
                    this.kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$releasePartitionOwnership();
                    HashSet queuesToBeCleared$1 = new HashSet();
                    relevantTopicThreadIdsMap.foreach((Function1)new ZKRebalancerListener$$anonfun$kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$rebalance$1(this, consumersPerTopicMap$2, partitionsPerTopicMap$1, queuesToBeCleared$1, object));
                    this.updateFetcher(cluster, (Iterable<BlockingQueue<FetchedDataChunk>>)queuesToBeCleared$1);
                    this.oldPartitionsPerTopicMap_$eq(partitionsPerTopicMap$1);
                    this.oldConsumersPerTopicMap_$eq(consumersPerTopicMap$2);
                    exceptionResult1 = true;
                }
                catch (NonLocalReturnControl nonLocalReturnControl2) {
                    if (nonLocalReturnControl2.key() != object) break block3;
                    exceptionResult1 = BoxesRunTime.unboxToBoolean((Object)nonLocalReturnControl2.value());
                }
                return exceptionResult1;
            }
            throw nonLocalReturnControl2;
        }

        private void updateFetcher(Cluster cluster, Iterable<BlockingQueue<FetchedDataChunk>> queuesTobeCleared) {
            Option option;
            block4: {
                block3: {
                    block2: {
                        ObjectRef allPartitionInfos$1 = new ObjectRef((Object)Nil$.MODULE$);
                        this.kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$$outer().kafka$consumer$ZookeeperConsumerConnector$$topicRegistry().values().foreach((Function1)new ZKRebalancerListener$$anonfun$updateFetcher$1(this, allPartitionInfos$1));
                        this.kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$$outer().kafka$consumer$ZookeeperConsumerConnector$$logger().info((Object)new StringBuilder().append((Object)"Consumer ").append((Object)this.consumerIdString()).append((Object)" selected partitions : ").append((Object)((TraversableOnce)((TraversableLike)((List)allPartitionInfos$1.elem).sortWith((Function2)new ZKRebalancerListener$$anonfun$updateFetcher$2(this))).map((Function1)new ZKRebalancerListener$$anonfun$updateFetcher$3(this), List$.MODULE$.canBuildFrom())).mkString(",")).toString());
                        option = this.kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$$outer().kafka$consumer$ZookeeperConsumerConnector$$fetcher();
                        if (!(option instanceof Some)) break block2;
                        ((Fetcher)((Some)option).x()).initConnections((Iterable<PartitionTopicInfo>)((List)allPartitionInfos$1.elem), cluster, queuesTobeCleared);
                        break block3;
                    }
                    None$ none$ = None$.MODULE$;
                    Option option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                }
                return;
            }
            throw new MatchError((Object)option);
        }

        public final boolean kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$processPartition(ZKGroupTopicDirs topicDirs, String partition, String topic, String consumerThreadId) {
            String partitionOwnerPath = new StringBuilder().append((Object)topicDirs.consumerOwnerDir()).append((Object)"/").append((Object)partition).toString();
            try {
                ZkUtils$.MODULE$.createEphemeralPathExpectConflict(this.kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$$outer().kafka$consumer$ZookeeperConsumerConnector$$zkClient(), partitionOwnerPath, consumerThreadId);
                this.addPartitionTopicInfo(topicDirs, partition, topic, consumerThreadId);
                return true;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            catch (ZkNodeExistsException zkNodeExistsException) {
                this.kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$$outer().kafka$consumer$ZookeeperConsumerConnector$$logger().info((Object)new StringBuilder().append((Object)"waiting for the partition ownership to be deleted: ").append((Object)partition).toString());
                return false;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void addPartitionTopicInfo(ZKGroupTopicDirs topicDirs, String partitionString, String topic, String consumerThreadId) {
            Partition partition = Partition$.MODULE$.parse(partitionString);
            Pool partTopicInfoMap = (Pool)this.kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$$outer().kafka$consumer$ZookeeperConsumerConnector$$topicRegistry().get(topic);
            String znode = new StringBuilder().append((Object)topicDirs.consumerOffsetDir()).append((Object)"/").append((Object)partition.name()).toString();
            String offsetString = ZkUtils$.MODULE$.readDataMaybeNull(this.kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$$outer().kafka$consumer$ZookeeperConsumerConnector$$zkClient(), znode);
            long offset = 0L;
            if (offsetString == null) {
                long l;
                String string;
                String string2 = string = this.kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$$outer().config().autoOffsetReset();
                String string3 = OffsetRequest$.MODULE$.SmallestTimeString();
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    l = this.kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$$outer().kafka$consumer$ZookeeperConsumerConnector$$earliestOrLatestOffset(topic, partition.brokerId(), partition.partId(), OffsetRequest$.MODULE$.EarliestTime());
                } else {
                    String string4 = string;
                    String string5 = OffsetRequest$.MODULE$.LargestTimeString();
                    if (string4 != null ? !string4.equals(string5) : string5 != null) throw new InvalidConfigException("Wrong value in autoOffsetReset in ConsumerConfig");
                    l = this.kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$$outer().kafka$consumer$ZookeeperConsumerConnector$$earliestOrLatestOffset(topic, partition.brokerId(), partition.partId(), OffsetRequest$.MODULE$.LatestTime());
                }
                offset = l;
            } else {
                offset = Predef$.MODULE$.augmentString(offsetString).toLong();
            }
            BlockingQueue queue = (BlockingQueue)this.kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$$outer().kafka$consumer$ZookeeperConsumerConnector$$queues().get(new Tuple2((Object)topic, (Object)consumerThreadId));
            AtomicLong consumedOffset = new AtomicLong(offset);
            AtomicLong fetchedOffset = new AtomicLong(offset);
            PartitionTopicInfo partTopicInfo = new PartitionTopicInfo(topic, partition.brokerId(), partition, queue, consumedOffset, fetchedOffset, new AtomicInteger(this.kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$$outer().config().fetchSize()));
            partTopicInfoMap.put(partition, partTopicInfo);
            if (!this.kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$$outer().kafka$consumer$ZookeeperConsumerConnector$$logger().isDebugEnabled()) return;
            this.kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$$outer().kafka$consumer$ZookeeperConsumerConnector$$logger().debug((Object)new StringBuilder().append((Object)Predef$.MODULE$.any2stringadd((Object)partTopicInfo).$plus(" selected new offset ")).append((Object)BoxesRunTime.boxToLong((long)offset)).toString());
        }

        public /* synthetic */ ZookeeperConsumerConnector kafka$consumer$ZookeeperConsumerConnector$ZKRebalancerListener$$$outer() {
            return this.$outer;
        }

        public ZKRebalancerListener(ZookeeperConsumerConnector $outer, String group, String consumerIdString) {
            this.group = group;
            this.consumerIdString = consumerIdString;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.dirs = new ZKGroupDirs(group);
            this.oldPartitionsPerTopicMap = new HashMap();
            this.oldConsumersPerTopicMap = new HashMap();
        }
    }

    public class ZKSessionExpireListenner
    implements IZkStateListener,
    ScalaObject {
        private final ZKGroupDirs dirs;
        private final String consumerIdString;
        private final TopicCount topicCount;
        private final ZKRebalancerListener loadBalancerListener;
        public final /* synthetic */ ZookeeperConsumerConnector $outer;

        public ZKGroupDirs dirs() {
            return this.dirs;
        }

        public String consumerIdString() {
            return this.consumerIdString;
        }

        public TopicCount topicCount() {
            return this.topicCount;
        }

        public ZKRebalancerListener loadBalancerListener() {
            return this.loadBalancerListener;
        }

        public void handleStateChanged(Watcher.Event.KeeperState state) throws Exception {
        }

        public void handleNewSession() throws Exception {
            this.kafka$consumer$ZookeeperConsumerConnector$ZKSessionExpireListenner$$$outer().kafka$consumer$ZookeeperConsumerConnector$$logger().info((Object)new StringBuilder().append((Object)"ZK expired; release old broker parition ownership; re-register consumer ").append((Object)this.consumerIdString()).toString());
            this.loadBalancerListener().resetState();
            this.kafka$consumer$ZookeeperConsumerConnector$ZKSessionExpireListenner$$$outer().kafka$consumer$ZookeeperConsumerConnector$$registerConsumerInZK(this.dirs(), this.consumerIdString(), this.topicCount());
            this.loadBalancerListener().syncedRebalance();
        }

        public /* synthetic */ ZookeeperConsumerConnector kafka$consumer$ZookeeperConsumerConnector$ZKSessionExpireListenner$$$outer() {
            return this.$outer;
        }

        public ZKSessionExpireListenner(ZookeeperConsumerConnector $outer, ZKGroupDirs dirs, String consumerIdString, TopicCount topicCount, ZKRebalancerListener loadBalancerListener) {
            this.dirs = dirs;
            this.consumerIdString = consumerIdString;
            this.topicCount = topicCount;
            this.loadBalancerListener = loadBalancerListener;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }
    }
}

