/*
 * Decompiled with CFR 0.152.
 */
package kafka.consumer;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import kafka.consumer.ConsumerTimeoutException;
import kafka.consumer.ConsumerTopicStat$;
import kafka.consumer.FetchedDataChunk;
import kafka.consumer.PartitionTopicInfo;
import kafka.consumer.ZookeeperConsumerConnector$;
import kafka.message.MessageAndOffset;
import kafka.serializer.Decoder;
import kafka.utils.IteratorTemplate;
import org.apache.log4j.Logger;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005]c\u0001B\u0001\u0003\u0001\u001d\u0011\u0001cQ8ogVlWM]%uKJ\fGo\u001c:\u000b\u0005\r!\u0011\u0001C2p]N,X.\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001!\u0006\u0002\t#M\u0019\u0001!C\u000f\u0011\u0007)iq\"D\u0001\f\u0015\taA!A\u0003vi&d7/\u0003\u0002\u000f\u0017\t\u0001\u0012\n^3sCR|'\u000fV3na2\fG/\u001a\t\u0003!Ea\u0001\u0001\u0002\u0005\u0013\u0001\u0011\u0005\tQ1\u0001\u0014\u0005\u0005!\u0016C\u0001\u000b\u001b!\t)\u0002$D\u0001\u0017\u0015\u00059\u0012!B:dC2\f\u0017BA\r\u0017\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"!F\u000e\n\u0005q1\"aA!osB\u0011QCH\u0005\u0003?Y\u00111bU2bY\u0006|%M[3di\"A\u0011\u0005\u0001BC\u0002\u0013%!%A\u0003u_BL7-F\u0001$!\t!sE\u0004\u0002\u0016K%\u0011aEF\u0001\u0007!J,G-\u001a4\n\u0005!J#AB*ue&twM\u0003\u0002'-!A1\u0006\u0001B\u0001B\u0003%1%\u0001\u0004u_BL7\r\t\u0005\t[\u0001\u0011)\u0019!C\u0005]\u000591\r[1o]\u0016dW#A\u0018\u0011\u0007A:\u0014(D\u00012\u0015\t\u00114'\u0001\u0006d_:\u001cWO\u001d:f]RT!\u0001N\u001b\u0002\tU$\u0018\u000e\u001c\u0006\u0002m\u0005!!.\u0019<b\u0013\tA\u0014GA\u0007CY>\u001c7.\u001b8h#V,W/\u001a\t\u0003umj\u0011AA\u0005\u0003y\t\u0011\u0001CR3uG\",G\rR1uC\u000eCWO\\6\t\u0011y\u0002!\u0011!Q\u0001\n=\n\u0001b\u00195b]:,G\u000e\t\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005\u0003\u0006\t2m\u001c8tk6,'\u000fV5nK>,H/T:\u0011\u0005U\u0011\u0015BA\"\u0017\u0005\rIe\u000e\u001e\u0005\t\u000b\u0002\u0011)\u0019!C\u0005\r\u00069A-Z2pI\u0016\u0014X#A$\u0011\u0007![u\"D\u0001J\u0015\tQE!\u0001\u0006tKJL\u0017\r\\5{KJL!\u0001T%\u0003\u000f\u0011+7m\u001c3fe\"Aa\n\u0001B\u0001B\u0003%q)\u0001\u0005eK\u000e|G-\u001a:!\u0011\u0015\u0001\u0006\u0001\"\u0001R\u0003\u0019a\u0014N\\5u}Q)!k\u0015+V-B\u0019!\bA\b\t\u000b\u0005z\u0005\u0019A\u0012\t\u000b5z\u0005\u0019A\u0018\t\u000b\u0001{\u0005\u0019A!\t\u000b\u0015{\u0005\u0019A$\t\u000fa\u0003!\u0019!C\u00053\u00061An\\4hKJ,\u0012A\u0017\t\u00037\nl\u0011\u0001\u0018\u0006\u0003;z\u000bQ\u0001\\8hi)T!a\u00181\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0017aA8sO&\u00111\r\u0018\u0002\u0007\u0019><w-\u001a:\t\r\u0015\u0004\u0001\u0015!\u0003[\u0003\u001dawnZ4fe\u0002Bqa\u001a\u0001A\u0002\u0013%\u0001.A\u0004dkJ\u0014XM\u001c;\u0016\u0003%\u00042A\u001b:v\u001d\tY\u0007O\u0004\u0002m_6\tQN\u0003\u0002o\r\u00051AH]8pizJ\u0011aF\u0005\u0003cZ\tq\u0001]1dW\u0006<W-\u0003\u0002ti\nA\u0011\n^3sCR|'O\u0003\u0002r-A\u0011a/_\u0007\u0002o*\u0011\u0001\u0010B\u0001\b[\u0016\u001c8/Y4f\u0013\tQxO\u0001\tNKN\u001c\u0018mZ3B]\u0012|eMZ:fi\"9A\u0010\u0001a\u0001\n\u0013i\u0018aC2veJ,g\u000e^0%KF$2A`A\u0002!\t)r0C\u0002\u0002\u0002Y\u0011A!\u00168ji\"A\u0011QA>\u0002\u0002\u0003\u0007\u0011.A\u0002yIEBq!!\u0003\u0001A\u0003&\u0011.\u0001\u0005dkJ\u0014XM\u001c;!\u0011%\ti\u0001\u0001a\u0001\n\u0013\ty!\u0001\tdkJ\u0014XM\u001c;ECR\f7\t[;oWV\t\u0011\bC\u0005\u0002\u0014\u0001\u0001\r\u0011\"\u0003\u0002\u0016\u0005!2-\u001e:sK:$H)\u0019;b\u0007\",hn[0%KF$2A`A\f\u0011%\t)!!\u0005\u0002\u0002\u0003\u0007\u0011\bC\u0004\u0002\u001c\u0001\u0001\u000b\u0015B\u001d\u0002#\r,(O]3oi\u0012\u000bG/Y\"ik:\\\u0007\u0005C\u0005\u0002 \u0001\u0001\r\u0011\"\u0003\u0002\"\u0005\u00012-\u001e:sK:$Hk\u001c9jG&sgm\\\u000b\u0003\u0003G\u00012AOA\u0013\u0013\r\t9C\u0001\u0002\u0013!\u0006\u0014H/\u001b;j_:$v\u000e]5d\u0013:4w\u000eC\u0005\u0002,\u0001\u0001\r\u0011\"\u0003\u0002.\u0005!2-\u001e:sK:$Hk\u001c9jG&sgm\\0%KF$2A`A\u0018\u0011)\t)!!\u000b\u0002\u0002\u0003\u0007\u00111\u0005\u0005\t\u0003g\u0001\u0001\u0015)\u0003\u0002$\u0005\t2-\u001e:sK:$Hk\u001c9jG&sgm\u001c\u0011\t\u0013\u0005]\u0002\u00011A\u0005\n\u0005e\u0012AD2p]N,X.\u001a3PM\u001a\u001cX\r^\u000b\u0003\u0003w\u00012!FA\u001f\u0013\r\tyD\u0006\u0002\u0005\u0019>tw\rC\u0005\u0002D\u0001\u0001\r\u0011\"\u0003\u0002F\u0005\u00112m\u001c8tk6,Gm\u00144gg\u0016$x\fJ3r)\rq\u0018q\t\u0005\u000b\u0003\u000b\t\t%!AA\u0002\u0005m\u0002\u0002CA&\u0001\u0001\u0006K!a\u000f\u0002\u001f\r|gn];nK\u0012|eMZ:fi\u0002Bq!a\u0014\u0001\t\u0003\n\t&\u0001\u0003oKb$H#A\b\t\u000f\u0005U\u0003\u0001\"\u0005\u0002R\u0005AQ.Y6f\u001d\u0016DH\u000f")
public class ConsumerIterator<T>
extends IteratorTemplate<T>
implements ScalaObject {
    private final String topic;
    private final BlockingQueue<FetchedDataChunk> channel;
    private final int consumerTimeoutMs;
    private final Decoder<T> decoder;
    private final Logger logger;
    private Iterator<MessageAndOffset> current;
    private FetchedDataChunk currentDataChunk;
    private PartitionTopicInfo currentTopicInfo;
    private long consumedOffset;

    private String topic() {
        return this.topic;
    }

    private BlockingQueue<FetchedDataChunk> channel() {
        return this.channel;
    }

    private Decoder<T> decoder() {
        return this.decoder;
    }

    private Logger logger() {
        return this.logger;
    }

    private Iterator<MessageAndOffset> current() {
        return this.current;
    }

    private void current_$eq(Iterator<MessageAndOffset> iterator) {
        this.current = iterator;
    }

    private FetchedDataChunk currentDataChunk() {
        return this.currentDataChunk;
    }

    private void currentDataChunk_$eq(FetchedDataChunk fetchedDataChunk) {
        this.currentDataChunk = fetchedDataChunk;
    }

    private PartitionTopicInfo currentTopicInfo() {
        return this.currentTopicInfo;
    }

    private void currentTopicInfo_$eq(PartitionTopicInfo partitionTopicInfo) {
        this.currentTopicInfo = partitionTopicInfo;
    }

    private long consumedOffset() {
        return this.consumedOffset;
    }

    private void consumedOffset_$eq(long l) {
        this.consumedOffset = l;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public T next() {
        void var1_1;
        Object decodedMessage = super.next();
        if (this.consumedOffset() < 0L) {
            throw new IllegalStateException(Predef$.MODULE$.augmentString("Offset returned by the message set is invalid %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.consumedOffset())})));
        }
        this.currentTopicInfo().resetConsumeOffset(this.consumedOffset());
        if (this.logger().isTraceEnabled()) {
            this.logger().trace((Object)Predef$.MODULE$.augmentString("Setting consumed offset to %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.consumedOffset())})));
        }
        ConsumerTopicStat$.MODULE$.getConsumerTopicStat(this.topic()).recordMessagesPerTopic(1);
        return var1_1;
    }

    @Override
    public T makeNext() {
        if (this.current() == null || !this.current().hasNext()) {
            if (this.consumerTimeoutMs < 0) {
                this.currentDataChunk_$eq(this.channel().take());
            } else {
                this.currentDataChunk_$eq(this.channel().poll(this.consumerTimeoutMs, TimeUnit.MILLISECONDS));
                if (this.currentDataChunk() == null) {
                    throw new ConsumerTimeoutException();
                }
            }
            if (this.currentDataChunk() == ZookeeperConsumerConnector$.MODULE$.shutdownCommand()) {
                if (this.logger().isDebugEnabled()) {
                    this.logger().debug((Object)"Received the shutdown command");
                }
                this.channel().offer(this.currentDataChunk());
                return this.allDone();
            }
            this.currentTopicInfo_$eq(this.currentDataChunk().topicInfo());
            if (this.currentTopicInfo().getConsumeOffset() != this.currentDataChunk().fetchOffset()) {
                this.logger().error((Object)Predef$.MODULE$.augmentString("consumed offset: %d doesn't match fetch offset: %d for %s;\n Consumer may lose data").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.currentTopicInfo().getConsumeOffset()), BoxesRunTime.boxToLong((long)this.currentDataChunk().fetchOffset()), this.currentTopicInfo()})));
                this.currentTopicInfo().resetConsumeOffset(this.currentDataChunk().fetchOffset());
            }
            this.current_$eq(this.currentDataChunk().messages().iterator());
        }
        MessageAndOffset item = (MessageAndOffset)this.current().next();
        this.consumedOffset_$eq(item.offset());
        return this.decoder().toEvent(item.message());
    }

    public ConsumerIterator(String topic, BlockingQueue<FetchedDataChunk> channel, int consumerTimeoutMs, Decoder<T> decoder) {
        this.topic = topic;
        this.channel = channel;
        this.consumerTimeoutMs = consumerTimeoutMs;
        this.decoder = decoder;
        this.logger = Logger.getLogger(ConsumerIterator.class);
        this.current = null;
        this.currentDataChunk = null;
        this.currentTopicInfo = null;
        this.consumedOffset = -1L;
    }
}

