package com.kalvan.core.mq;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;

/**
 * mq静态工具类
 *
 * @author kalvan
 */
@Component
@Slf4j
public class MqUtil {

    private static MqProducer producer;

    @Autowired(required = false)
    private MqProducer mqProducer;


    @PostConstruct
    public void init() {
        producer = mqProducer;
    }

    /**
     * 获取mq生产者
     *
     * @return MqProducer
     */
    public static MqProducer getProducer() {
        return producer;
    }

}
