/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.configuration;

import com.sshtools.common.configuration.InvalidProfileFileException;
import com.sshtools.common.util.PropertyUtil;
import com.sshtools.j2ssh.authentication.SshAuthenticationClient;
import com.sshtools.j2ssh.authentication.SshAuthenticationClientFactory;
import com.sshtools.j2ssh.configuration.SshConnectionProperties;
import com.sshtools.j2ssh.forwarding.ForwardingConfiguration;
import com.sshtools.j2ssh.io.IOUtil;
import com.sshtools.j2ssh.transport.AlgorithmNotSupportedException;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SshToolsConnectionProfile
extends SshConnectionProperties {
    private static Log log = LogFactory.getLog((Class)(class$com$sshtools$common$configuration$SshToolsConnectionProfile == null ? (class$com$sshtools$common$configuration$SshToolsConnectionProfile = SshToolsConnectionProfile.class$("com.sshtools.common.configuration.SshToolsConnectionProfile")) : class$com$sshtools$common$configuration$SshToolsConnectionProfile));
    public static final int DO_NOTHING = 1;
    public static final int START_SHELL = 2;
    public static final int EXECUTE_COMMANDS = 3;
    private Map applicationProperties = new HashMap();
    private Map authMethods = new HashMap();
    private Map localForwardings = new HashMap();
    private Map remoteForwardings = new HashMap();
    private boolean requestPseudoTerminal = true;
    private boolean disconnectOnSessionClose = true;
    private int onceAuthenticated = 2;
    private String executeCommands = "";
    private boolean allowAgentForwarding = false;
    private String currentElement = null;
    private String currentAuthentication = null;
    private Properties currentProperties = null;
    static /* synthetic */ Class class$com$sshtools$common$configuration$SshToolsConnectionProfile;

    public Map getAuthenticationMethods() {
        return this.authMethods;
    }

    public boolean requiresPseudoTerminal() {
        return this.requestPseudoTerminal;
    }

    public boolean disconnectOnSessionClose() {
        return this.disconnectOnSessionClose;
    }

    public void setRequiresPseudoTerminal(boolean bl) {
        this.requestPseudoTerminal = bl;
    }

    public void setDisconnectOnSessionClose(boolean bl) {
        this.disconnectOnSessionClose = bl;
    }

    public void setOnceAuthenticatedCommand(int n) {
        this.onceAuthenticated = n;
    }

    public int getOnceAuthenticatedCommand() {
        return this.onceAuthenticated;
    }

    public void setCommandsToExecute(String string) {
        this.executeCommands = string;
    }

    public String getCommandsToExecute() {
        return this.executeCommands;
    }

    public String getApplicationProperty(String string, String string2) {
        String string3 = (String)this.applicationProperties.get(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    public int getApplicationPropertyInt(String string, int n) {
        try {
            return Integer.parseInt(this.getApplicationProperty(string, String.valueOf(n)));
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public boolean getApplicationPropertyBoolean(String string, boolean bl) {
        try {
            return new Boolean(this.getApplicationProperty(string, String.valueOf(bl)));
        }
        catch (NumberFormatException numberFormatException) {
            return bl;
        }
    }

    public Color getApplicationPropertyColor(String string, Color color) {
        return PropertyUtil.stringToColor(this.getApplicationProperty(string, PropertyUtil.colorToString(color)));
    }

    public void setApplicationProperty(String string, String string2) {
        this.applicationProperties.put(string, string2);
    }

    public void setApplicationProperty(String string, int n) {
        this.applicationProperties.put(string, String.valueOf(n));
    }

    public void setApplicationProperty(String string, boolean bl) {
        this.applicationProperties.put(string, String.valueOf(bl));
    }

    public void setApplicationProperty(String string, Color color) {
        this.applicationProperties.put(string, PropertyUtil.colorToString(color));
    }

    public void addAuthenticationMethod(SshAuthenticationClient sshAuthenticationClient) {
        if (sshAuthenticationClient != null && !this.authMethods.containsKey(sshAuthenticationClient.getMethodName())) {
            this.authMethods.put(sshAuthenticationClient.getMethodName(), sshAuthenticationClient);
        }
    }

    public void addLocalForwarding(ForwardingConfiguration forwardingConfiguration) {
        if (forwardingConfiguration != null) {
            this.localForwardings.put(forwardingConfiguration.getName(), forwardingConfiguration);
        }
    }

    public void addRemoteForwarding(ForwardingConfiguration forwardingConfiguration) {
        if (forwardingConfiguration != null) {
            this.remoteForwardings.put(forwardingConfiguration.getName(), forwardingConfiguration);
        }
    }

    public boolean getAllowAgentForwarding() {
        return this.allowAgentForwarding;
    }

    public void setAllowAgentForwarding(boolean bl) {
        this.allowAgentForwarding = bl;
    }

    public void removeLocalForwarding(String string) {
        this.localForwardings.remove(string);
    }

    public void removeRemoteForwarding(String string) {
        this.remoteForwardings.remove(string);
    }

    public Map getLocalForwardings() {
        return this.localForwardings;
    }

    public Map getRemoteForwardings() {
        return this.remoteForwardings;
    }

    public void open(String string) throws InvalidProfileFileException {
        this.open(new File(string));
    }

    public void open(File file) throws InvalidProfileFileException {
        FileInputStream fileInputStream = null;
        try {
            try {
                fileInputStream = new FileInputStream(file);
                this.open(fileInputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new InvalidProfileFileException(file + " was not found!");
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            IOUtil.closeStream((InputStream)fileInputStream);
            throw throwable;
        }
        IOUtil.closeStream((InputStream)fileInputStream);
    }

    public void open(InputStream inputStream) throws InvalidProfileFileException {
        try {
            try {
                SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                SAXParser sAXParser = sAXParserFactory.newSAXParser();
                XMLHandler xMLHandler = new XMLHandler();
                sAXParser.parse(inputStream, (DefaultHandler)xMLHandler);
                xMLHandler = null;
            }
            catch (IOException iOException) {
                throw new InvalidProfileFileException("IO error. " + iOException.getMessage());
            }
            catch (SAXException sAXException) {
                throw new InvalidProfileFileException("SAX Error: " + sAXException.getMessage());
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new InvalidProfileFileException("SAX Parser Error: " + parserConfigurationException.getMessage());
            }
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            throw throwable;
        }
    }

    public void removeAuthenticaitonMethod(String string) {
        this.authMethods.remove(string);
    }

    public void save(String string) throws InvalidProfileFileException {
        try {
            try {
                File file = new File(string);
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                fileOutputStream.write(this.toString().getBytes());
                fileOutputStream.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new InvalidProfileFileException(string + " was not found!");
            }
            catch (IOException iOException) {
                throw new InvalidProfileFileException("io error on " + string);
            }
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            throw throwable;
        }
    }

    public String toString() {
        ForwardingConfiguration forwardingConfiguration;
        Map.Entry<Object, Object> entry;
        String string = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
        string = string + "<SshToolsConnectionProfile Hostname=\"" + this.host + "\" Port=\"" + String.valueOf(this.port) + "\" Username=\"" + this.username + "\"" + " Provider=\"" + this.getTransportProviderString() + "\">";
        string = string + "   <PreferedCipher Client2Server=\"" + this.prefEncryption + "\" Server2Client=\"" + this.prefDecryption + "\"/>\n";
        string = string + "   <PreferedMac Client2Server=\"" + this.prefRecvMac + "\" Server2Client=\"" + this.prefSendMac + "\"/>\n";
        string = string + "   <PreferedCompression Client2Server=\"" + this.prefRecvComp + "\" Server2Client=\"" + this.prefSendComp + "\"/>\n";
        string = string + "   <PreferedPublicKey Name=\"" + this.prefPK + "\"/>\n";
        string = string + "   <PreferedKeyExchange Name=\"" + this.prefKex + "\"/>\n";
        Iterator iterator = this.authMethods.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            string = string + "   <AuthenticationMethod Name=\"" + entry.getKey() + "\">\n";
            forwardingConfiguration = (SshAuthenticationClient)entry.getValue();
            Properties properties = forwardingConfiguration.getPersistableProperties();
            Iterator<Map.Entry<Object, Object>> iterator2 = properties.entrySet().iterator();
            while (iterator2.hasNext()) {
                entry = iterator2.next();
                string = string + "      <AuthenticationProperty Name=\"" + entry.getKey() + "\" Value=\"" + entry.getValue() + "\"/>\n";
            }
            string = string + "   </AuthenticationMethod>\n";
        }
        iterator = this.applicationProperties.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            string = string + "   <ApplicationProperty Name=\"" + entry.getKey() + "\" Value=\"" + entry.getValue() + "\"/>\n";
        }
        iterator = this.localForwardings.values().iterator();
        while (iterator.hasNext()) {
            forwardingConfiguration = (ForwardingConfiguration)iterator.next();
            string = string + "   <LocalPortForwarding Name=\"" + forwardingConfiguration.getName() + "\" AddressToBind=\"" + forwardingConfiguration.getAddressToBind() + "\" PortToBind=\"" + String.valueOf(forwardingConfiguration.getPortToBind()) + "\" AddressToConnect=\"" + forwardingConfiguration.getHostToConnect() + "\" PortToConnect=\"" + String.valueOf(forwardingConfiguration.getPortToConnect()) + "\"/>\n";
        }
        iterator = this.remoteForwardings.values().iterator();
        while (iterator.hasNext()) {
            forwardingConfiguration = (ForwardingConfiguration)iterator.next();
            string = string + "   <RemotePortForwarding Name=\"" + forwardingConfiguration.getName() + "\" AddressToBind=\"" + forwardingConfiguration.getAddressToBind() + "\" PortToBind=\"" + String.valueOf(forwardingConfiguration.getPortToBind()) + "\" AddressToConnect=\"" + forwardingConfiguration.getHostToConnect() + "\" PortToConnect=\"" + String.valueOf(forwardingConfiguration.getPortToConnect()) + "\"/>\n";
        }
        string = string + "</SshToolsConnectionProfile>";
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class XMLHandler
    extends DefaultHandler {
        private XMLHandler() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (SshToolsConnectionProfile.this.currentElement == null) {
                if (!string3.equals("SshToolsConnectionProfile")) {
                    throw new SAXException("Unexpected root element " + string3);
                }
                SshToolsConnectionProfile.this.host = attributes.getValue("Hostname");
                SshToolsConnectionProfile.this.username = attributes.getValue("Username");
                String string4 = attributes.getValue("Port");
                if (string4 == null) {
                    SshToolsConnectionProfile.this.port = 22;
                } else {
                    SshToolsConnectionProfile.this.port = Integer.parseInt(string4);
                }
                SshToolsConnectionProfile.this.setTransportProviderString(attributes.getValue("Provider"));
                if (SshToolsConnectionProfile.this.host == null || SshToolsConnectionProfile.this.username == null) {
                    throw new SAXException("Required attribute for element <SshToolsConnectionProfile> missing");
                }
            } else if (SshToolsConnectionProfile.this.currentElement.equals("SshToolsConnectionProfile")) {
                if (string3.equals("PreferedCipher")) {
                    String string5 = attributes.getValue("Client2Server");
                    String string6 = attributes.getValue("Server2Client");
                    if (string5 == null || string6 == null) {
                        throw new SAXException("Required attribute missing for <PreferedCipher> element");
                    }
                    SshToolsConnectionProfile.this.prefEncryption = string5;
                    SshToolsConnectionProfile.this.prefDecryption = string6;
                } else if (string3.equals("PreferedCompression")) {
                    String string7 = attributes.getValue("Client2Server");
                    String string8 = attributes.getValue("Server2Client");
                    if (string7 == null || string8 == null) {
                        throw new SAXException("Required attribute missing for <PreferedCompression> element");
                    }
                    SshToolsConnectionProfile.this.prefRecvComp = string7;
                    SshToolsConnectionProfile.this.prefSendComp = string8;
                } else if (string3.equals("PreferedMac")) {
                    String string9 = attributes.getValue("Client2Server");
                    String string10 = attributes.getValue("Server2Client");
                    if (string9 == null || string10 == null) {
                        throw new SAXException("Required attribute missing for <PreferedMac> element");
                    }
                    SshToolsConnectionProfile.this.prefRecvMac = string9;
                    SshToolsConnectionProfile.this.prefSendMac = string10;
                } else if (string3.equals("PreferedPublicKey")) {
                    String string11 = attributes.getValue("Name");
                    if (string11 == null) {
                        throw new SAXException("Required attribute missing for <PreferedPublickey> element");
                    }
                    SshToolsConnectionProfile.this.prefPK = string11;
                } else if (string3.equals("PreferedKeyExchange")) {
                    String string12 = attributes.getValue("Name");
                    if (string12 == null) {
                        throw new SAXException("Required attribute missing for <PreferedKeyExchange> element");
                    }
                    SshToolsConnectionProfile.this.prefPK = string12;
                } else if (string3.equals("ApplicationProperty")) {
                    String string13 = attributes.getValue("Name");
                    String string14 = attributes.getValue("Value");
                    if (string13 == null || string14 == null) {
                        throw new SAXException("Required attributes missing for <ApplicationProperty> element");
                    }
                    SshToolsConnectionProfile.this.applicationProperties.put(string13, string14);
                } else if (string3.equals("AuthenticationMethod")) {
                    SshToolsConnectionProfile.this.currentAuthentication = attributes.getValue("Name");
                    SshToolsConnectionProfile.this.currentProperties = new Properties();
                    if (SshToolsConnectionProfile.this.currentAuthentication == null) {
                        throw new SAXException("Required attribute missing for <AuthenticationMethod> element");
                    }
                } else {
                    if (!string3.equals("LocalPortForwarding") && !string3.equals("RemotePortForwarding")) throw new SAXException("Unexpected element <" + string3 + "> after SshToolsConnectionProfile");
                    String string15 = attributes.getValue("Name");
                    String string16 = attributes.getValue("AddressToBind");
                    String string17 = attributes.getValue("PortToBind");
                    String string18 = attributes.getValue("AddressToConnect");
                    String string19 = attributes.getValue("PortToConnect");
                    if (string15 == null || string16 == null || string17 == null || string18 == null || string19 == null) {
                        throw new SAXException("Required attribute missing for <" + string3 + "> element");
                    }
                    ForwardingConfiguration forwardingConfiguration = new ForwardingConfiguration(string15, string16, Integer.parseInt(string17), string18, Integer.parseInt(string19));
                    if (string3.equals("LocalPortForwarding")) {
                        SshToolsConnectionProfile.this.localForwardings.put(string15, forwardingConfiguration);
                    } else {
                        SshToolsConnectionProfile.this.remoteForwardings.put(string15, forwardingConfiguration);
                    }
                }
            } else if (SshToolsConnectionProfile.this.currentElement.equals("AuthenticationMethod")) {
                if (!string3.equals("AuthenticationProperty")) throw new SAXException("Unexpected element <" + string3 + "> found after AuthenticationMethod");
                String string20 = attributes.getValue("Name");
                String string21 = attributes.getValue("Value");
                if (string20 == null || string21 == null) {
                    throw new SAXException("Required attribute missing for <AuthenticationProperty> element");
                }
                SshToolsConnectionProfile.this.currentProperties.setProperty(string20, string21);
            }
            SshToolsConnectionProfile.this.currentElement = string3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void endElement(String string, String string2, String string3) throws SAXException {
            if (SshToolsConnectionProfile.this.currentElement == null) return;
            if (!SshToolsConnectionProfile.this.currentElement.equals(string3)) {
                throw new SAXException("Unexpected end element found " + string3);
            }
            if (string3.equals("SshToolsConnectionProfile")) {
                SshToolsConnectionProfile.this.currentElement = null;
                return;
            }
            if (string3.startsWith("Prefered")) {
                SshToolsConnectionProfile.this.currentElement = "SshToolsConnectionProfile";
                return;
            }
            if (string3.equals("ApplicationProperty")) {
                SshToolsConnectionProfile.this.currentElement = "SshToolsConnectionProfile";
                return;
            }
            if (string3.equals("AuthenticationProperty")) {
                SshToolsConnectionProfile.this.currentElement = "AuthenticationMethod";
                return;
            }
            if (string3.equals("LocalPortForwarding") || string3.equals("RemotePortForwarding")) {
                SshToolsConnectionProfile.this.currentElement = "SshToolsConnectionProfile";
                return;
            }
            if (!string3.equals("AuthenticationMethod")) throw new SAXException("Unexpected end element <" + string3 + "> found");
            SshToolsConnectionProfile.this.currentElement = "SshToolsConnectionProfile";
            try {
                try {
                    SshAuthenticationClient sshAuthenticationClient = SshAuthenticationClientFactory.newInstance((String)SshToolsConnectionProfile.this.currentAuthentication);
                    sshAuthenticationClient.setPersistableProperties(SshToolsConnectionProfile.this.currentProperties);
                    SshToolsConnectionProfile.this.authMethods.put(SshToolsConnectionProfile.this.currentAuthentication, sshAuthenticationClient);
                }
                catch (AlgorithmNotSupportedException algorithmNotSupportedException) {
                    log.warn((Object)("AuthenticationMethod element ignored because '" + SshToolsConnectionProfile.this.currentAuthentication + "' authentication is not supported"));
                    Object var6_7 = null;
                    SshToolsConnectionProfile.this.currentAuthentication = null;
                    return;
                }
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                SshToolsConnectionProfile.this.currentAuthentication = null;
                throw throwable;
            }
            SshToolsConnectionProfile.this.currentAuthentication = null;
        }
    }
}

